﻿\version "2.13.46"

%% mydefs.ly
%% by Hu Haipeng <hhpmusic@163.com>
%% Created: April, 2008
%% Last Updated: February 9, 2010

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Global setting
#(ly:set-option 'point-and-click #f)
\paper {
  ragged-bottom = ##t
}

modern =
#`(Staff ,(make-accidental-rule 'same-octave 0)
  ,(make-accidental-rule 'any-octave 0)
  ,(make-accidental-rule 'same-octave 1))
         
\layout {
  \context {
    \Score
    autoAccidentals = #modern
    autoCautionaries = #modern
  }
  \context {
    \RemoveEmptyStaffContext
  }
  \context {
    \RemoveEmptyRhythmicStaffContext
  }
  \context {
    \Dynamics
    \RemoveEmptyStaves
  }
  \context {
    \StaffGroup
    \consists "Instrument_name_engraver"
  }
  \context {
    \GrandStaff
    \consists "Instrument_name_engraver"
    \accepts "DrumStaff"
    \accepts "RhythmicStaff"
    \accepts "Lyrics"
    \accepts "ChordNames"
  }
  \context {
    \Dynamics
    \override TextSpanner #'breakable = ##t
    \override DynamicLineSpanner #'breakable = ##t
    \override DynamicTextSpanner #'breakable = ##t
    \override Hairpin #'to-barline = ##f
  }
  \context {
    \Voice
    \override Hairpin #'to-barline = ##f
    \override Glissando #'breakable = ##t
    \override TextSpanner #'breakable = ##t
    \override DynamicLineSpanner #'breakable = ##t
    \override DynamicTextSpanner #'breakable = ##t
    \override TrillSpanner #'breakable = ##t
  }
  \context {
    \CueVoice
    \override Hairpin #'to-barline = ##f
    \override Glissando #'breakable = ##t
    \override TextSpanner #'breakable = ##t
    \override DynamicLineSpanner #'breakable = ##t
    \override DynamicTextSpanner #'breakable = ##t
    \override TrillSpanner #'breakable = ##t
  }
  \context {
    \DrumVoice
    \override Hairpin #'to-barline = ##f
    \override Glissando #'breakable = ##t
    \override TextSpanner #'breakable = ##t
    \override DynamicLineSpanner #'breakable = ##t
    \override DynamicTextSpanner #'breakable = ##t
    \override TrillSpanner #'breakable = ##t
  }
  \context {
    \TabVoice
    \override Hairpin #'to-barline = ##f
    \override Glissando #'breakable = ##t
    \override TextSpanner #'breakable = ##t
    \override DynamicLineSpanner #'breakable = ##t
    \override DynamicTextSpanner #'breakable = ##t
    \override TrillSpanner #'breakable = ##t
  }
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% dynamic texts
ffz = #(make-dynamic-script "ffz")
fffz = #(make-dynamic-script "fffz")
sffz = #(make-dynamic-script "sffz")
sfffz = #(make-dynamic-script "sfffz")
ffp = #(make-dynamic-script "ffp")
sfp = #(make-dynamic-script "sfp")
rfp = #(make-dynamic-script "rfp")
fpp = #(make-dynamic-script "fpp")
pf = #(make-dynamic-script "pf")
parenf = #(make-dynamic-script (markup #:line(#:normal-text #:italic #:fontsize 2 "(" #:dynamic "f" #:normal-text #:italic #:fontsize 2 ")" )))
parenp = #(make-dynamic-script (markup #:line(#:normal-text #:italic #:fontsize 2 "(" #:dynamic "p" #:normal-text #:italic #:fontsize 2 ")" )))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%% Tempo texts
prestoagitato = \markup { \bold \italic "Presto agitato" }
presto = \markup { \bold \italic "Presto" }
vivace = \markup { \bold \italic "Vivace" }
allegroassai = \markup { \bold \italic "Allegro assai" }
allegrobrio = \markup { \bold \italic "Allegro con brio" }
allegroanima = \markup { \bold \italic "Allegro con anima" }
allegro = \markup { \bold \italic "Allegro" }
allegretto = \markup { \bold \italic "Allegretto" }
moderato = \markup { \bold \italic "Moderato" }
andantemoderato = \markup { \bold \italic "Andante moderato" }
andantecantabile = \markup { \bold \italic "Andante cantabile" }
andante = \markup { \bold \italic "Andante" }
adagio = \markup { \bold \italic "Adagio" }
larghetto = \markup { \bold \italic "Larghetto" }
largo = \markup { \bold \italic "Largo" }
lento = \markup { \bold \italic "Lento" }
lentoassai = \markup { \bold \italic "Lento assai" }
grave = \markup { \bold \italic "Grave" }
adlib = \markup { \bold \italic "Ad lib." }
piacere = \markup { \bold \italic "A piacere" }
rubato = \markup { \bold \italic "Rubato" }
pocorubato = \markup { \bold \italic "Poco rubato" }

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Tempo changes
accel = \markup { \bold \italic "Accel." }
accelpoco = \markup { \bold \italic "Accel. poco a poco" }
pocoaccel = \markup { \bold \italic "Poco accel." }
stretto = \markup { \bold \italic "Stretto" }
rit = \markup { \bold \italic "Rit." }
pocorit = \markup { \bold \italic "Poco rit." }
moltorit = \markup { \bold \italic "Molto rit." }
riten = \markup { \bold \italic "Riten." }
ritenuto = \markup { \bold \italic "Ritenuto" }
allarg = \markup { \bold \italic "Allarg." }
piumosso = \markup { \bold \italic "Più mosso" }
menomosso = \markup { \bold \italic "Meno mosso" }
piulento = \markup { \bold \italic "Più lento" }
rapido = \markup { \bold \italic "Rapido" }
atempo = \markup { \bold \italic "A tempo" }
pocoatempo = \markup { \bold \italic "A tempo poco a poco" }
tempoi = \markup { \bold \italic "Tempo I" }
tempoii = \markup { \bold \italic "Tempo II" }

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Other texts
fltg = \markup { \bold "Fltg." }
simile = \markup { \bold "Simile" }
sim = \markup { \bold "Sim." }
sempre = \markup { \bold "Sempre" }
agitato = \markup { \bold \italic "Agitato" }
appassionato = \markup { \bold \italic "Appassionato" }
maestoso = \markup { \bold \italic "Maestoso" }
gliss = \markup { \bold \italic "Gliss." }
moltocr = {
  \set crescendoText = \markup { \italic "Molto cresc." }
  \set crescendoSpanner = #'text
  \override DynamicTextSpanner #'style = #'dotted-line
}
pococr = {
  \set crescendoText = \markup { \italic "Poco cresc." }
  \set crescendoSpanner = #'text
  \override DynamicTextSpanner #'style = #'dotted-line
}
crpap = {
  \set crescendoText = \markup { \italic "Cresc. poco a poco" }
  \set crescendoSpanner = #'text
  \override DynamicTextSpanner #'style = #'dotted-line
}
%% Strange, can't define piucr
piuc = {
  \set crescendoText = \markup { \italic "Più cresc." }
  \set crescendoSpanner = #'text
  \override DynamicTextSpanner #'style = #'dotted-line
}
moltodim = {
  \set decrescendoText = \markup { \italic "Molto dim." }
  \set decrescendoSpanner = #'text
  \override DynamicTextSpanner #'style = #'dotted-line
}
pocodim = {
  \set decrescendoText = \markup { \italic "Poco dim." }
  \set decrescendoSpanner = #'text
  \override DynamicTextSpanner #'style = #'dotted-line
}
dimpap = {
  \set decrescendoText = \markup { \italic "Cresc. poco a poco" }
  \set decrescendoSpanner = #'text
  \override DynamicTextSpanner #'style = #'dotted-line
}
piud = {
  \set decrescendoText = \markup { \italic "Più dim." }
  \set decrescendoSpanner = #'text
  \override DynamicTextSpanner #'style = #'dotted-line
}
offCr = {
  \unset crescendoText
  \unset crescendoSpanner
  \revert DynamicTextSpanner #'style
}
offDim = {
  \unset decrescendoText
  \unset decrescendoSpanner
  \revert DynamicTextSpanner #'style
}
ramtostar = \markup { \bold { \italic "Play randomly to" } \fontsize #2 "*" }
star = \markup { \bold \fontsize #2 "*" }
esp = \markup { \bold \italic "Espressivo" }
ten = \markup { \bold \italic "Ten." }
tenu = \markup { \bold \italic "Tenuto" }
marc = \markup { \bold "Marcato" }
dolce = \markup { \bold \italic "Dolce" }
cantabile = \markup { \bold \italic "Cantabile" }
conmoto = \markup { \bold \italic "Con moto" }
risoluto = \markup { \bold \italic "Risoluto" }
pesante = \markup { \bold \italic "Pesante" }
collaparte = \markup { \bold \italic "Colla parte" }
tranquillo = \markup { \bold \italic "Tranquillo" }
piuf = \markup { \bold \italic "Più" \dynamic "f" }
sempref = \markup { \bold \italic "Sempre" \dynamic "f" }
sempreff = \markup { \bold \italic "Sempre" \dynamic "ff" }
semprepiuf = \markup { \bold \italic "Sempre più" \dynamic "f" }
piup = \markup { \bold \italic "Più" \dynamic "p" }
semprep = \markup { \bold \italic "Sempre" \dynamic "p" }
semprepp = \markup { \bold \italic "Sempre" \dynamic "pp" }
semprepiup = \markup { \bold \italic "Sempre più" \dynamic "p" }
piucr = \markup { \bold \italic "Più cresc." }
piudim = \markup { \bold \italic "Più dim." }
saltando = \markup { \bold \italic "Saltando" }
salt = \markup { \bold \italic "Salt." }
legato = \markup { \bold \italic "Legato" }
moltolegato = \markup { \bold \italic "Molto legato" }
nonlegato = \markup { \bold \italic "Non legato" }
legg = \markup { \bold \italic "Leggiero" }
consord = \markup { \bold \italic "Con sord." }
senzasord = \markup { \bold \italic "Senza sord." }
mut = \markup { \bold "Mute" }
opn = \markup { \bold "Open" }
pont = \markup { \bold \italic "Sul ponticello" }
cl = \markup { \bold \italic "Col legno" }
clp = \markup { \bold \italic "C.L., Pont." }
tasto = \markup { \bold \italic "Sul tasto" }
naturale = \markup { \bold \italic "Naturale" }
norm = \markup { \bold \italic "Norm." }
div = \markup { \bold "Div." }
divat = \markup { \bold "Div. a 3" }
divaq = \markup { \bold "Div. a 4" }
nondiv = \markup { \bold "Non div." }
unis = \markup { \bold "Unis." }
piz = \markup { \bold "Pizz." }
arc = \markup { \bold "Arco" }
btk = \markup { \bold \italic "Bartok pizz." }
martellato = \markup { \musicglyph #"scripts.dmarcato" }

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% fake clefs, using treble when bass is using in another voice, or vice versa
fakeTrebleClef = { %Treble clef with properties of bass clef
  \set Staff.clefGlyph = #"clefs.G"
  \set Staff.clefPosition = #-2
  \set Staff.middleCPosition = #6
}
fakeBassClef = { %Bass clef with properties of treble clef
  \set Staff.clefGlyph = #"clefs.F"
  \set Staff.clefPosition = #2
  \set Staff.middleCPosition = #-6
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Special time signatures
fourandfour = #(define-music-function (parser location numi numii) (number? number?)
  #{ \markup {
    \override #'(baseline-skip . 2) \number {
    \column { #$numi "4" }
    \vcenter "+"
    \bracket \column { #$numii "4" }
    }
  }
#})
fourfour = { \override Staff.TimeSignature #'stencil =
    #ly:text-interface::print
  \override Staff.TimeSignature #'text = #fourandfour
}

fourandeight = #(define-music-function (parser location numi numii) (number? number?)
  #{ \markup {
    \override #'(baseline-skip . 2) \number {
    \column { #$numi "4" }
    \vcenter "+"
    \bracket \column { #$numii "8" }
    }
  }
#})
foureight = { \override Staff.TimeSignature #'stencil =
    #ly:text-interface::print
  \override Staff.TimeSignature #'text = #fourandeight
}

eightandfour = #(define-music-function (parser location numi numii) (number? number?)
  #{ \markup {
    \override #'(baseline-skip . 2) \number {
    \column { #$numi "8" }
    \vcenter "+"
    \bracket \column { #$numii "4" }
    }
  }
#})
eightfour = { \override Staff.TimeSignature #'stencil =
    #ly:text-interface::print
  \override Staff.TimeSignature #'text = #eightandfour
}

eightandeight = #(define-music-function (parser location numi numii) (number? number?)
  #{ \markup {
    \override #'(baseline-skip . 2) \number {
    \column { #$numi "8" }
    \vcenter "+"
    \bracket \column { #$numii "8" }
    }
  }
#})
eighteight = { \override Staff.TimeSignature #'stencil =
    #ly:text-interface::print
  \override Staff.TimeSignature #'text = #eightandeight
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% parenthesized compond time signature
parenthps = #"
0 0 translate
45 45 scale
0 0 0 setrgbcolor
[] 0 setdash
1 setlinewidth
0 setlinejoin
0 setlinecap
newpath
0.0147465 0 moveto
0.011106 0.00351338 0.00916298 0.00598483 0.00710032 0.00978362 curveto
0.00248893 0.01832964 3e-008 0.02925362 3e-008 0.04074722 curveto
3e-008 0.05157272 0.00218483 0.06173772 0.00625033 0.07019282 curveto
0.00855727 0.07474937 0.01061993 0.07759971 0.0147465 0.08158922 curveto
0.0147465 0.07807584 lineto
0.00867816 0.06971302 0.00625033 0.05898344 0.00625033 0.04074724 curveto
0.00625033 0.02250984 0.00867816 0.01187244 0.0147465 0.00351344 curveto
0.0147465 6e-008 lineto
0.0147465 0 lineto
closepath
fill"

parenthL = \markup
{
    \with-dimensions #'(0 . 0.68) #'(0 . 3.67)
    \postscript #parenthps
}

parenthR = \markup { \rotate #180 \parenthL }

#(define (compound-time-parentheses one two num)
  (markup #:override '(baseline-skip . 0) #:number
   (#:line (#:left-align (#:center-column (one num))
     #:concat (#:vcenter parenthL #:hspace 0.2
      (#:left-align (#:center-column (two num))) #:hspace 0.2
      #:vcenter parenthR)))))

%{ example:
\relative c'
{
    \time 7/4
    \override Staff.TimeSignature #'stencil = #ly:text-interface::print
    \override Staff.TimeSignature #'text =
        #(compound-time-parentheses "7" "4+3" "4" )

    c1 \bar "dashed" c2. \time 12/4
    \override Staff.TimeSignature #'text =
        #(compound-time-parentheses "12" "5+4+3" "4" )
    c1 ~ c4 \bar "dashed" c1 \bar "dashed" c2. \bar "|."
}
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% layout to create orchestra staff group
%% with non-spanned barlines between two instrument groups
\layout {
  \context {
    \StaffGroup
    \name Orchestra
    \remove "Span_bar_engraver"
  }
  \context {
    \Score
    \accepts Orchestra
  }
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Layout to produce SquareStaff context
%% to group similar instruments in a staff group with thin square bracket
\layout {
  \context {
    \StaffGroup
    \name SquareStaff
    systemStartDelimiter = #'SystemStartSquare
  }
  \context {
    \Orchestra
    \accepts SquareStaff
  }
  \context {
    \StaffGroup
    \accepts SquareStaff
  }
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Layout to produce ChordMarks context
%% for doing harmony exercises
%% Chord marks are entered as text markups
\layout {
  \context {
    \type "Engraver_group"
    \name ChordMarks
    \alias Voice
    \consists "Output_property_engraver"
    \override VerticalAxisGroup #'minimum-Y-extent = #'(-1 . 1)
    \consists "Script_engraver"
    \consists "Text_engraver"
    \override TextScript #'font-size = #2
    \consists "Skip_event_swallow_translator"
    \consists "Axis_group_engraver"
  }
  \context {
    \Orchestra
    \accepts ChordMarks
  }
  \context {
    \StaffGroup
    \accepts ChordMarks
  }
  \context {
    \PianoStaff
    \accepts ChordMarks
  }
  \context {
    \GrandStaff
    \accepts ChordMarks
  }
  \context {
    \SquareStaff
    \accepts ChordMarks
  }
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Layout to produce MarkLine context
%% to place rehearsal marks and texts above full score
\layout {
  \context {
    \type "Engraver_group"
    \name "MarkLine"
    \consists "Output_property_engraver"
    \consists "Axis_group_engraver"
    \consists "Mark_engraver"
    \consists "Metronome_mark_engraver"
    \consists "Script_engraver"
    \consists "Text_engraver"
    \consists "Text_spanner_engraver"
    \consists "Font_size_engraver"
    \override VerticalAxisGroup #'minimum-Y-extent = #'(-2 . 2 )
    \override TextSpanner #'breakable = ##t
  }
  \context {
    \Score
    \accepts "MarkLine"
  }
  \context {
    \Orchestra
    \accepts "MarkLine"
  }
  \context {
    \StaffGroup
    \accepts "MarkLine"
  }
  \context {
    \PianoStaff
    \accepts "MarkLine"
  }
  \context {
    \GrandStaff
    \accepts "MarkLine"
  }
  \context {
    \ChoirStaff
    \accepts "MarkLine"
  }
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% layout to produce a smaller markline
%% put before 1st violin part
\layout {
  \context {
    \MarkLine
    \name "SmallMarkLine"
    \override MetronomeMark #'outside-staff-priority = #800
    \override RehearsalMark #'outside-staff-priority = #1200
  }
  \context {
    \Score
    \accepts SmallMarkLine
  }
  \context {
    \Orchestra
    \accepts SmallMarkLine
  }
  \context {
    \StaffGroup
    \accepts SmallMarkLine
  }
  \context {
    \PianoStaff
    \accepts "SmallMarkLine"
  }
  \context {
    \GrandStaff
    \accepts "SmallMarkLine"
  }
  \context {
    \ChoirStaff
    \accepts "SmallMarkLine"
  }
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% hide mark line
hideMarks = {
  \override RehearsalMark #'stencil = ##f
  \override MetronomeMark #'stencil = ##f
  \override Script #'stencil = ##f
  \override TextScript #'stencil = ##f
  \override TextSpanner #'stencil = ##f
}
unhideMarks = {
  \revert RehearsalMark #'stencil
  \revert MetronomeMark #'stencil
  \revert Script #'stencil   \revert TextScript #'stencil
  \revert TextSpanner #'stencil
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% add accidentals to trill spanner
sharpTrill = \once \override TrillSpanner #'edge-text = 
 #(cons (markup #:line (#:halign -0.5 #:musicglyph "scripts.trill" #:teeny #:raise 0.65 #:sharp)) "")
flatTrill = \once \override TrillSpanner #'edge-text = 
 #(cons (markup #:line (#:halign -0.5 #:musicglyph "scripts.trill" #:teeny #:raise 0.5 #:flat)) "")
naturalTrill = \once \override TrillSpanner #'edge-text = 
 #(cons (markup #:line (#:halign -0.5 #:musicglyph "scripts.trill" #:teeny #:raise 0.65 #:natural)) "")

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% limit the length of the tuplet bracket
%% to let it printed in triplet like r8 e4
tupbr = {
  \override TupletBracket #'springs-and-rods = #ly:spanner::set-spacing-rods
  \override TupletBracket #'minimum-length = #3
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% multimeasure rest without number
mmrNoNum = \once \override MultiMeasureRestNumber #'stencil = ##f

%{ \mmrNoNum R1*16 %}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% occationally in romantic piano music (such as Scriabin's),
%% this left hand sign is used in rh.
lhsign = \markup { \postscript #"0.2 setlinewidth 0 0 moveto -1 0 lineto 0 -5 rlineto stroke" }

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% add square bracket around a rest.
%% The three numbers control bracket thickness, protrusion and padding.
sqrest = \override Rest #'stencil = #(lambda (grob)
    (bracketify-stencil (ly:rest::print grob) Y 0.2 0.2 0.2))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Penderecki's triangle notehead for highest and lowest pitches
downTriangle =
#(define-music-function (parser location music) (ly:music?)
#{
  \override NoteHead #'stencil =
    #(lambda (grob)
       (grob-interpret-markup grob
        (markup #:rotate 180 #:musicglyph "noteheads.s0do")))
  \override NoteHead #'stem-attachment =
    #(lambda (grob)
       (let ((thickness (ly:staff-symbol-line-thickness grob)))
         (cons 1 (/ thickness 2))))
  $music
  \revert NoteHead #'stencil
  \revert NoteHead #'stem-attachment
#})
upTriangle =
#(define-music-function (parser location music) (ly:music?)
#{
  \override NoteHead #'stencil =
    #(lambda (grob)
       (grob-interpret-markup grob
        (markup #:musicglyph "noteheads.s0do")))
  \override NoteHead #'stem-attachment =
    #(lambda (grob)
       (let ((thickness (ly:staff-symbol-line-thickness grob)))
         (cons 1 (/ thickness 2))))
  $music
  \revert NoteHead #'stencil
  \revert NoteHead #'stem-attachment
#})

% \relative c' { c d e \upTriangle f g \downTriangle { a b } c }

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% double stem on a single note
%% you should enter both notes, one with other attachments
%% and the other a pure note without anything including values and octave sing
stemBoth = #(define-music-function (parser location mone mtwo) (ly:music? ly:music?)
#{ << \voiceOne $mone \new Voice { \voiceTwo $mtwo } >> \oneVoice #})

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% half pedal
sustainHalf =
  \override SustainPedal #'stencil =
  #(lambda (grob)
  (grob-interpret-markup grob
  (markup #:raise 0.1 "½" #:hspace -1 #:musicglyph "pedal.Ped")))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% "Noteheads only" for harp glissando
headsOn = \sequential {
  \override Dots #'transparent = ##t
  \override Stem #'transparent = ##t
  \override Beam  #'transparent = ##t
}
headsOff = \sequential {
  \revert Dots #'transparent
  \revert Stem #'transparent
  \revert Beam #'transparent
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% slashd and crossed notehead
sl = {
  \override NoteHead #'style = #'slash
  \override Stem #'transparent = ##t
}
nsl = {
  \revert NoteHead #'style
  \revert Stem #'transparent
}
crOn = \override NoteHead #'style = #'cross
crOff = \revert NoteHead #'style

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% stopwatch signs (min and sec)
timestamp =
#(define-music-function (parser location minutes seconds) (number? number?)
  (let* ((tens (if (< seconds 10) "0" ""))
  (min (number->string minutes))
  (sec (string-append tens (number->string seconds))))
  #{ \mark \markup \rounded-box \small \concat
  { $min \char ##x2032 $sec \char ##x2033 }
#}))
%{ example:
  { c'1 \timestamp #4 #03 c' \timestamp #4 #33 c' }
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% hide and unhide slur
hideSlur = \override Slur #'stencil = ##f
unHideSlur = \revert Slur #'stencil

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Hide and unhide time signature
hideTime = \override Staff.TimeSignature #'stencil = ##f
unhideTime = \revert Staff.TimeSignature #'stencil

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Hide and unhide accidentals
hideAcc = \override Accidental #'stencil = ##f
unhideAcc = \revert Accidental #'stencil

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Special midi effects
mute = \set Staff.midiInstrument = "muted trumpet"
hnopen = \set Staff.midiInstrument = "french horn"
tpopen = \set Staff.midiInstrument = "trumpet"
tbopen = \set Staff.midiInstrument = "trombone"
tuopen = \set Staff.midiInstrument = "tuba"
pizz = \set Staff.midiInstrument = "pizzicato strings"
arco = \set Staff.midiInstrument = "string ensemble 1"
vnarco = \set Staff.midiInstrument = "violin"
vlarco = \set Staff.midiInstrument = "viola"
vcarco = \set Staff.midiInstrument = "cello"
cbarco = \set Staff.midiInstrument = "contrabass"
legno = \set Staff.midiInstrument = "taiko drum"
bpizz = \set Staff.midiInstrument = "agogo"
vnsolo = \set Staff.midiInstrument = "violin"
vlsolo = \set Staff.midiInstrument = "viola"
vcsolo = \set Staff.midiInstrument = "cello"
cbsolo = \set Staff.midiInstrument = "contrabass"
tutti = \set Staff.midiInstrument = "string ensemble 1"
sord = \set Staff.midiInstrument = "string ensemble 2"
nosord = \set Staff.midiInstrument = "string ensemble 1"
trem = \set Staff.midiInstrument = "tremolo strings"

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Staff change
%% to define at least three,
%% in case the orchestral score contains
%% more than one harp or other two-staff instruments
str = \change Staff = rh
stl = \change Staff = lh
stu = \change Staff = up
std = \change Staff = down
stI = \change Staff = one
stII = \change Staff = two

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% flute slap notes
slap =
#(define-music-function (parser location music) (ly:music?)
  #{ \override NoteHead #'stencil = #ly:text-interface::print
  \override NoteHead #'text = \markup \musicglyph #"scripts.sforzato"
  \override NoteHead #'extra-offset = #'(0.1 . 0.0 )
  $music
  \revert NoteHead #'stencil
  \revert NoteHead #'text
  \revert NoteHead #'extra-offset
#})

%{ example:
\relative c' {
  c \slap c d r \slap { g a } b r
}
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Chinese-English text markup (currently use simfang.ttf only)
%% usage: \cheng #chinesefontsize #"chinese text" #englishfontsize #"english text"
#(define (cheng chisize chinese engsize english)
  (markup #:override '(baseline-skip . 2) #:center-align
    (#:bold #:fontsize chisize #:override '(font-name . "仿宋_GB2312") chinese
    #:bold #:fontsize engsize english
  )))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% The postscript code to produce drum beaters
stick = \markup {
  \with-dimensions #'(0 . 5) #'(0 . 5)
  \postscript #"
    0 6 translate
    0.8 -0.8 scale
    0 0 0 setrgbcolor
    [] 0 setdash
    1 setlinewidth
    0 setlinejoin
    0 setlinecap
    gsave [1 0 0 1 0 0] concat
    gsave [1 0 0 1 -3.5406095 -199.29342] concat
    gsave
    0 0 0 setrgbcolor
    newpath
    7.1434065 200.94354 moveto
    7.2109628 200.90454 7.2785188 200.86554 7.3460747 200.82654 curveto
    8.2056347 202.31535 9.0651946 203.80414 9.9247546 205.29295 curveto
    9.8571989 205.33195 9.7896429 205.37095 9.7220864 205.40996 curveto
    8.8625264 203.92115 8.0029664 202.43233 7.1434065 200.94354 curveto
    closepath
    eofill
    grestore
    gsave
    0 0 0 setrgbcolor
    newpath
    4.9646672 203.10444 moveto
    5.0036707 203.03688 5.0426744 202.96933 5.0816777 202.90176 curveto
    6.5704792 203.76133 8.0592809 204.6209 9.5480824 205.48045 curveto
    9.5090791 205.54801 9.4700754 205.61556 9.4310717 205.68311 curveto
    7.94227 204.82356 6.4534687 203.96399 4.9646672 203.10444 curveto
    closepath
    eofill
    grestore
    gsave
    <<
    /ShadingType 3
    /ColorSpace /DeviceRGB
    /Coords [113.13708 207.87465 0 113.13708 207.87465 16.162441]
    /Extend [true true]
    /Domain [0 1]
    /Function <<
    /FunctionType 3
    /Functions
    [
    <<
    /FunctionType 2
    /Domain [0 1]
    /C0 [1 1 1]
    /C1 [0.72941178 0.72941178 0.72941178]
    /N 1
    >>
    ]
    /Domain [0 1]
    /Bounds [ ]
    /Encode [ 0 1 ]
    >>
    >>
    newpath
    7.6422017 200.76488 moveto
    7.6505696 201.02554 7.3905363 201.24867 7.1341335 201.20075 curveto
    6.8759501 201.16916 6.6949602 200.87978 6.7801462 200.63381 curveto
    6.8480773 200.39155 7.1438307 200.25377 7.3728389 200.35861 curveto
    7.5332399 200.42458 7.6444521 200.59122 7.6422017 200.76488 curveto
    closepath
    clip
    gsave [0.052859054 0.063089841 -0.020912282 0.017521108 5.7334261 189.76443] concat
    shfill
    grestore
    grestore
    0 0 0 setrgbcolor
    [] 0 setdash
    0.027282091 setlinewidth
    0 setlinejoin
    0 setlinecap
    newpath
    7.6422017 200.76488 moveto
    7.6505696 201.02554 7.3905363 201.24867 7.1341335 201.20075 curveto
    6.8759501 201.16916 6.6949602 200.87978 6.7801462 200.63381 curveto
    6.8480773 200.39155 7.1438307 200.25377 7.3728389 200.35861 curveto
    7.5332399 200.42458 7.6444521 200.59122 7.6422017 200.76488 curveto
    closepath
    stroke
    gsave
    <<
    /ShadingType 3
    /ColorSpace /DeviceRGB
    /Coords [113.13708 207.87465 0 113.13708 207.87465 16.162441]
    /Extend [true true]
    /Domain [0 1]
    /Function <<
    /FunctionType 3
    /Functions
    [
    <<
    /FunctionType 2
    /Domain [0 1]
    /C0 [1 1 1]
    /C1 [0.72941178 0.72941178 0.72941178]
    /N 1
    >>
    ]
    /Domain [0 1]
    /Bounds [ ]
    /Encode [ 0 1 ]
    >>
    >>
    newpath
    5.2721217 202.83181 moveto
    5.2804896 203.09247 5.0204563 203.3156 4.7640539 203.26768 curveto
    4.5058701 203.23609 4.3248803 202.94671 4.4100662 202.70074 curveto
    4.4779975 202.45848 4.7737511 202.3207 5.0027593 202.42554 curveto
    5.1631598 202.49149 5.2743721 202.65813 5.2721217 202.83181 curveto
    closepath
    clip
    gsave [0.052859054 0.063089841 -0.020912282 0.017521108 3.363346 191.83136] concat
    shfill
    grestore
    grestore
    0 0 0 setrgbcolor
    [] 0 setdash
    0.027282091 setlinewidth
    0 setlinejoin
    0 setlinecap
    newpath
    5.2721217 202.83181 moveto
    5.2804896 203.09247 5.0204563 203.3156 4.7640539 203.26768 curveto
    4.5058701 203.23609 4.3248803 202.94671 4.4100662 202.70074 curveto
    4.4779975 202.45848 4.7737511 202.3207 5.0027593 202.42554 curveto
    5.1631598 202.49149 5.2743721 202.65813 5.2721217 202.83181 curveto
    closepath
    stroke
    grestore
    grestore
  "
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Markup command for absolute fontsize
#(define-markup-command (abs-fontsize layout props size arg)
  (number? markup?)
  (let* ((ref-size (ly:output-def-lookup layout 'text-font-size 12))
         (magnification (/ size ref-size))
         (font-size (magnification->font-size magnification)))
   (interpret-markup layout (cons `((baseline-skip . 
,(magnification->font-size magnification))
      (word-space (magnification->font-size magnification))
      (font-size . ,font-size)) props) arg)))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Markuplist command \paragraph
#(define-markup-list-command (paragraph layout props args) (markup-list?)
  (let ((indent (chain-assoc-get 'par-indent props 2)))
  (interpret-markup-list layout props
  (make-justified-lines-markup-list (cons (make-hspace-markup indent)
  args)))))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Function to write continuous octaves by just typing single notes
%% usage: \octaves #1 for upper octaves, #-1 for lower, #2 and #-2 for two octaves
#(define (octave-up m t)
 (let* ((octave (1- t))
       (new-note (ly:music-deep-copy m))
       (new-pitch (ly:make-pitch octave
         (ly:pitch-notename (ly:music-property m 'pitch))
         (ly:pitch-alteration (ly:music-property m 'pitch)))))
   (set! (ly:music-property new-note 'pitch) new-pitch)
   new-note))

#(define (octavize-chord elements t)
 (cond ((null? elements) elements)
      ((eq? (ly:music-property (car elements) 'name) 'NoteEvent)
        (cons (car elements)
              (cons (octave-up (car elements) t)
                    (octavize-chord (cdr elements) t))))
      (else (cons (car elements) (octavize-chord (cdr elements ) t)))))

#(define (octavize music t)
  (if (eq? (ly:music-property music 'name) 'EventChord)
        (ly:music-set-property! music 'elements (octavize-chord
(ly:music-property music 'elements) t)))
  music)

octaves = #(define-music-function (parser location arg mus) (integer? ly:music?)
 (music-map (lambda (x) (octavize x arg)) mus))

%{ example:
\relative c' {
  \time 3/8
  \key gis \minor
  \octaves #1  { dis8( e dis')~ dis8.( cis16 b8}
  \octaves #-1 { ais' gis dis) cis( dis ) }
  \time 4/4
  \octaves #1 { \times 2/3 {c,4 d e} \times 2/3 {c4 \times 2/3 {d8 e g} c,4} }
  \octaves #-1 { \repeat unfold 8 {\times 2/3 {c'16 d e} } }
}
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Add tempo text and metronome marking easily
%{ example:
  \relative c' {
    \time 3/4
    \movement "Allegro" "2." #96
    c2 e4 g2.
    \movement "Moderato" "4" #104
    f4 e d
    \tempo 4 = 92
    c2.
  }
%}

#(define ((make-format-movement-markup-function text) duration count context)
  (markup #:huge #:bold text #:hspace 1 "("
    #:general-align Y DOWN #:smaller
    #:note-by-number (ly:duration-log duration)
  (ly:duration-dot-count duration) 1 "="
    (number->string count)
  ")"))

#(define (string->duration duration-string)
  "Parse the `duration-string', e.g. ''4..'' or ''breve.'', and
  return a duration object."
  (let* ((length (string-length duration-string))
    (dot-index (or (string-index duration-string #\.) length))
    (len (substring duration-string 0 dot-index))
    (dots (- length dot-index)))
  (ly:make-duration (cond ((string=? len "breve") -1)
    ((string=? len "longa") -2)
    ((string=? len "maxima") -3)
    (else (log2 (string->number len))))
  dots 1 1)))

movement =
#(define-music-function (parser location text duration count music)
  (string? string? integer? ly:music?)
  #{
    \set Score . metronomeMarkFormatter = #(make-format-movement-
  markup-function $text)
    \set Score . tempoWholesPerMinute = #$(ly:duration-length (string-
  >duration duration))
    \set Score . tempoUnitDuration = #$(string->duration duration)
    \set Score . tempoUnitCount = #$count
    $music
    \set Score . metronomeMarkFormatter = #format-metronome-markup
  #})

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Add staccati to a sequence of notes.
%% To modify a sequence of notes, it's easiest to use a filter:
#(define (addStaccatoFilterFunction event)
  (let ((eventname (ly:music-property event 'name)))
    (if (eq? eventname 'EventChord)
      (let ((elements (ly:music-property event 'elements)))
        ; don't add staccato to rests!
        (if (not (eq? (ly:music-property (car elements) 'name) 'RestEvent))
          (set! (ly:music-property event 'elements)
            (append elements (list (make-music 'ArticulationEvent
'articulation-type "staccato"))
  )))))))

addStaccato = #(define-music-function (parser location music) (ly:music?)
   (music-filter addStaccatoFilterFunction music))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Speaker's rhythm (use \unsp before rests
%% Here is a comment from Han-Wen to fix the rests bug:
%% use grob-interpret-markup function!

sp = { \override Voice.Stem #'stencil = #(lambda (grob)
  (ly:stencil-combine-at-edge
  (ly:stem::print grob) 1 (* -1 (ly:grob-property grob 'direction))
  (ly:text-interface::print grob) -2.3 0))
  \override Voice.Stem #'text = \markup { \hspace #-1.025 \fontsize #-4 \musicglyph #"noteheads.s2cross" }
 }

unsp = {
\revert Voice.Stem #'stencil
\revert Voice.Stem #'text
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Alternative definition of \breathe that also does \noBeam
%% You can as well name this function "breathe", to replace the existing one.
breathenobeam =
#(define-music-function (parser location) ()
  (make-music 'EventChord
  'origin location
  'elements (list (make-music 'BreathingEvent)
  (make-music 'BeamForbidEvent))))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Add barline manually with increasing bar number and resetting accidentals
%% many thanks to Rune Zedeler for this snippet
increaseBarNumber = \applyContext
#(lambda (x)
  (let ((measurepos (ly:context-property x 'measurePosition)))
   ; Only increase bar number if not at start of measure.
   ; This way we ensure that you won't increase bar number twice
   ; if two parallel voices call increaseBarNumber simultanously:
   (if (< 0 (ly:moment-main-numerator measurepos)) ; ugh. ignore grace part
    (begin
     (ly:context-set-property!
      (ly:context-property-where-defined x 'internalBarNumber)
      'internalBarNumber
      (1+ (ly:context-property x 'internalBarNumber)))
     (ly:context-set-property!
      (ly:context-property-where-defined x 'currentBarNumber)
      'currentBarNumber
      (1+ (ly:context-property x 'currentBarNumber)))
     ; set main part of measurepos to zero, leave grace part as it is:
     (ly:context-set-property!
      (ly:context-property-where-defined x 'measurePosition)
      'measurePosition
      (ly:make-moment 0 1
       (ly:moment-grace-numerator measurepos)
       (ly:moment-grace-denominator measurepos)))))))

% Named Increasing BAR
nibar = #(define-music-function (parser location x) (string?)
  #{
  \bar $x
  \increaseBarNumber
#})

% Increasing BAR
ibar = \nibar "|"

%{ example:
  \new Staff \with { \remove Time_signature_engraver } {
    \cadenzaOn
    #(set-accidental-style 'modern-cautionary)
    \key a \major
    \repeat unfold 2 {
      c'8 dis' eis'  eis' \ibar
      c'4 dis'  e' eis' \nibar "||"
      c' dis' eis'8 dis' eis' \ibar
      c'1 dis' eis' eis'2 \nibar "|."
    }
  }
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% The below, invented by Mats Bengtsson,
%% creates left and right brackets vertically
%% spanning an entire staff.
%% It is useful for offseting optional passages of music,
%% as shown in the example
%% The number next to "th" in (th 0.2) controls thickness of the brackets.
#(define-markup-command (left-bracket layout props) ()
"Draw left hand bracket"
(let* ((th 0.2) ;; todo: take from GROB
 (width (* 2.5 th)) ;; todo: take from GROB
 (ext '(-2.8 . 2.8))) ;; todo: take line-count into account
 (ly:bracket Y ext th width)))

leftBracket = {
\once \override BreathingSign #'text = #(make-left-bracket-markup)
\once \override BreathingSign #'break-visibility = #end-of-line-invisible
\once \override BreathingSign #'Y-offset = ##f
% Trick to print it after barlines and signatures:
\once \override BreathingSign #'break-align-symbol = #'custos
\breathe
}

#(define-markup-command (right-bracket layout props) ()
"Draw right hand bracket"
(let* ((th .2);;todo: take from GROB
(width (* 2.5 th)) ;; todo: take from GROB
 (ext '(-2.8 . 2.8))) ;; todo: take line-count into account
 (ly:bracket Y ext th (- width))))

rightBracket = {
\once \override BreathingSign #'text = #(make-right-bracket-markup)
\once \override BreathingSign #'Y-offset = ##f
\breathe
}

%{ example of use:
\score{ \relative c'{ \set Score.timing = ##f \key f \major
f8( g4 a2 a8-- g4 f8 g4 f g f8[ e] f4 e2 f4 e2
\leftBracket g4. a8 bes2 a4 g a bes16[ a g8 a bes] c2 \bar""\break
bes8[ a] g4 bes a2 g8[ a bes c a] bes2 a4.\( bes8\) a4 g g8_-[ f16 g] a4 g f g2) \rightBracket
g8([ bes a g a bes]) }
\layout{ \context{ \Staff \remove "Time_signature_engraver" } } }
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% New command to add a three sided box, with sides north, west and south
%% Based on the box-stencil command defined in scm/stencil.scm
%% Note that you use ";" to comment a line in Scheme
#(define-public (NWS-box-stencil stencil thickness padding)
  "Add a box around STENCIL, producing a new stencil."
  (let* ((x-ext (interval-widen (ly:stencil-extent stencil 0) padding))
  (y-ext (interval-widen (ly:stencil-extent stencil 1) padding))
  (y-rule (make-filled-box-stencil (cons 0 thickness) y-ext))
  (x-rule (make-filled-box-stencil
    (interval-widen x-ext thickness) (cons 0 thickness))))
;    (set! stencil (ly:stencil-combine-at-edge stencil X 1 y-rule padding))
    (set! stencil (ly:stencil-combine-at-edge stencil X -1 y-rule padding))
    (set! stencil (ly:stencil-combine-at-edge stencil Y 1 x-rule 0.0))
    (set! stencil (ly:stencil-combine-at-edge stencil Y -1 x-rule 0.0))
    stencil))

%% The corresponding markup command, based on the \box command defined
%% in scm/define-markup-commands.scm
#(define-markup-command (NWS-box layout props arg) (markup?)
  "Draw a box round @var{arg}.  Looks at @code{thickness},
@code{box-padding} and @code{font-size} properties to determine line
thickness and padding around the markup."
  (let* ((th (chain-assoc-get 'thickness props  0.1))
  (size (chain-assoc-get 'font-size props 0))
  (pad (* (magstep size)
   (chain-assoc-get 'box-padding props 0.2)))
  (m (interpret-markup layout props arg)))
    (NWS-box-stencil m th pad)))

%{ Test it:
\relative c'{
  c^\markup{ \NWS-box ABCD }
  c^\markup{\NWS-box \note #"4" #1.0 }
}
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Usage:
%%% ------
%%%   \theSegnoRMark
%%%   \toCodaRMark
%%%   \codaNoNewLine \toSegnoRMark \DSMarkup
%%%   \theCodaRMark
%%%
%%% Example:
%%% --------
%%% { c d e f \segnoRMark
%%%   f d e c \toCodaRMark
%%%   c c e d \codaNoNewLine \toSegnoRMark \DSMarkup
%%%   \bar "||"
%%%   \theCodaRMark
%%%   c d e f
%%%   \bar "|." }

%%% Predefined options
%%% ------------------
%%% 1. "The-Coda-On-New-Line Layout" (\theCodaRMark)
%%% 1.1 Position of "The Coda"-Markup (\theCodaRMarkOnNewLine )
%%% 2. "The-Coda-No-New-Line Layout" (\theCodaRMark)

%%% Definitions
%%% ===========
%% Glyphs
%% ------
theSegnoGlyph = \markup { \musicglyph #"scripts.segno" }
toSegnoGlyph = \theSegnoGlyph
toCodaGlyph = \markup { \musicglyph #"scripts.coda" }
theCodaGlyph = \toCodaGlyph

%% some general shorthand commands
%% -------------------------------
padSegno = {
  \once \override Score.RehearsalMark #'padding = #'2
}
showClefKey = {
  \once \override Staff.KeySignature #'break-visibility = #all-visible
  \once \override Staff.Clef #'break-visibility = #all-visible
}
blankClefKey = {
  \once \override Staff.KeySignature #'break-visibility = #all-invisible
  \once \override Staff.Clef #'break-visibility = #all-invisible
}

%% segno-coda-markup related shorthands
%% ----------------------------
theSegnoRMark = {
  \padSegno % Pad away from key-accidentals
  \mark \markup { \theSegnoGlyph }
}
toCodaRMark = {
  \padSegno % keep "To Coda" on same level as Segno
  \once \override Score.RehearsalMark #'break-visibility = #begin-of-line-invisible
  \once \override Score.RehearsalMark #'font-size = #4 % Enlarge Coda-Sign
  \mark \markup { \toCodaGlyph }
}
toSegnoRMark = {
  \padSegno % keep "To Segno" on same level as "The Segno" and "To Coda"
  \once \override Score.RehearsalMark #'break-visibility = #begin-of-line-invisible
  \mark \markup { \toSegnoGlyph }
  \stopStaff % \cadenzaOn will suppress the bar count and
  \cadenzaOn % \stopStaff removes the staff lines (and creates some annoyances related to grob positioning, too)
}

%% Textual "dal segno" shorthands
%% ------------------------------
DSCodaTextLine = { % choice one
  \once \override TextScript #'extra-offset = #'(2 . -3.5)
  s1*0^\markup { D.S. al Coda }
}
DSCodaTextCenter = { % choice two
  \once \override TextScript #'extra-offset = #'(6 . -5.0)
  | s1*0^\markup { \center-align { D.S. "al Coda" } }
}
DSCodaTextSymbolCenter = { % choice three
  % 'padding or 'staff-padding won't accept negative values in 2.9.10,
  % so I had to use 'extra-offset instead of X-offset and one of the above
  \once \override TextScript #'extra-offset = #'(8 . -5.5)
  \once \override TextScript #'word-space = #1.5
  % \once \override TextScript #'baseline-skip = #0
  s1*0^\markup {
          \center-align {
            "D.S. al Coda"
            \line { % some kerning
              \halign #0 \musicglyph #"scripts.coda"
              \halign #0.7 \musicglyph #"scripts.tenuto"
              \halign #0 \musicglyph #"scripts.coda" }
          } }
}

%% "The Coda" related markup shorthands
%% ------------------------------------
theCodaRMarkSize = { % Make "the Coda" RehearsalMark easy to spot!
  \once \override Score.RehearsalMark #'font-size = #6
}

theCodaMiddleLeft = { % Choice 1 of The-Coda-On-New-Line Layout
  \theCodaRMarkSize
  % \once \override Score.RehearsalMark #'staff-padding = #-4.75 % can't use staff-padding (due to removerd staff?) - must use 'extra-offset
  % \once \override Score.RehearsalMark #'X-offset = #-4.5 % produces error - \stopStaff-related? - must use 'extra-offset
  \once \override Score.RehearsalMark #'extra-offset = #'(-1 . -10.65) % -10.65: volta bracket present
  \mark \markup { \theCodaGlyph }
}

theCodaTopLeft = { % Choice 2 of The-Coda-On-New-Line Layout
  \theCodaRMarkSize
  % \once \override Score.RehearsalMark #'staff-padding = #3 % can't use - see above
  % \once \override Score.RehearsalMark #'X-offset = #5 % can't use - see above
  \once \override Score.RehearsalMark #'extra-offset = #'(3.2 . 0) % Adjust to your layout
  \mark \markup { \theCodaGlyph }
}

theCodaRMarkNoNewLine = { % The-Coda-No-New-Line Layout
  % \once \override Score.RehearsalMark #'X-offset = #1.75
  \once \override Score.RehearsalMark #'padding = #2
  \once \override Score.RehearsalMark #'break-align-symbol =  #'clef
  \theCodaRMarkSize
  \mark \markup { \theCodaGlyph }
}

%% "The-Coda-On-New-Line": define position of "The Coda"-Markup
%% choices: \theCodaMiddleLeft or \theCodaTopLeft
%% ------------------------------------------------------------
theCodaRMarkOnNewLine =
  \theCodaMiddleLeft

%% "The-Coda-No-New-Line" Layout: space between "toSegno" and "theCoda"
%% --------------------------------------------------------------------
spacerNoNewLine = { % Increase unfold counter to adjust space
  \repeat unfold 2 {
    s4 s4 s4 s4
    \noBreak
    \bar ""
  }
}
%% "The-Coda-On-New-Line" Layout: space between "toSegno" and right margin
%% -----------------------------------------------------------------------
spacerWithNewLine = { % Increase unfold counter to adjust space
  \repeat unfold 5 {
    s4 s4 s4 s4
    \noBreak
    \bar ""
  }
}
%% shared Variable for both Layouts
%% --------------------------------
resumeStaff = {
  \cadenzaOff \startStaff % Resume bar count and show staff lines again
  \partial 32 s32 % Add a whee bit of staff before the clef!
  \bar ""
}
%% "The-Coda-On-New-Line" Layout: With indent
%% ------------------------------------------
doIndentTheCoda = {
  \blankClefKey
  \repeat unfold 1 { % Adjust unfold counter to manipulate indentation
    s4 s4 s4 s4
    \noBreak
    \bar ""
  }
  \theCodaRMarkOnNewLine
  \partial 64 s64
  \noBreak
  \bar ""
  \resumeStaff
  \showClefKey
}
%% "The-Coda-On-New-Line" Layout: WithOUT indent
%% ---------------------------------------------
dontIndentTheCoda = {
  \cadenzaOff \startStaff % Resume bar count and show staff lines again
  \theCodaRMarkOnNewLine
}

codaNoNewLine = { } % merely to avoid error message

%%% The Coda layout: uncomment only ONE set of the following
%%% ========================================================
%% Choice One: The Coda NOT on a new line
%% (a.k.a. "The-Coda-No-New-Line Layout")
%% --------------------------------------
% { !!Active!!
codaNoNewLine = { \noBreak }
theCodaRMark = {
  \spacerNoNewLine
  \resumeStaff
  \showClefKey % Show up, you clef and key!
  \theCodaRMarkNoNewLine
}
% } % !!Active!!

%% Choice Two: The Coda INDEED on a new line
%% (a.k.a. "The-Coda-On-New-Line Layout")
%% -----------------------------------------
%{ !!Off!!
theCodaRMark = {
  \spacerWithNewLine
  \break % This is the New line!
  \doIndentTheCoda % use \doIndentTheCoda or \dontIndentTheCoda to your liking
}
%} % !!Off!!

%%% Markup for textual D.S. display
%%% Choices are: \DSCodaTextCenter \DSCodaTextLine \DSCodaTextSymbolCenter
%%% ======================================================================
DSMarkup = \DSCodaTextSymbolCenter

%{ big example:
\clef treble
  \key g \major
  \time 4/4
  % \override Score.BarNumber #'break-visibility = #all-visible
  \relative c'' {
    \repeat unfold 5 { | c4 c c c }
    \theSegnoRMark % Set segno sign as rehearsal mark
    \repeat unfold 2 { | c4 c c c }
    \toCodaRMark % Set coda sign as rehearsal mark
    \repeat unfold 2 { | c4 c c c }
    \codaNoNewLine % Forbid line-break, if forthcoming Coda shouldn't be on new line
    \bar "||"
    \toSegnoRMark % Set segno sign as rehearsal mark
    \DSMarkup % Textual display of "dal Segno"
    % The coda
    \theCodaRMark % Set coda sign as rehearsal mark, add line break if wanted
    \repeat unfold 5 { | c4 c c c }
    \bar "||:"
    \repeat volta 3 { | c4 c c c }
    \alternative { { d d d e } { e e e f } { f f f g } }
    | c1
    \bar"|."
  }
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Definitions for letter-based rehearsalmarks (complete)
%% -------------------------------------
#(define (format-mark-box-letters-segno mark context)
  (markup #:line
    (#:center-align
      (#:musicglyph "scripts.segno"
        #:bold #:box (#:markletter (- (ly:context-property context 'rehearsalMark) 2))
        ))))

#(define (format-mark-box-letters-dsegno mark context)
  (markup #:line
    (#:center-align
      (#:line (#:musicglyph "scripts.segno" #:hspace 0.5 #:musicglyph "scripts.segno")
        #:bold #:box (#:markletter (- (ly:context-property context 'rehearsalMark) 2))
        ))))

#(define (format-mark-box-letters-coda mark context)
  (markup #:line
    (#:center-align
      (#:fontsize 3 #:musicglyph "scripts.coda"
        #:bold #:box (#:markletter (- (ly:context-property context 'rehearsalMark) 2))
        ))))

#(define (format-mark-box-letters-dcoda mark context)
  (markup #:line
    (#:center-align
      (#:line (#:fontsize 3 #:musicglyph "scripts.coda" #:hspace 0.5 #:fontsize 3 #:musicglyph "scripts.coda")
        #:bold #:box (#:markletter (- (ly:context-property context 'rehearsalMark) 2))
        ))))

#(define (format-mark-box-letters-varcoda mark context)
  (markup #:line
    (#:center-align
      (#:fontsize 3 #:musicglyph "scripts.varcoda"
        #:bold #:box (#:markletter (- (ly:context-property context 'rehearsalMark) 2))
        ))))

#(define (format-mark-box-letters-dvarcoda mark context)
  (markup #:line
    (#:center-align
      (#:line (#:fontsize 3 #:musicglyph "scripts.varcoda" #:hspace 0.5 #:fontsize 3 #:musicglyph "scripts.varcoda")
        #:bold #:box (#:markletter (- (ly:context-property context 'rehearsalMark) 2))
        ))))

%% Definitions for alphabet-based rehearsalmarks (segno and coda-marks)
%% --------------------------------------------------------------------
#(define (format-mark-box-alphabet-segno mark context)
  (markup #:line
    (#:center-align
      (#:musicglyph "scripts.segno"
        #:bold #:box (#:markalphabet (- (ly:context-property context 'rehearsalMark) 2))
        ))))

#(define (format-mark-box-alphabet-coda mark context)
  (markup #:line
    (#:center-align
      (#:fontsize 3 #:musicglyph "scripts.coda"
        #:bold #:box (#:markalphabet (- (ly:context-property context 'rehearsalMark) 2))
        ))))

%% Definitions for barnumber-based rehearsalmarks (segno and coda-marks)
%% ---------------------------------------------------------------------
#(define (format-mark-box-barnumber-segno mark context)
  (markup #:line
    (#:center-align
      (#:musicglyph "scripts.segno"
        #:bold #:box (number->string (ly:context-property context 'currentBarNumber))
        ))))

#(define (format-mark-box-barnumber-coda mark context)
  (markup #:line
    (#:center-align
      (#:fontsize 3 #:musicglyph "scripts.coda"
        #:bold #:box (number->string (ly:context-property context 'currentBarNumber))
        ))))

%% Definitions for number-based rehearsalmarks (segno and coda-marks)
%% --------------------------------------------------------------------
#(define (format-mark-box-numbers-segno mark context)
  (markup #:line
    (#:center-align
      (#:musicglyph "scripts.segno"
        #:bold #:box (number->string (- (ly:context-property context 'rehearsalMark) 1))
        ))))

#(define (format-mark-box-numbers-coda mark context)
  (markup #:line
    (#:center-align
      (#:fontsize 3 #:musicglyph "scripts.coda"
        #:bold #:box (number->string (- (ly:context-property context 'rehearsalMark) 1))
        ))))

%% some variables
stdMarkFormat = {
  \set Score.markFormatter = #format-mark-box-letters
}

markDefault = {
  \stdMarkFormat % this resets a possible previous segno/coda-mark
  \mark \default
}

markDefaultSegno = {
  \set Score.markFormatter = #format-mark-box-letters-segno
  \once \override Score.RehearsalMark #'baseline-skip = #5
  \mark \default
}

markDefaultDSegno = {
  \set Score.markFormatter = #format-mark-box-letters-dsegno
  \once \override Score.RehearsalMark #'baseline-skip = #5
  \mark \default
}

markDefaultCoda = {
  \set Score.markFormatter = #format-mark-box-letters-coda
  \once \override Score.RehearsalMark #'baseline-skip = #6
  \mark \default
}

markDefaultDCoda = {
  \set Score.markFormatter = #format-mark-box-letters-dcoda
  \once \override Score.RehearsalMark #'baseline-skip = #6
  \mark \default
}

markDefaultVarCoda = {
  \set Score.markFormatter = #format-mark-box-letters-varcoda
  \once \override Score.RehearsalMark #'baseline-skip = #6
  \mark \default
}

markDefaultDVarCoda = {
  \set Score.markFormatter = #format-mark-box-letters-dvarcoda
  \once \override Score.RehearsalMark #'baseline-skip = #6
  \mark \default
}

%{ example:
\score {
  \relative c' {
    c d e f
    \markDefault
    g a b c
    \markDefaultSegno
    c b a g
    \markDefault
    f e d c
    \markDefaultCoda
    c d e f
    \markDefault
    g a b c
    \markDefaultVarCoda
    c b a g
    \markDefault
    f e d c
    \markDefaultDSegno
    c d e f
    \markDefault
    g a b c
    \markDefaultDCoda
    c b a g
    \markDefault
    f e d c
    \markDefaultDVarCoda
    c b a g
    \bar "|."
  }
}
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Avoid tempo text increases note space
tempoNoSpace = #(define-music-function (parser location padding marktext)
    (number? string?)
    #{
      \once \override Score . RehearsalMark #'padding = $padding
      \once \override Score . RehearsalMark #'no-spacing-rods = ##t
      \mark \markup {  $marktext }
  #})

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Define a filter to combine two voices and erase things like
%% rests, fermatas and texts of the second voice

%{ definition of the voices:
mI = \relative c'' { R1-\fermataMarkup | c4\p d\accent c^"Text 1" d\fermata }
mII = \relative c'' { R1-\fermataMarkup | g4\p a\accent b_"Text 2" d_\fermata }
%}

%% Define a music-filter function, which is applied to each event. If it
%  returns false, the corresponding event is removed from the music. In our
%  case we want to remove all dynamics, text markups, articulations and all
%  markups assigned to MultiMeasures (which are MultiMeasureTextEvents, NOT
%  TextScriptEvent, see the section "Full measure rests" in the Notation
%  Reference)

#(define (filterOneEvent event)
(let ((eventname (ly:music-property event 'name)))
 (not (or ;; add here event name you do NOT want
   (eq? eventname 'MultiMeasureTextEvent)
   (eq? eventname 'AbsoluteDynamicEvent)
   (eq? eventname 'TextScriptEvent)
   (eq? eventname 'ArticulationEvent)
  ))))

filtermusic = #(define-music-function (parser location music) (ly:music?)
   (music-filter filterOneEvent music))

%{ example:
\score {
  \new Staff = "bothFiltered" <<
    \context Voice = "v1" << {\voiceOne \mI} >>
    \context Voice = "v2" << {\voiceTwo \filtermusic \mII} >>
  >>
}
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% make a tempoMark aligned with time or key signature
tempoMark = #(define-music-function (parser location tempomark anchor offset)
    (string? list? number?)
  #{
    \once \override Score.RehearsalMark #'self-alignment-X = #-1
    \once \override Score.KeySignature #'break-align-anchor-alignment = #CENTER
    \once \override Score.TimeSignature #'break-align-anchor-alignment = #LEFT
    \once \override Score.RehearsalMark #'break-align-symbols = #$anchor
    \once \override Score.RehearsalMark #'Y-offset = #$offset
    \mark \markup { \bold \smaller \smaller $tempomark }
  #})

%{ example:
\relative c'' {
  \key bes \minor
  \time 2/2
  \tempoMark #"Allegro" #'(key-signature) #0
  c des ees c
  bes aes c bes
  \key bes \minor
  \time 2/2
  \tempoMark #"Moderato" #'(time-signature) #0
  c des ees c
  bes aes c bes
}
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Print tempo mark like "fast 4=220-222"
compTempo =
  #(define-music-function (parser location prependText notevalue appendText) (string? string? string?)
  #{ \tempo \markup { \line { $prependText " (" \fontsize #-2 \general-align #Y #DOWN \note #$notevalue #1 $appendText ) } }
  #})

%{ example:
theMusic = {
  \once \override Score.RehearsalMark #'self-alignment-X = #-1
  \time 4/4 \compTempo "Fast" "4" "= 220-222" s1
}

\score {
  \theMusic
}
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Change instrument name easily
inst =
#(define-music-function (parser location string) (string?)
  (make-music
    'TextScriptEvent
    'direction UP
    'text (markup #:bold (#:box string))))

%{ example:
\relative c' { c \inst "Horn" d e f }
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Bis bar number
#(define (bis-bar-number BarNumber)
  "Append bis to the bar number."
  (let* (
    ; Set barNumber to the current value
    (barNumber (ly:grob-property BarNumber 'text))
    ; Append " bis" to it
    (bisBarNumber (string-append barNumber " bis")))
    ; Store the new value back
    (ly:grob-set-property! BarNumber 'text bisBarNumber))
  ; and print it
  (ly:text-interface::print BarNumber))

%{ example:
\score { \relative {
  \override Score.BarNumber #'self-alignment-X = #center
  \override Score.BarNumber #'break-visibility =
    #all-visible
  \repeat unfold 4 { a1 }
  \override Score.BarNumber #'stencil = #bis-bar-number
  \repeat unfold 4 { a1 }
  \revert Score.BarNumber #'stencil
  \repeat unfold 4 { a1 }
} }
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Nicolas' macro for instrument name definition
%% Usage:
%% \instrument for single line,
%% \instruments for centered multiline name

#(define-markup-command (hcenter-pad layout props width arg)
 (number? markup?)
 (let* ((arg-stencil (interpret-markup layout props arg))
        (w (interval-length (ly:stencil-extent arg-stencil X)))
        (pad-stencil (ly:make-stencil ""
                       (cons 0 (if (> w width)
                                0
                                (/ (- width w) 2.0)))
                       '(-0.1 . 0.1))))
  (stack-stencil-line 0
    (list pad-stencil arg-stencil pad-stencil))))

#(define-markup-command (instruments layout props texts) (markup-list?)
   (let ((indent (ly:output-def-lookup layout 'indent)))
     (interpret-markup layout props
      (make-column-markup
        (map (lambda (m) (markup #:hcenter-pad indent #:huge m))
        texts)))))

#(define-markup-command (instrument layout props text) (markup?)
 (interpret-markup layout props
  (markup #:instruments (text))))

%{ example:
\score {
  \new StaffGroup <<
    \new Staff <<
      \set Staff . instrumentName = \markup \instrument Violons
      { c'4 d' e' f' g'1 }
    >>
    \new Staff <<
      \set Staff . instrumentName = \markup \instruments { Haute-
        contres Tailles }
      { \clef alto c'4 d' e' f' g'1 }
    >>
    \new Staff <<
      \set Staff . instrumentName = \markup \instrument Basses
      { \clef bass c4 c c g, c1 }
    >>
  >>
  \layout { indent = 4\cm }
}
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% \extractMusic function:
%% \extractMusic \music s1*2 {s1*3 s2} }
%% start at bar 3, go 3 bars' far, then the half of the next bar
#(use-modules (srfi srfi-39))

#(define *current-moment*
  (make-parameter (ly:make-moment 0 1 0 1)))

#(define (clean-music music)
  (music-filter
   (lambda (evt)
     ;; don't keep simultaneous and  sequential music with empty 'elements
     (or (not (eq? 'EventChord (ly:music-property evt 'name)))
         (pair? (ly:music-property evt 'elements))
         (pair? (ly:music-property evt 'articulations))
         (ly:music? (ly:music-property evt 'element))))
   (music-filter
    (lambda (evt)
      ;; don't keep articulations or slurs with no notes assigned to
      (let ((elts (ly:music-property evt 'elements)))
        (not (and (eq? (ly:music-property evt 'name) 'EventChord)
                  (pair? elts)
                  (not (memq (ly:music-property (car elts) 'name)
                             (list 'NoteEvent 'RestEvent)))))))
    music)))

#(define (extract-music music from to)
  "description... `from' and `to' as moment"
  (let ((elts (ly:music-property music 'elements))
        (elt  (ly:music-property music 'element))
        (dur (ly:music-property music 'duration))
        (result music))
    (cond ((pair? elts)
           (if (not (eq? (ly:music-property music 'name) 'SimultaneousMusic))
               (set! (ly:music-property music 'elements) ;% for SequentialMusic
                     (filter (lambda (evt)
                               (extract-music evt from to))
                             elts)) ; for SimultaneousMusic
               (let ((max-moment (ly:make-moment 0 1 0 1))
                     (save-moment (*current-moment*))
                     (temp-moment (ly:make-moment 0 1 0 1))
                     (res-music (make-music 'Music)))
                 (set! (ly:music-property music 'elements)
                       (filter (lambda (evt)
                                 (set! res-music (extract-music evt from to))
                                (set! temp-moment (ly:moment-sub (*current-moment*) save-moment))
                                (if (ly:moment<? max-moment temp-moment)
                                    (set! max-moment temp-moment)) ;% keep the biggest length
                                (*current-moment* save-moment) ;%restore the previous length
                                res-music)
                               elts))
                 (*current-moment* (ly:moment-add save-moment max-moment)))))
          ((ly:music? elt)
           (extract-music elt from to))
          ((ly:duration? dur)
           (*current-moment* (ly:moment-add (*current-moment*) (ly:duration-length dur)))
           (set! result (and (ly:moment<? from (*current-moment*))
                             (not (ly:moment<? to (*current-moment*)))))))
    result))

%% the main function
extractMusic =
#(define-music-function (parser location music from during)
                       (ly:music? ly:music? ly:music?)
  (let* ((from-length (ly:music-length from))
         (during-length (ly:music-length during))
         (to-length (ly:moment-add during-length from-length)))
    (parameterize ((*current-moment* (ly:make-moment 0 1 0 1)))
      (clean-music (extract-music music from-length to-length)))))

%{ Example:
music = \relative {
 << { c4 d e f g1 } \\ { c,2 c b1 } >>
 g'4\< a b c\!
 << d1 \\ { b2\> b\! } >>
 d4( c) b-. a-.
 << { g1-> g4-. f-. e( d) } \\ { g4 f e d e2 r } >>
 c1
}

\score {
 <<
   \new Staff { \music }  %% original
   \new Staff {
     R1*2
     \extractMusic \music s1*2 s1*4
     %% extract the music begining at the 2 measures and during 4 measures
     R1*2
   }
 >>
}
%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% place scripts like fermata below text
below = { \once \override Script #'script-priority = #-100 }

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% function to ease tremolo writing
%% by Jay
%% usage: \tremolos #16 { c4 d e f }
#(define (tremolo-repeat-count dur music)
  (let* ((elements (ly:music-property music 'elements))
         (music-dur (ly:music-property (car elements) 'duration))
         (length (ly:duration-log music-dur))
         (dots (ly:duration-dot-count music-dur))
         (beats (* (- 2 (/ 1 (expt 2 dots))) (/ 4 (expt 2 length)))))
      (* beats (/ dur 4))))

#(define (make-tremolo dur music)
  (make-music
    'TremoloRepeatedMusic
    'elements
    '()
    'repeat-count
    (tremolo-repeat-count dur music)
    'element
    music))

#(define (tremoloize dur music)
  (if (eq? (ly:music-property music 'name) 'EventChord)
    (make-tremolo dur music)
    music))

% dur is 8, 16, 32, etc.
tremolos = #(define-music-function (parser location dur mus) (integer?
ly:music?)
  (music-map (lambda (x) (tremoloize dur x)) mus))

#(define (unfold-tremolos mus)
  (if (eq? (ly:music-property mus 'name) 'TremoloRepeatedMusic)
    (unfold-repeats mus)
    mus))

unfoldTremolos = #(define-music-function (parser location mus) (ly:music?)
  (music-map unfold-tremolos mus))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% slashed reverse turn
slashedturn =     \markup { \combine
  \vcenter \center-align \musicglyph #"scripts.reverseturn"
  \vcenter \center-align \fontsize #3.5 "|"
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% creating text spanners with 
%% arbitrary text. It allows you to specify as parameters:
%% The starting text
%% The outside staff priority
%% Whether the spanner is above or below the stave
%% The amount by which you want to adjust the left and right
%% ends of the spanner
%% The amount by which you want to adjust the left and right point
%% at which the spanner breaks when it crosses a line break
%% usage e.g.:
%%   \tspan "sul ponticello" #0 #DOWN #'(0 . -0.5) #5 #1
%%   g\startTextSpan c bes' ees, aes c, g c bes' ees, aes c,\stopTextSpan
tspan = #(define-music-function (parser location text osp dirn shorten adjBreak adjEnd) (string? number? number? pair? number? number?) #{
    % set osp to 999 if spanner is colliding with another element
    % this will position the spanner outside all other elements
    % can be normally be set to zero
    \once \override TextSpanner #'outside-staff-priority = #$osp
    \once \override TextSpanner #'bound-details #'left #'text = 
\markup\italic\small\bold { \concat { { $text } " " } }
    \once \override TextSpanner #'font-shape = #'upright
    % direction (either #UP or #DOWN)
    \once \override TextSpanner #'direction = #$dirn
    % setup dashed line and draw a bracket edge on RHS
    \once \override TextSpanner #'dash-period = #1.5
    \once \override TextSpanner #'dash-fraction = #0.3
    \once \override TextSpanner #'thickness = #0.8
    \once \override TextSpanner #'bound-details #'right #'text = \markup 
{ \draw-line #(cons 0 (/ $dirn -1)) }
    % set alignment of line with reference to left text
    \once \override TextSpanner #'bound-details #'left #'stencil-align-dir-y = #CENTER
    \once \override TextSpanner #'bound-details #'left #'padding = #(car $shorten)
    \once \override TextSpanner #'bound-details #'right #'padding = #(cdr $shorten)
    % allow adjustment of line end when it wraps to following stave
    \once \override TextSpanner #'bound-details #'right-broken #'padding = #$adjEnd
    % adjust LH end of line when it wraps to following stave so that it  doesn't
    % extend to the left of the notes on the stave
    \once \override TextSpanner #'bound-details #'left-broken #'X = #$adjBreak
    % optional override to remove text and bracket edge at line breaks
    \once \override TextSpanner #'bound-details #'left-broken #'text = ##f
    \once \override TextSpanner #'bound-details #'right-broken #'text = ##f
#})

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% The following hack makes regular rests hara-kiri-able
#(let* ((rest-def (assoc 'Rest all-grob-descriptions))
(meta-def (assoc 'meta (cdr rest-def)))
(interfaces-def (assoc 'interfaces (cdr meta-def)))
(interfaces (filter (lambda (interface)
(not (eqv? interface 'rhythmic-grob- interface)))
(cdr interfaces-def))))
(set-cdr! interfaces-def interfaces))

%%%%%%%%%%%%%%%%%%%%
%% chord glissando, up to 5 notes at a time
chordGliss =
#(define-music-function (parser location mus1 mus2) (ly:music? ly:music?)
  "Make a glissando between the notes of triads @code{mus1} and
@code{mus2}."
  (define (add-glissando musChord)
   (let ((els (ly:music-property musChord 'elements)))
    (ly:music-set-property! musChord 'elements (append els (list
(make-music 'GlissandoEvent))))
  musChord))
  (define (get-notes musicChord)
   (filter (lambda(x) (eq? (ly:music-property x 'name) 'NoteEvent))
     (ly:music-property musicChord 'elements)))
  (define (select-note musChord index)
    (let* ((notes (get-notes musChord))
      (non-notes (filter (lambda (x)
      (not (eq? (ly:music-property x 'name) 'NoteEvent)))
      (ly:music-property musChord 'elements)))
      (selected-note (list-ref notes index))
      (new-els (cons selected-note non-notes))
      (new-mus (ly:music-deep-copy musChord)))
    (ly:music-set-property! new-mus 'elements new-els) new-mus))
  (define (add-glissando-line mus1 mus2 index)
  #{ \new Voice {
    \hideNotes
    \override NoteColumn #'ignore-collision = ##t
    \once \override Glissando #'thickness = #2
    $(add-glissando (select-note mus1 (1- index)))
    $(select-note mus2 (1- index))
  } #})
  (let* ((notes1 (get-notes mus1))
    (notes2 (get-notes mus2))
    (note-count (min (length notes1) (length notes2))))
    #{ \once \override Glissando #'minimum-length = #5
       \once \override Glissando #'springs-and-rods =
#ly:spanner::set-spacing-rods
       \once \override Glissando #'thickness = #2
     <<
       \override NoteColumn #'ignore-collision = ##t
       {
         $(add-glissando mus1)
         $mus2
       }
       $(if (> note-count 1) (add-glissando-line mus1 mus2 1))
       $(if (> note-count 2) (add-glissando-line mus1 mus2 2))
       $(if (> note-count 3) (add-glissando-line mus1 mus2 3))
       $(if (> note-count 4) (add-glissando-line mus1 mus2 4))
       $(if (> note-count 5) (add-glissando-line mus1 mus2 5))
       $(if (> note-count 6) (add-glissando-line mus1 mus2 6))
       $(if (> note-count 7) (add-glissando-line mus1 mus2 7))
    >>
    \revert NoteColumn #'ignore-collision
  #}))

%{ \relative c' {
 \new Staff  {
   \override NoteColumn #'ignore-collision = ##t
   d8 [ \chordGliss <c e g>16 <d f a>] e4 <e g c> d |
   \chordGlissando <c e g>4 <e c f> \chordGlissando <c e g> <d f a> |
   \break
   \chordGlissando <c e>4 <e g>4
   \chordGlissando <c e g c>4 <e g c e>4
 }
}
%} 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% two functions for writing cues.
setCue = #(define-music-function (parser location instr) (string?)
   #{ \set Voice.instrumentCueName = $instr #} )

% generate a cue music section with instrument names
% Parameters: \namedCueDuring NameOfQuote CueDirection CueInstrument OriginalInstrument music
%                 -) NameOfQuote CueDirection music are the parameters for \cueDuring
%                 -) CueInstrument and OriginalInstrument are the displayed instrument names
% typical call:
% \namedCueDuring #"vIQuote" #UP #"V.I" #"Sop." { R1*3 }
%      This adds the notes from vIQuote (defined via \addQuote) to three measures, prints "V.I" at
%      the beginning of the cue notes and "Sop." at the end
namedCueDuring = #(define-music-function (parser location cuevoice direction instrcue instr cuemusic) (string? number? string? string? ly:music?)
   #{
     \tag #'cued { \cueDuring #$cuevoice #$direction { \setCue #$instrcue $cuemusic \setCue #$instr } }
     \tag #'uncued $cuemusic
   #})

setClefCue = #(define-music-function (parser location instr clef) 
                                                     (string? string?)
   #{
     \once \override Staff.Clef #'font-size = #-3 \clef $clef
     \set Voice.instrumentCueName = $instr
   #} )

% generate a cue music section with instrument names and clef changes
% Parameters: \cleffedCueDuring NameOfQuote CueDirection CueInstrument CueClef OriginalInstrument OriginalClef music
%                 -) NameOfQuote CueDirection music are the parameters for \cueDuring
%                 -) CueInstrument and OriginalInstrument are the displayed instrument names
%                 -) CueClef and OriginalClef are the clefs for the the cue notes and the clef of the containing voice
% typical call:
% \cleffedCueDuring #"vIQuote" #UP #"V.I" #"treble" #"Basso" #"bass" { R1*3 }
%      This adds the notes from vIQuote (defined via \addQuote) to three measures, prints "V.I" at
%      the beginning of the cue notes and "Basso" at the end. The clef is changed to treble at the 
%      beginning of the cue notes and reset to bass at the end
cleffedCueDuring = #(define-music-function (parser location cuevoice direction instrcue clefcue instr clefinstr cuemusic) 
                                                        (string? number? string? string? string? string? ly:music?)
   #{
     \tag #'cued { \cueDuring #$cuevoice #$direction { \setClefCue #$instrcue #$clefcue $cuemusic \setClefCue #$instr #$clefinstr } }
     \tag #'uncued $cuemusic
   #})

%{ examples:
% the voice, where cue notes are inserted:
Solo = \relative c'' {
   c2 c |
   \namedCueDuring #"vIQuote" #1 #"Vio.1" #"Sop." { R1*2 }
   c2 c \bar"||"
   \clef "bass"
   c,,2 c |
   \cleffedCueDuring #"vIQuote" #1 #"V1" #"treble" #"Basso" #"bass" { R1*2 }
   c2 c |
}

% the voice to be quoted
vI = \relative c'' { \clef "treble" f2 f | f f | f f | f f | f f | f f | f f | f f | }
\addQuote vIQuote { \vI }
% Lilypond >= 2.11 changed the spelling to \addQuote, so use the following command instead
% \addQuote vIQuote { \vI }

\layout {
  \context { \Score % set the font of the instrument names to a smaller size:
      \override InstrumentSwitch #'font-size = #-3
  }
}


% Solo score with cue notes:
\score {
  \new Staff \keepWithTag #'cued \Solo
  \header { piece="Solo score with cue notes"}
}

% full score with cue notes removed
\score {
        <<
                \new Staff \keepWithTag #'uncued \Solo
                \new Staff \keepWithTag #'uncued \vI
        >>
  \header { piece="Full score with cue notes removed"}
}
%}

