\version "2.13.49"

\include "mydefs.ly"
\include "articulate.ly"

\paper {
  left-margin = 20\mm
}

\header {
  tagline = ##f
  dedication = "Dedicated To Mr. Wang Xilin And Yang Shaoyi"
  title = \markup { \bold \fontsize #4 "Dance Of Heart" }
  composer = \markup { \bold \fontsize #3 "Hu Haipeng" }
  copyright = \markup { \center-column  { \line { "Copyright" \char ##x00A9 "2010-2011, by Hu Haipeng." } "All Rights Reserved." } }
}

  marks = {
    \set markFormatter = #format-mark-box-numbers
  % intro, 1-4
    \tempo \vivace 4=168
    \grace { s16 } s1.*4 |
  % a, rehearsal 1, 5-12
    \mark \default s1.*8 |
  % rehearsal 2, 13-17
    \mark \default s1*5/4*4 | s1. |
  % rehearsal 3, 18-28
    \mark \default
    s1*5/4*6 | s1.*4 |
    \tag #'score { s2 s1^\rit | }
    \tag #'midi { s2 \tempo 4=162 s8 \tempo 4=156 s \tempo 4=150 s \tempo 4=144 s \tempo 4=138 s \tempo 4=130 s \tempo 4=124 s \tempo 4=120 s \tempo 4=168 | }
  % rehearsal 4, 29-40
    \mark \default s1.*11^\atempo |
    \tag #'score { s1. \bar "||" \break }
    \tag #'midi { s2 \tempo 4=50 s4 \tempo 4=168 s2. | }
  % b, rehearsal 5, 41-54
    \tag #'hide { \hideMarks } \tag #'score { \mark \default \compTempo "Adagio" "4" "= ca 60" }
    \tag #'midi { \tempo 4=60 }
    s2.*3 | s1*9 |
    s1*2^\markup { \column { "I" "Spell of fate:" "Where's my way?" } } |
    \tag #'hide { \unhideMarks }
  % rehearsal 6, 55-66
    \mark \default \tempo "Andante" 4=69
    s2.*12 |
  % rehearsal 7, 67-81
    \mark \default
    s2.*8 |
    \tag #'score { s2.^\pocorit | }
    \tag #'midi { \tempo 4=66 s4 \tempo 4=63 s8 \tempo 4=60 s \tempo 4=56 s4 \tempo 4=69 | }
    s2.*4^\atempo |
    \tag #'score { s2.*2^\rit | }
    \tag #'midi { \tempo 4=64 s4 \tempo 4=60 s \tempo 4=56 s | s2. | }
  % rehearsal 8, 82-102
    \mark \default
    \tag #'score { \compTempo "Adagio" "4" "= ca 60" }
    \tag #'midi { \tempo 4=60 }
    s1*3 |
    s4. s8^\markup { \column { "Variant of spell 1:" "Must I have to" "deprave like this?" } } s2 | s1*2 |
    \tag #'hide { \hideMarks }
    \tag #'score { \textSpannerUp
    \override TextSpanner #'(bound-details left text) = \accel
    s2.*6^\startTextSpan |
    \tempo \agitato 4=176
    s2.*4^\stopTextSpan |
    \tempo \markup { \bold \italic "Poco lento" } 4=144
    s2.*4 | s2. | \break }
    \tag #'midi { \tempo 4=72 s4 \tempo 4=76 s \tempo 4=80 s |
    \tempo 4=84 s \tempo 4=90 s \tempo 4=96 s |
    \tempo 4=102 s8 \tempo 4=108 s \tempo 4=115 s \tempo 4=124 s \tempo 4=132 s \tempo 4=140 s |
    \tempo 4=144 s2. | \tempo 4=148 s2. |
    \tempo 4=154 s4 \tempo 4=160 s \tempo 4=168 s |
    \tempo 4=176 s2.*3 |
    \tempo 4=144 s2.*5 |
    s4 \tempo 4=90 s2 | }
    \tag #'hide { \unhideMarks }
  % rehearsal 9, 103-116
    \mark \default \tempo \markup { \bold \italic "Moderato, con spirito" } 4=96
    \grace { s16 } s1*5/4*14 |
  % rehearsal 10, 117-122
    \mark \default s1*5/4*6 |
  % rehearsal 11, 123-134
    \mark \default s1*5/4*10 |
    \tag #'score { s4 s1^\rit | }
    \tag #'midi { s4 \tempo 4=88 s \tempo 4=84 s \tempo 4=78 s2 \tempo 4=92 | }
    s1*5/4^\atempo \bar "||" \break
  % c, rehearsal 12, 135-142
    \mark \default \tempo \markup { \bold \italic "Tempo I, vivace" } 4=168
    s1*5/4*8 |
  % rehearsal 13, 143-148
    \mark \default
    s1*7/4 | s1*7/4 |
    s1.*4 \bar "||" \break
  % rehearsal 14, 149-161
    \mark \default s1.*8 |
    s1*5/4*4 | s1. |
  % rehearsal 15, 162-176
    \mark \default s1.*15 |
  % rehearsal 16, 177-180
    \mark \default s1.*4 |
  % rehearsal 17, 181-188
    \mark \default s1.*8 |
  % rehearsal 18, 189-202
    \mark \default
    s1*5/4*14 \bar "||" \break
  % d, rehearsal 19, 203-207
    \tag #'hide { \hideMarks } \tag #'score { \mark \default \tempo \adagio }
    \tag #'midi { \tempo 4=50 }
    s1 \bar ":" s \bar ":" s \bar ":" s \bar ":" s |
    \tag #'hide { \unhideMarks }
  % rehearsal 20, 208-221
    \mark \default \tempo \andante 4=76
    s1*2^\markup { \column { "Variant of spell 2:" "Oh, my love, where are you?" } } | s1. | s1*4 | s1. | s1*3 | s1. | s1 |
    \tag #'score { s1^\pocoaccel | }
    \tag #'midi { s2 \tempo 4=79 s4 \tempo 4=82 s | }
  % rehearsal 21, 222-228
    \mark \default \tempo 4=84
    s1*4 |
    \tempo \piumosso 4=88
    s1*3 |
  % rehearsal 22, 229-244
    \mark \default
    \tag #'score { s1^\rit | }
    \tag #'midi { \tempo 4=83 s4 \tempo 4=80 s \tempo 4=76 s \tempo 4=72 s | }
    \tempo \atempo 4=76
    s1. | s1*4 | s1. | s1*2 |
    \tag #'score { s2 s^\rit | s1 | }
    \tag #'midi { s2 \tempo 4=72 s4 \tempo 4=66 s | \tempo 4=60 s1 | }
    \tempo 4=58 s1*4 |
    \tag #'score { s1 \bar "||" \break }
    \tag #'midi { s2 \tempo 4=40 s | }
  % rehearsal 23, 245-249
    \mark \default \tempo \markup { \bold \italic "Moderato angoscioso" } 4=96
    s1*5 |
  % rehearsal 24, 250-254
    \mark \default
    s1*5 |
  % rehearsal 25, 255-261
    \mark \default
    s1*3 | s2.*4 |
  % rehearsal 26, 262-266
    \mark \default
    s2.*5 |
  % rehearsal 27, 267-272
    \mark \default \tempo \markup { \bold \italic "Poco lento" } 4=84
    s2.*6 |
  % rehearsal 28, 273-280
    \mark \default \tempo \agitato 4=104
    s1*4 |
    \tag #'score { s1*2^\rit |
      \tempo \atempo 4=84 s1 | s1 \bar "||" \break }
    \tag #'midi { \tempo 4=96 s4 \tempo 4=90 s \tempo 4=86 s2 | \tempo 4=82 s4 \tempo 4=80 s \tempo 4=74 s \tempo 4=66 s |
      \tempo 4=84 s1 | s2. \tempo 4=40 s4 | }
  % rehearsal 29, 281-286
    \mark \default
    \tag #'score { \compTempo "Adagio" "4" "= ca 60" s1*6 | }
    \tag #'midi { \tempo 4=60 s1*5 | s2. \tempo 4=30 s4 | }
  % rehearsal 30, 287-299
    \mark \default \tempo \piulento 4=58
    s1*5 |
    \tag #'score { s1^\pocorit | s2 \tempo 4=60 s | }
    \tag #'midi { s4 \tempo 4=56 s2 \tempo 4=54 s4 | \tempo 4=48 s2 \tempo 4=60 s | }
    s1*4 |
    \tag #'score { s1^\rit | s1 }
    \tag #'midi { s2 \tempo 4=56 s4 \tempo 4=52 s | \tempo 4=40 s1 } \bar "||" \break
  % e, rehearsal 31, 300-317
    \mark \default \tempo \markup { \bold \italic "Tempo I, vivace" } 4=168
    s1.*18 |
  % rehearsal 32, 318-322
    \mark \default
    s1.*5 |
  % rehearsal 33, 323-328
    \mark \default
    s1.*6 |
  % rehearsal 34, 329-336
    \mark \default
    s1.*8 |
  % rehearsal 35, 337-344
    \mark \default
    s1*5/4*8 |
  % rehearsal 36, 345-355
    \mark \default
    s1*5/4*6 | s1.*4 |
    \tag #'score { s2 s1^\rit | }
    \tag #'midi { s2 \tempo 4=162 s8 \tempo 4=156 s \tempo 4=150 s \tempo 4=144 s \tempo 4=138 s \tempo 4=130 s \tempo 4=124 s \tempo 4=120 s \tempo 4=168 | }
  % rehearsal 37, 356-362
    \mark \default
    s1.*7^\atempo |
  % rehearsal 38, 363-372
    \mark \default
    s1*5/4*10 \bar "||" \break
  % f, rehearsal 39, 373-378
    \mark \default \tempo \grave 4=52
    s1. |
    s1.*5^\markup { \column { "Variant of spell 4:" "Alack! What a ruthless reality!" } } \bar "||"
  }

  piccolo = \relative c'' {
    \clef treble \key g \minor \numericTimeSignature \time 6/4
    \transposition c''
  % intro, 1-4
    \grace { s16 } R1.*4 |
  % a, rehearsal 1, 5-12
    d4->\mp bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes(\< g-.) c-. bes-. bes-. g-. g'16->(\!\mf f d8-.) d4-.-> r |
    R1.*4 |
  % rehearsal 2' 13-17
    \time 5/4
    R1*5/4*3 |
    d'8->(\mp c16 d g,8-.) d'4-> bes8-. c16( bes g8-.) g4-. |
    \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4
    r2 r4 a8-.\p b-. cis-. cis-. cis-. cis-. |
    r2 r4 cis8-. e-. fis-. fis-. fis-. fis-. |
    R1. |
    a,8-.->\mf c-. d-. d-. d-. d-. a-.-> c-. d-. d-. d-. d-. |
    a-.-> c-. d-.\< d-. d-. d-. d-. d-. d-. d-. d-. d-. |
  % rehearsal 4, 29-40
    d4-.->\!\f r8 d,-. f-. g-. bes-. g-. bes-. f'4-> c8-. |
    d4-.-> r8 d,-. f-. g-. bes-. g-. bes-. f'4-> c8-. |
    d4-. bes8-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> \times 4/7 { d,16(\mf\< ees f g a bes c) } |
    d4-.->\!\f r8 d,-. f-. g-. bes-. g-. bes-. f'4-> c8-. |
    d4-.-> r8 d,-. f-. g-. bes-. g-. bes-. f'4-> c8-. |
    d4-. bes8-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes-.->\mf\< g-. c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. c-. g-. |
    c16->(\!\f bes g8-.) r4 r r2 r4 |
    R1. |
    r2 r4 d'8-.\f\< d-. d-. d-. d-. d-. |
    d16->(\!\ff bes4..-> ~ bes4)\fermata c16-> bes-> g8-.-> r4 r \bar "||"
  % b, rehearsal 5, 41-54
    \key c \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | R2. |
    R2.*4 | R2. | R2.^\fermataMarkup |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4*14 |
  % rehearsal 10, 117-122
    R1*5/4*6 |
  % rehearsal 11, 123-134
    R1*5/4*10 | R1*5/4 | R1*5/4 \bar "||"
  % c, rehearsal 12, 135-142
    \key g \minor
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1. | R1. |
    r2 r4 d'8-.\f\< d-. d-. d-. d-. d-. |
    d-.->\!\ff r r4 r r2 r4 \bar "||"
  % rehearsal 14, 149-161
    d,4->\mp bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes(\< g-.) c-. bes-. bes-. g-. g'16->(\!\mf f d8-.) d4-.-> r |
    R1.*4 |
    \time 5/4
    R1*5/4*3 |
    d'8->(\mp c16 d g,8-.) d'4-> bes8-. c16( bes g8-.) g4-. |
    \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    R1.*4 |
  % rehearsal 17, 181-188
    r4 r8 d-.\f f-. g-. bes-. g-. bes-. f'4-> c8-. |
    d4-.-> r8 d,-. f-. g-. bes-. g-. bes-. f'4-> c8-. |
    d4-. bes8-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> \times 4/7 { d,16(\mf\< ees f g a bes c) } |
    d4-.->\!\f r8 d,-. f-. g-. bes-. g-. bes-. f'4-> c8-. |
    d4-.-> r8 d,-. f-. g-. bes-. g-. bes-. f'4-> c8-. |
    d4-. bes8-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes-.->\mf\< g-. c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. bes-. c-. |
  % rehearsal 18, 189-202
    \time 5/4
    d-.->\!\f r r4 r r2 | R1*5/4*3 |
    f8-.->\mf\< c-. c-. f-.-> d-. f-.-> c-. c-. f-.-> d-. |
    f-.-> d-. f-.-> d-. f-.-> d-. f-.-> d-. f-.-> d-.->\!\ff |
    R1*5/4*8 \bar "||"
  % d, rehearsal 19, 203-207
    \key g \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 | R1 | R1 | R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    R1 | R1 |
    r4 gis,8->(\f\> ~ \times 2/3 { gis16 fis e } cis4)\!\mf r |
    r2 gis'8->(\f\> ~ \times 2/3 { gis16 fis e } cis4)\!\mf |
    r8 gis32(\< cis e fis) b8->(\!\f gis ~ gis\> fis16 e cis4)\!\mf |
  % rehearsal 24, 250-254
    R1 | R1 |
    r2 r4 \times 8/9 { e32(\mf\< fis gis a b cis dis e fis } |
    gis4->\!\f ~ gis16) r r8 r2 | R1 |
  % rehearsal 25, 255-261
    \key d \minor
    R1 | R1 |
    r2 r4 \times 8/9 { f,32(\mf\< g a bes c d e f g } |
    \time 3/4
    a4->\!\f ~ a16) r r8 r4 |
    R2.*3 |
  % rehearsal 26, 262-266
    R2.*3 |
    g16(\f\cresc f) f( d) g( f) f( d) g( f) f( d) |
    f8-.->\!\ff d-.-> r4 r |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    R1*4 | R1 | R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    \key g \major
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    r2 \times 2/3 { b4->\ff d-> e-> } |
    b2.-> \times 2/3 { a8( b g } |
    a2)\dim r8 b( a8. e16 |
    g2) r8 a( g8. b,16 |
    d2) r8 e( d8. g,16) |
    g1 ~ | g4\!\mp\fermata r r2 |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    r2 r4 a'16->(\mf g f8-.) f-. f-. f-. f-. |
    f->( g16 f d4-.) r a'16->( g f8-.) f-. f-. f-. f-. |
    g16( f d8-.) r4 r r2 r4 |
    R1. |
    a'16->(\f\cresc c d8-.) d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d4-.->\!\sf r r r2 \times 4/7 { d,16(\f ees f g a bes c } |
  % rehearsal 34, 329-336
    d4-.->) r r r2 r4 |
    R1. | R1. |
    r2 r4 r2 \times 4/7 { d,,16(\mp ees f g a bes c) } |
    d4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes(\< g-.) c-. bes-. bes-. g-. g'16->(\!\mf f d8-.) d4-.-> r |
  % rehearsal 35, 337-344
    \time 5/4
    R1*5/4*3 |
    d'8->(\mf c16 d g,8-.) d'4-> bes8-. c16( bes g8-.) g4-. |
    r2 r4 bes8-.->\f g-. g4-.-> |
    r2 r4 c16->( bes g8-.) g4-.-> |
    r4 c16->( bes g8-.) r4 c16->( bes g8-.) r4 |
    R1*5/4 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4
    r2 r4 a8-.\p b-. cis-. cis-. cis-. cis-. |
    r2 r4 cis8-. e-. fis-. fis-. fis-. fis-. |
    R1. |
    a,8-.->\mf c-. d-. d-. d-. d-. a-.-> c-. d-. d-. d-. d-. |
    a-.-> c-. d-.\< d-. d-. d-. d-. d-. d-. d-. d-. d-. |
  % rehearsal 37, 356-362
    d4-.->\!\f d,,16(\mf\< g bes c d g bes c) d->(\!\f\> c bes g d c bes g d\!\mf\< g bes c |
    d4-.->)\!\f d,16(\mf\< g bes c d g bes c) d->(\!\f\> c bes g d c bes g d\!\mf\< g bes c |
    d4-.->)\!\f bes'8-. \times 2/3 { c16->(\> bes g } \times 4/6 { ees c bes g ees c } d4-.)\!\mf bes''8-.\f \times 2/3 { c16->(\> bes g } \times 4/6 { ees c bes g ees c } |
    d4-.)\!\mf c16(\< ees g bes \times 4/5 { c ees g bes c) } \times 4/5 { d->(\!\f\> c a g f } \times 4/5 { d c a g f } d4-.)\!\mf |
    r d16(\< g bes c d g bes c) f->(\!\f\> d c bes g f d c bes\!\mf\< g bes c |
    d4-.->)\!\f d,16(\mf\< g bes c d g bes c) f->(\!\f\> d c bes g f d c bes\!\mf\< g bes c |
    d4-.->)\!\f bes'8-. \times 2/3 { c16->(\> bes g } \times 4/6 { ees c bes g ees c } d4-.)\!\mf bes''8-.\f \times 2/3 { c16->(\> bes g } \times 4/6 { ees c bes g ees c } |
  % rehearsal 38, 363-372
    \time 5/4
    d4-.\!\mp c''8-.\cresc g-. bes-.-> g-. c-. g-. bes-.-> g-. |
    c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. bes-. c-. |
    d4-.->\!\f r r bes8-. c-. d4-.-> |
    d-.-> r r f8-. d-. d4-.-> |
    d-.-> r r bes16( g bes c) d4-.-> |
    d-.-> r r g16->( f d8-.) d4-.-> |
    R1*5/4*3 |
    f8-.->\f\< d-. f-.-> d-. f-.-> d-. f-.-> d-. f-.-> d-. \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    g2.->\!\fff ~ g2\> ~ g4\!\f |
    R1.*5 \bar "||"
  }

  flutes = \relative c'' {
    \clef treble \key g \minor \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1.*4 |
  % a, rehearsal 1, 5-12
    R1.*3 |
    r2 r4 r2 \times 4/7 { d16(\mf\<^"I" ees f g a bes c) } |
    d4->\!\f bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> r |
  % rehearsal 2' 13-17
    \time 5/4
    R1*5/4*4 |
    \time 6/4
    c16(\mf bes g8-.) r4 r r2 r4 |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*4 |
    cis4(\mf fis,8-.) cis'4-> fis,8-. a-. b-. cis4-. |
    e8( fis16 e cis8-.) e4-> a,8-. b-. cis-. cis4-. |
    \time 6/4
    R1. | R1. |
    f8-.->\mp\< g-. a-. a-. a-. a-. f-.-> g-. a-. a-. a-. a-. |
    a,-.->\!\mf c-. d-. d-. d-. d-. a-.-> c-. d-. d-. d-. d-. |
    <a fis>-.-> <c a>-. <d c>-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 4, 29-40
    <d bes>4->\!\f bes8-.^"a2" d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> \times 4/7 { d,16(\mf\< ees f g a bes c) } |
    d4->\!\f bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes-.->\mf\<^"I" g-. c-. g-. bes-.-> g-. c-. g-. bes-.->^"a2" g-. c-. g-. |
    c16->(\!\f bes g8-.) r4 c,16->( bes g8-.) r2 r4 |
    R1. |
    d''8-.\mf\< d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d16->(\!\ff bes4..-> ~ bes4)\fermata c16-> bes-> g8-.-> r4 r \bar "||"
  % b, rehearsal 5, 41-54
    \key c \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4
    g8(\mf^\dolce^"I" c ~ c2 ~ |
    c8) g g( f) f( ees) |
    ees16( f g4. f8 ees |
    f16 ees c4.) bes8.( c32 bes |
    g2.) |
    g'8.( ees'16 c2 ~ |
    c8) bes bes( g) g( bes) |
    c16( bes g4. f8 ees) |
    c( g' f ees16 f c8) r |
    c( g' f ees16 f c4) |
    bes8( g4. ~ g4) |
    ees'8( c4. ~ c4) |
  % rehearsal 7, 67-81
    R2.*7 |
    r2 ees8(\mf\<^"I" f) |
    bes4..( c32 bes g4) |
    g8(\!\f c) c2 |
    f8( ees c4.) c8( |
    g'-> f16 ees c2) |
    bes8(\> c g2) |
    bes8( ~ \times 2/3 { bes16 c bes } g2 ~ |
    g4)\!\p\fermata r r |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4 | R1*5/4 |
    g8(\mf^"I" c4. ~ c4.) c8 bes16( c g bes |
    c2 ~ c4.) bes8 g16( bes f bes |
    g8-.) r16 g-. g8-. g4-> g-> g8 f16( g ees f |
    g8-.) g16-. g-. g8-. g4-> ees8 f( ees) c16( ees bes ees |
    c4-.) r r r2 | R1*5/4 |
    g'8-> r16 ees'16->( c2-> ~ c8) c bes16( c g bes |
    c2 ~ c4.) bes8 g16( bes f bes |
    g8-.) r16 g-. g8-. g4-> g-> g8 f16( g ees f |
    g8-.) g16-. g-. g8-. g4-> g-> g8 f16( g c, f |
    ees8-.) r16 ees-. ees4->( ~ ees16 f c f ees2 ~ |
    ees16) f(\mp\< c f ees f c f \tag #'score { ees2\trill } \tag #'midi { \repeat tremolo 8 { ees32 f } } ees32\!\mf\< f ges aes bes ces c d) |
  % rehearsal 10, 117-122
    ees2.->\!\f ~ ees8 bes16( ees) ges8(-> aes16 ges) |
    ees2.-> ~ ees8 des bes16( des aes des |
    bes8-.) r16 bes-. bes8-. bes4-> ees,8( ges ees) des'->( ees16 des |
    bes8-.) bes16-. bes-. bes8-. bes4-> bes,8( ees bes') aes16( bes ges aes |
    bes8-.->) r16 ees,-. ees2\> ~ ees4 bes16(\!\mf\< ees ges aes) |
    bes8-.->\!\f r16 ees,-. ees2\> ~ ees4 bes32(\!\mf\< des ees f aes bes des ees |
  % rehearsal 11, 123-134
    << { f8-.->)\!\f r r4 } \new Voice \voiceTwo { r2 } >> \oneVoice r8 f,4^"a2" bes8-. c-. ees-. |
    f-.-> r r4 r8 f,-. bes-. c-. ees-. f-. |
    bes-.-> r r4 r8 f,4 c'8-. ees-. f-. |
    bes-.-> r r4 r8 c,,-. ees-. f-. bes-. c-. |
    ees-.-> r16 ees-. ees8-. ees4 ees bes8-. ees-. f-. |
    ees-.-> ees16-. ees-. ees8-. ees4 ees aes,8-. bes-. ees-. |
    f8.-> f16-> f8-> f-> r4 r2 |
    f8.-> f16-> f8-> f-> r4 r2 |
    f4-.-> r f-.-> r f-.-> |
    r2 c4--->\ff bes---> c---> |
    f,---> bes---> c---> f2---> |
    g4-.-> r r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \key g \minor
    R1*5/4*6 |
    cis,4\mp^"I" fis,8-. cis'4 fis,8-. a-. b-. cis4-. |
    e4 a,8-. e'4 a,8-. c-. d-. e4-. |
  % rehearsal 13, 143-148
    \time 7/4
    r2 r r4 a,8-.\mf c-. d-.-> r |
    r2 r r4 a8-. c-. d-.-> r |
    \time 6/4
    r4 r8 a-. c-. d-. r4 r8 a-. c-. d-. |
    R1. |
    a8-.\f\<^"a2" c-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d-.->\!\ff r r4 r r2 r4 \bar "||"
  % rehearsal 14, 149-161
    R1.*3 |
    r2 r4 r2 \times 4/7 { d,16(\mf\<^"I" ees f g a bes c) } |
    d4->\!\f bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> r |
    \time 5/4
    R1*5/4*4 |
    \time 6/4
    c16(\mf bes g8-.) r4 r r2 r4 |
  % rehearsal 15, 162-176
    R1.*10 |
    bes8-.\mf^\legg^"I" g16( f ees8-.) g4 c,8-. ees-. c16( bes g8-.) f-. g-. bes-. |
    c-. bes16( c g8-.) bes-. c-. bes-. ees-. g,16( bes c bes c ees f ees f g |
    ees8-.) r r4 r r2 r4 |
    aes8-. ees16(\< f c8-.) ees-. f-. ees-. aes-. c,16( ees f ees f aes bes f aes bes |
    c8-.) c,16( ees f8-.) ees16( f aes f aes bes c8-.) ees,16( f g8-.) f16( g bes g bes c |
  % rehearsal 16, 177-180
    d8-.)\!\f r r4 r r r8 a16(^"a2" c d8-.->) r |
    r2 r4 r r8 a16( c d8-.->) r |
    r a16( c d8-.->) r r a16( c d8-.->) r r4 r |
    r2 r4 r2 \times 4/7 { d,16( ees f g a bes c) } |
  % rehearsal 17, 181-188
    d4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> \times 4/7 { d,16(\mf\< ees f g a bes c) } |
    d4->\!\f bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes-.->\mf\<^"I" g-. c-. g-. bes-.-> g-. c-. g-. bes-.->^"a2" g-. bes-. c-. |
  % rehearsal 18, 189-202
    \time 5/4
    d-.->\!\f r r4 r r2 |
    d4-> bes8-. d4-> g,8-. f'-. d-. d4-.-> |
    R1*5/4 |
    d4-> bes8-. d4-> g,8-. g'16->( f d8-.) d4-.-> |
    f8-.->\mf\< c-. c-. f-.-> d-. f-.-> c-. c-. f-.-> d-. |
    f-.-> d-. f-.-> d-. f-.-> d-. f-.-> d-. f-.-> d-.->\!\ff |
    R1*5/4*5 |
    <f d>1(\mp\> <d a>4 ~ |
    <d a>1)\!\p r4 | R1*5/4 \bar "||"
  % d, rehearsal 19, 203-207
    \key g \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 |
    r4 \times 2/3 { d,8(\mf^"I" f g } d'8 c16 bes g4) |
    \times 2/3 { r4 d8( } \times 2/3 { f g bes } f'16 d c bes g4) |
    \times 2/3 { r8 d(\< f } \times 2/3 { g bes d) } \times 2/3 { r f,( g } bes16 d f g |
  % rehearsal 22, 229-244
    a8->) \times 2/3 { r16 g( f } d4) r8 d,(\!\f e8. b'16 |
    \time 6/4 g2) r8 d( e b' g4) d'8.( e32 d |
    \time 4/4 b2) r8 b( a g |
    a2) r8 e( g b |
    a4.\> g8 e4) a,8.( b16 |
    d16\!\mf e d4.)\< r8 d8( e8.\!\f b'16 |
    \time 6/4 g2) r8 d( e b' g4) d'8.( e32 d |
    \time 4/4 b2) r8 d( e g) |
    a4.( g8 \times 2/3 { e4) b8( } \times 2/3 { d e g) } |
    a4.( g8 e\> g,16( a b d e g) |
    b1->\!\mp |
    R1 | R1 |
    r2 << { r8 d,,8(\p e g | b e4 b8 a4) b( | g1)\fermata } \\
      { r4 e | g2 c, | b1\fermata } >> \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    R1 | R1 |
    r4 gis''8->(\f\>^"a2" ~ \times 2/3 { gis16 fis e } cis4)\!\mf r |
    r2 gis'8->(\f\> ~ \times 2/3 { gis16 fis e } cis4)\!\mf |
    r8 gis32(\< cis e fis) b8->(\!\f gis ~ gis\> fis16 e cis4)\!\mf |
  % rehearsal 24, 250-254
    R1 | R1 |
    r2 \times 2/3 { e,4(\mf\< gis8 } \times 2/3 { b cis e) } |
    gis1->\!\f\> | <gis, e,>2^"I" <gis, e,>4\!\p r |
  % rehearsal 25, 255-261
    \key d \minor
    R1 | R1 |
    r2 \times 2/3 { f'4(\mf\<^"a2" a8 } \times 2/3 { c d f) } |
    \time 3/4
    a4->\!\f ~ a16 g-. g-. f-. f-. d-. d-. a-. |
    a-.\> g-. g-. f-. f-.^"I" d-. d-. a-. a4-.\!\mp |
    a''4->\f^"a2" ~ a16 g-. g-. f-. f-. d-. d-. a-. |
    a-.\> g-. g-. f-. f-.^"I" d-. d-. a-. a4-.\!\mp |
  % rehearsal 26, 262-266
    R2. |
    g'16(\cresc f) f( d) g( f) f( d) g( f) f( d) |
    g'( f) f( d) g( f) f( d) g( f) f( d) |
    g(^"a2" f) f( d) g( f) f( d) g( f) f( d) |
    f8-.->\!\ff d-.-> r4 r |
  % rehearsal 27, 267-272
    R2. | R2. |
    << { f2.(\p | d4) } \\ { gis,2. ~ | gis4 } >> r r |
    R2. | R2. |
  % rehearsal 28, 273-280
    \time 4/4
    r2 a32->\ff^"a2" a16.-.-> r8 r4 |
    r4 a32-> a16.-.-> r8 a32-> a16.-.-> r8 r4 |
    a8-.-> r f-.-> r d-.-> r a-.-> r |
    r2 \times 2/3 { <a f>8-.-> q-.-> q-.-> } q4-.-> |
    r2 \times 2/3 { q8-.->\f q-.-> q-.-> } q4-.-> |
    r2 \times 2/3 { <a e>8-_\mf\> q-_ q-_\!\mp } r4 |
    R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    \key g \major
    R1^\collaparte |
    r8 d(\p^"I" e8. b'16 g2)\fermata |
    R1 |
    r4 d'8.(\mp\> e32 d b2)\!\p\fermata |
    R1 |
    r4 \times 2/3 { g'4(\mp\> e8 } d2)\!\p\fermata |
  % rehearsal 30, 287-299
    r2 \times 2/3 { b4->\ff^"a2" d-> e-> } |
    \times 4/6 { <b' g>32->(\> <a e> <g d> <e c> <d a> <c g> } <a e>16-.)\!\f r r8 \times 4/6 { <a e>32( <c g> <d a> <e c> <g d> <a e>) } \times 4/6 { <b g>->( <a e> <g d> <e c> <d a> <c g> } <a e>16-.) r r8 \times 4/6 { <a e>32( <c g> <d a> <e c> <g d> <b g>) } |
    \times 4/6 { <a e>->(\dim <g d> <e c> <d a> <c g> <a e> } <g d>16-.) r r8 \times 4/6 { <g d>32( <a e> <c g> <d a> <e c> <g d>) } \times 4/6 { <a e>->( <g d> <e c> <d a> <c g> <a e> } <g d>16-.) r r8 \times 4/6 { <g d>32( <a e> <c g> <d a> <e c> <a e>) } |
    \times 4/6 { <g d>->( <e b> <d a> <b g> <a e> <g d> } <e b>16-.) r r8 \times 4/6 { <d a>32( <e b> <g d> <a e> <b g> <d a>) } \times 4/6 { <e b>->( <d a> <b g> <a e> <g d> <a e> } <e b>16-.) r r8 \times 4/6 { <b g>32( <d a> <e b> <g d> <a e> <b g>) } |
    \times 4/5 { <d a>->( <b g> <a e> <g d> <e b> } <d a>16-.) r r8 \times 4/5 { <d a>32( <e b> <g d> <a e> <b g>) } \times 4/5 { <d bes>->( <c g> <bes f> <g d> <f c> } <d bes>16-.) r r8 \times 4/5 { <d bes>32( <f c> <g d> <bes f> <d g,>) } |
    <e c>1 ~ | q4\!\p\fermata r r2 |
    R1 |
    r2 r8 d,(\mp^"I" e8. d'16 |
    b4) r r8 d,( e8. d'16 |
    b4) r r2 |
    r8 b,(\> d e g4 b) |
    <d g,>1\!\pp\fermata \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1. | R1. |
    f4->\mf^"I" des8-. f-. ees-. des-. ees16( des bes8-.) bes4-_ f-_ |
    R1. | R1. |
  % rehearsal 33, 323-328
    r2 r4 a16->( g f8-.) f-. f-. f-. f-. |
    f->( g16 f d4-.) r a'16->( g f8-.) f-. f-. f-. f-. |
    g16( f d8-.) r4 r r2 r4 |
    r2 r4 a'16->(\cresc c d8-.) d-. d-. d-. d-. |
    << { a16->( c d8-.) } \\ { r4 } >> <d a>8-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q4-.->\!\sf r r r \times 4/7 { d,16(\f^"I" ees f g a bes c } d8-.) r |
  % rehearsal 34, 329-336
    d4->^"a2" bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> r |
    R1.*4 |
  % rehearsal 35, 337-344
    \time 5/4
    f4->(\f^"I" d8-.) f4-> bes,8-. c-. d-. d4-. |
    R1*5/4 |
    f8->( g16 f d8-.) f4-> bes,8-. c-. d-. d4-.-> |
    R1*5/4 |
    r2 r4 bes8-.->^"a2" g-. g4-.-> |
    r2 r4 c16->( bes g8-.) g4-.-> |
    r4 c16->( bes g8-.) r4 c16->( bes g8-.) r4 |
    R1*5/4 |
  % rehearsal 36, 345-355
    R1*5/4*4 |
    cis4(\mf^"I" fis,8-.) cis'4-> fis,8-. a-. b-. cis4-. |
    e8( fis16 e cis8-.) e4-> a,8-. b-. cis-. cis4-. |
    \time 6/4
    R1. | R1. |
    f8-.->\mp\< g-. a-. a-. a-. a-. f-.-> g-. a-. a-. a-. a-. |
    a,-.->\!\mf c-. d-. d-. d-. d-. a-.-> c-. d-. d-. d-. d-. |
    <a fis>-.-> <c a>-. <d c>-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 37, 356-362
    <d bes>4->\!\f bes8-.^"a2" d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> \times 4/7 { d,16(\mf\< ees f g a bes c) } |
    d4->\!\f bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
  % rehearsal 38, 363-372
    \time 5/4
    bes8-.->\mp\cresc^"I" g-. c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. |
    c-. g-. bes-.-> g-. c-. g-. bes-.->^"a2" g-. bes-. c-. |
    d4-.->\!\f r r bes8-. c-. d4-.-> |
    d-.-> r r f8-. d-. d4-.-> |
    d-.-> r r bes16( g bes c) d4-.-> |
    d-.-> r r g16->( f d8-.) d4-.-> |
    R1*5/4 |
    f8-.->\mf^"I" c-. c-. f-.-> d-. f-.-> c-. c-. f-.-> d-. |
    f-.->\cresc d-. f-.-> d-. f-.-> d-. f-.-> d-. f-.-> d-. |
    f-.->^"a2" d-. f-.-> d-. f-.-> d-. f-.-> d-. f-.-> d-. \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    g2.->\!\fff ~ g2\> ~ g4\!\f |
    r2 r4 <g des>2.\ff |
    r2 r4 <g, des>2.\f |
    r2 r4 <g, des>2.\mp\> ~ |
    q4\!\p r r r2 r4 |
    R1. \bar "||"
  }

  oboes = \relative c' {
    \clef treble \key g \minor \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1. | R1. |
    d8-.->\f^"I" r r4 r r2 r4 | R1. |
  % a, rehearsal 1, 5-12
    R1.*3 |
    r2 r4 r2 \times 4/7 { d16(\mf\<^"I" ees f g a bes c) } |
    d4->\!\f bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> r |
  % rehearsal 2, 13-17
    \time 5/4
    f4->(\mp d8-.) f4-> bes,8-. c-. d-. d4-. |
    R1*5/4 |
    f8->( g16 f d8-.) f4-> bes,8-. c-. d-. d4-. |
    R1*5/4 |
    \time 6/4
    c16(\mf bes g8-.) r4 r r2 r4 |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*4 |
    cis4(\mf fis,8-.) cis'4-> fis,8-. a-. b-. cis4-. |
    e8( fis16 e cis8-.) e4-> a,8-. b-. cis-. cis4-. |
    \time 6/4 R1. | R1. |
    f8-.->\mp\<^"II" g-. a-. a-. a-. a-. f-.-> g-. a-. a-. a-. a-. |
    a,-.->\!\mf c-. d-. d-. d-. d-. a-.-> c-. d-. d-. d-. d-. |
    <d a>-.-> <fis c>-. <fis d>-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 4, 29-40
    <g d>4->\!\f bes,8-.^"a2" d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> \times 4/7 { d,16(\mf\< ees f g a bes c) } |
    d4->\!\f bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes-.->\mf\<^"I" g-. c-. g-. bes-.-> g-. c-. g-. bes-.->^"a2" g-. c-. g-. |
    c16->(\!\f bes g8-.) r4 c16->( bes g8-.) r2 r4 |
    r2 r4 d'8-.\mp\cresc d-. d-. d-. d-. d-. |
    d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d16->(\!\ff bes4..-> ~ bes4)\fermata c16-> bes-> g8-.-> r4 r \bar "||"
  % b, rehearsal 5, 41-54
    \key c \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*5 |
    g4.(\mp\< f8 g bes |
    c4)\mf ees16( f g8 f ees16 f |
    c2) ees,8( f) |
    bes4..( c32 bes g4) |
    g8(\!\f c) c2 |
    f8( ees c4.) c8( |
    g'-> f16 ees c2) |
    bes8(\> c g2) |
    bes8(^"I" ~ \times 2/3 { bes16 c bes } g2 ~ |
    g4)\!\p\fermata r r |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4*13 |
    r2 r4 ees32(\mf^"I" f ges aes bes ces c d) ees,( f ges aes bes ces c d) |
  % rehearsal 10, 117-122
    \key ees \minor
    ees2.->\!\f ~ ees8 bes16( ees) ges8(-> aes16 ges) |
    ees2.-> ~ ees8 des bes16( des aes des |
    bes8-.) r16 bes-. bes8-. bes4-> ees,8( ges ees) des'->( ees16 des |
    bes8-.) bes16-. bes-. bes8-. bes4-> r8 ees,( bes') aes16( bes ges aes |
    bes8-.->) r16 ees,-. ees2\> ~ ees4 bes16(\!\mf\< ees ges aes) |
    bes8-.->\!\f r16 ees,-. ees2\> ~ ees4 r32 des(\!\mf\< ees f aes bes des ees |
  % rehearsal 11, 123-134
    << { f8-.->)\!\f r r4 } \new Voice \voiceTwo { r2 } >> \oneVoice r8 f,4^"a2" bes8-. c-. ees-. |
    f-.-> r r4 r8 f,-. bes-. c-. ees-. f-. |
    bes-.-> r r4 r8 f,4 c'8-. ees-. f-. |
    bes-.-> r r4 r8 c,,-. ees-. f-. bes-. c-. |
    ees-.-> r16 ees-. ees8-. ees4 ees bes8-. ees-. f-. |
    ees-.-> ees16-. ees-. ees8-. ees4 ees aes,8-. bes-. ees-. |
    f8.-> f16-> f8-> f-> r4 r2 |
    f8.-> f16-> f8-> f-> r4 r2 |
    f4-.-> r f-.-> r f-.-> |
    r2 c4--->\ff bes---> c---> |
    f,---> bes---> c---> f2---> |
    g4-.-> r r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \key g \minor
    R1*5/4*3 |
    bes4\p^"I" g8-. bes4 ees,8-. f-. g-. g4-. |
    bes8( c16 bes g8-.) bes4 ees,8-. f-. g-. g4-. |
    R1*5/4*3 |
  % rehearsal 13, 143-148
    \time 7/4
    r2 r r4 a,8-.\mf c-. d-.-> r |
    r2 r r4 a8-. c-. d-.-> r |
    \time 6/4
    r4 r8 a-. c-. d-. r4 r8 a-. c-. d-. |
    r2 r4 a8-.\cresc^"a2" c-. d-. a-. c-. d-. |
    a-. c-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d-.->\!\ff r r4 r r2 r4 \bar "||"
  % rehearsal 14, 149-161
    R1.*3 |
    r2 r4 r2 \times 4/7 { d,16(\mf\<^"I" ees f g a bes c) } |
    d4->\!\f bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> r |
    \time 5/4
    f4->(\mp d8-.) f4-> bes,8-. c-. d-. d4-. |
    R1*5/4 |
    f8->( g16 f d8-.) f4-> bes,8-. c-. d-. d4-. |
    R1*5/4 |
    \time 6/4
    c16(\mf bes g8-.) r4 r r2 r4 |
  % rehearsal 15, 162-176
    R1.*8 |
    g'8-.\mf^\legg^"I" a16( g e8-.) g4 c,8-. d-. c-. e-. c-. a-. e-. |
    g-. d16( e g8-.) e4 g8-. c-. g16( a c a c d e d e g |
    bes8-.) r r4 r r2 r4 | R1. |
    ees,8-. des16( ees bes8-.) des-. ees-. des-. ges-. bes,16( des ees des ees ges aes ges aes bes |
    aes8-.) r r4 r r2 r4 |
    r8 c,,16(\< ees f8-.) ees16( f aes f aes bes c8-.) ees,16( f g8-.) f16( g bes g bes c |
  % rehearsal 16, 177-180
    d8-.)\!\f r r4 r r r8 a16(^"a2" c d8-.->) r |
    r2 r4 r r8 a16( c d8-.->) r |
    r a16( c d8-.->) r r a16( c d8-.->) r r4 r |
    r2 r4 r2 \times 4/7 { d,16( ees f g a bes c) } |
  % rehearsal 17, 181-188
    d4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> \times 4/7 { d,16(\mf\< ees f g a bes c) } |
    d4->\!\f bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes-.->\mf\<^"I" g-. c-. g-. bes-.-> g-. c-. g-. bes-.->^"a2" g-. bes-. c-. |
  % rehearsal 18, 189-202
    \time 5/4
    d-.->\!\f r r4 r r2 |
    d4-> bes8-. d4-> g,8-. f'-. d-. d4-.-> |
    R1*5/4 |
    d4-> bes8-. d4-> g,8-. g'16->( f d8-.) d4-.-> |
    f8-.->\mf\< c-. c-. f-.-> d-. f-.-> c-. c-. f-.-> d-. |
    f-.-> d-. f-.-> d-. f-.-> d-. f-.-> d-. f-.-> d-.->\!\ff |
    R1*5/4*8^"II changes to English horn" \bar "||"
  % d, rehearsal 19, 203-207
    \key g \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    \set Staff.midiInstrument = "oboe"
    r2 r8 d,(\f e8. b'16 |
    \time 6/4 g2) r8 d( e b' g4) d'8.( e32 d |
    \time 4/4 b2) r8 b( a g |
    a2) r8 e( g b |
    a4.\> g8 e4) a,8.( b16 |
    d16\!\mf e d4.)\< r8 d8( e8.\!\f b'16 |
    \time 6/4 g2) r8 d( e b' g4) d'8.( e32 d |
    \time 4/4 b2) r8 d( e g) |
    a4.( g8 \times 2/3 { e4) b8( } \times 2/3 { d e g) } |
    a4.( g8 e\> g,16( a b d e g) |
    b1->\!\mp |
    R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    \set Staff.midiInstrument = "oboe"
    R1 | R1 |
    r4 gis8->(\f\> ~ \times 2/3 { gis16 fis e } cis4)\!\mf r |
    r2 gis'8->(\f\> ~ \times 2/3 { gis16 fis e } cis4)\!\mf |
    r8 gis32(\< cis e fis) b8->(\!\f gis ~ gis\> fis16 e cis4)\!\mf |
  % rehearsal 24, 250-254
    R1 | R1 |
    r2 \times 2/3 { gis4(\mf\< cis8 } \times 2/3 { e4 gis8) } |
    cis1->\!\f\> | cis,4\!\mf r r2 |
  % rehearsal 25, 255-261
    \key d \minor
    R1 | R1 |
    r2 \times 2/3 { a4(\mf\< d8 } \times 2/3 { f4 a8) } |
    \time 3/4
    d2->\!\f r4 | R2. |
    d2-> r4 | R2. |
  % rehearsal 26, 262-266
    R2. |
    d,2.\mp\cresc ~ | d |
    g16( f) f( d) g( f) f( d) g( f) f( d) |
    f8-.->\!\ff d-.-> r4 r |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    r2 f32->\ff f16.-.-> r8 r4 |
    r4 f32-> f16.-.-> r8 f32-> f16.-.-> r8 r4 |
    f8-.-> r d-.-> r a-.-> r f-.-> r |
    R1 | R1 | R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    \key g \major
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    r2 \times 2/3 { b4->\ff d-> e-> } |
    b'2.-> \times 2/3 { a8( b g } |
    a2)\dim r8 b( a8. e16 |
    g2) r8 a( g8. b,16 |
    d2) r8 e( d8. g,16) |
    g1 ~ | g4\!\mp\fermata r r2 |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1. | R1. |
    f'4->\mf^"I" des8-. f-. ees-. des-. ees16( des bes8-.) bes4-_ f-_ |
    c'-> aes8-. c-. bes-. aes-. bes16( aes f8-.) f4-_ c-_ |
    R1. |
  % rehearsal 33, 323-328
    r2 r4 a'4.->( g8-.) a-. c-. |
    a4-.-> r r a4.->( g8-.) a-. c-. |
    a4-.-> r4 r r2 r4 |
    a16->(\cresc c d8-.) d-. d-. d-. d-. a16->( c d8-.) d-. d-. d-. d-. |
    a16->(^"a2" c d8-.) d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d4-.->\!\sf r r \times 4/7 { d,16(\f^"I" ees f g a bes c) } \times  4/7 { d,( ees f g a bes c } d8-.) r |
  % rehearsal 34, 329-336
    d4->^"a2" bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> r |
    R1.*4 |
  % rehearsal 35, 337-344
    \time 5/4
    f4->(\f^"I" d8-.) f4-> bes,8-. c-. d-. d4-. |
    R1*5/4 |
    f8->( g16 f d8-.) f4-> bes,8-. c-. d-. d4-.-> |
    R1*5/4 |
    r2 r4 bes8-.->^"a2" g-. g4-.-> |
    r2 r4 c16->( bes g8-.) g4-.-> |
    r4 c16->( bes g8-.) r4 c16->( bes g8-.) r4 |
    R1*5/4 |
  % rehearsal 36, 345-355
    R1*5/4*4 |
    cis4(\mf^"I" fis,8-.) cis'4-> fis,8-. a-. b-. cis4-. |
    e8( fis16 e cis8-.) e4-> a,8-. b-. cis-. cis4-. |
    \time 6/4 R1. | R1. |
    f8-.->\mp\<^"II" g-. a-. a-. a-. a-. f-.-> g-. a-. a-. a-. a-. |
    a,-.->\!\mf c-. d-. d-. d-. d-. a-.-> c-. d-. d-. d-. d-. |
    <d a>-.-> <fis c>-. <fis d>-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 37, 356-362
    <g d>4->\!\f bes,8-.^"a2" d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> \times 4/7 { d,16(\mf\< ees f g a bes c) } |
    d4->\!\f bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
  % rehearsal 38, 363-372
    \time 5/4
    bes8-.->\mp\cresc^"I" g-. c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. |
    c-. g-. bes-.-> g-. c-. g-. bes-.->^"a2" g-. bes-. c-. |
    d4-.->\!\f r r bes8-. c-. d4-.-> |
    d-.-> r r f8-. d-. d4-.-> |
    d8-.-> c16( d g,8-.) bes4-> g8-. bes16( g bes c) d4-.-> |
    d8-.-> c16( d g,8-.) bes4-> g8-. g'16->( f d8-.) d4-.-> |
    R1*5/4 |
    f8-.->\mf^"I" c-. c-. f-.-> d-. f-.-> c-. c-. f-.-> d-. |
    f-.->\cresc d-. f-.-> d-. f-.-> d-. f-.-> d-. f-.-> d-. |
    f-.->^"a2" d-. f-.-> d-. f-.-> d-. f-.-> d-. f-.-> d-. \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    g2.->\!\fff ~ g2\> ~ g4\!\f |
    bes->\fff des,-> bes'16-> g8.-> ~ g2 ~ g8 r |
    R1.*4 \bar "||"
  }

  enghorn = \relative c'' {
    \clef treble \key d \minor \numericTimeSignature \time 6/4
    \transposition f
  % intro, 1-4
    \grace { s16 } R1.*4 |
  % a, rehearsal 1, 5-12
    R1.*8 |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 4, 29-40
    R1.*11 | R1.^\fermataMarkup \bar "||"
  % b, rehearsal 5, 41-54
    \key g \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | R2. |
    R2.*4 | R2. | R2.^\fermataMarkup |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4*14 |
  % rehearsal 10, 117-122
    R1*5/4*6 |
  % rehearsal 11, 123-134
    R1*5/4*10 | R1*5/4 | R1*5/4 \bar "||"
  % c, rehearsal 12, 135-142
    \key d \minor
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1.*4 \bar "||"
  % rehearsal 14, 149-161
    R1.*8 |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    R1.*4 |
  % rehearsal 17, 181-188
    R1.*8 |
  % rehearsal 18, 189-202
    \time 5/4
    R1*5/4*14 |
  % d, rehearsal 19, 203-207
    \key d \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 |
    \set Staff.midiInstrument = "english horn"
    r2 r8 a(\mp^\dolce b8. fis'16 |
    \time 6/4 d2) r8 a( b fis' d4 a'8. b32 a |
    \time 4/4 fis2) r8 fis( e d |
    e2) r8 b( d fis |
    e4. d8 b4) e,8.( fis16 |
    a16 b a4.) r8 a8( b8. fis'16 |
    \time 6/4 d2) r8 a(\< b fis' d4 a'8. b32 a |
    \time 4/4 fis2) r8 a( b d |
    e4.\!\mf d8 b4 fis8. b16 |
    a2) r8 fis( a b) |
    \time 6/4 b( fis4 e16 d e8 b4.) r8 a( b d |
    \time 4/4 fis b4\> fis8 e4 fis |
    d2.)\!\mp r4 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 | R1 | R1 | R1*3 |
    \set Staff.midiInstrument = "english horn"
    r2 r8 a(\mp b8. a'16 | fis1)\fermata \bar "||"
  % rehearsal 23, 245-249
    \key gis \minor
    R1*5 |
  % rehearsal 24, 250-254
    R1 | R1 |
    r2 \times 2/3 { gis,4(\mf\< b8 } \times 2/3 { dis4 gis8) } |
    b1->\!\f\> | b,4\!\mf r r2 |
  % rehearsal 25, 255-261
    \key a \minor
    R1 | R1 |
    r2 \times 2/3 { a4(\mf\< c8 } \times 2/3 { e4 a8) } |
    \time 3/4
    c2->\!\f r4 | R2. |
    c2-> r4 | R2. |
  % rehearsal 26, 262-266
    R2. |
    fis,2.\mp\cresc ~ | fis |
    d16( c) c( a) d( c) c( a) d( c) c( a) |
    c8-.->\!\ff a-.-> r4 r |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    r2 a'32->\ff a16.-.-> r8 r4 |
    r4 a32-> a16.-.-> r8 a32-> a16.-.-> r8 r4 |
    a8-.-> r e-.-> r c-.-> r a-.-> r |
    R1 | R1 | R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 277-283
    \key d \major \time 4/4
    \set Staff.midiInstrument = "english horn"
    r2 r8 a(\p^\adlib b8. fis'16 |
    d2.) r4\fermata |
    r8 a(\< b fis' d4) a'8.(\!\mp\> b32 a |
    fis2.)\!\p r4\fermata |
    \times 2/3 { a,8(\< b fis' } \times 2/3 { d e b' } fis4) d'->(\!\mf\> |
    b8 a4. ~ a2)\!\p\fermata |
  % rehearsal 30, 287-299
    \set Staff.midiInstrument = "oboe"
    r2 \times 2/3 { fis4->\ff a-> b-> } |
    fis'2.-> \times 2/3 { e8( fis d } |
    e2)\dim r8 fis( e8. b16 |
    d2) r8 e( d8. fis,16 |
    a2)\!\mf r2 |
   \set Staff.midiInstrument = "english horn"
    R1 |
    r2\fermata r8 a,(\mp\< b d |
    fis b4\!\mf fis8 e4)\> fis( |
    d1)\!\mp | R1 |
    r2 r8 a( b8.) b'16( |
    a8)^"Changes to oboe II" r r4 r2 |
    R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key d \minor \time 6/4
    \set Staff.midiInstrument = "oboe"
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    R1.*6 |
  % rehearsal 34, 329-336
    R1.*8 |
  % rehearsal 35, 337-344
    \time 5/4
    R1*5/4*8 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 37, 356-362
    R1.*7 |
  % rehearsal 38, 363-372
    \time 5/4
    R1*5/4*10 \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    R1. | R1.*5 \bar "||"
  }

  clarinets = \relative c' {
    \clef treble \key a \minor \numericTimeSignature \time 6/4
    \transposition bes
  % intro, 1-4
    \grace { s16 } R1. | R1. |
    r2 r4 b8-.\f^"I" r r4 r |
    R1. |
  % a, rehearsal 1, 5-12
    e'4->\mp c8-. e-. d-. c-. d16( c a8-.) a4-_ e-_ |
    e'4-> c8-. e-. d-. c-. d16( c a8-.) a4-_ e-_ |
    c'8( a-.) c-. d4-> a8-. c( a-.) c-. d4-> a8-. |
    c(\< a-.) d-. c-. c-. a-. a'16->(\!\mf g e8-.) e4-.-> r |
    R1.*4 |
  % rehearsal 2, 13-17
    \time 5/4
    R1*5/4 |
    e4->(\mp^"I" a,8-.) e'4-> c8-. d16( c a8-.) a4-. |
    R1*5/4 |
    e'8->( d16 e a,8-.) e'4-> c8-. d16( c a8-.) a4-. |
    \time 6/4
    r4 d16(\mf c a8-.) r4 r2 r4 |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4 | R1*5/4 |
    c4(\mp a8-.) c4-> f,8-. g-. a-. a4-. |
    c8( d16 c a8-.) c4-> f,8-. g-. a-. a4-. |
    R1*5/4 | R1*5/4 |
    \time 6/4
    r2 r4 b8-.->\p cis-. dis-. dis-. dis-. dis-. |
    r2 r4 dis8-.-> fis-. gis-. gis-. gis-. gis-. |
    R1. | R1. |
    <b b,>8-.->\mf <d d,>-. <e e,>-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 4, 29-40
    q4-.->\!\f r8 <e, e,>-. <g g,>-. <a a,>-. <c c,>-. <a a,>-. <c c,>-. <g' g,>4-> <d d,>8-. |
    <e e,>4-.-> r8 <e, e,>-. <g g,>-. <a a,>-. <c c,>-. <a a,>-. <c c,>-. <g' g,>4-> <d d,>8-. |
    <e e,>4-. <c c,>8-. <d d,>4-> <a a,>8-. <c c,>( <a a,>-.) <c c,>-. <d d,>4-> <a a,>8-. |
    <c c,>( <a a,>-.) <d d,>-. <c c,>-. <c c,>-. <a a,>-. <a' a,>16->( <g g,> <e e,>8-.) <e e,>4-.-> \times 4/7 { <e, e,>16(\mf\< <f f,> <g g,> <a a,> <b b,> <c c,> <d d,>) } |
    <e e,>4-.->\!\f r8 <e, e,>-. <g g,>-. <a a,>-. <c c,>-. <a a,>-. <c c,>-. <g' g,>4-> <d d,>8-. |
    <e e,>4-.-> r8 <e, e,>-. <g g,>-. <a a,>-. <c c,>-. <a a,>-. <c c,>-. <g' g,>4-> <d d,>8-. |
    <e e,>4-. <c c,>8-. <d d,>4-> <a a,>8-. <c c,>( <a a,>-.) <c c,>-. <d d,>4-> <a a,>8-. |
    r2 <c c,>8-.->\mf\< <a a,>-. <d d,>-. <a a,>-. <c c,>-.-> <a a,>-. <d d,>-. <a a,>-. |
    <d d,>16->(\!\f <c c,> <a a,>8-.) r4 <d, d,>16->( <c c,> <a a,>8-.) r2 r4 |
    r8 e-.\p\cresc^"a2" e-. e-. e-. e-. e-. e-. e-. e-. e-. e-. |
    e'-. e-. e-. e-. e-. e-. <e' e,>-. q-. q-. q-. q-. q-. |
    <e e,>16->(\!\ff c4..->^"a2" ~ c4)\fermata d16-> c-> a8-.-> r4 r \bar "||"
  % b, rehearsal 5, 41-54
    \key d \minor \time 3/4
    a,32(\mf^\adlib^"I" c d8. ~ d4) f8( a |
    g16 f) f( g) g32( f d8. ~ d4) |
    \times 2/3 { r8 f( a) } g16( d) d( f) f( c) c( d) |
    \time 4/4
    d4 d32( c a8. ~ a8) g(\> d8.) d32( g |
    a2)\!\mp r8 r16 c8.( d32 c a g |
    d2) \times 2/3 { r8 g(\< d } g16 a  g a |
    d2)\!\mf \times 4/6 { g,16(\< d g a g a } \times 2/3 { c a c } d8-.) |
    a32( d g8.->\!\f ~ g2) g8 g |
    \times 2/3 { g8 g g } g-> d-> a'32( f g8.-> ~ g4 ~ |
    g4 \times 2/3 { r8 g\< g } \times 4/5 { g16 g g g g } g8-> d-> |
    c'32->(\!\ff a8..-> ~ a4) r16 g\> g( e c e) r16 d32( c |
    a2)\!\mf r16 g\> g( e c e) r16 d32( c |
    a1\!\p ~ | a2.)\fermata r4 \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    a8(\p^"I" d) d2 |
    d8(\< g) g4( f8 d) |
    c'(\!\mp a4. ~ a8) g( |
    f16\> g a8 g f d4)\!\p |
    R2. | a4.(\mp\< g8 a c |
    d4)\!\mf f16( g a8 g f16 g |
    d2) r4 |
    <a'' e>2( <e c>4) |
    <f d>4.\!\f <g g,>8( <a a,> <c c,> |
    <d d,>8 <c c,> <a a,>) <f f,>16( <g g,> <a a,> <g g,> <a a,> <c c,> |
    <d d,>4) << { a8( g f g |
      a4) e2\> | fis2. ~ | fis4\!\p\fermata } \\
      { a,8( g f g |
      a4.) c8( g c | a4) c2 ~ | c4\fermata } >> r r |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } <a d,>8-.\p r16 q-. q8-. q4 q q8-. <c ees,>4->( |
    <a d,>8-.) q16-. q-. q8-. q4 q q8-. <c ees,>4->( |
    <a d,>8-.) r16 q-. q8-. q4 q q8-. <c ees,>4->( |
    <a d,>8-.) q16-. q-. q8-. q4 q q8-. <c ees,>4->( |
    <a d,>8-.) r16 q-. q8-. q4 q q8-. <c ees,>4->( |
    <a d,>8-.) q16-. q-. q8-. q4 q q8-. <c ees,>4->( |
    <a d,>2.\< ~ <a d,>4) <c ees,>4->(\!\mf\> |
    <a d,>2.\!\p\< ~ <a d,>4) <c ees,>4->(\!\mf\> |
    <a d,>8-.)\!\p r16 q-. q8-. q4 q q8-. <c ees,>4->( |
    <a d,>8-.) q16-. q-. q8-. q4 q q8-. <c ees,>4->( |
    <a d,>8-.) r16 q-. q8-. q4 q q8-. <c ees,>4->( |
    <a d,>8-.) q16-. q-. q8-. q4 q q8-. <c ees,>4->( |
    <aes d,>8-.) r16 q-. q8-. q4 q q8-. <c f,>4->( |
    <aes d,>8-.)\< q16-. q-. q8-. q4 q q8-. <f' f,>32( <g g,> <aes aes,> <bes bes,> <c c,> <des des,> <d d,> <e e,>) |
  % rehearsal 10, 117-122
    <f f,>2.->\!\f ~ <f f,>8 <c c,>16( <f f,>) <aes aes,>8(-> <bes bes,>16 <aes aes,>) |
    <f f,>2.-> ~ <f f,>8 <ees ees,> <c c,>16( <ees ees,> <bes bes,> <ees ees,> |
    <c c,>8-.) r16 q-. q8-. q4-> <f, f,>8( <aes aes,> <f f,>) <ees' ees,>->( <f f,>16 <ees ees,> |
    <c c,>8-.) q16-. q-. q8-. q4-> <c, c,>8( <f f,> <c' c,>) <bes bes,>16( <c c,> <aes aes,> <bes bes,> |
    <c c,>8-.->) r16 <f, f,>-. <f f,>2\> ~ <f f,>4 <c c,>16(\!\mf\< <f f,> <aes aes,> <bes bes,>) |
    <c c,>8-.->\!\f r16 <f, f,>-. <f f,>2\> ~ <f f,>4 <c c,>32(\!\mf\< <ees ees,> <f f,> <g g,> <bes bes,> <c c,> <ees ees,> <f f,> |
  % rehearsal 11, 123-134
    <g g,>8-.->)\!\f r r4 r8 <d, c>4 <g f>8-. <a g>-. <c bes>-. |
    <d c>-.-> r r4 r8 <d, c>-. <g f>-. <a g>-. <c bes>-. <d c>-. |
    <g f>-.-> r r4 r8 <d, c>4 <a' g>8-. <c bes>-. <d c>-. |
    <g f>-.-> r r4 r8 <a,, g>-. <c bes>-. <d c>-. <g f>-. <a g>-. |
    bes-.->^"a2" r16 bes-. bes8-. bes4 bes f8-. bes-. bes-. |
    bes-.-> bes16-. bes-. bes8-. bes4 bes f8-. f-. bes-. |
    <d bes>8.-> q16-> q8-> q-> r4 r2 |
    q8.-> q16-> q8-> q-> r4 r2 |
    q4-.-> r q-.-> r q-.-> |
    r2 <a g>4--->\ff <g f>---> <a g>---> |
    <d, c>---> <g f>---> <a g>---> <d c>2---> |
    <e d>4-.-> r r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \key a \minor
    R1*5/4*6 |
    dis,4\mp^"I" gis,8-. dis'4 gis,8-. b-. cis-. dis4-. |
    fis4 b,8-. fis'4 b,8-. d-. e-. fis4-. |
  % rehearsal 13, 143-148
    \time 7/4
    r2 r r4 <b b,>8-.\mf <d d,>-. <e e,>-.-> r |
    r2 r r4 <b b,>8-. <d d,>-. <e e,>-.-> r |
    \time 6/4
    r4 r8 <b b,>-. <d d,>-. <e e,>-. r4 r8 <b b,>-. <d d,>-. <e e,>-. |
    R1. |
    <b b,>8-.\f\< <d d,>-. <e e,>-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-.->\!\ff r r4 r r2 r4 \bar "||"
  % rehearsal 14, 149-161
    e,4->\mp^"I" c8-. e-. d-. c-. d16( c a8-.) a4-_ e-_ |
    e'4-> c8-. e-. d-. c-. d16( c a8-.) a4-_ e-_ |
    c'8( a-.) c-. d4-> a8-. c( a-.) c-. d4-> a8-. |
    c(\< a-.) d-. c-. c-. a-. a'16->(\!\mf g e8-.) e4-.-> r |
    R1.*4 |
    \time 5/4
    R1*5/4 |
    e4->(\mp^"I" a,8-.) e'4-> c8-. d16( c a8-.) a4-. |
    R1*5/4 |
    e'8->( d16 e a,8-.) e'4-> c8-. d16( c a8-.) a4-. |
    \time 6/4
    r4 d16(\mf c a8-.) r4 r2 a,32(\p\< b cis d e f g gis |
  % rehearsal 15, 162-176
    a8-.)\!\mp r r4 r r2 r4 | R1.*7 |
    r8 fis,8(\mf a b d e fis4.) a8( b a |
    fis4 e8 d a b) d( b a fis) r4 |
    r8 f( a c d4) r8 a( c d f g) |
    a4( g8 f c d) f( d c a f) r |
    r c''( bes aes ees f) aes( f ees c aes) r |
    r d'(\< c bes f g) bes( g f d bes) r |
    r bes( d f g4) r8 d( f g a4) |
  % rehearsal 16, 177-180
    b8-.\!\f r r4 r r r8 <b' b,>16( <d d,> <e e,>8-.->) r |
    r2 r4 r r8 <b b,>16( <d d,> <e e,>8-.->) r |
    r <b b,>16( <d d,> <e e,>8-.->) r r <b b,>16( <d d,> <e e,>8-.->) r r b,,16(^"a2" d e8-.->) r |
    R1. |
  % rehearsal 17, 181-188
    r4 r8 <e' e,>-. <g g,>-. <a a,>-. <c c,>-. <a a,>-. <c c,>-. <g' g,>4-> <d d,>8-. |
    <e e,>4-.-> r8 <e, e,>-. <g g,>-. <a a,>-. <c c,>-. <a a,>-. <c c,>-. <g' g,>4-> <d d,>8-. |
    <e e,>4-. <c c,>8-. <d d,>4-> <a a,>8-. <c c,>( <a a,>-.) <c c,>-. <d d,>4-> <a a,>8-. |
    <c c,>( <a a,>-.) <d d,>-. <c c,>-. <c c,>-. <a a,>-. <a' a,>16->( <g g,> <e e,>8-.) <e e,>4-.-> \times 4/7 { <e, e,>16(\mf\< <f f,> <g g,> <a a,> <b b,> <c c,> <d d,>) } |
    <e e,>4-.->\!\f r8 <e, e,>-. <g g,>-. <a a,>-. <c c,>-. <a a,>-. <c c,>-. <g' g,>4-> <d d,>8-. |
    <e e,>4-.-> r8 <e, e,>-. <g g,>-. <a a,>-. <c c,>-. <a a,>-. <c c,>-. <g' g,>4-> <d d,>8-. |
    <e e,>4-. <c c,>8-. <d d,>4-> <a a,>8-. <c c,>( <a a,>-.) <c c,>-. <d d,>4-> <a a,>8-. |
    r2 <c c,>8-.->\mf\< <a a,>-. <d d,>-. <a a,>-. <c c,>-.-> <a a,>-. <c c,>-. <d d,>-. |
  % rehearsal 18, 189-202
    \time 5/4
    <e e,>-.->\!\f r r4 r r2 | R1*5/4*3 |
    <g g,>8-.->\mf\< <d d,>-. <d d,>-. <g g,>-.-> <e e,>-. <g g,>-.-> <d d,>-. <d d,>-. <g g,>-.-> <e e,>-. |
    <g g,>-.-> <e e,>-. <g g,>-.-> <e e,>-. <g g,>-.-> <e e,>-. <g g,>-.-> <e e,>-. <g g,>-.-> <e e,>-.->\!\ff |
    R1*5/4*5 |
    <b g>1(\mp\> <g e>4 ~ |
    <g e>1)\!\p r4 | R1*5/4 \bar "||"
  % d, rehearsal 19, 203-207
    \key a \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    r2 r4 <e,~ d>(\p |
    \time 6/4 <e cis>1 ~ q4) <e b>( |
    \time 4/4 <fis a,>1)\< |
    <fis b,>1\!\mp | <e cis> |
    \time 6/4 <fis~ cis>2( <fis b,>) <e a,>2 |
    \time 4/4 <fis dis>2(\> <e d>) |
    <cis a>2.(\!\p\< <e b>4) |
  % rehearsal 21, 222-228
    <fis a,>1\!\mp ~ | q |
    << { fis2.( dis4 | e2.) } \\ { a,1( | gis2.) } >> r4 |
    r4 \times 2/3 { e'8(\mf^"I" g a } e'8 d16 c a4) |
    \times 2/3 { r4 e8( } \times 2/3 { g a c } g'16 e d c a4) |
    \times 2/3 { r8 e(\< g } \times 2/3 { a c e) } \times 2/3 { r g,( a } c16 e g a |
  % rehearsal 22, 229-244
    b8->) \times 2/3 { r16 a( g } e4)\!\f r2 |
    \set tupletSpannerDuration = #(ly:make-moment 1 4)
    \time 6/4 << { \times 4/7 { e'16([ fis e cis b a fis] e[ cis e fis a b cis] e[ fis e cis b a fis] e[ fis e cis b a fis] e[ cis e fis a b cis] e[ fis cis e fis a b] } |
      \time 4/4 cis8) r r4 r2 | R1 |
      \times 4/7 { b16([\> cis b a fis dis cis] b[ cis b a fis dis cis] dis[ fis cis dis fis a b] cis[ dis b cis dis fis a] } |
      \times 4/7 { b[\!\mf cis b gis fis e d] b[ cis b gis fis e d] b[\< d e fis gis b d] e[ b d e fis gis b] } |
      \time 6/4 e8)\!\f r r4 r2 r |
      \time 4/4 \times 4/7 { cis16([ e cis b a fis e] cis[ b a b cis e fis] a[ b a fis e cis b] cis[ e b cis e fis a] } |
      \times 4/7 { b[ cis b a fis e d] b[ cis b a fis e d] b[ d a b d fis a] b[ d a b d fis a] } |
      b8) r r4 r \times 4/7 { a16(\mf\> b fis a b cis e } |
      fis1->\!\mp ~ | fis8) } \\
    { R1. |
      \times 4/7 { cis16([ e cis b a fis e] cis[ b a b cis e fis] a[ b a fis e cis b] cis[ e b cis e fis a] } |
      \times 4/7 { b[ cis b a fis e d] b[ cis b a fis e d] b[ d a b d fis a] b[ cis a b cis fis a] } |
      b8) r r4 r2 | R1 |
      \times 4/7 { e16([ fis e cis b a fis] e[ cis e fis a b cis] e[ fis e cis b a fis] e[ fis e cis b a fis] e[ cis e fis a b cis] e[ fis cis e fis a b] } |
      cis8) r r4 r2 | R1 |
      \times 4/7 { b16([ cis b a fis e cis] b[ cis b a fis e cis] e[ fis a b cis e fis] e[ fis cis e fis a b] } |
      a1-> ~ | a8) } >> r r4 r2 |
    R1 | r2 r4 <e c>(\p |
    <dis b>2) <gis, e>( |
    <e a,>1)\fermata \bar "||"
  % rehearsal 23, 245-249
    \key dis \minor
    R1 | R1 |
    r4 ais'8->(\f\>^"a2" ~ \times 2/3 { ais16 gis fis } dis4)\!\mf r |
    r2 ais'8->(\f\> ~ \times 2/3 { ais16 gis fis } dis4)\!\mf |
    r8 ais32(\< dis fis gis) cis8->(\!\f ais ~ ais\> gis16 fis dis4)\!\mf |
  % rehearsal 24, 250-254
    <ais, fis>4(\p\< <dis ais> <fis dis>\!\mp\> <dis ais>) |
    \times 2/3 { <ais fis>4(\p\< <cis gis>8 } \times 2/3 { <dis ais>4 <ais' fis>8\!\mp } \times 2/3 { <gis dis>4 <fis cis>8 } <dis ais>4) |
    <fis dis>2\< \times 2/3 { fis4(^"a2" ais8 } \times 2/3 { cis dis fis) } |
    ais1->\!\f\> | <dis, ais>2^"I" <dis, ais>4\!\p r |
  % rehearsal 25, 255-261
    \key e \minor
    <b g>4(\< <e b> <g e>\!\mp\> <e b>) |
    \times 2/3 { <b g>4(\p\< <d a>8 } \times 2/3 { <e b>4 <b' g>8\!\mp } \times 2/3 { <a e>4 <g d>8 } <e b>4) |
    <g e>2\< \times 2/3 { g4(^"a2" b8 } \times 2/3 { d e g) } |
    \time 3/4
    b4->\!\f ~ b16 a-. a-. g-. g-. e-. e-. b-. |
    b-.\> a-. a-. g-. g-.^"I" e-. e-. b-. b4-.\!\mp |
    b''4->\f ~ b16 a-. a-. g-. g-. e-. e-. b-. |
    b-.\> a-. a-. g-. g-.^"I" e-. e-. b-. b4-.\!\mp |
  % rehearsal 26, 262-266
    a'16(\p\cresc g) g( e) a( g) g( e) a( g) g( e) |
    a( g) g( e) a( g) g( e) a( g) g( e) |
    a'( g) g( e) a( g) g( e) a( g) g( e) |
    a(^"a2" g) g( e) a( g) g( e) a( g) g( e) |
    g8-.->\!\ff e-.-> r4 r |
  % rehearsal 27, 267-272
    R2. | R2. |
    << { e2.(\p | g4) } \\ { cis,2. ~ | cis4 } >> r r |
    R2. | R2. |
  % rehearsal 28, 273-280
    \time 4/4
    r2 b32->\ff^"a2" b16.-.-> r8 r4 |
    r4 b32-> b16.-.-> r8 b32-> b16.-.-> r8 r4 |
    b8-.-> r g-.-> r e-.-> r b-.-> r |
    r2 \times 2/3 { <e b>8-.-> q-.-> q-.-> } q4-.-> |
    r2 \times 2/3 { q8-.->\f q-.-> q-.-> } q4-.-> |
    r2 \times 2/3 { q8-_\mf\> q-_ q-_\!\mp } r4 |
    << { e1 | R1^\fermataMarkup } \\
      { e1\p\> ~ | e2\!\pp r\fermata } >> \bar "||"
  % rehearsal 29, 281-286
    \key a \major
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1 |
    r8 \times 4/6 { <b'' fis>32(\f <a e> <fis d> <e b> <fis d> <d a> } \times 4/6 { <e b> <fis d> <a e> <b fis> <d a> <e b> } <b fis>16-.) r r8 \times 4/6 { <b fis>32( <a e> <fis d> <e b> <fis d> <d a> } \times 4/6 { <e b> <fis d> <a e> <b fis> <d a> <e b> } <b fis>16-.) r |
    r8 \times 4/6 { <a e>32(\dim <fis d> <e b> <d a> <e b> <b fis> } \times 4/6 { <d a> <e b> <fis d> <a e> <b fis> <d a> } <a e>16-.) r r8 \times 4/6 { <a e>32( <fis d> <e b> <d a> <e b> <b fis> } \times 4/6 { <d a> <e b> <fis d> <a e> <b fis> <d a> } <a e>16-.) r |
    r8 \times 4/6 { <fis cis>32( <e b> <cis a> <e b> <b fis> <cis a> } \times 4/6 { <a e> <b fis> <cis a> <e b> <fis cis> <a e> } <e b>16-.) r r8 \times 4/6 { <fis cis>32( <e b> <cis a> <b fis> <a e> <b fis> } \times 4/6 { <fis cis> <a e> <b fis> <cis a> <e b> <fis cis> } <cis a>16-.) r |
    r8 \times 4/5 { <e b>32( <cis a> <b fis> <a e> <fis cis> } \times 4/5 { <e b> <fis cis> <a e> <b fis> <cis a> } <e b>16-.) r r8 \times 4/5 { <e c>32( <d a> <c g> <a e> <g d> } \times 4/5 { <e c> <g d> <a e> <c g> <d a> } <e c>16-.) r |
    <a fis>1 ~ |
    q4\!\p\fermata r r8 <b,, gis>(\< <e a,>4) |
    <dis a>2(\!\mp <d gis,>)\> |
    <cis e,>1\!\p ~ | q ~ |
    q8 e,(\mp^"I" fis8. e'16 cis8) r r4 |
    R1 |
    <cis'' e,>1\pp\fermata \bar "||"
  % e, rehearsal 31, 300-317
    \key a \minor \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*3 |
    d,,4->\mf^"I" bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d'-_ |
    a'-> f8-. a-. g-. f-. g16( f d8-.) d-. a-. b-. d-. |
  % rehearsal 33, 323-328
    e4-.-> r r g8( a16 g e8-.) g4-> d8-. |
    e4-.-> r r g8( a16 g e8-.) g4-> d8-. |
    e4-.-> r r r2 r4 |
    R1. |
    << { b''16->(\cresc d e8-.) } \new Voice \voiceTwo { r4 } >> \oneVoice <e a,>8-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q4-.->\!\sf r \times 4/7 { e,,,16(\f^"I" f g a b c d) } \times 4/7 { e,( f g a b c d } e8-.) r \times 4/7 {  <e' e,>16( <f f,> <g g,> <a a,> <b b,> <c c,> <d d,> } |
  % rehearsal 34, 329-336
    <e e,>4-.->) r r r2 r4 |
    R1. | R1. |
    r2 r4 r2 \times 4/7 { e,,16(\mp^"I" f g a b c d) } |
    e4-> c8-. e-. d-. c-. d16( c a8-.) a4-_ e-_ |
    e'4-> c8-. e-. d-. c-. d16( c a8-.) a4-_ e-_ |
    c'8( a-.) c-. d4-> a8-. c( a-.) c-. d4-> a8-. |
    c(\< a-.) d-. c-. c-. a-. a'16->(\!\mf g e8-.) e4-.-> r |
  % rehearsal 35, 337-344
    \time 5/4
    R1*5/4 |
    e4->( a,8-.) e'4-> c8-. d16( c a8-.) a4-. |
    R1*5/4 |
    e'8->( d16 e a,8-.) e'4-> c8-. d16( c a8-.) a4-. |
    r2 r4 <a' e>8-.-> <e c>-. q4-.-> |
    r2 r4 <a e>8-.-> <e c>-. q4-.-> |
   r4 <a e>8-.-> <e c>-. r4 <a e>8-.-> <e c>-. r4 |
    R1*5/4 |
  % rehearsal 36, 345-355
    R1*5/4 | R1*5/4 |
    c4(\mp^"I" a8-.) c4-> f,8-. g-. a-. a4-. |
    c8( d16 c a8-.) c4-> f,8-. g-. a-. a4-. |
    R1*5/4 | R1*5/4 |
    \time 6/4
    r2 r4 <b fis,>8-.->\p <cis fis,>-. <dis fis,>-. q-. q-. q-. |
    r2 r4 <dis gis,>8-.-> <fis gis,>-. <gis gis,>-. q-. q-. q-. |
    R1. | R1. |
    <b b,>8-.->\mf <d d,>-. <e e,>-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 37, 356-362
    <e e,>4-.->\!\f e,,16(\mf\<^"a2" a c d e a c d) e->(\!\f\> d c a e d c a e\!\mf\< a c d |
    e4-.->)\!\f e,16(\mf a c d e a c d) e->(\!\f\> d c a e d c a e\!\mf\< a c d |
    e4-.->)\!\f c'8-. \times 2/3 { d16->(\> c a } \times 4/6 { f d c a f d } e4-.)\!\mf c''8-.\f \times 2/3 { d16->(\> c a } \times 4/6 { f d c a f d } |
    e4-.)\!\mf d16(\< f a c \times 4/5 { d f a c d) } \times 4/5 { e->(\!\f\> d b a g } \times 4/5 { e d b a g }e4-.)\!\mf |
    r e16(\< a c d e a c d) g->(\!\f\> e d c a g e d c\!\mf\< a c d |
    e4-.->)\!\f e,16(\mf a c d e a c d) g->(\!\f\> e d c a g e d c\!\mf\< a c d |
    e4-.->)\!\f c'8-. \times 2/3 { d16->(\> c a } \times 4/6 { f d c a f d } e4-.)\!\mf c''8-.\f \times 2/3 { d16->(\> c a } \times 4/6 { f d c a f d } |
  % rehearsal 38, 363-372
    \time 5/4
    e4-.\!\mp r r r2 |
    r4 <c'' c,>8-.->\mf\< <a a,>-. <d d,>-. <a a,>-. <c c,>-.-> <a a,>-. <c c,>-. <d d,>-. |
    <e e,>4-.->\!\f r r <c c,>8-. <d d,>-. <e e,>4-.-> |
    q-.-> r r <g g,>8-. <e e,>-. q4-.-> |
    q-.-> r r <c c,>16( <a a,> <c c,> <d d,>) <e e,>4-.-> |
    <e e,>-.-> r r <a a,>16->( <g g,> <e e,>8-.) <e e,>4-.-> |
    R1*5/4*3 |
    <g g,>8-.->\f\< <e e,>-. <g g,>-.-> <e e,>-. <g g,>-.-> <e e,>-. <g g,>-.-> <e e,>-. <g g,>-.-> << { e-. } \\ { r } >> \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    <f ees>2.->\!\fff ~ q2\> ~ q4\!\f |
    r2 r4 <f a,>2.\ff |
    r2 r4 <f, a,>2.\f |
    r2 r4 <f, a,>2.\mp\> ~ |
    q4\!\p r r r2 r4 |
    R1. \bar "||"
  }

  bassoons = \relative c {
    \clef bass \key g \minor \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1.*3 |
    d8-.\mf^"I" r r4 r r2 r4 |
  % a, rehearsal 1, 5-12
    R1.*3 |
    r2 r4 r r8 <d, d,>-.\mf\< <d d,>-. <d d,>-. |
    <g g'>4-.\!\f r <d d'>-. <g g'>-. r <d d'>-. |
    <g g'>-. r <d d'>-. <g g'>-. r <d d'>-. |
    <g g'>-. <g g'>8-. <c, c'>4-> <c c'>8-. <g' g'>4-. <g g'>8-. <c, c'>4-> <c c'>8-. |
    <g' g'>4-. <c, c'>8-. <c c'>4-. <c c'>8-. <d d'>4-.-> <d d'>-.-> r |
  % rehearsal 2, 13-17
    \time 5/4
    R1*5/4 | R1*5/4 |
    f''8->(\mp^"I" g16 f d8-.) f4-> bes,8-. c-. d-. d4-. |
    R1*5/4 |
    \time 6/4
    r4 c16(\mf bes g8-.) r4 r2 r4 |
  % rehearsal 3, 18-28
    \time 5/4
    g'4(\p e8-.) g4-> c,8-. d-. e-. e4-. |
    g8( a16 g e8-.) g4-> c,8-. d-. e-. e4-. |
    R1*5/4*4 |
    \time 6/4
    r2 r4 <a, e'>8-.->\p q-. q-. q-. q-. q-. |
    r2 r4 <a fis'>8-.-> q-. q-. q-. q-. q-. |
    <a f'>4-. <f, c'>2(\mp\< <ees ees'>2.) |
    <d d'>1.\!\mf |
    <d d'>4-> q8-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 4, 29-40
    <g g'>4-.->\!\f r <d d'>-. <g g'>-. r <d d'>-. |
    <g g'>-. r <d d'>-. <g g'>-. r <d d'>-. |
    <g g'>-. <g g'>8-. <c, c'>4-> <c c'>8-. <g' g'>4-. <g g'>8-. <c, c'>4-> <c c'>8-. |
    <g' g'>4-. <c, c'>8-. <c c'>4-. <c c'>8-. <d d'>4-.-> q-.-> q8-. q-. |
    <g g'>4-.-> r <d d'>-. <g g'>-. r <d d'>-. |
    <g g'>-. r <d d'>-. <g g'>-. r <d d'>-. |
    <g g'>-. <g g'>8-. <c, c'>4-> <c c'>8-. <g' g'>4-. <g g'>8-. <c, c'>4-> <c c'>8-. |
    <g' g'>-.->\mf\< q-. q-. q-. <f f'>-.-> q-. q-. q-. <e e'>-.-> q-. q-. q-. |
    <ees ees'>4-.->\!\f r c''16->(^"a2" bes g8-.) r2 r4 |
    r8 <d, d'>-.\p\cresc q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q8-.->\!\ff r r4 r\fermata <g g'>16-> q-> q8-.-> r4 r\bar "||"
  % b, rehearsal 5, 41-54
    \key c \minor \time 3/4
    R2.*3^\collaparte |
    \time 4/4 R1*9 |
    r2 \times 2/3 { bes4(\p^"I" f) r8 bes( } |
    g2.)\fermata r4 \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*5 |
    <g g'>2(\mp\< <f f'>4 |
    <ees ees'>2.)\!\mf\< |
    <aes aes'> | <g g'> |
    <c, c'>\!\f | <bes' bes'> |
    <a a'>2( <aes aes'>4 | <g g'>2.)\> |
    <c, c'> ~ | <c c'>4\!\p\fermata r r |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } <ees'' g,>8-.\p r16 q-. q8-. q4 q q8-. <f( g,>4-> |
    <ees) g,>8-. q16-. q-. q8-. q4 q q8-. <f( g,>4-> |
    <ees) g,>8-. r16 q-. q8-. q4 q q8-. <f( g,>4-> |
    <ees) g,>8-. q16-. q-. q8-. q4 q q8-. <f( g,>4-> |
    <ees) g,>8-. r16 q-. q8-. q4 q q8-. <f( g,>4-> |
    <ees) g,>8-. q16-. q-. q8-. q4 q q8-. <f( g,>4-> |
    <ees g,>2.\< ~ <ees) g,>4 <f( g,>4->\!\mf\> |
    <ees g,>2.\!\p\< ~ <ees) g,>4 <f( g,>4->\!\mf\> |
    <ees) g,>8-.\!\p r16 q-. q8-. q4 q q8-. <f( g,>4-> |
    <ees) g,>8-. q16-. q-. q8-. q4 q q8-. <f( g,>4-> |
    <ees) g,>8-. r16 q-. q8-. q4 q q8-. <f( g,>4-> |
    <ees) g,>8-. q16-. q-. q8-. q4 q q8-. <f g,>4->( |
    <ees bes>8-. r16 q-. q8-. q4 q q8-. <ges c,>4->( |
    <ees bes>8-.)\< q16-. q-. q8-. q4 q q8-. <bes, bes'>4 |
  % rehearsal 10, 117-122
    <ees, ees'>4-.\!\f r <bes bes'>-. <ees ees'>-. <bes bes'>-> |
    <ees ees'>-. r <bes bes'>-. <ees ees'>-. <bes bes'>-> |
    <ees ees'>-. r <bes bes'>-. <ees ees'>-. <bes bes'>-> |
    <ees ees'>-. r <bes bes'>-. <ees ees'>-. <bes bes'>-> |
    <ees ees'>-.-> r <bes bes'>-. <ees ees'>-. <bes bes'> |
    <ees ees'>-.-> r <bes bes'>-. <ees ees'>-. <bes bes'>8-. <bes bes'>-. |
  % rehearsal 11, 123-134
    <f' f'>-.-> r r4 r8 <f f'>4 <ees ees'>8-. <c c'>-. <bes bes'>-. |
    <f' f'>-.-> r r4 r8 <bes bes'>-. <aes aes'>-. <f f'>-. <ees ees'>-. <c c'>-. |
    <bes bes'>-.-> r r4 r8 <aes' aes'>4 <f f'>8-. <ees ees'>-. <c c'>-. |
    <bes bes'>-.-> r r4 r8 <bes' bes'>-. <aes aes'>-. <f f'>-. <ees ees'>-. <c c'>-. |
    <ces ces'>-.-> r r4 r r8 <ees ees'>-. q-. q-. |
    <ces ces'>-.-> r r4 r r8 <ees ees'>-. q-. q-. |
    <des des'>8.-> q16-> q8-> q-> r4 r2 |
    q8.-> q16-> q8-> q-> r4 r2 |
    q4-.-> r q-.-> r q-.-> |
    r2 q4--->\ff q---> <aes' aes'>---> |
    <des, des'>---> q---> <aes' aes'>---> <des, des'>2---> |
    <g g'>4-.-> r r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \key g \minor
    g''4\p^"I" e8-. g4 c,8-. d-. e-. e4-. |
    g8( a16 g e8-.) g4 c,8-. d-. e-. e4-. |
    R1*5/4*6 |
  % rehearsal 13, 143-148
    \time 7/4
    <d,, d'>4->\mf <c c'>8-. <d d'>4-> \stemBoth a'8-. a <c, c'>-. <d d'>-. <d d'>-. r r2 |
    <d d'>4-> <c c'>8-. <d d'>4-> \stemBoth a'8-. a <c, c'>-. <d d'>-. <d d'>-. r r2 |
    \time 6/4
    \stemBoth a'8-. a <c, c'>-. <d d'>-. r r4 \stemBoth a'8-. a <c, c'>-. <d d'>-. r r4 |
    \stemBoth a'8-.\cresc a <c, c'>-. <d d'>-. \stemBoth a'-. a <c, c'>-. <d d'>-. \stemBoth a'-. a <c, c'>-.  <d d'>-. \stemBoth a'-. a <c, c'>-. <d d'>-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-.->\!\ff r r4 r r2 r4 \bar "||"
  % rehearsal 14, 149-161
    R1.*3 |
    r2 r4 r r8 <d d,>-.\mf\< <d d,>-. <d d,>-. |
    <g g'>4-.\!\f r <d d'>-. <g g'>-. r <d d'>-. |
    <g g'>-. r <d d'>-. <g g'>-. r <d d'>-. |
    <g g'>-. <g g'>8-. <c, c'>4-> <c c'>8-. <g' g'>4-. <g g'>8-. <c, c'>4-> <c c'>8-. |
    <g' g'>4-. <c, c'>8-. <c c'>4-. <c c'>8-. <d d'>4-.-> <d d'>-.-> r |
    \time 5/4
    R1*5/4 | R1*5/4 |
    f''8->(\mp^"I" g16 f d8-.) f4-> bes,8-. c-. d-. d4-. |
    R1*5/4 |
    \time 6/4
    r4 c16(\mf bes g8-.) r4 r \times 4/7 { g,16(\p a b c d e f } g8-.) r |
  % rehearsal 15, 162-176
    R1.*14 |
    <f, f'>2.(\mf\< <ees ees'>) |
  % rehearsal 16, 177-180
    <d d'>4->\!\f <c c'>8-. <d d'>4-> \stemBoth a'8-. a <c, c'>-. <d d'>-. <d d'>4-.-> r |
    <d d'>-> <c c'>8-. <d d'>4-> \stemBoth a'8-. a <c, c'>-. <d d'>-. <d d'>4-.-> r8 \stemBoth a' a |
    <d, d'>-.-> r r \stemBoth a' a <d, d'>-.-> r r4 r8 a'16(^"a2" c d8-.->) r |
    R1. |
  % rehearsal 17, 181-188
    <g, g'>4-.-> r <d d'>-. <g g'>-. r <d d'>-. |
    <g g'>-. r <d d'>-. <g g'>-. r <d d'>-. |
    <g g'>-. <g g'>8-. <c, c'>4-> <c c'>8-. <g' g'>4-. <g g'>8-. <c, c'>4-> <c c'>8-. |
    <g' g'>4-. <c, c'>8-. <c c'>4-. <c c'>8-. <d d'>4-.-> q-.-> q8-. q-. |
    <g g'>4-.-> r <d d'>-. <g g'>-. r <d d'>-. |
    <g g'>-. r <d d'>-. <g g'>-. r <d d'>-. |
    <g g'>-. <g g'>8-. <c, c'>4-> <c c'>8-. <g' g'>4-. <g g'>8-. <c, c'>4-> <c c'>8-. |
    <g' g'>-.->\mf\< q-. q-. q-. <f f'>-.-> q-. q-. q-. <e e'>-.-> q-. <ees ees'>-. q-. |
  % rehearsal 18, 189-202
    \time 5/4
    <d d'>-.->\!\f r r4 r r2 |
    <d d'>2. ~ <d d'>2 |
    R1*5/4 |
    q2. ~ q2 |
    q8-.->\mf\< r r q-.-> r q-.-> r4 q8-.-> r |
    q-.-> r q-.-> r q-.-> r q-.-> r q-.-> q-.->\!\ff |
    R1*5/4*8 \bar "||"
  % d, rehearsal 19, 203-207
    \key g \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    r2 r4 <d fis'>\p |
    \time 6/4 <g d'>1 ~ q4 <fis fis'>( |
    \time 4/4 <e e'>2\< <d d'>) |
    <c c'>2\!\mp <c' g'> | <b fis'>1 |
    \time 6/4 <e, g'~>4( <d g'> <c g''>2) <b' g'~>4( <bes g'>) |
    \time 4/4 <a g'>2(\> <d, fis'>) |
    <g d'>2.(\!\p\< <fis fis'>4) |
  % rehearsal 21, 222-228
    <g g'>1\!\mp | <d d'> |
    <c c'>2 <b' e~>4( <a e'>) |
    <d, d'>1 |
    <g d'~> | <f d'> |
    <e e'>2(\< <ees ees'>) |
  % rehearsal 22, 229-244
    <d d'>2 ~ q8 q4\!\f q8 |
    \time 6/4 <g d'>1 ~ q4 <fis fis'> |
    \time 4/4 <e e'>2( <d d'>) |
    <c c'>2. <b b'>4( | <a a'>2.)\> <a a'>4( |
    <d d'>2.)\!\mf\< <d d'>4(\!\f |
    \time 6/4 <g d'>1 ~ q4 <fis fis'> |
    \time 4/4 <e e'>2( <d d'>) |
    <c c'>1 | <b b'>2.\> <b' e>4 |
    <a e'>1->\!\mp ~ |
    q8^"II changes to contrabassoon" r r4 r2 |
    R1*3 | r8^"I" d8(\p e8.) e'16( d2)^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    r2 r8 gis,,-.->\f^"I" cis-.-> e-.-> |
    fis16-.-> cis-.-> e-.-> fis-.-> gis8-.-> r16 e'-.-> cis8-.-> r16 r32 cis,-> cis4-.-> |
    r2 r4 r8 gis-.-> |
    \times 2/3 { b-.-> cis-.-> e-.-> } \times 4/5 { fis16-.-> cis-.-> e-.-> fis-.-> b-.-> } gis8-.-> r16 gis'-.-> gis4-> ~ |
    gis8. fis32 e cis8-.-> r16 r32 e,-> e8-.-> cis-.-> r4 |
  % rehearsal 24, 250-254
    R1 | R1 |
    \times 2/3 { cis8-.\mf\< b-. gis-. } \times 2/3 { cis-. b-. gis-. } \times 2/3 { cis-. b-. gis-. } \times 2/3 { cis-. b-. gis-.\! } |
    << { ais1->\f ~ | ais } \\ { s | s2.\> s4\!\mp } >> |
  % rehearsal 25, 255-261
    \key d \minor
    R1 | R1 |
    \times 2/3 { d8-.\mf\< c-. a-. } \times 2/3 { d-. c-. a-. } \times 2/3 { d-. c-. a-. } \times 2/3 { d-. c-. a-.\! } |
    \time 3/4
    << { b2.\f ~ | b } \\ { s2. | s2\> s4\!\mp } >> |
    << { bes2.(\f | a) } \\ { s2. | s2\> s4\!\mp } >> |
  % rehearsal 26, 262-266
    gis2.\p\cresc ~ | gis | gis ~ | gis |
    gis8-.->\!\ff gis-.-> r4 r |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    r2 a32->\ff a16.-.-> r8 r4 |
    r4 a32-> a16.-.-> r8 a32-> a16.-.-> r8 r4 |
    a'8-.-> r a-.-> r f-.-> r d-.-> r |
    r2 \times 2/3 { a8-.-> a-.-> a-.-> } a4-.-> |
    r2 \times 2/3 { a8-.->\f a-.-> a-.-> } a4-.-> |
    r2 \times 2/3 { a8-_\mf\> a-_ a ~ } a8 ~ \times 2/3 { a16\!\mp g'(\> f } |
    d1 ~ | d2)\pp r\fermata \bar "||"
  % rehearsal 29, 281-286
    \key g \major
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1 |
    c,1->\ff ~ | c\dim |
    e | b'2 bes |
    a1 ~ |
    a4\!\mp\fermata r r8 c(\p\< b bes) |
    a2(\!\mp << { d } \\ { s4\> s\!\p } >> |
    r8 d(\mp e8. b'16 g2) |
    r8 d( e8. b'16 g2 ~ |
    g8) r r4 r2 |
    R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*4 |
    g4->\mf^"I" ees8-. g-. f-. ees-. f16( ees c8-.) c4-_ g-_ |
  % rehearsal 33, 323-328
    a16->( c d8-.) d-. d-. d-. d-. d4-.-> r r |
    a16->( c d8-.) d-. d-. d-. d-. d4-.-> r r |
    a16->(\cresc c d8-.) d-. d-. d-. d-. a16->( c d8-.) d-. d-. d-. d-. |
    a16->( c d8-.) d-. d-. d-. d-. a16->( c d8-.) d-. d-. d-. d-. |
    a16->( c d8-.) d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d4-.->\!\sf \times 4/7 { d,16->(\f ees f g a bes c) } \times 4/7 { d,( ees f g a bes c } d8-.) r d2 |
  % rehearsal 34, 329-336
    g,4-.-> r d'-. g-. r d-. |
    g-. r d-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> r |
    R1.*4 |
  % rehearsal 35, 337-344
    \time 5/4
    bes4-.\f r f'-. bes,-. bes-. |
    R1*5/4 |
    bes4-. r f'-. bes,-. bes-. |
    R1*5/4 |
    r2 r4 g8-.-> g-. g4-.-> |
    r2 r4 g8-.-> g-. g4-.-> |
    r4 g16-.-> g-. g8-. r4 g16-.-> g-. g8-. r4 |
    R1*5/4 |
  % rehearsal 36, 345-355
    g''4(\p e8-.) g4-> c,8-. d-. e-. e4-. |
    g8( a16 g e8-.) g4-> c,8-. d-. e-. e4-. |
    R1*5/4*4 |
    \time 6/4
    r2 r4 a,8-.->\p a-. a-. a-. a-. a-. |
    r2 r4 a8-.-> a-. a-. a-. a-. a-. |
    a4-. c,2(\mp\< ees2.) |
    d1.\!\mf |
    d4-> d8-.\< d-. d-. d-. d-. d-. d-. d-. d-. d-. |
  % rehearsal 37, 356-362
    g,4-.->\!\f r d'-. g-. r d-. |
    g-. r d-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> d,8-. q-. |
    g4-.-> r d'-. g-. r d-. |
    g-. r d-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
  % rehearsal 38, 363-372
    \time 5/4
    g'-.->\mp\cresc g-. g-. g-. g-.-> g-. g-. g-. fis-.-> fis-. |
    fis-. fis-. f-.-> f-. f-. f-. e-.-> e-. ees-. ees-. |
    d4-.->\!\f r r d8-. d-. d4-.-> |
    d-.-> r r d8-. d-. d4-.-> |
    d-.-> r r d8-. d-. d4-.-> |
    d-.-> r r d8-. d-. d4-.-> |
    d8-.\mf r r d-. r d-. r4 d8-. r |
    d-. r r d-. r d-. r4 d8-. r |
    d-.\cresc r d-. r d-. r d-. r d-. r |
    d-. r d-. r d-. r d-. r d-. r \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    g,2.->\!\fff ~ g\> ~ |
    g\!\ff\> g ~ | g\!\f\> g ~ |
    g\!\mp\> g ~ |
    g4\!\p r r r2 r4 | R1. \bar "||"
  }

  contrabassoon = \relative c {
    \clef treble \key g \minor \numericTimeSignature \time 6/4
    \transposition c
  % intro, 1-4
    \grace { s16 } R1.*4 |
  % a, rehearsal 1, 5-12
    R1.*8 |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 4, 29-40
    R1.*11 | R1.^\fermataMarkup \bar "||"
  % b, rehearsal 5, 41-54
    \key c \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | R2. |
    R2.*4 | R2. | R2.^\fermataMarkup |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4*14 |
  % rehearsal 10, 117-122
    R1*5/4*6 |
  % rehearsal 11, 123-134
    R1*5/4*10 | R1*5/4 | R1*5/4 \bar "||"
  % c, rehearsal 12, 135-142
    \key g \minor
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1.*4 \bar "||"
  % rehearsal 14, 149-161
    R1.*8 |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    R1.*4 |
  % rehearsal 17, 181-188
    R1.*8 |
  % rehearsal 18, 189-202
    \time 5/4
    R1*5/4*14 \bar "||"
  % d, rehearsal 19, 203-207
    \key g \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 | R1 | R1 | R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    r2 r8 gis-.->\f cis-.-> e-.-> |
    fis16-.-> cis-.-> e-.-> fis-.-> gis8-.-> r16 e'-.-> cis8-.-> r16 r32 cis,-> cis4-.-> |
    r2 r4 r8 gis-.-> |
    \times 2/3 { b-.-> cis-.-> e-.-> } \times 4/5 { fis16-.-> cis-.-> e-.-> fis-.-> b-.-> } gis8-.-> r16 gis'-.-> gis4-> ~ |
    gis8. fis32 e cis8-.-> r16 r32 e,-> e8-.-> cis-.-> r4 |
  % rehearsal 24, 250-254
    R1 | R1 |
    \times 2/3 { cis8-.\mf\< b-. gis-. } \times 2/3 { cis-. b-. gis-. } \times 2/3 { cis-. b-. gis-. } \times 2/3 { cis-. b-. gis-.\! } |
    << { ais1->\f ~ | ais } \\ { s | s2.\> s4\!\p } >> |
  % rehearsal 25, 255-261
    \key d \minor
    R1 | R1 |
    \times 2/3 { d8-.\mf\< c-. a-. } \times 2/3 { d-. c-. a-. } \times 2/3 { d-. c-. a-. } \times 2/3 { d-. c-. a-.\! } |
    \time 3/4
    << { b2.\f ~ | b } \\ { s2. | s2\> s4\!\mp } >> |
    << { bes2.(\f | a) } \\ { s2. | s2\> s4\!\mp } >> |
  % rehearsal 26, 262-266
    gis2.\p\cresc ~ | gis | gis ~ | gis |
    gis8-.->\!\ff gis-.-> r4 r |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    r2 a32->\ff a16.-.-> r8 r4 |
    r4 a32-> a16.-.-> r8 a32-> a16.-.-> r8 r4 |
    a'8-.-> r a-.-> r f-.-> r d-.-> r |
    r2 \times 2/3 { a8-.-> a-.-> a-.-> } a4-.-> |
    r2 \times 2/3 { a8-.->\f a-.-> a-.-> } a4-.-> |
    r2 \times 2/3 { a8-_\mf\> a-_ a ~ } a8 ~ \times 2/3 { a16\!\mp g'(\> f } |
    d1 ~ | d2)\pp r\fermata \bar "||"
  % rehearsal 29, 281-286
    \key g \major
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1 |
    c,1->\ff ~ | c\dim |
    e | b'2 bes |
    a1 ~ | a4\!\mp\fermata r r2 |
    r2 r4 d\> |
    g1\!\p ~ | g ~ |
    g8 r r4 r2 |
    R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    a,16->(\mf c d8-.) d-. d-. d-. d-. d4-.-> r r |
    a16->( c d8-.) d-. d-. d-. d-. d4-.-> r r |
    a16->(\cresc c d8-.) d-. d-. d-. d-. a16->( c d8-.) d-. d-. d-. d-. |
    a16->( c d8-.) d-. d-. d-. d-. a16->( c d8-.) d-. d-. d-. d-. |
    a16->( c d8-.) d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d4-.->\!\sf \times 4/7 { d,16->(\f ees f g a bes c } d8-.) r d2. |
  % rehearsal 34, 329-336
    g,4-.-> r d'-. g-. r d-. |
    g-. r d-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> r |
    R1.*4 |
  % rehearsal 35, 337-344
    \time 5/4
    bes4-.->\f r f'-. bes,-. bes-. |
    R1*5/4 |
    bes4-.-> r f'-. bes,-. bes-. |
    R1*5/4 |
    r2 r4 g8-.-> g-. g4-.-> |
    r2 r4 g8-.-> g-. g4-.-> |
    r4 g16-.-> g-. g8-. r4 g16-.-> g-. g8-. r4 |
    R1*5/4 |
  % rehearsal 36, 345-355
    \time 5/4
    R1*5/4*6 |
    \time 6/4
    R1. | R1. |
    r4 f'2(\mp\< ees2.) |
    d1.\!\mf |
    d4-> d8-.\< d-. d-. d-. d-. d-. d-. d-. d-. d-. |
  % rehearsal 37, 356-362
    g,4-.->\!\f r d'-. g-. r d-. |
    g-. r d-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> d,8-. q-. |
    g4-.-> r d'-. g-. r d-. |
    g-. r d-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
  % rehearsal 38, 363-372
    \time 5/4
    g'-.->\mp\cresc g-. g-. g-. g-.-> g-. g-. g-. fis-.-> fis-. |
    fis-. fis-. f-.-> f-. f-. f-. e-.-> e-. ees-. ees-. |
    d4-.->\!\f r r d8-. d-. d4-.-> |
    d-.-> r r d8-. d-. d4-.-> |
    d-.-> r r d8-. d-. d4-.-> |
    d-.-> r r d8-. d-. d4-.-> |
    d8-.\mf r r d-. r d-. r4 d8-. r |
    d-. r r d-. r d-. r4 d8-. r |
    d-.\cresc r d-. r d-. r d-. r d-. r |
    d-. r d-. r d-. r d-. r d-. r \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    g,2.->\!\fff ~ g\> ~ |
    g\!\ff\> g ~ | g\!\f\> g ~ |
    g\!\mp\> g ~ |
    g4\!\p r r r2 r4 | R1. \bar "||"
  }

  hornI = \relative c'' {
    \clef treble \key d \minor \numericTimeSignature \time 6/4
    \transposition f
  % intro, 1-4
    \grace { s16 } \mute R1.^\consord |
    e8-.\sf^"a2" r r4^\senzasord r r2 r4 |
    \hnopen R1. | R1. |
  % a, rehearsal 1, 5-12
    R1.*3 |
    r2 r4 r r8 <c e,>-.\mp\< <c e,>-. <c e,>-. |
    <d f,>-.\!\mf q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
    <d f,>-. q-. <d g,>-. q-. q-. q-. <c e,>-.-> q-. q-.-> a-.\>^"I" a-. a-.\!\p |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4
    <b( e,~>1.\p | <cis) e,> |
    <c( e,~>2.\mp\< <d) e,> |
    <cis g>1.\!\mf |
    <cis g>4-> q8-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 4, 29-40
    <d f,>-.->\!\f q-.\mf q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
    <d f,>-. q-. <d g,>-. q-. q-. q-. <c e,>-.-> q-. q-.-> a-.^"a2" a-. a-. |
    <d f,>-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
    <d f,>-.->\mp\< q-. q-. q-. q-.-> q-. q-. q-. q-.-> q-. q-. q-. |
    <d f,>4-.->\!\f r r r2 r4 |
    r2 r4 a8-.\mp\cresc^"a2" a-. a-. a-. a-. a-. |
    a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. |
    f'2.->\fermata\!\ff d16-> d-> d8-.-> r4 r \bar "||"
  % b, rehearsal 5, 41-54
    \key g \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*6 |
    <g, d>2(\mp\< <bes g>4) |
    <c g>2. | <d f,>4. <f a,>8( <c f,> <f a,>) |
    <d g,>2.\!\f ~ | <d g,> |
    << { d2( c4) } \\ { g2. } >> |
    <d' f,>4. <f a,>8(\> <c f,> <f a,>) |
    <d f,>2. ~ | <d f,>4\!\p\fermata r r |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4*13 |
    <des g,>2.\p\< ~ <des g,>4 <f a,>8 q |
  % rehearsal 10, 117-122
    <f bes,>8-.\!\f r16 q-. q8-. q4 q q8-. <aes c,>4->( |
    <f bes,>8-.) q16-. q-. q8-. q4 q q8-. <aes c,>4->( |
    <f bes,>8-.) r16 q-. q8-. q4 q q8-. <aes c,>4->( |
    <f bes,>8-.) q16-. q-. q8-. q4 q q8-. <aes c,>4-> |
    <f bes,>8-.-> r16 q-. q8-. q4 q q8-. <aes c,>4 |
    <f bes,>8-.-> r16 q-. q8-. q4 q q8-. <aes c,>-. <ees bes>-. |
  % rehearsal 11, 123-134
    <c f,>-.-> r16 q-. q8-. q4 q q8-. <d f,>-. <bes ees,>-. |
    <c f,>-.-> q16-. q-. q8-. q4 q8-. q-. q-. <bes ees,>-. <c f,>-. |
    <f bes,>-.-> r16 q-. q8-. q4 q q8-. q-. q-. |
    q-.-> q16-. q-. q8-. q4 q8-. q-. q-. <c g>-. q-. |
    <c ges>-.-> <ees ees,>4-> <bes bes,>8 <ges' ges,>->( <aes aes,>16 <ges ges,>) <ees ees,>8( <des des,>16 <ees ees,> <bes bes,>8-.) <des des,>-. |
    <ees ees,>-. <ges ges,>4-> <bes, bes,>8 <ges' ges,>->( <aes aes,>16 <ges ges,>) <ees ees,>8( <des des,>16 <ees ees,>) <bes bes,>-. <des des,>-. <ees ees,>-. <f f,>-. |
    <ees g,>8.-> q16-> q8-> q-> r4 r2 |
    q8.-> q16-> q8-> q-> r4 r2 |
    q4-.-> r q-.-> r q-.-> |
    r2 <c ees,>4--->\ff q---> q---> |
    <ees g,>---> <c ees,>---> q---> <ees g,>2---> |
    <d g,>4-.-> r r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \key d \minor
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    <cis g>1.\mp ~ |
    q\cresc ~ |
    q8-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-.->\!\ff r r4 r r2 r4 \bar "||"
  % a, rehearsal 1, 5-12
    R1.*3 |
    r2 r4 r r8 <c e,>-.\mp\< <c e,>-. <c e,>-. |
    <d f,>-.\!\mf q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
    <d f,>-. q-. <d g,>-. q-. q-. q-. <c e,>-.-> q-. q-.-> a-.\>^"I" a-. a-.\!\p |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    r8 <b e,>4\p q q q q q8-. |
    q-. q4 q q q q8-. q-. q-. |
    q-. q4 q q q q q8-. |
    q-. q4 q q q q8-. q-. q-. |
    <bes f>-. q4 q q q q q8-. |
    q-. q4 q q q q8-. q-. q-. |
    <c g>-. q4 q q8-. q-. q4 q q8-. |
    <d a>-. q4 q q q\< q q8-. |
    <b e,>-.\!\mp q4 q q q q q8-. |
    q-. q4 q q q q8-. q-. q-. |
    <bes f>-. q4 q q q q q8-. |
    q-. q4 q <c f,>8-. <d f,>-. q4 q8-. q-. q-. |
    <des aes>-. q4 q <c ges>8-. <des aes>-. q4 q8-. q-. q-. |
    <c g>-.\< q4 q <bes f>8-. <c g>-. q4 q8-. q-. q-. |
    q2. <d g,>2( <bes f>4) |
  % rehearsal 16, 177-180
    <a e>1.\!\f ~ | q2. ~ q2 ~ q8-. r |
    R1. | R1. |
  % rehearsal 17, 181-188
    <d f,>8-.->\mf q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
    <d f,>-. q-. <d g,>-. q-. q-. q-. <c e,>-.-> q-. q-.-> a-.^"a2" a-. a-. |
    <d f,>-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
    <d f,>-.->\mp\< q-. q-. q-. q-.-> q-. q-. q-. q-.-> q-. q-. q-. |
  % rehearsal 18, 189-202
    \time 5/4
    q2.\!\f\> ~ q2\!\mf ~ | q2. ~ q2 |
    q2. ~ q2 ~ | q2. ~ q2 |
    <c g>8-.->\mf\< q-. q-. q-.-> q-. q-.-> q-. q-. q-.-> q-. |
    q-.-> q-. q-.-> q-. q-.-> q-. q-.-> q-. q-.-> q-.->\!\ff |
    R1*5/4*3 |
    <c f,>2.\mf <a c,>4 q ~ |
    q2. r2 | R1*5/4*3 \bar "||"
  % d, rehearsal 19, 203-207
    \key d \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*3 |
    r2 r8 <cis g>4\mp q8 |
    <d a> q4 q q q8 |
    q q4 q q q8 |
    <d f,>\< q4 q8 q q4 q8 |
  % rehearsal 22, 229-244
    <cis g> q4 q q\!\f q8 |
    \time 6/4 <b fis> q4 q q q4 q8 <cis fis,>4 |
    \time 4/4 <d a>8 q4 q <b fis> q8 |
    <b e,> q4 q q q8 |
    q\> q4 q q q8 |
    <a e>\!\mf q4 q\< <cis g> q8 |
    \time 6/4 <b fis>\!\f q4 q q q4 q8 <cis fis,>4 |
    \time 4/4 <d a>8 q4 q <b fis> q8 |
    <b e,> q4 q q q8 |
    <b fis>\> q4 q q q8 |
    <b e,>1\!\mp ~ |
    q8 r r4 r2 |
    r2 << { fis'4.(\> b,8) |
      b4.\!\p } \\ { gis2 ~ | gis4. } >> r8 r2 |
    R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key gis \minor
    <dis' gis,>8-.->\f r r4 r2 | R1 |
    r2 r4 q8-.-> r | R1 | R1 |
  % rehearsal 24, 250-254
    R1 | R1 |
    q2\mp\< ~ \times 2/3 { q8 q-. q-. } \times 2/3 { q-. q-. q-. } |
    q1->\!\f\> ~ | q\!\p |
  % rehearsal 25, 255-261
    \key a \minor
    R1 | R1 |
    <e a,>2\mp\< ~ \times 2/3 { q8 q-. q-. } \times 2/3 { q-. q-. q-.\! } |
    \time 3/4
    << { q2.\f ~ | q } \\ { s2. | s2\> s4\!\mp } >> |
    << { q2.\f ~ | q } \\ { s2. | s2\> s4\!\mp } >> |
  % rehearsal 26, 262-266
    <c fis,>2.\p\cresc ~ | q |
    q ~ | q |
    q8-.->\!\f q-.-> r4 r |
  % rehearsal 27, 267-272
    R2.*4 |
    <c dis,~>2.(\p |
    <a dis,>4) r r |
  % rehearsal 28, 273-280
    \time 4/4
    r2 <e' a,>32->\f q16.-.-> r8 r4 |
    r4 q32-> q16.-.-> r8 q32-> q16.-.-> r8 r4 |
    q8-.-> r q-.-> r q-.-> r q-.-> r |
    r2 \times 2/3 { <c e,>8-.-> q-.-> q-.-> } q4-.-> |
    r2 \times 2/3 { q8-.->\mf q-.-> q-.-> } q4-.-> |
    r2 \times 2/3 { <e a,>8-_\mp\> q-_ q-_\!\p } r4 |
    <a, a,>1\> ~ | q2)\pp r\fermata \bar "||"
  % rehearsal 29, 281-286
    \key d \major
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1 |
    <d g,>1->\mf ~ | q\dim |
    <d fis,> | <d a> |
    <d g,>1 ~ | q4\!\p\fermata r r2 |
    \mute R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key d \minor \time 6/4
    <d d,>8-.\mf^\mut \hnopen r r4 r r2 r4 |
    R1.*17 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    R1.*4 |
    e,8->(\f\cresc^"a2" a-.) <d a>-. q-. q-. q-. d-. q-. q-. q-. q-. q-. |
    q4-.->\!\sf r r r2 r4 |
  % rehearsal 34, 329-336
    <d f,>8-.->\f q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
    <d f,>-. q-. <d g,>-. q-. q-. q-. <c e,>-.-> q-. q-.-> a-.\>^"I" a-. a-.\!\p |
    R1.*3 |
    r2 r4 r r8 a-.\mf^"a2" a-. a-. |
  % rehearsal 35, 337-344
    \time 5/4
    <d a>8-.-> q-. q-. q-.-> q-. q-. q-.-> q-. q4-.-> |
    <a' d,>8-.->\p q-. q-. q-.-> q-. q-. <g d>-> q-. <f c>4-.-> |
    <d a>8-.->\mf q-. q-. q-.-> q-. q-. q-.-> q-. q4-.-> |
    <f c>8-.->\p q-. q-. q-.-> q-. q-. <d a>-> q-. q4-.-> |
    r2 r4 q8-.->\f q-. q4-.-> |
    r2 r4 q8-.-> q-. q4-.-> |
    r4 q8-.-> q-. r4 q8-.-> q-. r4 |
    R1*5/4 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4
    <b( e,~>1.\p | <cis) e,> |
    <c( e,~>2.\mp\< <d) e,> |
    <cis g>1.\!\mf |
    <cis g>4-> q8-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 37, 356-362
    <d f,>-.->\!\f q-.\mf q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
    <d f,>-. q-. <d g,>-. q-. q-. q-. <c e,>-.-> q-. q-.-> a-.^"a2" a-. a-. |
    <d f,>-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
  % rehearsal 38, 363-372
    \time 5/4
    <d a>-.->\p\cresc q-. q-. q-. q-.-> q-. q-. q-. q-.-> q-. |
    q-. q-. q-.-> q-. q-. q-. q-.-> q-. <d g,>-. q-. |
    <d f,>4-.->\!\f r r q8-. q-. q4-.-> |
    q-.-> r r q8-. q-. q4-.-> |
    q-.-> r r q8-. q-. q4-.-> |
    q-.-> r r q8-. q-. q4-.-> |
    <c g>2.\mf ~ q2 ~ |
    q2. ~ q2 |
    q2.\cresc ~ q2 |
    q8-.-> q-. q-.-> q-. q-.-> q-. q-.-> q-. q-.-> q-. \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    <d aes>2.->\!\fff ~ q\> |
    q1.\!\f |
    f4->^"a2" aes,-> f'16-> d8.-> ~ d2 ~ d8 r |
    <d aes>1.\p |
    R1. | R1. \bar "||"
  }

  hornII = \relative c'' {
    \clef treble \key d \minor \numericTimeSignature \time 6/4
    \transposition f
  % intro, 1-4
    \grace { s16 } R1.*4 |
  % a, rehearsal 1, 5-12
    R1.*3 |
    r2 r4 r r8 a-.\mp\<^"III" a-. a-. |
    a-.\!\mf a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. |
    a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. |
    a-. a-. a-. bes-.-> bes-. bes-. a-. a-. a-. bes-.-> bes-. bes-. |
    a-. a-. bes-. bes-. bes-. bes-. a-.-> a-. a-.-> r r4 |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4
    gis1.\mp^"III" ~ | gis |
    g2.(\mp\< gis) |
    <a e>1.\!\mf |
    <cis g>4-> q8-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 4, 29-40
    <d f,>-.->\!\f q-.\mf q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
    <d f,>-. q-. <d g,>-. q-. q-. q-. <c e,>-.-> q-. q-.-> a-.^"a2" a-. a-. |
    <d f,>-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
    <d f,>-.->\mp\< q-. q-. q-. q-.-> q-. q-. q-. q-.-> q-. q-. q-. |
    <d f,>4-.->\!\f r r r2 r4 |
    R1. |
    a8-.\mf\<^"a2" a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. |
    a-.->\!\ff r r4 r\fermata c16-> c-> c8-.-> r4 r \bar "||"
  % b, rehearsal 5, 41-54
    \key g \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*6 |
    bes,2(\mp\<^"IV" d4) | c2. | <a' d,>4. <c( d,>8 <a d,> <c) d,> |
    <bes d,>2.\!\f ~ | <bes d,> |
    << { bes2. } \\ { d,2( c4) } >> |
    <a' d,>4. <c( d,>8\> <a d,> <c) d,> |
    <b d,>2. ~ | <b d,>4\!\p\fermata r r |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4*13 |
    <bes f>2.\p\< ~ <bes f>4 <des g,>8 q |
  % rehearsal 10, 117-122
    <des f,>8-.\!\f r16 q-. q8-. q4 q q8-. <ees aes,>4->( |
    <des f,>8-.) q16-. q-. q8-. q4 q q8-. <ees aes,>4->( |
    <des f,>8-.) r16 q-. q8-. q4 q q8-. <ees aes,>4->( |
    <des f,>8-.) q16-. q-. q8-. q4 q q8-. <ees aes,>4-> |
    <des f,>8-.-> r16 q-. q8-. q4 q q8-. <ees aes,>4 |
    <des f,>8-.-> r16 q-. q8-. q4 q q8-. <ees aes,>-. <ees bes>-. |
  % rehearsal 11, 123-134
    <c f,>-.-> r16 q-. q8-. q4 q q8-. <d f,>-. <bes ees,>-. |
    <c f,>-.-> q16-. q-. q8-. q4 q8-. q-. q-. <bes ees,>-. <c f,>-. |
    <f bes,>-.-> r16 <c f,>-. q8-. q4 <f bes,>4 q8-. q-. q-. |
    q-.-> <c f,>16-. q-. q8-. q4 <f bes,>8-. q-. q-. <c g>-. q-. |
    <c ges>-.-> <ees ees,>4-> <bes bes,>8 <ges' ges,>->( <aes aes,>16 <ges ges,>) <ees ees,>8( <des des,>16 <ees ees,> <bes bes,>8-.) <des des,>-. |
    <ees ees,>-. <ges ges,>4-> <bes, bes,>8 <ges' ges,>->( <aes aes,>16 <ges ges,>) <ees ees,>8( <des des,>16 <ees ees,>) <bes bes,>-. <des des,>-. <ees ees,>-. <f f,>-. |
    <ees g,>8.-> q16-> q8-> q-> r4 r2 |
    q8.-> q16-> q8-> q-> r4 r2 |
    q4-.-> r q-.-> r q-.-> |
    r2 <c ees,>4--->\ff q---> q---> |
    <ees g,>---> <c ees,>---> q---> <ees g,>2---> |
    <d g,>4-.-> r r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \key d \minor
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    <a e>1.\mp ~ |
    q\cresc ~ |
    q8-. <cis g>-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-.->\!\ff r r4 r r2 r4 \bar "||"
  % rehearsal 14, 149-161
    R1.*3 |
    r2 r4 r r8 a-.\mp\<^"III" a-. a-. |
    a-.\!\mf a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. |
    a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. |
    a-. a-. a-. bes-.-> bes-. bes-. a-. a-. a-. bes-.-> bes-. bes-. |
    a-. a-. bes-. bes-. bes-. bes-. a-.-> a-. a-.-> r r4 |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    r8 <g d>4\p q q q q q8-. |
    q-. q4 q q q q8-. q-. q-. |
    q-. q4 q q q q q8-. |
    q-. q4 q q q q8-. q-. q-. |
    q-. q4 q q q q q8-. |
    q-. q4 q q q q8-. q-. q-. |
    <bes ees,>-. q4 q q8-. <bes e,>-. q4 q q8-. |
    <c fis,>-. q4 q q q\< q q8-. |
    <g d>-.\!\mp q4 q q q q q8-. |
    q-. q4 q q q q8-. q-. q-. |
    q-. q4 q q q q q8-. |
    q-. q4 q <a f>8-. <bes f>-. q4 q8-. q-. q-. |
    q-. q4 q <aes ees>8-. <bes f>-. q4 q8-. q-. q-. |
    <bes ees,>-.\< q4 q <aes d,>8-. <bes ees,>-. q4 q8-. q-. q-. |
    q2. <bes f>2( <g d>4) |
  % rehearsal 16, 177-180
    <g d>1.\!\f ~ | q2. ~ q2 ~ q8-. r |
    R1. | R1. |
  % rehearsal 17, 181-188
    <d' f,>8-.->\mf q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
    <d f,>-. q-. <d g,>-. q-. q-. q-. <c e,>-.-> q-. q-.-> a-.^"a2" a-. a-. |
    <d f,>-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
    <d f,>-.->\mp\< q-. q-. q-. q-.-> q-. q-. q-. q-.-> q-. q-. q-. |
  % rehearsal 18, 189-202
    \time 5/4
    <a d,>2.\!\f\> ~ q2\!\mf ~ | q2. ~ q2 |
    q2. ~ q2 ~ | q2. ~ q2 |
    <c g>8-.->\mf\< <a e>-. q-. <c g>-.-> <a e>-. <c g>-.-> <a e>-. q-. <c g>-.-> <a e>-. |
    <c g>-.-> <a e>-. <c g>-.-> <a e>-. <c g>-.-> <a e>-. <c g>-.-> <a e>-. <c g>-.-> q-.->\!\ff |
    R1*5/4*3 |
    a2.\mf^"III" f4 f ~ |
    f2. r2 | R1*5/4*3 \bar "||"
  % d, rehearsal 19, 203-207
    \key d \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*3 |
    r2 <a e>8\mp q4 q8 |
    <c f,> q4 q q q8 |
    q q4 q q q8 |
    <a d,>\< q4 q8 q q4 q8 |
  % rehearsal 22, 229-244
    <a e> q4 q q\!\f q8 |
    \time 6/4 <a d,> q4 q q q4 q8 <a e>4 |
    \time 4/4 <b fis>8 q4 q <a d,> q8 |
    <g d> q4 q q q8 |
    <gis d>\> q4 q q q8 |
    <g cis,>\!\mf q4 q\< <a e> q8 |
    \time 6/4 <a d,>\!\f q4 q q q4 q8 <a e>4 |
    \time 4/4 <b fis>8 q4 q <a d,> q8 |
    <g d> q4 q q q8 |
    <a d,>\> q4 q q q8 |
    <gis d>1\!\mp ~ |
    q8 r r4 r2 |
    r2 <d e,>\> ~ |
    q4.\!\p r8 r2 |
    R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key gis \minor
    <dis' gis,>8-.->\f r r4 r2 | R1 |
    r2 r4 q8-.-> r | R1 | R1 |
  % rehearsal 24, 250-254
    R1 | R1 |
    <b dis,>2\mp\< ~ \times 2/3 { q8 q-. q-. } \times 2/3 { q-. q-. q-. } |
    q1->\!\f\> ~ | q\!\p |
  % rehearsal 25, 255-261
    \key a \minor
    R1 | R1 |
    <c e,>2\mp\< ~ \times 2/3 { q8 q-. q-. } \times 2/3 { q-. q-. q-.\! } |
    \time 3/4
    << { q2.\f ~ | q } \\ { s2. | s2\> s4\!\mp } >> |
    << { q2.\f ~ | q } \\ { s2. | s2\> s4\!\mp } >> |
  % rehearsal 26, 262-266
    <a dis,>2.\p\cresc ~ | q |
    <c fis,> ~ | q |
    q8-.->\!\f q-.-> r4 r |
  % rehearsal 27, 267-272
    R2.*4 |
    <fis, c>2.(\p ~ |
    <fis c>4) r r |
  % rehearsal 28, 273-280
    \time 4/4
    r2 <e' a,>32->\f q16.-.-> r8 r4 |
    r4 q32-> q16.-.-> r8 q32-> q16.-.-> r8 r4 |
    q8-.-> r q-.-> r q-.-> r q-.-> r |
    r2 \times 2/3 { <c e,>8-.-> q-.-> q-.-> } q4-.-> |
    r2 \times 2/3 { q8-.->\mf q-.-> q-.-> } q4-.-> |
    r2 \times 2/3 { <b e,>8-_\mp\> q-_ q-_\!\p } r4 |
    R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    \key d \major
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1 |
    <d g,>1->\mf ~ | q\dim |
    <d fis,> | <a d,> |
    <b d,>1 ~ | q4\!\p\fermata r r2 |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key d \minor \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    R1.*4 |
    r4 <d a>8-.\f\cresc q-. q-. q-. d-. q-. q-. q-. q-. q-. |
    q4-.->\!\sf r r r2 r4 |
  % rehearsal 34, 329-336
    <d f,>8-.->\f a-.^"III" a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. |
    a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. |
    a-. a-. a-. bes-.-> bes-. bes-. a-. a-. a-. bes-.-> bes-. bes-. |
    a-. a-. bes-. bes-. bes-. bes-. a-.-> a-. a-.-> r r4 |
    R1.*3 |
    r2 r4 r r8 a-.\mf^"a2" a-. a-. |
  % rehearsal 35, 337-344
    \time 5/4
    <d a>8-.-> q-. q-. q-.-> q-. q-. q-.-> q-. q4-.-> |
    <f d>8-.->\p q-. q-. <f c>-.-> q-. q-. <f bes,>-> q-. <d a>4-.-> |
    q8-.->\mf q-. q-. q-.-> q-. q-. q-.-> q-. q4-.-> |
    q8-.->\p q-. q-. <d g,>-.-> q-. q-. <c fis,>-> q-. <c f,>4-.-> |
    r2 r4 <d a>8-.->\f q-. q4-.-> |
    r2 r4 q8-.-> q-. q4-.-> |
    r4 q8-.-> q-. r4 q8-.-> q-. r4 |
    R1*5/4 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4
    gis,1.\mp^"III" ~ | gis |
    g2.(\mp\< gis) |
    <a e>1.\!\mf |
    <cis g>4-> q8-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 37, 356-362
    <d f,>-.->\!\f q-.\mf q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
    <d f,>-. q-. <d g,>-. q-. q-. q-. <c e,>-.-> q-. q-.-> a-.^"a2" a-. a-. |
    <d f,>-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <d g,>-.-> q-. q-. <d f,>-. q-. q-. <d g,>-.-> q-. q-. |
  % rehearsal 38, 363-372
    \time 5/4
    <d a>-.->\p\cresc q-. q-. q-. q-.-> q-. q-. q-. q-.-> q-. |
    q-. q-. q-.-> q-. q-. q-. q-.-> q-. <d g,>-. q-. |
    <d f,>4-.->\!\f r r q8-. q-. q4-.-> |
    q-.-> r r q8-. q-. q4-.-> |
    q-.-> r r q8-. q-. q4-.-> |
    q-.-> r r q8-. q-. q4-.-> |
    <a e>2.\mf ~ q2 ~ |
    q2. ~ q2 |
    <c g>2.\cresc ~ q2 |
    q8-.-> q-. q-.-> q-. q-.-> q-. q-.-> q-. q-.-> q-. \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    <d aes>2.->\!\fff ~ q\> |
    q1.\!\f |
    f4->^"a2" aes,-> f'16-> d8.-> ~ d2 ~ d8 r |
    <bes d,>1.\p |
    R1. | R1. \bar "||"
  }

  trumpets = \relative c'' {
    \clef treble \key a \minor \numericTimeSignature \time 6/4
    \transposition bes
  % intro, 1-4
    \mute \grace { s16 } e8-.\sf^"a2"^\consord r r4^\senzasord r \tpopen r2 r4 |
    R1.*3 |
  % a, rehearsal 1, 5-12
    R1.*8 |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1.*4 |
    b8-.->\mf^"I" d-. e-.\< e-. e-. e-. e-. e-. e-. e-. e-. e-. |
  % rehearsal 4, 29-40
    e4->\!\f c8-. e-. d-. c-. d16( c a8-.) a4-_ e-_ |
    e'4-> c8-. e-. d-. c-. d16( c a8-.) a4-_ e-_ |
    c'8( a-.) c-. d4-> a8-. c( a-.) c-. d4-> a8-. |
    c( a-.) d-. c-. c-. a-. a'16->( g e8-.) e4-.-> e,-. |
    e'4-> c8-. e-. d-. c-. d16( c a8-.) a4-_ e-_ |
    e'4-> c8-. e-. d-. c-. d16( c a8-.) a4-_ e-_ |
    c'8( a-.) c-. d4-> a8-. c( a-.) c-. d4-> a8-. |
    c-.->\mp\< a-. d-. a-. c-.-> a-. d-. a-. c-.-> a-. d-. a-.\!\f |
    R1. | R1. |
    e'8-.\mf\< e-. e-. e-. e-. e-. e-.^"a2" e-. e-. e-. e-. e-. |
    e16->(\!\ff <c' c,>4..-> ~ <c c,>4)\fermata <d d,>16-> <c c,>-> <a a,>8-.-> r4 r \bar "||"
  % b, rehearsal 5, 41-54
    \key d \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | R2. |
    R2.*4 | R2. | R2.^\fermataMarkup |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4*14 |
  % rehearsal 10, 117-122
    R1*5/4*4 |
    r4 r8 aes4->\f^"I, marcato" c,8 aes'->( bes16 aes) ees4 |
    << { f4-. r8 aes4-> c,8 aes'->( bes16 aes ees8-.) } \\ { r2 r4 r r8 } >> <f c>-. |
  % rehearsal 11, 123-134
    <g d>-.-> r16 q-. q8-. q4 q \stemBoth c,8-. c <d c>-. <f c>-. |
    <g d>-.-> q16-. q-. q8-. q4 q8-. \stemBoth c,-. c <d c>-. <f c>-. <g d>-. |
    <c g>-.-> r16 <c, g>16-. q8-. q4 <g' d>4 \stemBoth d8-. d <f d>-. <g d>-. |
    <c g>-.-> <c, g>16-. q-. q8-. q4 \stemBoth d8-. d <f d>-. <g d>-. <c c,>-. <d, c>-. |
    <g bes,>-.-> bes,4->^"II" f8 des'->( ees16 des) bes8( aes16 bes f8-.) aes-. |
    bes-. des4-> f,8 des'->( ees16 des) bes8( aes16 bes) f-. aes-. bes-. c-. |
    <g' d>8.-> q16-> q8-> q-> r4 r2 |
    q8.-> q16-> q8-> q-> r4 r2 |
    q4-.-> r q-.-> r q-.-> |
    r2 <d bes>4--->\ff <c bes>---> <d bes>---> |
    <g, d>---> <c bes>---> <d bes>---> <g d>2---> |
    <a e>4-.-> r r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \key a \minor
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1. | R1. |
    b,8-.\f\<^"I" d-. e-. e-. e-. e-. e-.^"a2" e-. e-. e-. e-. e-. |
    e-.->\!\ff r r4 r r2 r4 \bar "||"
  % rehearsal 14, 149-161
    R1.*8 |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    r2 r4 r r8 b16\f^"a2" d e8-.-> r |
    r2 r4 r r8 b16 d e8-.-> r |
    r b16 d e8-.-> r r4 r2 r4 | R1. |
  % rehearsal 17, 181-188
    r4 r8 e,-.^"I" g-. a-. c-. a-. c-. g'4-> d8-. |
    e4-.-> r8 e,-. g-. a-. c-. a-. c-. g'4-> d8-. |
    e4-. c8-. d4-> a8-. c( a-.) c-. d4-> a8-. |
    c( a-.) d-. c-. c-. a-. a'16->( g e8-.) e4-.-> e,-. |
    e'-.-> r8 e,-. g-. a-. c-. a-. c-. g'4-> d8-. |
    e4-.-> r8 e,-. g-. a-. c-. a-. c-. g'4-> d8-. |
    e4-. c8-. d4-> a8-. c( a-.) c-. d4-> a8-. |
    c-.->\mp\< a-. d-. a-. c-.-> a-. d-. a-. c-.-> a-. d-. e-. |
  % rehearsal 18, 189-202
    \time 5/4
    e-.->\!\f r r4 r r2 |
    e4-> c8-. e4-> a,8-. g'-. e-. e4-.-> |
    R1*5/4 |
    e4-> c8-. e4-> a,8-. a'16->( g e8-.) e4-.-> |
    <g b,>8-.->\mf\< <d b>-. q-. <g b,>-.-> <e b>-. <g b,>-.-> <d b>-. q-. <g b,>-.-> <e b>-. |
    <g b,>-.-> <e b>-. <g b,>-.-> <e b>-. <g b,>-.-> <e b>-. <g b,>-.-> <e b>-. <g b,>-.-> <e b>-.->\!\ff |
    R1*5/4 |
    <g e>2.\f <e c>4 q ~ |
    q2. r2 | R1*5/4*5 \bar "||"
  % d, rehearsal 19, 203-207
    \key a \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 | R1 | R1 | R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key dis \minor
    \mute R1 |
    r4 dis->\f^"I, mute" ~ \times 2/3 { dis8 cis-.-> ais-.-> } \times 2/3 { ais-.-> fis-.-> gis-.-> } |
    ais-.-> r16 dis,-. dis2-> r4 |
    r4 fis'-> dis-> \times 2/3 { cis8-.-> gis-.-> cis-.-> } |
    ais8-.-> r16 gis32-. dis-. fis8.-> gis16-. ais2-> |
  % rehearsal 24, 250-254
    R1*3 |
    \tpopen r8^\senzasord r16 r32 <fis' dis>\f q2->\> ~ q4\!\mp |
    R1 |
  % rehearsal 25, 255-261
    \key e \minor
    R1*3 |
    \time 3/4
    r8 r16 r32 <g e>\f q2->\> ~ |
    q8\!\mp r r4 r |
    r8 r16 r32 q\f q2->\> ~ |
    q8\!\mp r r4 r |
  % rehearsal 26, 262-266
    R2. | R2. |
    <e cis,>2.\mp\cresc ~ | q |
    <g cis,>8-.->\!\f <e cis>-.-> r4 r |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    r2 <e b>32->\f q16.-.-> r8 r4 |
    r4 q32-> q16.-.-> r8 q32-> q16.-.-> r8 r4 |
    q8-.-> r q-.-> r q-.-> r q-.-> r |
    r2 \times 2/3 { <b e,>8-.-> q-.-> q-.-> } q4-.-> |
    r2 \times 2/3 { q8-.->\mf q-.-> q-.-> } q4-.-> |
    R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    \key a \major
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1 |
    <fis' b,>1->\mf ~ | q\dim |
    <fis cis> | <e a,>2\!\mp r |
    R1 | R1^\fermataMarkup |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key a \minor \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    R1.*3 |
    b16->(\mf\cresc^"I" d e8-.) e-. e-. e-. e-. b16->( d e8-.) e-. e-. e-. e-. |
    << { b16->( d e8-.) } \\ { r4 } >> <e b>8-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q4-.->\!\sf r r r2 r4 |
  % rehearsal 34, 329-336
    e4->\f^"I" c8-. e-. d-. c-. d16( c a8-.) a4-_ e-_ |
    e'4-> c8-. e-. d-. c-. d16( c a8-.) a4-_ e-_ |
    c'8( a-.) c-. d4-> a8-. c( a-.) c-. d4-> a8-. |
    c( a-.) d-. c-. c-. a-. a'16->( g e8-.) e4-.-> r |
    R1.*4 |
  % rehearsal 35, 337-344
    \time 5/4
    g4->(\f e8-.) g4-> c,8-. d-. e-. e4-. |
    R1*5/4 |
    g8->( a16 g e8-.) g4-> c,8-. d-. e-. e4-. |
    R1*5/4 |
    r2 r4 c8-.-> a-. a4-.-> |
    r2 r4 d16->( c a8-.) a4-.-> |
    r4 c8-.-> a-. r4 c8-.-> a-. r4 |
    R1*5/4 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4 R1.*4 |
    b8-.->\mf^"I" d-. e-.\< e-. e-. e-. e-. e-. e-. e-. e-. e-. |
  % rehearsal 37, 356-362
    e4->\!\f r8 e,-. g-. a-. c-. a-. c-. g'4-> d8-. |
    e4-.-> r8 e,-. g-. a-. c-. a-. c-. g'4-> d8-. |
    e4-. c8-. d4-> a8-. c( a-.) c-. d4-> a8-. |
    c( a-.) d-. c-. c-. a-. a'16->( g e8-.) e4-.-> e,-. |
    e'-.-> r8 e,-. g-. a-. c-. a-. c-. g'4-> d8-. |
    e4-.-> r8 e,-. g-. a-. c-. a-. c-. g'4-> d8-. |
    e4-. c8-. d4-> a8-. c( a-.) c-. d4-> a8-. |
  % rehearsal 38, 363-372
    \time 5/4
    c-.->\p\cresc a-. d-. a-. c-.-> a-. d-. a-. c-.-> a-. |
    d-. a-. c-.-> a-. d-. a-. c-.-> a-. c-. d-. |
    e4-.->\!\f r r c8-. d-. e4-.-> |
    e-.-> r r g8-. e-. e4-.-> |
    e8-.-> d16( e a,8-.) c4-> a8-. c16( a c d) e4-.-> |
    e8-.-> d16( e a,8-.) c4-> a8-. a'16->( g e8-.) e4-.-> |
    <e b>8-.\mp r r q-. r q-. r4 q8-. r |
    <e b>-. r r q-. r q-. r4 q8-. r |
    <g b,>-.->\mf\cresc <e b>-. <g b,>-.-> <e b>-. <g b,>-.-> <e b>-. <g b,>-.-> <e b>-. <g b,>-.-> <e b>-. |
    <g b,>-.-> <e b>-. <g b,>-.-> <e b>-. <g b,>-.-> <e b>-. <g b,>-.-> <e b>-. <g b,>-.-> <e b>-. \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    <a c,>8-.->\!\ff r r4 r r2 r4 |
    c4->\fff^"a2" ees,-> c'16-> a8.-> ~ a2 ~ a8 r |
    <a, f>1.\mp |
    R1.*3 \bar "||"
  }

  trombones = \relative c' {
    \clef tenor \key g \minor \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1.*4 |
  % a, rehearsal 1, 5-12
    R1.*8 |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1.*4 |
    <d a>4->\mf q8-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 4, 29-40
    <d g,>-.->\!\f q-.\mf q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <ees g,>-.-> q-. q-. <d g,>-. q-. q-. <ees g,>-.-> q-. q-. |
    <d g,>-. q-. <ees g,>-. q-. q-. q-. <d f,>-.-> q-. q4-.-> <d f,>-. |
    <d g,>8-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <ees g,>-.-> q-. q-. <d g,>-. q-. q-. <ees g,>-.-> q-. q-. |
    <d g,>-.->\mp\< q-. q-. q-. q-.-> q-. q-. q-. q-.-> q-. q-. q-. |
    <cis g>4-.->\!\f r r r2 r4 |
    R1. |
    r2 r4 <d d,>8-.\f\< q-. q-. q-. q-. q-. |
    <d bes>-.->\!\ff r r4 r\fermata <d bes>16-> q-> q8-.-> r4 r \bar "||"
  % b, rehearsal 5, 41-54
    \key c \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | R2. |
    R2.*4 | R2. | R2.^\fermataMarkup |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4*14 |
  % rehearsal 10, 117-122
    R1*5/4*5 |
    r2 r4 r r8 <ees bes>-.\f |
  % rehearsal 11, 123-134
    <c f,>-.-> r16 q-. q8-. q4 q q8-. <c g>-. <bes ees,>-. |
    <c f,>-.-> q16-. q-. q8-. q4 q8-. q-. q-. <bes ees,>-. <c f,>-. |
    <f bes,>-.-> r16 <ees bes>-. q8-. q4 <f c> q8-. q-. q-. |
    <f bes,>-.-> <ees bes>16-. q-. q8-. q4 <f c>8-. q-. q-. <ees bes>-. q-. |
    <ees aes,>-.-> aes,4->^"II" ees8 ces'-> des16 ces aes8 ges16 aes ees8-. ges-. |
    aes-. ces4-> ees,8 ces'-> des16 ces aes8 ges16 aes ees-. ges-. aes-. bes-. |
    <f' aes,>8.-> q16-> q8-> q-> r4 r2 |
    q8.-> q16-> q8-> q-> r4 r2 |
    q4-.-> r q-.-> r q-.-> |
    r2 <c f,>4--->\ff q---> q---> |
    <f aes,>---> <c f,>---> q---> <f aes,>2---> |
    <d g,>4-.-> r r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \key g \minor
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1. | R1. |
    r8 <d a>-.\f\< q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-.->\!\ff r r4 r r2 r4 \bar "||"
  % rehearsal 14, 149-161
    R1.*8 |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    d4->\f^"a2" c8-. d4-> a8-. c-. d-. d4-.-> r |
    d-> c8-. d4-> a8-. c-. d-. d4-.-> r8 a-. |
    d-.-> r r a-. d-.-> r r2 r4 |
    R1. |
  % rehearsal 17, 181-188
    <d g,>8-.->\mf q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <ees g,>-.-> q-. q-. <d g,>-. q-. q-. <ees g,>-.-> q-. q-. |
    <d g,>-. q-. <ees g,>-. q-. q-. q-. <d f,>-.-> q-. q4-.-> <d f,>-. |
    <d g,>8-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <ees g,>-.-> q-. q-. <d g,>-. q-. q-. <ees g,>-.-> q-. q-. |
    <d g,>-.->\mp\< q-. q-. q-. q-.-> q-. q-. q-. q-.-> q-. q-. q-. |
  % rehearsal 18, 189-202
    \time 5/4
    d4->\!\f bes8-. d4-> g,8-. bes-. c-. d4-.-> |
    R1*5/4 |
    d4-> bes8-. d4-> g,8-. bes-. c-. d4-.-> |
    R1*5/4 |
    <d a>8-.->\mf\< r r q-.-> r q-.-> r4 q8-.-> r |
    q-.-> r q-.-> r q-.-> r q-.-> r q-.-> q-.->\!\ff |
    R1*5/4 |
    bes'2.\f^"I" g4 g ~ |
    g2. r2 | R1*5/4*5 \bar "||"
  % d, rehearsal 19, 203-207
    \key a \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 | R1 | R1 | R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    <e gis,>8-.->\f r r4 r2 | R1 |
    r2 r4 q8-.-> r | R1 | R1 |
  % rehearsal 24, 250-254
    R1*3 |
    r8 r16 r32 <e cis>\f q2->\> ~ q4\!\mp |
    R1 |
  % rehearsal 25, 255-261
    \key d \minor
    R1*3 |
    \time 3/4
    r8 r16 r32 <f d>\f q2->\> ~ |
    q8\!\mp r r4 r |
    r8 r16 r32 q\f q2->\> ~ |
    q8\!\mp r r4 r |
  % rehearsal 26, 262-266
    R2. | R2. |
    <d gis,>2.\mp\cresc ~ | q |
    q8-.->\!\f q-.-> r4 r |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    r2 <f a,>32->\f q16.-.-> r8 r4 |
    r4 q32-> q16.-.-> r8 q32-> q16.-.-> r8 r4 |
    q8-.-> r q-.-> r q-.-> r q-.-> r |
    R1 | R1 | R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    \key g \major
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1 |
    <e g,>1->\mf ~ | q\dim |
    q\!\mp | R1 |
    R1 | R1^\fermataMarkup |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    d4->\mf^"I" a8-. d-. c-. a-. c-. d-. d4-_ a-_ |
    d-> a8-. d-. c-. a-. c-. d-. d4-_ a-_ |
    r2 r4 a8->\cresc d-. d-. d-. d-. d-. |
    a-> d-. d-. d-. d-. d-. a-> d-. d-. d-. d-. d-. |
    << { a-> d-. } \\ { r4 } >> <e a,>8-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q4-.->\!\sf r r r2 r4 |
  % rehearsal 34, 329-336
    <d g,>4-.->\f r r r2 r4 |
    R1.*7 |
  % rehearsal 35, 337-344
    \time 5/4
    <f bes,>8-.->\mf q-. q-. q-.-> q-. q-. q-.-> q-. q4-.-> |
    R1*5/4 |
    q8-.-> q-. q-. q-.-> q-. q-. q-.-> q-. q4-.-> |
    R1*5/4 |
    r2 r4 q8-.->\f q-. q4-.-> |
    r2 r4 q8-.-> q-. q4-.-> |
    r4 q8-.-> q-. r4 q8-.-> q-. r4 |
    R1*5/4 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4 R1.*4 |
    <d a>4->\mf q8-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 37, 356-362
    <d g,>-.->\!\f q-.\mf q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <ees g,>-.-> q-. q-. <d g,>-. q-. q-. <ees g,>-.-> q-. q-. |
    <d g,>-. q-. <ees g,>-. q-. q-. q-. <d f,>-.-> q-. q4-.-> <d f,>-. |
    <d g,>8-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-. q-. q-. <ees g,>-.-> q-. q-. <d g,>-. q-. q-. <ees g,>-.-> q-. q-. |
  % rehearsal 38, 363-372
    \time 5/4
    <f bes,>-.->\p\cresc q-. q-. q-. q-.-> q-. q-. q-. q-.-> q-. |
    q-. q-. q-.-> q-. q-. q-. q-.-> q-. <ees bes>-. q-. |
    <d g,>4-.->\!\f r r q8-. q-. q4-.-> |
    q-.-> r r q8-. q-. q4-.-> |
    q-.-> r r q8-. q-. q4-.-> |
    q-.-> r r q8-. q-. q4-.-> |
    R1*5/4 | R1*5/4 |
    <d a>2.\mf\cresc ~ q2 |
    q8-.-> q-. q-.-> q-. q-.-> q-. q-.-> q-. q-.-> q-. \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    <ees bes>2.->\!\fff ~ q\> |
    q1.\!\f |
    <des bes>\mp |
    bes4->\mf^"I" des,-> bes'16-> g8.-> ~ g2\> ~ g4\!\p |
    R1. | R1. \bar "||"
  }

  tuba = \relative c, {
    \clef bass \key g \minor \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1.*4 |
  % a, rehearsal 1, 5-12
    R1.*8 |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1.*4 |
    <d d'>4->\mf q8-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 4, 29-40
    <g, g'>4-.->\!\f r <d' d'>-.\mf <g, g'>-. r <d' d'>-. |
    <g, g'>-. r <d' d'>-. <g, g'>-. r <d' d'>-. |
    <g, g'>-. <g g'>8-. <c c'>4-> <c c'>8-. <g g'>4-. <g g'>8-. <c c'>4-> <c c'>8-. |
    <g g'>4-. <c c'>8-. <c c'>4-. <c c'>8-. <d d'>4-.-> q-.-> q8-. q-. |
    <g, g'>4-.-> r <d' d'>-. <g, g'>-. r <d' d'>-. |
    <g, g'>-. r <d' d'>-. <g, g'>-. r <d' d'>-. |
    <g, g'>-. <g g'>8-. <c c'>4-> <c c'>8-. <g g'>4-. <g g'>8-. <c c'>4-> <c c'>8-. |
    <g g'>4-.->\mp\< <g' g'>-. <f f'>-.-> q-. <e e'>-.-> q-. |
    <ees ees'>-.->\!\f r r r2 r4 | R1. |
    <d d'>8-.\mf\< q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q8-.->\!\ff r r4 r\fermata <g, g'>8-.-> q-.-> r4 r\bar "||"
  % b, rehearsal 5, 41-54
    \key c \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | g2\mp\<^"Tu." g4 |
    c2.\!\mf | bes | a2( aes4) |
    g2.\> | c ~ | c4\!\p^\fermataMarkup r r |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4*13 |
    r2 r4 r <bes bes'>\mp\< |
  % rehearsal 10, 117-122
    <ees ees'>4-.\!\mf r <bes bes'>-. <ees ees'>-. <bes bes'>-> |
    <ees ees'>-. r <bes bes'>-. <ees ees'>-. <bes bes'>-> |
    <ees ees'>-. r <bes bes'>-. <ees ees'>-. <bes bes'>-> |
    <ees ees'>-. r <bes bes'>-. <ees ees'>-. <bes bes'>-> |
    <ees ees'>-.-> r <bes bes'>-. <ees ees'>-. <bes bes'> |
    <ees ees'>-.-> r <bes bes'>-. <ees ees'>-. <bes bes'>8-. <bes bes'>-. |
  % rehearsal 11, 123-134
    <f f'>-.-> r r4 r8 <f' f'>4 <ees ees'>8-. <c c'>-. <bes bes'>-. |
    <f f'>-.-> r r4 << { r4 r8 f''-. } \\ { r8 bes,-. aes-. f-. } >> <ees ees'>-. <c c'>-. |
    <bes bes'>-.-> r r4 r8 <aes' aes'>4 <f f'>8-. <ees ees'>-. <c c'>-. |
    <bes bes'>-.-> r r4 << { r4 } \\ { r8 bes'-. } >> <aes aes'>-. <f f'>-. <ees ees'>-. <c c'>-. |
    <ces ces'>-.-> r r4 r r8 <ees ees'>-. q-. q-. |
    <ces ces'>-.-> r r4 r r8 <ees ees'>-. q-. q-. |
    <des des'>8.-> q16-> q8-> q-> r4 r2 |
    q8.-> q16-> q8-> q-> r4 r2 |
    q4-.-> r q-.-> r q-.-> |
    r2 q4--->\ff q---> <aes aes'>---> |
    <des des'>---> q---> <aes aes'>---> <des des'>2---> |
    <g, g'>4-.-> r r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \key g \minor
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1. |
    <a a'>8-.\mf\cresc <c c'>-. <d d'>-. <a a'>-. <c c'>-. <d d'>-. <a a'>-. <c c'>-. <d d'>-. <a a'>-. <c c'>-. <d d'>-. |
    q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-.->\!\ff r r4 r r2 r4 \bar "||"
  % rehearsal 14, 149-161
    R1.*8 |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    <d d'>4->\f <c c'>8-. <d d'>4-> <a a'>8-. <c c'>-. <d d'>-. <d d'>4-.-> r |
    <d d'>-> <c c'>8-. <d d'>4-> <a a'>8-. <c c'>-. <d d'>-. <d d'>4-.-> r8 <a a'>-. |
    <d d'>-.-> r r <a a'>-. <d d'>-.-> r r2 r4 |
    R1. |
  % rehearsal 17, 181-188
    <g, g'>4-.->\mf r <d' d'>-. <g, g'>-. r <d' d'>-. |
    <g, g'>-. r <d' d'>-. <g, g'>-. r <d' d'>-. |
    <g, g'>-. <g g'>8-. <c c'>4-> <c c'>8-. <g g'>4-. <g g'>8-. <c c'>4-> <c c'>8-. |
    <g g'>4-. <c c'>8-. <c c'>4-. <c c'>8-. <d d'>4-.-> q-.-> q8-. q-. |
    <g, g'>4-.-> r <d' d'>-. <g, g'>-. r <d' d'>-. |
    <g, g'>-. r <d' d'>-. <g, g'>-. r <d' d'>-. |
    <g, g'>-. <g g'>8-. <c c'>4-> <c c'>8-. <g g'>4-. <g g'>8-. <c c'>4-> <c c'>8-. |
    <g g'>4-.->\mp\< <g' g'>-. <f f'>-.-> q-. <e e'>-.-> <ees ees'>-. |
  % rehearsal 18, 189-202
    \time 5/4
    <d d'>4->\!\f <bes bes'>8-. <d d'>4-> <g, g'>8-. <bes bes'>-. <c c'>-. <d d'>4-.-> |
    R1*5/4 |
    <d d'>4-> <bes bes'>8-. <d d'>4-> <g, g'>8-. <bes bes'>-. <c c'>-. <d d'>4-.-> |
    R1*5/4 |
    <d d'>8-.->\mf\< r r q-.-> r q-.-> r4 q8-.-> r |
    q-.-> r q-.-> r q-.-> r q-.-> r q-.-> q-.->\!\ff |
    R1*5/4*8 \bar "||"
  % d, rehearsal 19, 203-207
    \key g \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 | R1 | R1 | R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    R1*5 |
  % rehearsal 24, 250-254
    R1*3 |
    << { <ais ais'>1->\f ~ | q } \\ { s1 | s2.\> s4\!\p } >> |
  % rehearsal 25, 255-261
    \key d \minor
    R1*3 |
    \time 3/4
    << { <b b'>2.\f ~ | q } \\ { s2. | s2\> s4\!\mp } >> |
    << { <bes bes'>2.(\f | <a a'>) } \\ { s2. | s2\> s4\!\mp } >> |
  % rehearsal 26, 262-266
    R2. | R2. |
    <gis gis'>2.\mp\cresc ~ | q |
    q8-.->\!\f q-.-> r4 r |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    r2 <a a'>8-.->\f r r4 |
    r4 q8-.-> r q-.-> r r4 |
    <a' a'>8-.-> r q-.-> r <f f'>-.-> r <d d'>-.-> r |
    r2 \times 2/3 { <a a'>8-.-> q-.-> q-.-> } q4-.-> |
    r2 \times 2/3 { q8-.->\mf q-.-> q-.-> } q4-.-> |
    r2 \times 2/3 { q8-_\mp\> q-_ q-_\!\p } r4 |
    d1\>^"Tu." ~ | d2)\!\pp r\fermata \bar "||"
  % rehearsal 29, 281-286
    \key g \major
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1 |
    <c c'>1->\mf ~ | q\dim |
    <e e'> | <b b'>2 <bes  bes'> |
    <a a'>1 ~ | q4\!\p\fermata r r2 |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    d'4->\mf^"Btb." a8-. d-. c-. a-. c-. d-. d4-_ a-_ |
    d-> a8-. d-. c-. a-. c-. d-. d4-_ a-_ |
    <a, a'>8->\cresc <d d'>-. q-. q-. q-. q-. <a a'>-> <d d'>-. q-. q-. q-. q-. |
    <a a'>-> <d d'>-. q-. q-. q-. q-. <a a'>-> <d d'>-. q-. q-. q-. q-. |
    <a a'>-> <d d'>-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q4-.->\!\sf r r r2 r4 |
  % rehearsal 34, 329-336
    <g, g'>4-.->\f r <d' d'>-.\mf <g g'>-. r <d d'>-. |
    <g, g'>-. r <d' d'>-. <g g'>-. r <d d'>-. |
    <g, g'>-. <g g'>8-. <c c'>4-> <c c'>8-. <g g'>4-. <g g'>8-. <c c'>4-> <c c'>8-. |
    <g g'>4-. <c c'>8-. <c c'>4-. <c c'>8-. <d d'>4-.-> q-.-> r |
    R1.*4 |
  % rehearsal 35, 337-344
    \time 5/4
    <bes bes'>4-.->\f r <f f'>-. <bes bes'>-. <bes bes'>-. |
    R1*5/4 |
    <bes bes'>4-.-> r <f f'>-. <bes bes'>-. <bes bes'>-. |
    R1*5/4 |
    r2 r4 <g g'>8-.-> q-. q4-.-> |
    r2 r4 q8-.-> q-. q4-.-> |
    r4 q8-.-> q-. r4 q8-.-> q-. r4 |
    R1*5/4 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4 R1.*4 |
    <d' d'>4->\mf q8-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 37, 356-362
    <g, g'>4-.->\!\f r <d' d'>-.\mf <g, g'>-. r <d' d'>-. |
    <g, g'>-. r <d' d'>-. <g, g'>-. r <d' d'>-. |
    <g, g'>-. <g g'>8-. <c c'>4-> <c c'>8-. <g g'>4-. <g g'>8-. <c c'>4-> <c c'>8-. |
    <g g'>4-. <c c'>8-. <c c'>4-. <c c'>8-. <d d'>4-.-> q-.-> q8-. q-. |
    <g, g'>4-.-> r <d' d'>-. <g, g'>-. r <d' d'>-. |
    <g, g'>-. r <d' d'>-. <g, g'>-. r <d' d'>-. |
    <g, g'>-. <g g'>8-. <c c'>4-> <c c'>8-. <g g'>4-. <g g'>8-. <c c'>4-> <c c'>8-. |
  % rehearsal 38, 363-372
    \time 5/4
    <g g'>4-.->\p\cresc <g' g'>-. q-.-> q-. <fis fis'>-.-> |
    q-. <f f'>-.-> q-. <e e'>-.-> <ees ees'>-. |
    <d d'>4-.->\!\f r r q8-. q-. q4-.-> |
    q-.-> r r q8-. q-. q4-.-> |
    q-.-> r r q8-. q-. q4-.-> |
    q-.-> r r q8-. q-. q4-.-> |
    R1*5/4 | R1*5/4 |
    <d d'>8-.\mf\cresc r q-. r q-. r q-. r q-. r |
    q-. r q-. r q-. r q-. r q-. r \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    <g, g'>2.->\!\fff ~ q\> |
    q1.\!\f\> | q\!\mf\> | q2.\!\mp\> ~ q4\!\p r r |
    bes'8->^"Tu." g4.->\> ~ g4 ~ g\!\pp r r |
    R1. \bar "||"
  }

  timpani = \relative c {
    \clef bass \key g \minor \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1.*4^\markup { "4 in G, C, D and F" } |
  % a, rehearsal 1, 5-12
    R1.*3 |
    r2 r4 r2 d4\mf |
    g,2 d'4 g,2 r4 |
    g2 d'4 g,2 r4 |
    g4 g8 c4-> r8 g4 g8 c4-> r8 |
    g4 c8 g4 c8 d4-> d-> r |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1.*3 |
    d4\mf r r d r r |
    d4-> d8\< d d d d d d d d d |
  % rehearsal 4, 29-40
    g,2\!\f d'4\mf g,2 d'4 |
    g,2 d'4 g,2 d'4 |
    g,4 g8 \repeat tremolo 8 c32-> c8 g4 g8 \repeat tremolo 8 c32-> c8 |
    g4 c8 g4 c8 d4-> d-> d |
    g,2 d'4 g,2 d'4 |
    g,2 d'4 g,2 d'4 |
    g,4 g8 \repeat tremolo 8 c32-> c8 g4 g8 \repeat tremolo 8 c32-> c8 |
    r2 g\mp\< g\!\mf |
    r2 r4 r c8->\f g-> r4 |
    R1. |
    d'8\mf\< d d d d d d d d d d d |
    d8->\!\ff r r4 r\fermata g,16-> g-> g8-> r4 r \bar "||"
  % b, rehearsal 5, 41-54
    \key c \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 |
    \times 2/3 { r8 g\mp\< g } \times 2/3 { g g g } \times 2/3 { g g g } |
    c2.\!\f | R2.*3 | R2. | R2.^\fermataMarkup |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4 | r2 r4 r g\p |
    c r r r2 | R1*5/4*4 |
    r2 r4 r g |
    c^\markup { "C to B" \smaller \flat ", D to E" \smaller \flat } r r r2 | R1*5/4*4 |
    r2 r4 r \repeat tremolo 8 bes32\< |
  % rehearsal 10, 117-122
    ees2\!\f bes4 ees bes-> |
    ees2 bes4 ees bes-> |
    ees2 bes4 ees bes-> |
    ees2 bes4 ees bes-> |
    ees2-> bes4 ees \repeat tremolo 8 bes32\mp\< |
    ees2->\!\f bes4 ees \repeat tremolo 8 bes32\mp\< |
  % rehearsal 11, 123-134
    f'4->\!\f r r8 f4 f8 ees ees |
    f4-> r r r8 f f f |
    bes,4-> r r8 f'4 f8 ees ees |
    bes4-> r r r8 f' ees ees |
    ees4-> r r r8 ees ees ees |
    ees4->^\markup { "E" \smaller \flat " to D, B" \smaller \flat " to C" } r r r2 |
    f8.-> f16-> f8-> f-> r4 r2 |
    f8.-> f16-> f8-> f-> r4 r2 |
    f4-> r f-> r f-> |
    r2 f4-> f-> c-> |
    f-> f-> c-> << { \repeat tremolo 16 f32-> } \\ { s8\f s\mf\< s4\! } >> |
    g,8->\sf^"Secco" r r4 r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \key g \minor
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1. | R1. |
    d'8\mf\< d d d d d d d d d d d |
    d8->\!\ff r r4 r r2 r4 \bar "||"
  % rehearsal 14, 149-161
    R1.*3 |
    r2 r4 r2 d4\mf |
    g,2 d'4 g,2 r4 |
    g2 d'4 g,2 r4 |
    g4 g8 c4-> r8 g4 g8 c4-> r8 |
    g4 c8 g4 c8 d4-> d-> r |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*7 |
    r2 r4 r \repeat tremolo 16 g,32\p\< |
    c2.\!\mf^\markup { "G to A" } r2 r4 |
    R1.*6 |
  % rehearsal 16, 177-180
    d4->\f a8 d4.-> a8 d d4-> r |
    d-> a8 d4.-> a8 d d4-> r |
    d-> r d-> r2 r4 |
    r8 a16 c d4-> r^\markup { "A to G" } r2 r4 |
  % rehearsal 17, 181-188
    g,2\mf d'4 g,2 d'4 |
    g,2 d'4 g,2 d'4 |
    g,4 g8 \repeat tremolo 8 c32-> c8 g4 g8 \repeat tremolo 8 c32-> c8 |
    g4 c8 g4 c8 d4-> d-> d |
    g,2 d'4 g,2 d'4 |
    g,2 d'4 g,2 d'4 |
    g,4 g8 \repeat tremolo 8 c32-> c8 g4 g8 \repeat tremolo 8 c32-> c8 |
    r2 g\mp\< g4 g |
  % rehearsal 18, 189-202
    \time 5/4
    d'4->\!\f g,8 d'4.-> d4 d | R1*5/4 |
    d4-> g,8 d'4.-> d4 d | R1*5/4 |
    d4.\mf\< d4 d4. d4 |
    d4-> d-> d-> d-> d8-> d->\!\ff |
    R1*5/4*8 \bar "||"
  % d, rehearsal 19, 203-207
    \key g \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    r2 \repeat tremolo 16 d32\mp\< |
    \time 6/4 g,2\!\f r r |
    \time 4/4 R1*3 |
    r2 \repeat tremolo 16 d'32\mp\< |
    \time 6/4 g,2\!\f^\markup { "C to C" \smaller \sharp } r2 r |
    \time 4/4 R1 | R1 | R1 | R1 | R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    R1*5 |
  % rehearsal 24, 250-254
    R1 | R1 |
    r2 \times 2/3 { r8 cis\mp\< cis } \times 2/3 { cis cis cis } |
    \repeat tremolo 32 cis32->\!\f |
    << { \repeat tremolo 32 cis32-> } \\ { s2.\> s4\p } >> |
  % rehearsal 25, 255-261
    \key d \minor
    R1^\markup { "C" \smaller \sharp "to C" \smaller \natural } | R1 |
    r2 \times 2/3 { r8 d\mp\< d } \times 2/3 { d d d } |
    \time 3/4
    \repeat tremolo 24 d32\!\f |
    << { \repeat tremolo 24 d } \\ { s2\> s4\!\mp } >> |
    \repeat tremolo 24 d32\f |
    << { \repeat tremolo 24 d } \\ { s2\> s4\!\mp } >> |
  % rehearsal 26, 262-266
    \repeat tremolo 24 d32\p\cresc |
    \repeat tremolo 24 d |
    \repeat tremolo 24 d |
    \repeat tremolo 24 d |
    d8->\!\f d-> r4 r |
  % rehearsal 27, 267-272
    d4.-> d-> |
    \times 2/3 { d8-> d4-> } r r |
    R2.*4^\markup { "G to A, F to E" } |
  % rehearsal 28, 273-280
    \time 4/4
    r2 a32-> a16.-> r8 r4 |
    r4 a32-> a16.-> r8 a32-> a16.-> r8 r4 |
    R1 |
    r2 \times 2/3 { a8-> a-> a-> } a4-> |
    r2 \times 2/3 { a8->\mf a-> a-> } a4-> |
    r2 \times 2/3 { a8\mp\> a a } r4 |
    \repeat tremolo 32 d32\!\p\> |
    d4 d2 d4\!\pp\fermata \bar "||"
  % rehearsal 29, 281-286
    \key g \major
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1 |
    \tag #'score { \repeat tremolo 32 c32->\ff |
      \repeat tremolo 32 c\dim | }
    \tag #'midi { \repeat tremolo 64 c64->\ff |
      \repeat tremolo 64 c\dim | }
    e1 | d |
    \tag #'score { \repeat tremolo 32 a32\!\p | }
    \tag #'midi { \repeat tremolo 64 a64\!\p | }
    a4\fermata^\markup { "A to G, E to F" } r r2 |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    R1.*4 |
    d4\f\cresc d8 d d d d d d d d d |
    \repeat tremolo 48 d32->\!\sfp\< | 
  % rehearsal 34, 329-336
    g,2\!\f d'4\mf g,2 d'4 |
    g,2 d'4 g,2 d'4 |
    g,4 g8 \repeat tremolo 8 c32-> c8 g4 g8 \repeat tremolo 8 c32-> c8 |
    g4 c8 g4 c8 d4-> d-> r |
    R1.*4^\markup { "C to B" \smaller \flat } |
  % rehearsal 35, 337-344
    \time 5/4
    bes2\f f'4 bes, bes | R1*5/4 |
    bes2 f'4 bes, bes | R1*5/4 |
    r2 r4 <d g,>8-> d g,4-> |
    r2 r4 <d' g,>8-> d g,4-> |
    r4 g8-> g r4 g8-> g r4 |
    R1*5/4^\markup { "B" \smaller \flat "to C" } |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4 R1.*3 |
    d'4\mf r r d r r |
    d4-> d8\< d d d d d d d d d |
  % rehearsal 37, 356-362
    g,2\!\f d'4\mf g,2 d'4 |
    g,2 d'4 g,2 d'4 |
    g,4 g8 \repeat tremolo 8 c32-> c8 g4 g8 \repeat tremolo 8 c32-> c8 |
    g4 c8 g4 c8 d4-> d-> d |
    g,2 d'4 g,2 d'4 |
    g,2 d'4 g,2 d'4 |
    g,4 g8 \repeat tremolo 8 c32-> c8 g4 g8 \repeat tremolo 8 c32-> c8 |
  % rehearsal 38, 363-372
   \time 5/4
    r2 g2\p\cresc g4 ~ |
    g g2 c4 c |
    d->\!\f r r d8 d d4-> |
    d-> r r d8 d d4-> |
    d-> r r d8 d d4-> |
    d-> r r d8 d d4-> |
    R1*5/4 | R1*5/4 |
    d4\mp\cresc d d d d |
    d d d d d \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    \tag #'score { \repeat tremolo 24 g,32\!\ff \repeat tremolo 24 g\> |
      \repeat tremolo 24 g\!\f \repeat tremolo 24 g\> |
      \repeat tremolo 24 g\!\mf \repeat tremolo 24 g\> |
      \repeat tremolo 24 g\!\mp \repeat tremolo 24 g\> | }
    \tag #'midi { \repeat tremolo 48 g64\!\ff \repeat tremolo 48 g\> |
      \repeat tremolo 48 g\!\f \repeat tremolo 48 g\> |
      \repeat tremolo 48 g\!\mf \repeat tremolo 48 g\> |
      \repeat tremolo 48 g\!\mp \repeat tremolo 48 g\> | }
    g4\!\pp r r r2 r4 | R1. \bar "||"
  }

  trian = \relative c' {
    \clef percussion \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1.*4 |
  % a, rehearsal 1, 5-12
    \tag #'i { R1.*4 |
      c2.\mf r2 r4 | c2. r2 r4 |
      r4 r8 c4:32 c8 r4 r8 c4:32 c8 |
      r2 r4 c-> c-> r | }
    \tag #'ii { R1.*8 | }
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 4, 29-40
    R1.*11 | R1.^\fermataMarkup \bar "||"
  % b, rehearsal 5, 41-54
    \time 3/4 R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | R2. |
    \tag #'i { c2.\f | R2.*3 | c2.\p | }
    \tag #'ii { R2.*5 | }
    R2.^\fermataMarkup |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \tag #'i { \grace { s16 } r2 r4 r c\laissezVibrer\p | R1*5/4 |
    r2 r4 r c\laissezVibrer | R1*5/4 |
    r2 r4 r c\laissezVibrer | R1*5/4 |
    r2 r4 r c\laissezVibrer | R1*5/4 |
    r2 r4 r c\laissezVibrer | R1*5/4 |
    r2 r4 r c\laissezVibrer | R1*5/4 |
    r2 r4 r c\laissezVibrer | R1*5/4 |
  % rehearsal 10, 117-122
    r2 r4 r c\laissezVibrer\f | R1*5/4 |
    r2 r4 r c\laissezVibrer | R1*5/4*3^\markup { \column { "Give the triangle to" "player II, and switch" "to snare drum" } } | }
    \tag #'ii { R1*5/4*14 | R1*5/4*6 | }
  % rehearsal 11, 123-134
    \tag #'i { R1*5/4*10 | }
    \tag #'ii { R1*5/4*4 |
    c2.:32\f c2: | c2.: c2: |
    c2^\markup { "Hand it back to player I" } r4 r2 | R1*5/4*3 | }
    R1*5/4 | R1*5/4 \bar "||"
  % c, rehearsal 12, 135-142
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1.*4 \bar "||"
  % rehearsal 14, 149-161
    \tag #'i { R1.*4 |
    c2.\mf r2 r4 | c2. r2 r4 |
    r4 r8 c4:32 c8 r4 r8 c4:32 c8 |
    r2 r4 c-> c-> r | }
    \tag #'ii { R1.*8 | }
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    \tag #'i { R1.*8 |
    c2.\mf r2 r4 | R1.*6 | }
    \tag #'ii { R1.*15 | }
  % rehearsal 16, 177-180
    R1.*4 |
  % rehearsal 17, 181-188
    R1.*8 |
  % rehearsal 18, 189-202
    \time 5/4
    R1*5/4*14 \bar "||"
  % d, rehearsal 19, 203-207
    \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    \tag #'i { c1\mp | R1 | }
    \tag #'ii { R1 | R1 | }
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 | R1 |
    \tag #'i { c1\mp } \tag #'ii { R1 } |
    R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    R1*5 |
  % rehearsal 24, 250-254
    R1*5 |
  % rehearsal 25, 255-261
    R1*3 |
    \time 3/4
    R2.*4 |
  % rehearsal 26, 262-266
    R2.*5 |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    R1*4 | R1 | R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1*5 | R1 | R1^\fermataMarkup |
    R1*4 | R1 |
    \tag #'i { c1\p\fermata }
    \tag #'ii { R1^\fermataMarkup } \bar "||"
  % e, rehearsal 31, 300-317
    \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    R1.*6 |
  % rehearsal 34, 329-336
    R1.*8 |
  % rehearsal 35, 337-344
    \time 5/4
    R1*5/4*8 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 37, 356-362
    R1.*7 |
  % rehearsal 38, 363-372
    \time 5/4
    R1*5/4*10 \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    R1. | R1.*5 \bar "||"
  }

  cym = \relative c' {
    \clef percussion \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1.*4 |
  % a, rehearsal 1, 5-12
    R1.*8 |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 4, 29-40
    \tag #'i { c2.\mf^"Cyms." r2 r4 | c2. r2 r4 |
    r4 r8 c4. r4 r8 c4. |
    r2 r4 c4 c r |
    c2. r2 r4 | c2. r2 r4 |
    r4 r8 c4. r4 r8 c4. |
    c4\p\< r c r c\!\mf r |
    R1.*3 | r2 r4\fermata c4->\ff r r \bar "||" }
    \tag #'iii { R1.*11 | R1.^\fermataMarkup \bar "||" }
  % b, rehearsal 5, 41-54
    \time 3/4 R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | R2. |
    R2.*4 | R2. | R2.^\fermataMarkup |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } \tag #'i { R1*5/4*14 | R1*5/4*6 | R1*5/4*10 | R1*5/4 | R1*5/4 \bar "||" }
    \tag #'iii { R1*5/4 | r2 r4 r c\p |
    R1*5/4 | r2 r4 r c |
    R1*5/4 | r2 r4 r c |
    R1*5/4 | r2 r4 r c |
    R1*5/4 | r2 r4 r c |
    R1*5/4 | r2 r4 r c |
    R1*5/4 | r2^"Susp. cym." r4 r c:32\< |
  % rehearsal 10, 117-122
    c2.\!\f r2 | r2^"Cyms." r4 r c\mf |
    R1*5/4 | r2 r4 r c |
    c2.-> r2 | c2.-> r2 |
  % rehearsal 11, 123-134
    R1*5/4*6 |
    c2->\f r4 r2 | c2-> r4 r2 |
    R1*5/4 | R1*5/4 | R1*5/4 |
    c8->^\markup { \column { "Secco" "Switch back to snare drum" } } r r4 r r2 \bar "||" }
  % c, rehearsal 12, 135-142
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    \tag #'i { R1.*3 | c8->\f^"Secco" r r4 r r2 r4 }
    \tag #'iii { R1.*4 } \bar "||"
  % rehearsal 14, 149-161
    R1.*8 |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    R1.*4 |
  % rehearsal 17, 181-188
    \tag #'i { c2.\mf r2 r4 | c2. r2 r4 |
    r4 r8 c4. r4 r8 c4. |
    r2 r4 c4 c r |
    c2. r2 r4 | c2. r2 r4 |
    r4 r8 c4. r4 r8 c4. |
    c4\p\< r c r c r | }
    \tag #'iii { R1.*8 | }
  % rehearsal 18, 189-202
    \time 5/4
    \tag #'i { c2.\!\f r2 | R1*5/4*3 |
    c4.\p\< c4 c4. c4 |
    c4\< c c c c8 c->\laissezVibrer\!\f |
    R1*5/4*8 }
    \tag #'iii { R1*5/4*14 } \bar "||"
  % d, rehearsal 19, 203-207
    \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    \tag #'i { r2^"Susp. cym." c:32\p\< |
    \time 6/4 c1\!\mf r2 | }
    \tag #'iii { R1 |
    \time 6/4 R1. | }
    \time 4/4 R1*4 |
    \time 6/4 \tag #'i { c1\mf^"Cyms." r2 } \tag #'iii { R1. } |
    \time 4/4 R1 | R1 | R1 | R1 | R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    R1*5 |
  % rehearsal 24, 250-254
    \tag #'i { R1 | R1 |
    r2^"Susp. cym." r4 c:32\p\< |
    c2\!\mf r | R1 | }
    \tag #'iii { R1*5 | }
  % rehearsal 25, 255-261
    \tag #'i { R1 | R1 |
    r2 r4 c:32\p\< | }
    \tag #'iii { R1*3 | }
    \time 3/4
    \tag #'i { c2.\!\mf | R2.*3 | }
    \tag #'iii { R2.*4 | }
  % rehearsal 26, 262-266
    R2.*5 |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    R1*4 | R1 | R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    \tag #'i { R1 | c1\f^"Cyms." | R1*3 | }
    \tag #'iii { R1*5 | }
    R1 | R1^\fermataMarkup |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    \tag #'i { R1.*5 |
    r2 r4 c2.:32\p\<^"Susp. cym." | }
    \tag #'iii { R1.*6 | }
  % rehearsal 34, 329-336
    \tag #'i { c4\!\f r r r2 r4 | R1.*7 | }
    \tag #'iii { R1.*8 | }
  % rehearsal 35, 337-344
    \time 5/4
    \tag #'i { R1*5/4 |
    c4.\p^"Cyms." c c4 c |
    R1*5/4 |
    c4. c c4 c |
    R1*5/4*4 | }
    \tag #'iii { R1*5/4*8 | }
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4
    \tag #'i { c4\p r r r2 r4 |
    c r r r2 r4 |
    R1. | R1. | }
    \tag #'iii { R1.*4 | }
    R1. |
  % rehearsal 37, 356-362
    \tag #'i { c2.\mf r2 r4 | c2. r2 r4 |
    r4 r8 c4. r4 r8 c4. |
    r2 r4 c c r |
    c2. r2 r4 | c2. r2 r4 |
    r4 r8 c4. r4 r8 c4. | }
    \tag #'iii { R1.*7 | }
  % rehearsal 38, 363-372
    \time 5/4
    \tag #'i { c4\p\cresc r c r c |
    r c r c c |
    c->\!\f r r r2 |
    R1*5/4*3 |
    c4.\p c4 c4. c4 |
    c4. c4 c4. c4 |
    c\cresc c c c c |
    c c c c c }
    \tag #'iii { R1*5/4*10 } \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    \tag #'i { c1.->\laissezVibrer\ff | }
    \tag #'iii { R1. | }
    R1.*5 \bar "||"
  }

  tamtam = \relative c' {
    \clef percussion \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1.*4 |
  % a, rehearsal 1, 5-12
    R1.*8 |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 4, 29-40
    R1.*11 | R1.^\fermataMarkup \bar "||"
  % b, rehearsal 5, 41-54
    \time 3/4 R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | R2. |
    R2.*4 | R2. | R2.^\fermataMarkup |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \tag #'i { \grace { c16(\p^\markup { \bold \italic "Scrape with the triangle beater" } } c2.->)\laissezVibrer r2 | R1*5/4*13 | }
    \tag #'ii { R1*5/4*14 | }
  % rehearsal 10, 117-122
    R1*5/4*6 |
  % rehearsal 11, 123-134
    R1*5/4*10 | R1*5/4 | R1*5/4 \bar "||"
  % c, rehearsal 12, 135-142
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1.*4 \bar "||"
  % rehearsal 14, 149-161
    R1.*8 |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    R1.*4 |
  % rehearsal 17, 181-188
    R1.*8 |
  % rehearsal 18, 189-202
    \time 5/4
    R1*5/4*14 \bar "||"
  % d, rehearsal 19, 203-207
    \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 | R1 | R1 | R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    R1*5 |
  % rehearsal 24, 250-254
    R1*5 |
  % rehearsal 25, 255-261
    R1*3 |
    \time 3/4
    R2.*4 |
  % rehearsal 26, 262-266
    R2.*5 |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    R1*4 | R1 | R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1*5 | R1 | R1^\fermataMarkup |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    R1.*6 |
  % rehearsal 34, 329-336
    R1.*8 |
  % rehearsal 35, 337-344
    \time 5/4
    R1*5/4*8 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 37, 356-362
    R1.*7 |
  % rehearsal 38, 363-372
    \time 5/4
    R1*5/4*10 \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    R1. |
    \tag #'i { R1.*5 }
    \tag #'ii { r2 r4 c2.->\laissezVibrer\fff |
    r2 r4 c2.\laissezVibrer\f |
    r2 r4 c2.\laissezVibrer\mp |
    R1. |
    r2 c1\laissezVibrer\p } \bar "||"
  }

  whip = \relative c' {
    \clef percussion \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } c4\sf r r r2 r4 |
    R1.*3 |
  % a, rehearsal 1, 5-12
    R1.*8 |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 4, 29-40
    R1.*11 | R1.^\fermataMarkup \bar "||"
  % b, rehearsal 5, 41-54
    \time 3/4 R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | R2. |
    R2.*4 | R2. | R2.^\fermataMarkup |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4*14 |
  % rehearsal 10, 117-122
    R1*5/4*6 |
  % rehearsal 11, 123-134
    R1*5/4*10 | R1*5/4 | R1*5/4 \bar "||"
  % c, rehearsal 12, 135-142
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1.*3 |
    r2 r4 c->\sf r r \bar "||"
  % rehearsal 14, 149-161
    R1.*8 |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    R1.*4 |
  % rehearsal 17, 181-188
    R1.*8 |
  % rehearsal 18, 189-202
    \time 5/4
    R1*5/4*14 \bar "||"
  % d, rehearsal 19, 203-207
    \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 | R1 | R1 | R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    R1*5 |
  % rehearsal 24, 250-254
    R1*5 |
  % rehearsal 25, 255-261
    R1*3 |
    \time 3/4
    R2.*4 |
  % rehearsal 26, 262-266
    R2.*5 |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    R1*4 | R1 | R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1*5 | R1 | R1^\fermataMarkup |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    R1.*6 |
  % rehearsal 34, 329-336
    R1.*8 |
  % rehearsal 35, 337-344
    \time 5/4
    R1*5/4*8 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 37, 356-362
    R1.*7 |
  % rehearsal 38, 363-372
    \time 5/4
    R1*5/4*10 \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    R1. | R1.*5 \bar "||"
  }

  tamb = \relative c' {
    \clef percussion \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1. | R1. |
    c4\f r r r2 r4 | R1. |
  % a, rehearsal 1, 5-12
    R1.*8 |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 4, 29-40
    r8 c\f c c c c r c c c c c |
    r c c c c c r c c c c c |
    c4 c8 c4:32-> c8 c4 c8 c4:32-> c8 | 
    c c c c c c c-> c c-> r r4 |
    r8 c c c c c r c c c c c |
    r c c c c c r c c c c c |
    c4 c8 c4:32-> c8 c4 c8 c4:32-> c8 | 
    c->\mp\< c c c c-> c c c c-> c c c |
    c4->\!\f r r r2 r4 |
    R1. | R1. | R1.^\fermataMarkup \bar "||"
  % b, rehearsal 5, 41-54
    \time 3/4 R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | R2. |
    R2.*4 | R2. | R2.^\fermataMarkup |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } c8.\p c16 c8 c4 c c8 c-> c |
    c c16 c c8 c4 c c8 c4-> |
    c8. c16 c8 c4 c c8 c-> c |
    c c16 c c8 c4 c c8 c4-> |
    c8. c16 c8 c4 c c8 c-> c |
    c c16 c c8 c4 c c8 c4-> |
    c8. c16 c8 c4 c c8 c-> c |
    c c16 c c8 c4 c c8 c4-> |
    c8. c16 c8 c4 c c8 c-> c |
    c c16 c c8 c4 c c8 c4-> |
    c8. c16 c8 c4 c c8 c-> c |
    c c16 c c8 c4 c c8 c4-> |
    c8. c16 c8 c4 c c8 c-> c |
    c c16 c c8 c4 c c8 c\< c |
  % rehearsal 10, 117-122
    c8.\!\f r16 c8 c4 c c8 c-> c |
    c8 c16 c c8 c4 c c8 c-> c |
    c8. r16 c8 c4 c c8 c-> c |
    c8 c16 c c8 c4 c c8 c-> c |
    c8. r16 c8 c4 c c8 c4:32\mp\< |
    c8.->\!\f c16 c8 c4 c c8 c4:32\mp\< |
  % rehearsal 11, 123-134
    c4->\!\f r r r2 | R1*5/4*9 |
    R1*5/4 | R1*5/4 \bar "||"
  % c, rehearsal 12, 135-142
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1.*4 \bar "||"
  % rehearsal 14, 149-161
    R1.*8 |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    R1.*4 |
  % rehearsal 17, 181-188
    r8 c\mf c c c c r c c c c c |
    r c c c c c r c c c c c |
    c4 c8 c4:32-> c8 c4 c8 c4:32-> c8 | 
    c c c c c c c-> c c-> r r4 |
    r8 c c c c c r c c c c c |
    r c c c c c r c c c c c |
    c4 c8 c4:32-> c8 c4 c8 c4:32-> c8 | 
    c->\mp\< c c c c-> c c c c-> c c c |
  % rehearsal 18, 189-202
    \time 5/4
    c4->\!\f r r r2 |
    c2.:32 ~ c4 c-> |
    R1*5/4 |
    c2.:32 ~ c4 c-> |
    c4.\mf\< c4 c4. c4 |
    c4\< c c c c8 c->\!\ff |
    R1*5/4*8 \bar "||"
  % d, rehearsal 19, 203-207
    \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 | R1 | R1 | R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    R1*5 |
  % rehearsal 24, 250-254
    R1*5 |
  % rehearsal 25, 255-261
    R1*3 |
    \time 3/4
    R2.*4 |
  % rehearsal 26, 262-266
    R2.*5 |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    R1*4 | R1 | R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1*5 | R1 | R1^\fermataMarkup |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    R1.*6 |
  % rehearsal 34, 329-336
    c8->\f c c c c c c-> c c c c c |
    c-> c c c c c c-> c c c c c |
    c c c c4:32-> c8 c c c c4:32-> c8 | 
    c c c c c c c-> c c-> r r4 |
    R1.*4 |
  % rehearsal 35, 337-344
    \time 5/4
    c8->\f c c c-> c c c-> c c-> c | R1*5/4 |
    c8-> c c c-> c c c-> c c-> c | R1*5/4 |
    r2 r4 c8-> c c4-> |
    r2 r4 c8-> c c4-> |
    r4 c8-> c r4 c8-> c r4 |
    R1*5/4 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 37, 356-362
    r8 c\f c c c c r c c c c c |
    r c c c c c r c c c c c |
    c4 c8 c4:32-> c8 c4 c8 c4:32-> c8 | 
    c c c c c c c-> c c-> r r4 |
    r8 c c c c c r c c c c c |
    r c c c c c r c c c c c |
    c4 c8 c4:32-> c8 c4 c8 c4:32-> c8 | 
  % rehearsal 38, 363-372
    \time 5/4
    c->\mp\cresc c c c c-> c c c c-> c |
    c c c-> c c c c-> c c-> c |
    c4->\!\f r r r2 | R1*5/4 |
    c4-> r r c8 c c4-> |
    c-> r r c8 c c4-> |
    c8->\mf c c c-> c c-> c c c-> c |
    c-> c c c-> c c-> c c c-> c |
    c->\cresc c c-> c c-> c c-> c c-> c |
    c-> c c-> c c-> c c-> c c-> c \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    c4->\!\ff r r r2 r4 | R1.*5 \bar "||"
  }

  snareI = \relative c' {
    \clef percussion \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1.*4 |
  % a, rehearsal 1, 5-12
    R1.*8 |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 4, 29-40
    R1.*11 | R1.^\fermataMarkup \bar "||"
  % b, rehearsal 5, 41-54
    \time 3/4 R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | R2. |
    R2.*4 | R2. | R2.^\fermataMarkup |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4*14 |
  % rehearsal 10, 117-122
    R1*5/4*5 |
    r2 r4 r c:32\mp\< |
  % rehearsal 11, 123-134
    c4->\!\f r r8 c4 c8 c c |
    c4-> r r8 c c c c c |
    c4-> r r8 c4 c8 c c |
    c4-> r r8 c c c c c |
    c8.-> c16 c8 c c c c c c c |
    c-> c16 c c8 c c c c c c c |
    c8.-> c16-> c8-> c-> r4 r2 |
    c8.-> c16-> c8-> c-> r4 r2 |
    c4-> r c-> r c-> |
    r4 c2:32 c:32 |
    c2.: c2:\< |
    c8->\sf^\markup { "Switch back to triangle" } r r4 r r2 \bar "||"
  % c, rehearsal 12, 135-142
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1.*4 \bar "||"
  % rehearsal 14, 149-161
    R1.*8 |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    R1.*4 |
  % rehearsal 17, 181-188
    R1.*8 |
  % rehearsal 18, 189-202
    \time 5/4
    R1*5/4*14 \bar "||"
  % d, rehearsal 19, 203-207
    \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 | R1 | R1 | R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    R1*5 |
  % rehearsal 24, 250-254
    R1*5 |
  % rehearsal 25, 255-261
    R1*3 |
    \time 3/4
    R2.*4 |
  % rehearsal 26, 262-266
    R2.*5 |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    R1*4 | R1 | R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1*5 | R1 | R1^\fermataMarkup |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    R1.*6 |
  % rehearsal 34, 329-336
    R1.*8 |
  % rehearsal 35, 337-344
    \time 5/4
    R1*5/4*8 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 37, 356-362
    R1.*7 |
  % rehearsal 38, 363-372
    \time 5/4
    R1*5/4*10 \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    R1. | R1.*5 \bar "||"
  }

  snareIII = \relative c' {
    \clef percussion \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1. | R1. |
    c4\sf r r r2 r4 | R1. |
  % a, rehearsal 1, 5-12
    R1.*8 |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1. | R1. |
    c4\mp r r c r r |
    c8->\mf c c c c c c-> c c c c c |
    c-> c c\< c c c c c c c c c |
  % rehearsal 4, 29-40
    c4->\!\f r r r2 r4 |
    R1. | R1. |
    r2 r4 r r8 c\mf\< c c |
    c4->\!\f r r r2 r4 |
    R1.*5 |
    r2 r4 c8\f\< c c c c c |
    c->\!\ff r r4 r\fermata c16-> c-> c8-> r4 r \bar "||"
  % b, rehearsal 5, 41-54
    \time 3/4 R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | R2. |
    R2.*4 | R2. | R2.^\fermataMarkup |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4*14 |
  % rehearsal 10, 117-122
    R1*5/4*6 |
  % rehearsal 11, 123-134
    R1*5/4*10 | R1*5/4 | R1*5/4 \bar "||"
  % c, rehearsal 12, 135-142
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1. | R1. |
    r2 r4 c8\f\< c c c c c |
    c->\!\ff r r4 r r2 r4 \bar "||"
  % rehearsal 14, 149-161
    R1.*8 |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    r2 r4 r r8 c16\f c c8-> r |
    r2 r4 r r8 c16 c c8-> r |
    r c16 c c8-> r r4 r2 r4 |
    r2 r4 c2.:32\p\< |
  % rehearsal 17, 181-188
    c4->\!\f r r r2 r4 |
    R1. | R1. |
    r2 r4 r r8 c\mf\< c c |
    c4->\!\f r r r2 r4 |
    R1.*3 |
  % rehearsal 18, 189-202
    \time 5/4
    R1*5/4*4 |
    c8->\mf\< c c c-> c c-> c c c-> c |
    c-> c c-> c c-> c c-> c c-> c->\!\ff |
    R1*5/4*8 \bar "||"
  % d, rehearsal 19, 203-207
    \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 | R1 | R1 | R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    R1*5 |
  % rehearsal 24, 250-254
    R1*5 |
  % rehearsal 25, 255-261
    R1*3 |
    \time 3/4
    R2.*4 |
  % rehearsal 26, 262-266
    R2. | R2. |
    c2.:32\mp\< | c: |
    c8->\!\f c-> r4 r |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    R1*4 | R1 | R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1*5 | R1 | R1^\fermataMarkup |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    r2. c16->\mp c c8 c c c c |
    c4 r r c16-> c c8 c c c c |
    c4 r r r2 r4 |
    c16->\cresc c c8 c c c c c16-> c c8 c c c c |
    c16-> c c8 c c c c c c c c c c |
    c4->\!\sf r r c2.:32\mp\< |
  % rehearsal 34, 329-336
    c4->\!\f r r r2 r4 |
    R1.*7 |
  % rehearsal 35, 337-344
    \time 5/4
    R1*5/4 |
    c8->\mp c c c-> c c c-> c c-> c |
    R1*5/4 |
    c8-> c c c-> c c c-> c c-> c |
    r2 r4 c8->\f c c4-> |
    r2 r4 c16-> c c8 c4-> |
    r c16-> c c8 r4 c16-> c c8 r4 |
    R1*5/4 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4 R1. | R1. |
    c4\mp r r c r r |
    c8->\mf c c c c c c-> c c c c c |
    c-> c c\< c c c c c c c c c |
  % rehearsal 37, 356-362
    c4->\!\f r r r2 r4 |
    R1. | R1. |
    r2 r4 r r8 c\mf\< c c |
    c4->\!\f r r r2 r4 |
    R1. | R1. |
  % rehearsal 38, 363-372
    \time 5/4
    R1*5/4 | R1*5/4 |
    c4->\f r r c8 c c16-> c c8 |
    c4-> r r c8 c c16-> c c8 |
    c4-> r r c8 c c16-> c c8 |
    c4-> r r c8 c c16-> c c8 |
    R1*5/4 | R1*5/4 |
    c8->\mf\cresc c c-> c c-> c c-> c c-> c |
    c-> c c-> c c-> c c-> c c-> c \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    c2.:32->\!\ff c:\> |
    c1.:\!\f\> | c: |
    c4\!\p r r r2 r4 |
    R1. | R1. \bar "||"
  }

  bsdrum = \relative c' {
    \clef percussion \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1.*4 |
  % a, rehearsal 1, 5-12
    R1.*8 |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 4, 29-40
    c2.\mf r2 r4 | c2. r2 r4 |
    r4 r8 c4. r4 r8 c4. |
    r2 r4 c c r |
    c2. r2 r4 | c2. r2 r4 |
    r4 r8 c4. r4 r8 c4. |
    R1.*4 |
    r2 r4\fermata c->\ff r r \bar "||"
  % b, rehearsal 5, 41-54
    \time 3/4 R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | R2. |
    R2.*4 | R2. | R2.^\fermataMarkup |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4 | r2 r4 r c\p |
    R1*5/4 | r2 r4 r c |
    R1*5/4 | r2 r4 r c |
    R1*5/4 | r2 r4 r c |
    R1*5/4 | r2 r4 r c |
    R1*5/4 | r2 r4 r c |
    R1*5/4 | r2 r4 r c:32\< |
  % rehearsal 10, 117-122
    c2.\!\f r2 | r2 r4 r c\mf |
    R1*5/4 | r2 r4 r c |
    c2.-> r2 | c2.-> r4 c:32\mp\< |
  % rehearsal 11, 123-134
    c4->\!\f r r r2 | c4 r r r2 |
    c4 r r r2 | c4 r r r2 |
    c4 r r r2 | c4 r r r2 |
    c8.-> c16-> c8-> c-> r4 r2 |
    c8.-> c16-> c8-> c-> r4 r2 |
    c4-> r c-> r c-> |
    R1*5/4 | R1*5/4 |
    c8->\sf^"Secco" r r4 r r2 \bar "||"
  % c, rehearsal 12, 135-142
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1.*3 |
    c8->\f^"Secco" r r4 r r2 r4 \bar "||"
  % rehearsal 14, 149-161
    R1.*8 |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    R1.*3 |
    r2^\markup { \bold \italic "As violently as possible!" } c4->\laissezVibrer\ff r2 r4 |
  % rehearsal 17, 181-188
    c2.\mf r2 r4 | c2. r2 r4 |
    r4 r8 c4. r4 r8 c4. |
    r2 r4 c c r |
    c2. r2 r4 | c2. r2 r4 |
    r4 r8 c4. r4 r8 c4. |
    R1. |
  % rehearsal 18, 189-202
    \time 5/4
    R1*5/4*14 \bar "||"
  % d, rehearsal 19, 203-207
    \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 | R1 | R1 | R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    R1*5 |
  % rehearsal 24, 250-254
    R1*5 |
  % rehearsal 25, 255-261
    R1*3 |
    \time 3/4
    R2.*4 |
  % rehearsal 26, 262-266
    R2.*4 |
    c8\f c r4 r |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    r2 c4-> r |
    r4 c-> c-> r |
    R1 |
    r2 \times 2/3 { c8-> c-> c-> } c4-> |
    r2 \times 2/3 { c8->\mf c-> c-> } c4-> |
    r2 \times 2/3 { c8\mp\> c c\!\p } r4 |
    R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1 |
    c1:32->\mf\> | c2: c4\!\p r |
    R1 | R1 | R1 | R1^\fermataMarkup |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    R1.*6 |
  % rehearsal 34, 329-336
    c4\f r r r2 r4 |
    R1.*7 |
  % rehearsal 35, 337-344
    \time 5/4
    R1*5/4*4 |
    r2 r4 c->\mf c-> |
    r2 r4 c-> c-> |
    r4 c-> r c-> r |
    R1*5/4 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 37, 356-362
    c2.\mf r2 r4 | c2. r2 r4 |
    r4 r8 c4. r4 r8 c4. |
    r2 r4 c c r |
    c2. r2 r4 | c2. r2 r4 |
    r4 r8 c4. r4 r8 c4. |
  % rehearsal 38, 363-372
    \time 5/4
    R1*5/4 | R1*5/4 |
    c4\f r r r2 | c4 r r r2 |
    c4 r r r2 | c4 r r r2 |
    R1*5/4*4 \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    c2.:32->\ff c:\> |
    c1.:\f\> | c: | c: |
    c4\!\p r r c4.->\f c-> |
    c16-> c4..->\laissezVibrer r4 r2 r4 \bar "||"
  }

  harprh = \relative c'' {
    \clef treble \key g \minor \numericTimeSignature \time 6/4
    \showStaffSwitch
  % intro, 1-4
    \grace { s16 } R1.*4 |
  % a, rehearsal 1, 5-12
    R1.*8 |
  % rehearsal 2, 13-17
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 4, 29-40
    R1.*11 | R1.^\fermataMarkup \bar "||"
  % b, rehearsal 5, 41-54
    \key c \minor \time 3/4
    r4^\markup { "D" \smaller \flat }^\collaparte <c g f ees>2\laissezVibrer\arpeggio |
    r <c g f ees>4\laissezVibrer\arpeggio |
    r^\markup { "G" \smaller \flat } <c f, ees c>\arpeggio <bes f ees bes>^\markup { "G" \smaller \natural "A" \smaller \natural } |
    \time 4/4
    <a ees a,>\arpeggio <g c, bes g>2\arpeggio^\markup { "A" \smaller \flat } <f c aes f>4\arpeggio |
    r^\markup { "D" \smaller \natural } <g f d c>2\arpeggio r4 |
    r^\markup { "D" \smaller \flat } <c, aes f>2\arpeggio r4 |
    r <g' c, g>2\arpeggio r4 |
    r <f ees c aes>2->\arpeggio r4 |
    r2 r4 <f c aes f>->\arpeggio ~ |
    <f c aes f>2 r^\markup { "D" \smaller \natural } |
    r4 <g f d c>->\arpeggio <g' f d c>2->\arpeggio |
    r4 <g, f d c>\arpeggio <g' f d c>2\arpeggio |
    r4 <g, f d c>2\arpeggio r4 |
    r2 g\flageolet\fermata \bar "||"
  % rehearsal 6, 55-66
    \time 3/4
    <g f ees c>2.\arpeggio\p^\markup { "A" \smaller \natural } ~ |
    <g f ees c> |
    <g ees c a>2.\arpeggio^\markup { "A" \smaller Hflat } |
    <f ees c aes>\arpeggio |
    <g f d bes>\arpeggio |
    <g f ees c>2.\arpeggio^\markup { "A" \smaller \natural } ~ |
    <g f ees c> |
    <g ees c bes>\arpeggio |
    <g ees c a>\arpeggio^\markup { "A" \smaller \flat } |
    <f ees c aes>\arpeggio |
    <f d bes g>\arpeggio |
    <ees c g>\arpeggio |
  % rehearsal 7, 67-81
    R2.*8^\markup { \harp-pedal #"--^|v--v" } |
    r2 \tag #'score { g,4\mf\<\glissando } \tag #'midi { \times 16/21 { g64\mp\< ais bes c d eis f g ais bes c d eis f g ais bes c d eis f } } |
    g4\!\f r s |
    \set tupletSpannerDuration = #(ly:make-moment 1 4)
    \stl \times 2/3 { bes,,,,8([^\markup { "A" \smaller \natural } g' c] \str ees[ f g] c[ ees f] } |
    g4) s2 | s2. |
    \stl \times 2/3 { c,,,,8([ c' g'] bes[ \str c e] } g16 bes c e |
    <c' g c,>4)\arpeggio\fermata r_\markup { \harp-pedal #"--^|^^^^" } r |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } R1*5/4*13 |
    r2 r4 \tag #'score { \stl bes,,,32 c d e fes ges aes bes32*9\glissando | }
      \tag #'midi { \times 8/14 { bes,32 c d e fes ges aes bes c d e fes ges aes } \times 8/14 { bes c d e fes ges aes bes c d e fes ges aes } | }
  % rehearsal 10, 117-122
    \str bes2 r4_\markup { \harp-pedal #"^-^|^--^" } r2 | R1*5/4*5 |
  % rehearsal 11, 123-134
    R1*5/4*10 |
    r2 r4 \tag #'score { \stl des,,,,,32 ees f g aes bes c des32*9\glissando | }
      \tag #'midi { \times 8/15 { des,32 ees f g aes bes c des ees f g aes bes c des } ees64 f g aes bes c des ees f g aes bes c des ees f | }
    \str g4-> r_\markup { \harp-pedal #"--^|^---" } r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \key g \minor
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    R1*7/4 | R1*7/4 |
    \time 6/4
    R1.*4 \bar "||"
  % rehearsal 14, 149-161
    R1.*8 |
    \time 5/4 R1*5/4*4 | \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    R1.*3 |
    r2 r4 r \tag #'score { \stl d,,,4*2\glissando | }
      \tag #'midi { \times 16/21 { d32 ees f g a bes c d ees f g a bes c d ees f g a bes c } | }
  % rehearsal 17, 181-188
    \str d4 r_\markup { \harp-pedal #"-^-|-v--" } r r2 r4 | R1.*7 |
  % rehearsal 18, 189-202
    \time 5/4
    R1*5/4*14 \bar "||"
  % d, rehearsal 19, 203-207
    \key g \major \time 4/4
    e64([^\adlib b g e \stl d b g e)] \str d''([ b g d \stl b g e d)] \str b''([ g d b \stl g e d b)] \str g''([ d b g \stl e d b g)] \str e''([ b g e \stl d b g e)] \str d''([ b g d \stl b g e d)] \str b''([ g d b \stl g e d b)] \str g''([ d b g \stl e d b g)] |
    \str e''([ b g e \stl d b g e)] \str d''([ b g d \stl b g e d)] \str r2 \tag #'score { b''4\glissando | } \tag #'midi { \times 16/21 { b64 ces d e fes g a b ces d e fes g a b ces d e fes g a } | \tempo 4=50 }
    \tag #'midi { \tempo 4=60 } b4^\markup { "C" \smaller \natural "F" \smaller \sharp } r <a e c a>8[\arpeggio <g e c g>]\arpeggio <e b g e>[\arpeggio <b g e b>]\arpeggio \bar ":"
    <d b g d>[\arpeggio <e b g e>]\arpeggio << { \tag #'score { <g, e c g>2.\arpeggio } \tag #'midi { <g e c g>2 r4 } } \\ { \stl r4 a,,,8[ \times 2/3 { e'16 g a] } \str \times 4/7 { c[ e g a c e g] } } >> \bar ":"
    c4 r r8 <d, d,> <e e,>8.[ <b' b,>16] |
  % rehearsal 20, 208-221
    <g g,>2 s | s1 |
    \time 6/4 s1. |
    \time 4/4 s1*4 |
    \time 6/4 s1. |
    \time 4/4 s1*3 |
    \time 6/4 s1. |
    \time 4/4 s1 | s1 |
  % rehearsal 21, 222-228
    R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \time 6/4 s1. |
    \time 4/4 s1*4 |
    \time 6/4 s1. |
    \time 4/4 s1 | s1 | s1 |
    \stl \times 2/3 { a,,,8([ g' cis] \str e[ g a] b[ cis e] g[ a cis] } |
    e2) r | R1*3 |
    <g, g,>1\p\fermata \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    R1*5 |
  % rehearsal 24, 250-254
    R1*5 |
  % rehearsal 25, 255-261
    R1*3 |
    \time 3/4
    R2.*4 |
  % rehearsal 26, 262-266
    R2.*5 |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    R1*4 | R1 | R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    \key g \major
    R1^\collaparte_\markup { \harp-pedal #"--v|-^--" } |
    <d' d,>1\arpeggio\fermata | R1 | R1^\fermataMarkup | R1 |
    r2 r4 <d d,>\arpeggio\p\fermata |
  % rehearsal 30, 287-299
    R1 |
    << { \tag #'score { r8 g,,,64 a bis c d e fes g64*9\glissando \headsOn \ottava #1 e'''8\glissando \ottava #0 c,,,4\glissando \headsOff }
      \tag #'midi { r8 \times 8/15 { g64 a bis c d e fes g a bis c d e fes g } \times 16/29 { a bis c d e fes g a bis c d e d c bis a g fes e d c bis a g fes e d c bis } \times 16/28 { a g fes e d c d e fes g a bis c d e fes g a bis c d e fes g a bis c d } }
      \ottava #1 e4-> \ottava #0 } \\
      { <c,,,, bis>1-> } >> |
    s1*3 |
    \stl \times 8/9 { a16( e' g c \str e g c e g) } \stl \times 8/9 { a,,( e' g a \str c e g a c } |
    <g' e>4)\fermata r^\markup { "E" \smaller \flat "B" \smaller \flat } r2 |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    R1.*5 |
    r2 r4 \tag #'score { \stl d,,,,4*3\glissando | }
      \tag #'midi { \times 8/11 { d32 ees f g a bes c d ees f g } \times 8/12 { a bes c d ees f g a bes c d ees } \times 8/12 { f g a bes c d ees f g a bes c } | }
  % rehearsal 34, 329-336
    \str d4-> r r r2 r4 |
    R1.*6 |
    r2 r4 r2 \tag #'score { d,,,4\glissando | }
      \tag #'midi { d64 ees f g a bes c d ees f g a bes c d ees } |
  % rehearsal 35, 337-344
    \time 5/4
    f4-> r r r2 | R1*5/4*7 |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4 R1.*4 | R1. |
  % rehearsal 37, 356-362
    R1.*7 |
  % rehearsal 38, 363-372
    \time 5/4
    R1*5/4*10 \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    r2_\markup { \harp-pedal #"vv^|^--v" } r4 r
      \tag #'score { \stl g,,,,64 ais bes cis dis ees f g64*9\glissando \str \headsOn g''8\glissando \stl g,,\glissando | }
      \tag #'midi { g,64 ais128 bes cis dis ees f g ais bes cis dis ees f g ais bes cis dis ees f g f ees dis cis bes ais g f ees dis cis bes ais g ais bes cis dis ees f g ais bes cis dis ees f g ais bes cis dis ees f g ais bes cis dis ees f | }
    g4-> r r r2 r4 |
    R1.*4 \bar "||"
  }

  harplh = \relative c {
    \clef bass \key g \minor \numericTimeSignature
  % intro, 1-4
    \grace { s16 } R1.*4 |
  % a, rehearsal 1, 5-12
    R1.*8 |
  % rehearsal 2, 13-17
    R1*5/4*4 | R1. |
  % rehearsal 3, 18-28
    R1*5/4*6 | R1.*4 | R1. |
  % rehearsal 4, 29-40
    R1.*11 | R1.^\fermataMarkup \bar "||"
  % b, rehearsal 5, 41-54
    \key c \minor
    r4 <c g' c>2\laissezVibrer\arpeggio |
    r <bes g' c>4\laissezVibrer\arpeggio |
    r <aes f' aes>\arpeggio <ges des' ges>\arpeggio |
    <f c' f>\arpeggio <ees c' ees>2\arpeggio <des aes' des>4\arpeggio |
    r <g d' f>2\arpeggio r4 |
    r <aes ees'>2\arpeggio r4 |
    r <g ees'>2\arpeggio r4 |
    r <f c' f>2->\arpeggio r4 |
    r2 r4 <des aes' des>->\arpeggio ~ |
    <des aes' des>2 r |
    r4 <g d' g>->\arpeggio <g' d' g>2->\arpeggio |
    r4 <g, d' g>\arpeggio <g' d' g>2\arpeggio |
    r4 <g, d' g>2\arpeggio r4 |
    R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    R2.*12 |
  % rehearsal 7, 67-81
    R2.*8 | R2. |
    \set tupletSpannerDuration = #(ly:make-moment 1 4)
    r4 \times 2/3 { ees''8([ f g] \str c[ ees f] } |
    g4) \stl s2 |
    \times 2/3 { a,,,8([ g' c] \str ees[ f c'] f[ c f,)] } |
    \stl \times 2/3 { g,,8([^\markup { "E" \smaller \natural } d' g] bes[ \str c d] g[ bes g')] } |
    \stl s2. | \clef treble <c,, e bes'>4\arpeggio\fermata r r |
  % rehearsal 8, 82-102
    \clef bass
    R1*3 | R1*3 | R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \grace { s16 } R1*5/4*13 | r2 r4 s2 |
  % rehearsal 10, 117-122
    R1*5/4*6 |
  % rehearsal 11, 123-134
    R1*5/4*10 | r2 r4 s2 | R1*5/4 \bar "||"
  % c, rehearsal 12, 135-142
    \key g \minor
    R1*5/4*8 |
  % rehearsal 13, 143-148
    R1*7/4 | R1*7/4 | R1.*4 \bar "||"
  % rehearsal 14, 149-161
    R1.*8 | R1*5/4*4 | R1. |
  % rehearsal 15, 162-176
    R1.*15 |
  % rehearsal 16, 177-180
    R1.*3 | r2 r4 r s2 |
  % rehearsal 17, 181-188
    R1.*8 |
  % rehearsal 18, 189-202
    R1*5/4*14 \bar "||"
  % d, rehearsal 19, 203-207
    \clef treble \key g \major
    s2 \clef bass s \bar ":"
    s4 g,,--( ~ g32[ d' e g b d e g)] r4 \bar ":"
    \clef treble r2 <a' c e>8[\arpeggio <g c e>]\arpeggio <e g b>[\arpeggio <b e g>]\arpeggio \bar ":"
    <d g b>[\arpeggio <e g b>]\arpeggio \tag #'score { <g, c e>2.\arpeggio } \tag #'midi { <g c e>4 r2 }  \bar ":"
    \clef bass r2 r4 <d fis c'>\arpeggio |
  % rehearsal 20, 208-221
    \times 2/3 { g,8([ d' g] \str b[ d e] b'[ g e] d[ b g)] } | 
    \stl \times 2/3 { g,([ d' g] \str b[ d e] b'[ g e] d[ b g)] } | 
    \stl \times 2/3 { g,([ d' g] \str b[ d e] b'[ g e] g[ e d] e[ d b] a[ d a')] } | 
    \stl \times 2/3 { e,,([ b' g'] \str b[ e g)] \stl d,,([ b' g'] \str b[ e g)] } |
    \stl \times 2/3 { c,,,([ e' a] \str c[ e g] a[^\markup { "C" \smaller \sharp } g e] d[ e b)] } |
    \stl \times 2/3 { a,([ e' g] a[ \str cis e] a[ g e] cis[ e a,)] } |
    \stl \times 2/3 { d,,([^\markup { "C" \smaller \natural } d' fis] \str a[ c d] a'[ fis e] fis[ e d)] } |
    \stl \times 2/3 { g,,([ d' g] \str b[ d e] b'[ g e] g[ e d] e[ d b] a[ d a')] } | 
    \stl \times 2/3 { e,,([ b' g'] \str b[ e g)] \stl d,,([ b' g'] \str b[ e g)] } |
    \stl \times 2/3 { c,,,([ e' a] \str c[ e g] a[ g e] g[ e a,)] } |
    \stl \times 2/3 { b,,([^\markup { "C" \smaller \sharp } b' fis'] \str d'[ e fis] d'[ b fis] e[ d b)] } |
    \stl \times 2/3 { e,,([ b' g'] \str b[ e b')] \stl c,,,([ e' g] \str a[ e' a)] \stl b,,([ \str g' d'] e[ d g,)] } |
    \stl \times 2/3 { a,([ \str g' cis] g'[ cis, g)]^\markup { "C" \smaller \natural } \stl d,([ \str fis' c'] d[ c fis,)] } |
    \stl \times 2/3 { g,([ d' e] g[ \str b d] e[ g a] } b4) |
  % rehearsal 21, 222-228
    \stl R1*4 | R1*3 |
  % rehearsal 22, 229-244
    R1 |
    \times 2/3 { g,,8([ d' g] \str b[ d e] b'[ g e] g[ e d] e[ d b] a[ d a')] } | 
    \stl \times 2/3 { e,,([ b' g'] \str b[ e g)] \stl d,,([ b' g'] \str b[ e g)] } |
    \stl \times 2/3 { c,,,([ e' a] \str c[ e g] a[^\markup { "C" \smaller \sharp } g e] d[ e b)] } |
    \stl \times 2/3 { a,([ e' g] a[ \str cis e] a[ g e] cis[ e a,)] } |
    \stl \times 2/3 { d,,([^\markup { "C" \smaller \natural } d' fis] \str a[ c d] a'[ fis e] fis[ e d)] } |
    \stl \times 2/3 { g,,([ d' g] \str b[ d e] b'[ g e] g[ e d] e[ d b] a[ d a')] } | 
    \stl \times 2/3 { e,,([ b' g'] \str b[ e g)] \stl d,,([ b' g'] \str b[ e g)] } |
    \stl \times 2/3 { c,,,([ e' a] \str c[ e g] a[ g e] g[ e a,)] } |
    \stl \times 2/3 { b,,([^\markup { "C" \smaller \sharp } e' g] \str b[ d e] b'[ g e] d[ e b)] } |
    \stl s1 | R1*4 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    R1*5 |
  % rehearsal 24, 250-254
    R1*5 |
  % rehearsal 25, 255-261
    R1*3 | R2.*4 |
  % rehearsal 26, 262-266
    R2.*5 |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    R1*4 | R1 | R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    \key g \major
    R1 | <d e g b>1\arpeggio\fermata | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1 |
    << { \voiceTwo <c,,, bis' c>1->\laissezVibrer } \new Voice \voiceOne {
      \tag #'score { r8 g''64 a bis c d e fes g64*9\glissando \headsOn \fakeTrebleClef g'8\glissando \clef bass c,,4\glissando \headsOff \fakeTrebleClef g''-> }
      \tag #'midi { r8 \times 8/15 { g,,64 a bis c d e fes g a bis c d e fes g } \times 16/29 { a bis c d e fes g a bis c d e d c bis a g fes e d c bis a g fes e d c bis } \times 16/28 { a g fes e d c d e fes g a bis c d e fes g a bis c d e fes g a bis c d } e4-> } } >> |
    \oneVoice \clef bass
    \times 4/5 { c,,,16([^\markup { "F" \smaller \natural "B" \smaller \natural } g' a c d] \str e[ g a c e)] \stl e,,([ g a c e] \str g[ a c e g)] } |
    \stl \times 4/5 { e,,,([ b' d e g] \str b[ d e g b)] \stl e,,([ b' d e g] \str b[ d e g b)] } |
    \stl \times 4/5 { b,,,([ d^\markup { "B" \smaller \flat } e g b] \str d[ e g b d)] \stl bes,,([ d g bes c] \str d[ e g bes d)] } |
    \stl s1 |
    \clef treble <e g>4\fermata r r2 |
    \clef bass R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    R1.*5 | r2. s |
  % rehearsal 34, 329-336
    R1.*8 |
  % rehearsal 35, 337-344
    \time 5/4
    R1*5/4*8 |
  % rehearsal 36, 345-355
    R1*5/4*6 | R1.*4 | R1. |
  % rehearsal 37, 356-362
    R1.*7 |
  % rehearsal 38, 363-372
    R1*5/4*10 \bar "||"
  % f, rehearsal 39, 373-378
    r2 r4 r s2 | R1.*5 \bar "||"
  }

  dynamics = \relative c' {
  % intro, 1-4
    \grace { s16 } s1.*4 |
  % a, rehearsal 1, 5-12
    s1.*8 |
  % rehearsal 2, 13-17
    s1*5/4*4 | s1. |
  % rehearsal 3, 18-28
    s1*5/4*6 | s1.*4 | s1. |
  % rehearsal 4, 29-40
    s1.*11 | s1. |
  % b, rehearsal 5, 41-54
    s2.*3\mf | s2 s\> | s1\!\mp | s | s\mf | s1*3\f | s1\ff | s\mf | s1*2\p |
  % rehearsal 6, 55-66
    s2.*12 |
  % rehearsal 7, 67-81
    s2.*8 | s2. |
    s2.*3 | s2.\> | s | s\p |
  % rehearsal 8, 82-102
    s1*3 | s1*3 | s2.*6 | s2.*4 | s2.*4 s2. |
  % rehearsal 9, 103-116
    \grace { s16 } s1*5/4*13 | s2. s2\mf\< |
  % rehearsal 10, 117-122
    s1*5/4*6\f |
  % rehearsal 11, 123-134
    s1*5/4*10 | s2. s2\ff | s1*5/4 |
  % c, rehearsal 12, 135-142
    s1*5/4*8 |
  % rehearsal 13, 143-148
    s1*7/4 | R1*7/4 | s1.*4 |
  % rehearsal 14, 149-161
    s1.*8 | s1*5/4*4 | s1. |
  % rehearsal 15, 162-176
    s1.*15 |
  % rehearsal 16, 177-180
    s1.*3 | s1 s2\f |
  % rehearsal 17, 181-188
    s1.*8 |
  % rehearsal 18, 189-202
    s1*5/4*14 |
  % d, rehearsal 19, 203-207
    s1\mf \bar ":" s \bar ":" s \bar ":" s \bar ":" s2 s8 s4.\mp |
  % rehearsal 20, 208-221
    s1*2 | s1. | s1*4 | s1. | s1\< | s1\!\mf | s1 | s1. | s1\> | s1\!\mp |
  % rehearsal 21, 222-228
    s1*4 | s1*3 |
  % rehearsal 22, 229-244
    s1\f | s1. | s1*4 | s1. |
    s1 | s1 | s1\> | s\!\mp | s1*4 | s1 |
  % rehearsal 23, 245-249
    s1*5 |
  % rehearsal 24, 250-254
    s1*5 |
  % rehearsal 25, 255-261
    s1*3 | s2.*4 |
  % rehearsal 26, 262-266
    s2.*5 |
  % rehearsal 27, 267-272
    s2.*6 |
  % rehearsal 28, 273-280
    s1*4 | s1 | s1 | s1 | s1 |
  % rehearsal 29, 281-286
    s1 | s\p | s | s | s | s |
  % rehearsal 30, 287-299
    s1 | s1\ff | s1*3\dim | s1 | s1\!\mp |
    s1*4 | s1 | s1 |
  % e, rehearsal 31, 300-317
    s1.*18 |
  % rehearsal 32, 318-322
    s1.*5 |
  % rehearsal 33, 323-328
    s1.*5 |
    s2. s\f |
  % rehearsal 34, 329-336
    s1.*7 | s2. s2 s4\f |
  % rehearsal 35, 337-344
    s1*5/4*8 |
  % rehearsal 36, 345-355
    s1*5/4*6 | s1.*4 | s1. |
  % rehearsal 37, 356-362
    s1.*7 |
  % rehearsal 38, 363-372
    s1*5/4*10 |
  % f, rehearsal 39, 373-378
    s1 s2\fff | s1.*5 |
  }

  midiperc = <<
    \new DrumVoice = "tri-cym" {
      \drummode {
    \grace { s16 } hc4\sf r r r2 r4 | sn r r r2 r4 |
    tamb r r r2 r4 | R1.*5 |
    trio1.\mf | trio |
    r4 r8 \repeat tremolo 8 trio32 trim8 r4 r8 \repeat tremolo 8 trio32 trim8 |
    r2. trio4 trio r |
    R1*5/4*4 | R1. | R1*5/4*6 |
    R1.*2 |
    sn4\mp r r sn r r |
    sn8\mf sn\p sn sn sn sn sn\mf sn\p sn sn sn sn |
    sn8\mf sn\pp\< sn sn sn sn sn sn sn sn sn sn |
    sn\!\f tamb tamb tamb tamb tamb r tamb tamb tamb tamb tamb |
    r tamb tamb tamb tamb tamb r tamb tamb tamb tamb tamb |
    tamb4 tamb8 \repeat tremolo 8 tamb32-> tamb8 tamb4 tamb8 \repeat tremolo 8 tamb32-> tamb8 | 
    tamb tamb tamb tamb tamb tamb tamb-> tamb tamb-> sn\p\< sn sn |
    sn\!\f tamb\mf tamb tamb tamb tamb r tamb tamb tamb tamb tamb |
    r tamb tamb tamb tamb tamb r tamb tamb tamb tamb tamb |
    tamb4 tamb8 \repeat tremolo 8 tamb32-> tamb8 tamb4 tamb8 \repeat tremolo 8 tamb32-> tamb8 | 
    \repeat unfold 12 tamb8\p\< |
    tamb1.\!\f | R1. |
    r2. \repeat unfold 6 sn8\mf\< |
    sn4\!\ff r2 sn16 sn sn8 r2 |
    R2.*3 | R1*10 | R1 \bar "||"
    R2.*21 |
    trio2.\f | R2.*3 | trio2.\p | R2. |
    R1*6 | R2.*15 |
    \grace { cymch16\p } cymch2. r2 | R1*5/4*18 |
    r1 \repeat tremolo 8 sn32\mp\< |
    sn4\!\f r r8 sn4 sn8 sn sn |
    sn4 r r8 sn sn sn sn sn |
    sn4 r r8 sn4 sn8 sn sn |
    sn4 r r8 sn sn sn sn sn |
    sn8. sn16 sn8 sn sn sn sn sn sn sn |
    sn8 sn16 sn sn8 sn sn sn sn sn sn sn |
    sn8.-> sn16-> sn8-> sn-> r4 r2 |
    sn8.-> sn16-> sn8-> sn-> r4 r2 |
    sn4 r sn r sn |
    r \repeat unfold 40 sn32*4/5 |
    \repeat unfold 30 sn \repeat unfold 20 sn\< |
    sn4 r1 |
    R1*5/4*8 |
    R1*7/4*2 | R1.*2 |
    r2. sn8\f\< sn sn sn sn sn |
    sn\!\ff r r4 r hc r r |
    R1.*4 |
    trio1.\mf | trio |
    r4 r8 \repeat tremolo 8 trio32 trim8 r4 r8 \repeat tremolo 8 trio32 trim8 |
    r2. trio4 trio r |
    R1*5/4*4 | R1. |
    R1.*15 |
    r2 r4 r r8 sn16\f sn sn8-> r |
    r2 r4 r r8 sn16 sn sn8-> r |
    r sn16 sn sn8-> r r4 r2 r4 |
    r2 r4 \repeat tremolo 24 sn32\pp\< |
    sn8\!\f tamb\mf tamb tamb tamb tamb r tamb tamb tamb tamb tamb |
    r tamb tamb tamb tamb tamb r tamb tamb tamb tamb tamb |
    tamb4 tamb8 \repeat tremolo 8 tamb32-> tamb8 tamb4 tamb8 \repeat tremolo 8 tamb32-> tamb8 | 
    tamb tamb tamb tamb tamb tamb tamb-> tamb tamb-> sn\p\< sn sn |
    sn\!\f tamb\mf tamb tamb tamb tamb r tamb tamb tamb tamb tamb |
    r tamb tamb tamb tamb tamb r tamb tamb tamb tamb tamb |
    tamb4 tamb8 \repeat tremolo 8 tamb32-> tamb8 tamb4 tamb8 \repeat tremolo 8 tamb32-> tamb8 | 
    \repeat unfold 12 tamb8\p\< |
    tamb4\!\f r r r2 |
    \repeat tremolo 32 tamb32 tamb4\ff |
    R1*5/4 |
    \repeat tremolo 32 tamb32\f tamb4\ff |
    tamb4.\mf\< tamb4 tamb4. tamb4 |
    tamb4\< tamb tamb tamb tamb8 tamb\!\ff |
    R1*5/4*8 |
    R1*5 |
    trio1\mp | R1 | R1. | R1*4 | R1. | R1*3 | R1. | R1*10 |
    R1. | R1*4 | R1. | R1*3 | trio1\mp | R1*5 |
    R1*13 | R2.*6 |
    \repeat tremolo 24 sn32\mp\< |
    \repeat tremolo 24 sn |
    sn8\!\f sn r4 r |
    R2.*6 | R1*26 | trio1\pp |
    R1.*23 |
    r2. sn16\p sn sn8 sn sn sn sn |
    sn4 r r sn16 sn sn8 sn sn sn sn |
    sn4 r r r2 r4 |
    sn16\< sn sn8 sn sn sn sn sn16 sn sn8 sn sn sn sn |
    sn16 sn sn8 sn sn sn sn sn sn sn sn sn sn |
    sn4\!\sf r2 \repeat tremolo 24 sn32\mp\< |
    sn8\!\f tamb tamb tamb tamb tamb tamb tamb tamb tamb tamb tamb |
    tamb tamb tamb tamb tamb tamb tamb tamb tamb tamb tamb tamb |
    tamb tamb tamb \repeat tremolo 8 tamb32-> tamb8 tamb tamb tamb \repeat tremolo 8 tamb32-> tamb8 | 
    tamb tamb tamb tamb tamb tamb tamb-> tamb tamb-> r r4 |
    R1.*4 |
    tamb8\f tamb\p tamb tamb\f tamb\p tamb tamb\f tamb\p tamb\f tamb\p |
    sn\f sn\p sn sn\f sn\p sn sn\f sn\p sn\f sn\p |
    tamb8\f tamb\p tamb tamb\f tamb\p tamb tamb\f tamb\p tamb\f tamb\p |
    sn\f sn\p sn sn\f sn\p sn sn\f sn\p sn\f sn\p |
    r2. tamb8\f tamb tamb4 |
    r2. tamb8 tamb tamb4 |
    r4 tamb8 tamb r4 tamb8 tamb r4 |
    R1*5/4*7 |
    R1.*2 |
    sn4\mp r r sn r r |
    sn8\mf sn\p sn sn sn sn sn\mf sn\p sn sn sn sn |
    sn8\mf sn\pp\< sn sn sn sn sn sn sn sn sn sn |
    sn\!\f tamb tamb tamb tamb tamb r tamb tamb tamb tamb tamb |
    r tamb tamb tamb tamb tamb r tamb tamb tamb tamb tamb |
    tamb4 tamb8 \repeat tremolo 8 tamb32-> tamb8 tamb4 tamb8 \repeat tremolo 8 tamb32-> tamb8 | 
    tamb tamb tamb tamb tamb tamb tamb-> tamb tamb-> sn\p\< sn sn |
    sn\!\f tamb\mf tamb tamb tamb tamb r tamb tamb tamb tamb tamb |
    r tamb tamb tamb tamb tamb r tamb tamb tamb tamb tamb |
    tamb4 tamb8 \repeat tremolo 8 tamb32-> tamb8 tamb4 tamb8 \repeat tremolo 8 tamb32-> tamb8 | 
    tamb\p\< tamb tamb tamb tamb tamb tamb tamb tamb tamb |
    tamb tamb tamb tamb tamb tamb tamb tamb tamb tamb |
    tamb4\!\f r1 | R1*5/4 |
    tamb2. tamb8 tamb tamb4 |
    tamb2. tamb8 tamb tamb4 |
    \repeat unfold 10 tamb8\p |
    \repeat unfold 10 tamb |
    \repeat unfold 10 tamb\< |
    \repeat unfold 10 tamb |
    tamb1.\!\ff | s1.*5 |
    }
  }
    \new DrumVoice = "sn" {
      \drummode {
    \grace { s16 } s1.*12 | s1*5/4*4 | s1. | s1*5/4*6 | s1.*5 |
    cymca1.\mf | cymca | r4. cymca r cymca | r2. cymca4 cymca2 |
    cymca1. | cymca | r4. cymca r cymca |
    cymca4\p\< r cymca r cymca\!\mf r |
    R1.*3 | r2. cymca |
    s2.*3 | s1*11 |
    s2.*27 |
    s1*6 | s2.*15 |
    \grace { s16 } s1 trio4\pp | s1 cymca4 |
    s1 trio4 | s1 cymca4 |
    s1 trio4 | s1 cymca4 |
    s1 trio4 | s1 cymca4 |
    s1 trio4 | s1 cymca4 |
    s1 trio4 | s1 cymca4 |
    s1 trio4 | s1 \repeat tremolo 8 cymca32\p\< |
    cymca1\!\f trio4 | s1 cymca4\mf |
    s1 trio4 | s1 cymca4\mp |
    cymca1\f s4 | cymca1 s4 |
    s1*5/4*6 |
    cymca2\f s2. | cymca2 s2. |
    s1*5/4*3 | cymca8 s s1 |
    s1*5/4*8 |
    s1*7/4*2 | s1.*3 | cymca8\ff s s2 s2. |
    s1.*8 | s1*5/4*4 | s1. |
    s1.*19 |
    cymca1.\mf | cymca | r4. cymca r cymca | r2. cymca4 cymca2 |
    cymca1. | cymca | r4. cymca r cymca |
    cymca4\p\< r cymca r cymca r |
    cymca2.\!\f s2 | s1*5/4*3 |
    cymca4.\p\< cymca4 cymca4. cymca4 |
    cymca4\< cymca cymca cymca cymca8 cymca\!\f |
    s1*5/4*8 |
    s1*7 | s1. | s1*4 | s1. | s1*3 | s1. | s1*9 |
    s2 \repeat tremolo 16 cymca32\p\< |
    cymca1.\!\mf | s1*4 | cymca1. | s1*9 |
    s1*7 |
    s2. \repeat tremolo 8 cymca32\p\< |
    cymca2\!\mf s | s1*3 |
    s2. \repeat tremolo 8 cymca32\p\< |
    cymca2.\!\mf | s2.*14 |
    s1*15 | cymca1\f | s1*11 |
    s1.*29 |
    tamb4 r r s2. | s1.*7 |
    s1*5/4 |
    cymca8\p s4 cymca8 s4 cymca cymca |
    s1*5/4 |
    cymca8 s4 cymca8 s4 cymca cymca |
    s2. sn8\f sn sn4 | s2. sn16 sn sn8 sn4 |
    s4 sn16 sn sn8 s4 sn16 sn sn8 s4 |
    s1*5/4*7 |
    cymca4\pp s2 s2. | cymca4 s2 s2. |
    s1.*3 |
    cymca1.\mf | cymca | r4. cymca r cymca | r2. cymca4 cymca2 |
    cymca1. | cymca | r4. cymca r cymca |
    cymca2\pp\< cymca cymca4 | s cymca2 cymca4 cymca |
    cymca4\!\f s1 | s1*5/4*3 |
    cymca4.\p cymca4 cymca4. cymca4 |
    cymca4. cymca4 cymca4. cymca4 |
    cymca4\< cymca cymca cymca cymca |
    cymca cymca cymca cymca cymca |
    cymca1.\!\ff |
    s2. cymch | s cymch\mf |
    s cymch\mp | s1. | s2 cymch1\p |
    }
  }
    \new DrumVoice = "bd" {
      \drummode {
    \grace { s16 } s1.*12 | s1*5/4*4 | s1. | s1*5/4*6 | s1.*5 |
    bd1.\mf | bd | r4. bd r bd | r2. bd4 bd2 |
    bd1. | bd | r4. bd r bd |
    s1.*4 | s2. bd |
    s2.*3  | s1*11 |
    s2.*27 |
    s1*6 | s2.*15 |
    \grace { s16 } tamb8.\p tamb16 tamb8 tamb4 tamb tamb8 tamb tamb |
    tamb tamb16 tamb tamb8 tamb4 tamb tamb8 tamb4 |
    tamb8. tamb16 tamb8 tamb4 tamb tamb8 tamb tamb |
    tamb tamb16 tamb tamb8 tamb4 tamb tamb8 tamb4 |
    tamb8. tamb16 tamb8 tamb4 tamb tamb8 tamb tamb |
    tamb tamb16 tamb tamb8 tamb4 tamb tamb8 tamb4 |
    tamb8. tamb16 tamb8 tamb4 tamb tamb8 tamb tamb |
    tamb tamb16 tamb tamb8 tamb4 tamb tamb8 tamb4 |
    tamb8. tamb16 tamb8 tamb4 tamb tamb8 tamb tamb |
    tamb tamb16 tamb tamb8 tamb4 tamb tamb8 tamb4 |
    tamb8. tamb16 tamb8 tamb4 tamb tamb8 tamb tamb |
    tamb tamb16 tamb tamb8 tamb4 tamb tamb8 tamb4 |
    tamb8. tamb16 tamb8 tamb4 tamb tamb8 tamb tamb |
    tamb\< tamb16 tamb tamb8 tamb4 tamb tamb8 tamb tamb |
    tamb8.\!\f tamb16 tamb8 tamb4 tamb tamb8 tamb tamb |
    tamb tamb16 tamb tamb8 tamb4 tamb tamb8 tamb tamb |
    tamb8. tamb16 tamb8 tamb4 tamb tamb8 tamb tamb |
    tamb tamb16 tamb tamb8 tamb4 tamb tamb8 tamb tamb |
    tamb8. tamb16 tamb8 tamb4 tamb tamb8 \repeat tremolo 8 tamb32\p\< |
    tamb8.\!\f tamb16 tamb8 tamb4 tamb tamb8 \repeat tremolo 8 tamb32\p\< |
    tamb4\!\f s1 | s1*5/4*3 |
    \repeat unfold 40 trio32 | \repeat unfold 40 trio |
    trio2 s2. | s1*5/4*5 |
    s1*5/4*8 |
    s1*7/4*2 | s1.*4 |
    s1.*8 | s1*5/4*4 | s1. |
    s1.*8 |
    trio2.\mf s2. | s1.*10 |
    bd1.\mf | bd | r4. bd r bd | r2. bd4 bd2 |
    bd1. | bd | r4. bd r bd | s1. |
    s1*5/4*4 |
    sn8\mf sn\p sn sn\mf sn\p sn\mf sn\p sn sn\mf sn\p |
    sn\f sn\p sn\f sn\p sn\f sn\p sn\f sn\p sn\f sn\ff |
    s1*5/4*8 |
    s1*7 | s1. | s1*4 | s1. | s1*3 | s1. | s1*10 |
    s1. | s1*4 | s1. | s1*9 |
    s1*13 | s2.*8 | bd8\f bd s2 |
    s2.*6 |
    r2 bd4 r |
    r4 bd bd r |
    R1 |
    r2 \times 2/3 { bd8-> bd-> bd-> } bd4-> |
    r2 \times 2/3 { bd8->\mf bd-> bd-> } bd4-> |
    r2 \times 2/3 { bd8\mp\> bd bd\!\p } r4 |
    s1*9 |
    \repeat tremolo 64 bd64\mf\> |
    \repeat tremolo 32 bd bd4\!\p r |
    s1*10 |
    s1.*29 |
    bd1.\f | s1.*7 |
    s1*5/4*4 |
    s2. bd4 bd | s2. bd4 bd |
    s bd s bd s |
    s1*5/4*7 | s1.*5 |
    bd1.\mf | bd | r4. bd r bd | r2. bd4 bd2 |
    bd1. | bd | r4. bd r bd |
    s1*5/4*2 |
    bd1 s4 | bd1 s4 | bd1 s4 | bd1 s4 |
    s1*5/4*2 |
    \repeat unfold 10 sn8\mf\< |
    \repeat unfold 10 sn8 |
    \repeat tremolo 96 sn64\!\ff\> |
    \repeat tremolo 96 sn\!\f\> |
    \repeat tremolo 96 sn\!\mf\> |
    sn4\!\p s s1 | s1.*2 |
    }
  }
    \new DrumVoice = "other" {
      \drummode {
    \grace { s16 } s1.*12 |
    s1*5/4*4 | s1. |
    s1*5/4*6 | s1.*17 |
    s2.*3 | s1*11 |
    s2.*27 |
    s1*6 | s2.*15 |
    \grace { s16 } s1*5/4 | s1 bd4\p |
    s1*5/4 | s1 bd4 |
    s1*5/4 | s1 bd4 |
    s1*5/4 | s1 bd4 |
    s1*5/4 | s1 bd4 |
    s1*5/4 | s1 bd4 |
    s1*5/4 | s1 \repeat tremolo 8 bd32\< |
    bd1*5/4\!\f | s1 bd4\mf |
    s1*5/4 | s1 bd4\mp |
    bd1\mf s4 | bd1 \repeat tremolo 8 bd32\p\< |
    bd4\!\f s1 | bd4 s1 |
    bd4 s1 | bd4 s1 |
    bd4 s1 | bd4 s1 |
    bd8.-> bd16-> bd8-> bd-> r4 r2 |
    bd8.-> bd16-> bd8-> bd-> r4 r2 |
    bd4 r bd r bd |
    s1*5/4*2 | bd8 s s1 |
    s1*5/4*8 |
    s1*7/4*2 | s1.*3 | bd1. |
    s1.*8 | s1*5/4*4 | s1. |
    s1.*18 |
    s2 bd4\ff s2. |
    s1.*8 | s1*5/4*14 | 
    s1*7 | s1. | s1*4 | s1. | s1*3 | s1. | s1*10 |
    s1. | s1*4 | s1. | s1*9 |
    s1*13 | s2.*15 |
    s1*27 |
    s1.*28 |
    s2. \repeat tremolo 24 cymca32\p\< |
    cymca4\!\f s s1 | s1.*7 |
    s1*5/4*14 | s1.*12 |
    s1*5/4*2 |
    sn2. sn8 sn sn16 sn sn8 |
    sn2. sn8 sn sn16 sn sn8 |
    sn2. sn8 sn sn16 sn sn8 |
    sn2. sn8 sn sn16 sn sn8 |
    s1*5/4*4 |
    \repeat tremolo 96 bd64\ff\> |
    \repeat tremolo 96 bd\!\f\> |
    \repeat tremolo 96 bd |
    \repeat tremolo 96 bd |
    bd4\!\p s2 bd4.\f bd |
    bd16 bd4.. s1 |
    }
  }
  >>

  violinI = \relative c'' {
    \clef treble \key g \minor \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace cis16( d8-.->)\f d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d-.-> d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d-.-> r r4 r \pizz d,->^\piz r r |
    d-> r r r2 r4 |
  % a, rehearsal 1, 5-12
    << { <g bes,>8\mp^\div r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> r |
      <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> r |
      <g bes,> r <g bes,> <g c,>-> <g c,> r <g bes,> r <g bes,> <g c,>-> <g c,> r |
      <g bes,>\< r <g c,> <g c,> <g c,> r <f a,>->\!\mf r <f a,>-> } \\
      { d s d s d s d s d s d s |
      d s d s d s d s d s d s |
      d s d ees-> ees s d s d ees-> ees s |
      d s ees ees ees s d-> s d-> } >>
    \arco r \times 4/7 { d'16(\<^\arc^\unis ees f g a bes c) } |
    d4->\!\f bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> r |
  % rehearsal 2, 13-17
    \time 5/4
    \pizz R1*5/4 | R1*5/4 |
    <bes d,>4.->\mp^\piz q-> q4 q |
    <g d>4.-> q-> q4 q |
    \time 6/4
    \arco r2 r4 g,,8->\mf\>^\cl g g g g g\!\p |
  % rehearsal 3, 18-28
    \time 5/4 R1*5/4*6 |
    \time 6/4
    a''8-.->\p^\arc b-. cis-. cis-. cis-. cis-. r2 r4 |
    cis8-.-> e-. fis-. fis-. fis-. fis-. r2 r4 |
    f,8-.->\mp\< g-. a-. a-. a-. a-. f-.-> g-. a-. a-. a-. a-. |
    a-.->\mf c-. d-. d-. d-. d-. a-.-> c-. d-. d-. d-. d-. |
    a-.-> c-. d-.\< d-. d-. d-. d-. d-. d-. d-. d-. d-. |
  % rehearsal 4, 29-40
    \stemBoth d4->\!\f { <g, bes,>8 s } bes-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> d,-. |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes-.->\mf\< g-. c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. c-. g-.\!\f |
    r4 c16->( bes g8-.) r4 c,,16->( bes g8-.) r4 r |
    R1. |
    d'''8-.\mf\< d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d16->(\!\ff bes'4..-> ~ bes4)\fermata c16-> bes-> g8-.-> r4 r \bar "||"
  % b, rehearsal 5, 41-54
    \key c \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4
    g,,2.\p ~ | g ~ | g | f | g4.\< bes8( f\!\mp\> bes) |
    g2.\!\p ~ | g ~ | g ~ | g | f | g ~ | g |
  % rehearsal 7, 67-81
    R2.*6 |
    g8(\mf\< c) c2 |
    c8( f) f4( ees8 f) |
    bes4..( c32 bes g4) |
    g8(\!\f c) c2 |
    f8( ees c4.) c8( |
    g'-> f16 ees c2) |
    bes8(\> c g2) |
    bes8( ~ \times 2/3 { bes16 c bes } g2 ~ |
    g4)\!\p\fermata r r |
  % rehearsal 8, 82-102
    \time 4/4
    \vnsolo f2\mf^\adlib^"Dolce, quasi cadenza"^"solo" \times 4/5 { ees16( f c ees bes } \times 4/5 { c) f,( bes c ees } |
    f2) \times 2/3 { ees8(\p g f) } \times 4/5 { ees16( f c ees bes } |
    \times 4/5 { c) f,( bes c  ees } f2) r8 ees\mf |
    ees16( c) c( bes) bes( f) f8(\> c8.) bes'16( g4 ~ |
    g)\!\p r8 f4(\pp c) bes'8( |
    g2) r8 f(\p c8.) bes'16( |
    \time 3/4
    g4) r8 f c8. bes'16 |
    g4 r8 f\cresc c8. f16 |
    \times 2/3 { g8 f g } \times 2/3 { c g c } \times 2/3 { f c f } |
    g4 r8 f c8. bes'16 |
    g4 r8 f c8. f16 |
    \times 2/3 { g8 f g } \times 2/3 { c g c } \times 2/3 { f c f } |
    g4\!\f r8 f c8. bes'16 |
    g4 r8 f c8. bes'16 |
    \times 2/3 { g8\< f c } \times 2/3 { bes' g f } \times 2/3 { c bes' g } |
    \times 2/3 { f-> c-> bes'-> } g4->\! r |
    f4->\ff c'2-> ~ |
    c4 bes2-> ~ |
    bes8-. c16-> bes-> g2-> ~ |
    g2. ~ | g4-. \pizz r r\fermata \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } g,,8.\pp^\piz^"Tutti" g16 g8 g4 g g8 bes4-> |
    g8 g16 g g8 g4 g g8 bes4-> |
    g8. g16 g8 g4 g g8 bes4-> |
    g8 g16 g g8 g4 g g8 bes4-> |
    g8. g16 g8 g4 g g8 bes4-> |
    g8 g16 g g8 g4 g g8 bes4-> |
    g8. g16 g8 g4 g g8 bes4-> |
    g8 g16 g g8 g4 g g8 bes4-> |
    g8. g16 g8 g4 g g8 bes4-> |
    g8 g16 g g8 g4 g g8 bes4-> |
    g8. g16 g8 g4 g g8 bes4-> |
    g8 g16 g g8 g4 g g8 bes4-> |
    ges8. ges16 ges8 ges4 ges ges8 bes4-> |
    ges4 \arco \tag #'score { ees'\mp\<\startTrillSpan^\arc ~ ees2\stopTrillSpan } \tag #'midi { \repeat tremolo 12 { ees32\mp\< f } } ees32(\mf\< f ges aes bes ces c d) |
  % rehearsal 10, 117-122
    ees2.->\!\f ~ ees8 bes16( ees) ges8(-> aes16 ges) |
    ees2.-> ~ ees8 des bes16( des aes des |
    bes8-.) r16 bes-. bes8-. bes4-> ees,8( ges ees) des'->( ees16 des |
    bes8-.) bes16-. bes-. bes8-. bes4-> bes,8( ees bes') aes16( bes ges aes |
    bes8-.->) r16 ees,-. ees2\> ~ ees4 bes16(\!\mf\< ees ges aes) |
    bes8-.->\!\f r16 ees,-. ees2\> ~ ees4 bes32(\!\mf\< des ees f aes bes des ees |
  % rehearsal 11, 123-134
    f8-.->)\!\f r r4 r8 f,4 bes8-. <c f,>-. <ees aes,>-. |
    <f bes,>-.-> r r4 r8 f,-. bes-. <c  f,>-. <ees aes,>-. <f bes,>-. |
    <bes ees,>-.-> r r4 r8 f,4 <c' f,>8-. <ees aes,>-. <f bes,>-. |
    <bes ees,>-.-> r r4 r8 c,,-. ees-. <f bes,>-. <bes ees,>-. <c f,>-. |
    <ees aes, ces,>-.-> r16 ees-. ees8-. ees4 ees bes8-. ees-. f-. |
    <ees aes, ces,>-.-> ees16-. ees-. ees8-. ees4 ees aes,8-. bes-. ees-. |
    f8.-> f16-> f8-> f-> r8 c-> ~ \times 2/3 { c8 bes-> c-> } \times 2/3 { f,-> bes-> c-> } |
    f8.-> f16-> f8-> f-> r8 c-> ~ \times 2/3 { c8 bes-> bes-> } c16-> f,-> bes-> c-> |
    f16-.-> c-> c-> bes-> \times 4/5 { c-> f, bes c ees } f-.-> c-> c-> bes-> \times 4/5 { c-> f, bes c ees } f-.-> c-> c-> bes-> |
    \times 4/5 { c-> f, bes c ees } f8-.-> r c4--->\ff bes---> c---> |
    f,---> bes---> c---> <f c>2---> |
    <g d>8-.-> \tag #'score { <g g,>8:32\p^\div <g g,>2:32 <g g,>: \bar "||" }
      \tag #'midi { \trem <g g,>8\pp ~ <g g,>1 ~ | }
  % c, rehearsal 12, 135-142
    \key g \minor
    \tag #'score { <g g,>2.:32 <g g,>2: |
      <g g,>2.: <g g,>2: |
      <g g,>2.: <g g,>2: |
      <g g,>2.: <g g,>2: |
      <g g,>2.: <g g,>2: |
      <g g,>2.: <g g,>2: |
      <a a,>2.: <a a,>2: |
      <a a,>2.: <a a,>2: | }
    \tag #'midi { <g g,>1*5/4 ~ |
      q ~ | q ~ | q ~ | q ~ | q |
      <a a,> ~ | q ~ | }
  % rehearsal 13, 143-148
    \time 7/4
    \tutti <a a,>8-. r r4 \pizz r2 r4 a,8\mf^\piz^\unis c d4-> |
    r2 r r4 a8 c d4-> |
    \time 6/4
    r r8 a c d r4 r8 a c d |
    \arco R1. |
    a8-.\f\cresc c-. <d fis,>-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-.->\!\ff r r4 r \pizz d,,^\snappizzicato\sf^"Secco" r r \bar "||"
  % rehearsal 14, 149-161
    << { <g bes,>8\mp^\piz^\div r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> r |
      <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> r |
      <g bes,> r <g bes,> <g c,>-> <g c,> r <g bes,> r <g bes,> <g c,>-> <g c,> r |
      <g bes,>\< r <g c,> <g c,> <g c,> r <f a,>->\!\mf r <f a,>-> } \\
      { d s d s d s d s d s d s |
      d s d s d s d s d s d s |
      d s d ees-> ees s d s d ees-> ees s |
      d s ees ees ees s d-> s d-> } >>
    \arco r \times 4/7 { d'16(\<^\arc^\unis ees f g a bes c) } |
    d4->\!\f bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> r |
    \time 5/4
    \pizz R1*5/4 | R1*5/4 |
    <bes d,>4.->\mp^\piz q-> q4 q |
    <g d>4.-> q-> q4 q |
    \time 6/4
    \arco r2 c,,16(\mf^\unis^\arc bes g8-.) \tag #'score { g4->(\>\trill g8-.)\p r } \tag #'midi { \repeat tremolo 4 { g32->(\> a } g8-.)\!\p r } r4 |
  % rehearsal 15, 162-176
    R1.*7 |
    r2 r4 r2 g'32(\mp\< a b c d e f fis) |
    g2(\!\mf^\dolce e4 g2 c,4) |
    c2( d8 e) e2. |
    g2( ees8 f g2 c,4) |
    ees2( f8 bes g2.) |
    ges2( aes8 des bes2.) |
    aes2(\< bes8 ees c2.) |
    c4.( f,8 aes bes) c4.( g8 bes c) |
  % rehearsal 16, 177-180
    \tag #'score { <d g,>1.:32\!\f | q: | }
      \tag #'midi { \trem <d g,>1.\!\f ~ | q | }
    \tutti r8 a16 c d8-.-> r r4 r8 a,16 c d8-.-> r r4 |
    r4 \pizz r d,^\snappizzicato\sf \arco r r \times 4/7 { d'16(\f^\arc ees f g a bes c) } |
  % rehearsal 17, 181-188
    d4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> d,-. |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes-.->\mf\< g-. c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. bes-. c-. |
  % rehearsal 18, 189-202
    \time 5/4
    \tag #'score { <d g,>2.:32\!\f q2: |
      q2.: q2: | q2.: q2: | q2.: q2: | }
    \tag #'midi { \trem <d g,>2.\!\f ~ q2 ~ |
      q2. ~ q2 ~ | q2. ~ q2 ~ | q2. ~ \tutti q2 | }
    <f a,>8-.->\mf\< c-. c-. <f a,>-.-> d-. <f a,>-.-> c-. c-. <f a,>-.-> d-. |
    <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> \tag #'score { d-.->\!\ff ~ } \tag #'midi { d\!\ff } |
    \tag #'score { \dimpap d2.:32\> d2: |
      d2.: d2: | d2.: d2: | d2.: d2: |
      d2.: d2: | d2.: d2: |
      d2.: d2: | d2:\!\p \offDim r4 r2 \bar "||" }
    \tag #'midi { \trem d2.\> ~ d2 ~ |
      d2. ~ d2 ~ | d2. ~ d2 ~ |
      d2. ~ d2 ~ | d2. ~ d2 ~ |
      d2. ~ d2 ~ | d2. ~ d2 ~ | d2\!\p \tutti r4 r2 \bar "||" }
  % d, rehearsal 19, 203-207
    \key g \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    g,,8\mp g4 g g g8 |
    g g4 g g g8 |
    g g4 g g g8 |
    fis fis4 fis d8\mf d d |
    d'( c16 bes g4) r8 d( \times 2/3 { f g bes) } |
    f'16->( d c bes g4) r8 d16( f g bes c d) |
    g8.->(\< f16) \times 2/3 { f8( d) d } g8.->( f16) \times 2/3 { f8( d) d } |
  % rehearsal 22, 229-244
    a'8-> \times 2/3 { r16 g( f } d4) r8 d(\!\f e8. b'16 |
    \time 6/4 g2) r8 d( e b' g4) d'8.( e32 d |
    \time 4/4 b2) r8 b( a g |
    a2) r8 e( g b |
    a4.\> g8 e4) a,8.( b16 |
    d16\!\mf e d4.)\< r8 d8( e8.\!\f b'16 |
    \time 6/4 g2) r8 d( e b' g4) d'8.( e32 d |
    \time 4/4 b2) r8 d( e g) |
    a4.( g8 \times 2/3 { e4) b8( } \times 2/3 { d e g) } |
    a4.( g8 e\> g,16( a b d e g) |
    b1->\!\mp ~ |
    b8 a(\> g e) \times 2/3 { e4( b8 ~ } \times 2/3 { b a g } |
    e4.)\!\p r8 r2 |
    \trem R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    \tag #'score { <gis, cis,>1:32->\f | q: | q: | q: | q: | }
    \tag #'midi { <gis cis,>1->\f ~ | q ~ | q ~ | q ~ | \tutti q | }
  % rehearsal 24, 250-254
    R1 | R1 |
    r2 r4 \times 4/6 { e'16\mf\< fis gis b cis e\! } |
    << { gis4->\f ~ gis16 } \\ { <cis, e,>8 s s16 } >> fis-. fis-. e-. e-. cis-. cis-. gis-. gis-. fis-. fis-. e-. |
    gis-.\> fis-. fis-. e-. e-. cis-. cis-. gis-. gis8-.\!\mf r r4 |
  % rehearsal 25, 255-261
    \key d \minor
    R1 | R1 |
    r2 r4 \times 4/6 { f'16\mf\< g a c d f\! } |
    \time 3/4
    << { a4->\f ~ a16 } \\ { <d, f,>8 s s16 } >> g-. g-. f-. f-. d-. d-. a-. |
    a-.\> g-. g-. f-. f-. d-. d-. a-. a4-.\!\mp |
    << { a''4->\f ~ a16 } \\ { <d, f,>8 s s16 } >> g-. g-. f-. f-. d-. d-. a-. |
    a-.\> g-. g-. f-. f-. d-. d-. a-. a4-.\!\mp |
  % rehearsal 26, 262-266
    R2. | R2. |
    <g'' gis,>16(\mf\cresc f) f( d) <g gis,>( f) f( d) <g gis,>( f) f( d) |
    <g gis,>( f) f( d) <g gis,>( f) f( d) <g gis,>( f) f( d) |
    <f gis,>8-.->\!\ff <d gis,>-.-> r4 r |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    r4 a32->(\ff a'8.. ~ a8-.) g-.-> \times 2/3 { f-.-> d-.-> a-.-> } |
    f'16->( d8. ~ d4 ~ d8-.) c-.-> g-.-> c-.-> |
    \times 4/5 { a16-> g f d a } \times 4/5 { g'-> f d a g } \times 4/5 { f'-> d a g f } \times 4/5 { d'-> a g f d } |
    c'8-.-> r d32->( c a8. ~ a2)\> |
    c8-.->\!\f r d32->( c a8. ~ a2)\> |
    c8-.->\!\mf r \times 2/3 { d16( c a ~ } a8 ~ a2)\!\mp |
    R1 | \trem R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    \key g \major
    \tag #'score { d'1:32\pp^\collaparte | d:\fermata | d: | d:\fermata | d: | d:\fermata | }
    \tag #'midi { d1\pp ~ | d ~ | d ~ | d ~ | d ~ | \tutti d | }
  % rehearsal 30, 287-299
    r2 \times 2/3 { b4->\ff d-> e-> } |
    b'2.-> \times 2/3 { a8( b g } |
    a2)\dim r8 b( a8. e16 |
    g2) r8 a( g8. b,16 |
    d2) r8 e( d8. g,16) |
    g1 ~ | g4\!\mp\fermata r r2 |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor \time 6/4
    g,4->\f^\cl r r r2 r4 |
    R1.*13 |
    d'4->\mf^\arc bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes-.-> g-. c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. bes-. c-. |
  % rehearsal 32, 318-322
    d4-.-> r r r2 r4 |
    R1. | R1. |
    aes'4-> r8 f-. aes-. ees-. f( ees16 f c8-.) ees4-> bes8-. |
    c4-> r8 ees-. bes-. c-. ees16->( f g8-.) g-. g-. g-. g-. |
  % rehearsal 33, 323-328
    f8->( g16 f d8-.) f4-> g8-. a16->( g f8-.) f-. f-. f-. f-. |
    f->( g16 f d8-.) f4-> g8-. a16->( g f8-.) f-. f-. f-. f-. |
    g16( f d8-.) r4 r r2 r4 |
    r2 r4 a'16->(\cresc c d8-.) d-. d-. d-. d-. |
    a16->( c d8-.) <d g,>-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q4-.->\!\sf r r r \times 4/7 { d,16(\f ees f g a bes c) } \times 4/7 { d,( ees f g a bes c) } |
  % rehearsal 34, 329-336
    d4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> \pizz r |
    << { <g,, bes,>8\mp^\piz^\div r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> r |
      <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> r |
      <g bes,> r <g bes,> <g c,>-> <g c,> r <g bes,> r <g bes,> <g c,>-> <g c,> r |
      <g bes,>\< r <g c,> <g c,> <g c,> r <f a,>->\!\mf r <f a,>4-> } \\
      { d8 s d s d s d s d s d s |
      d s d s d s d s d s d s |
      d s d ees-> ees s d s d ees-> ees s |
      d s ees ees ees s d-> s d4-> } >> \arco r |
  % rehearsal 35, 337-344
    \time 5/4
    f''->(\f^\arc^\unis d8-.) f4-> bes,8-. c-. d-. d4-. |
    \pizz d,4.\mf^\piz d c4 bes |
    \arco f''8->(\f^\arc g16 f d8-.) f4-> bes,8-. c-. d-. d4-. |
    \pizz bes,4.\mf^\piz bes g4 g |
    \arco r2 r4 <bes' d,>8->\f g <g d>4-.-> |
    r2 r4 <c d,>16->( bes g8-.) <g d>4-.-> |
    r4 <c d,>16->( bes g8-.) r4 <c d,>16->( bes g8-.) \pizz r4 |
    g,4->^\snappizzicato \arco r g,8->\mf\>^\cl g g g g g\!\p |
  % rehearsal 36, 345-355
    R1*5/4*6 |
    \time 6/4
    a''8-.->\p^\arc b-. cis-. cis-. cis-. cis-. r2 r4 |
    cis8-.-> e-. fis-. fis-. fis-. fis-. r2 r4 |
    f,8-.->\mp\< g-. a-. a-. a-. a-. f-.-> g-. a-. a-. a-. a-. |
    a-.->\mf c-. d-. d-. d-. d-. a-.-> c-. d-. d-. d-. d-. |
    a-.-> c-. d-.\< d-. d-. d-. d-. d-. d-. d-. d-. d-. |
  % rehearsal 37, 356-362
    \stemBoth d4->\!\f { <g, bes,>8 s } bes-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> d,-. |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
  % rehearsal 38, 363-372
    \time 5/4
    bes-.->\mp\cresc g-. c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. |
    c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. bes-. c-. |
    d8-.->\!\f c16( d g,8-.) bes4-> g8-. bes-. c-. d4-.-> |
    d8-.-> c16( d g,8-.) bes4-> g8-. f'-. d-. d4-.-> |
    d8-.-> c16( d g,8-.) bes4-> g8-. bes16( g bes c) d4-.-> |
    d8-.-> c16( d g,8-.) bes4-> g8-. g'16->( f d8-.) d4-.-> |
    f8-.->\mf c-. c-. f-.-> d-. f-.-> c-. c-. f-.-> d-. |
    f-.-> c-. c-. f-.-> d-. f-.-> c-. c-. f-.-> d-. |
    <f a,>-.->\cresc d-. <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> d-. |
    <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> d-. \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    \tag #'score { <g des,>2.:32->\!\fff q:\> |
      q1.:\ff |
      <g, des>:\f |
      <g, des>:\mp\> |
      q1.:\!\p\< |
      q1:\!\f\> q2:\!\pp \bar "||" }
    \tag #'midi { \trem <g'' des,>2.\!\fff ~ q\> ~ |
      q1.\ff |
      <g, des>\f |
      <g, des>\mp\> ~ |
      q1.\!\p\< ~ |
      q1\!\f\> ~ q2\!\pp | }
  }

  violinII = \relative c'' {
    \clef treble \key g \minor \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1. |
    \grace gis16( a8-.)\f a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. a-. |
    a-. r r4 r \pizz a,^\piz r r |
    a r r r2 r4 |
  % a, rehearsal 1, 5-12
    << { r8 <g' bes,>\mp^\div r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> |
      r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> |
      r <g bes,> r <g c,>-> r <g c,> r <g bes,> r <g c,>-> r <g c,> |
      r <g bes,>\< r <g c,> r <g c,> <f a,>->\!\mf <f a,> <f a,>-> } \\
      { s8 d s d s d s d s d s d |
      s d s d s d s d s d s d |
      s d s ees-> s ees s d s ees-> s ees |
      s d s ees s ees d-> d d-> } >>
    \arco r \times 4/7 { d16(\<^\arc^\unis ees f g a bes c) } |
    d4->\!\f bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> r |
  % rehearsal 2, 13-17
    \time 5/4
    << { <g, d>8\p^\div q-. q-. q-. q-. q-. q-. q-. q-. q-. |
      q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
      q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
      q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. } \\
      { <f bes,>-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
      q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
      q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
      q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. } >> |
    \time 6/4
    r2 c16(\mf^\unis bes g8-.) r8 g\>^\cl g g g g\!\p |
  % rehearsal 3, 18-28
    \time 5/4 \arco R1*5/4*6 |
    a'8-.->\p^\arc b-. cis-. cis-. cis-. cis-. r2 r4 |
    cis8-.-> e-. fis-. fis-. fis-. fis-. r2 r4 |
    f,8-.->\mp\< g-. a-. a-. a-. a-. f-.-> g-. a-. a-. a-. a-. |
    a-.->\mf c-. d-. d-. d-. d-. a-.-> c-. d-. d-. d-. d-. |
    a-.-> c-. d-.\< d-. d-. d-. d-. d-. d-. d-. d-. d-. |
  % rehearsal 4, 29-40
    \stemBoth d4->\!\f { <d, g,>8 s } bes'-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> d,-. |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes-.->\mf\< g-. c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. c-. g-.\!\f |
    r4 c16->( bes g8-.) r4 c,16->( bes g8-.) r4 r |
    r2 r4 d''8-.\mp\cresc d-. d-. d-. d-. d-. |
    d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    <d bes>16->(\!\ff bes'4..-> ~ bes4)\fermata c16-> bes-> g8-.-> r4 r \bar "||"
  % b, rehearsal 5, 41-54
    \key c \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4
    ees,2.\p ~ | ees ~ | ees | c | d4.\< f8( des\!\mp\> f) |
    ees2.\!\p ~ | ees ~ | ees ~ | ees | c | d | ees |
  % rehearsal 7, 67-81
    R2.*6 |
    <g g,>8(\mf\<^\div <c c,>) <c c,>2 |
    <c c,>8( <f f,>) <f f,>4( <ees ees,>8 <f f,>) |
    <bes bes,>4..( <c c,>32 <bes bes,> <g g,>4) |
    <g g,>8(\!\f <c c,>) <c c,>2 |
    <f f,>8( <ees ees,> <c c,>4.) <c c,>8( |
    <g' g,>-> <f f,>16 <ees ees,> <c c,>2) |
    <bes bes,>8(\> <c c,> <g g,>2) |
    <bes bes,>8( ~ \times 2/3 { <bes bes,>16 <c c,> <bes bes,> } <g g,>2 ~ |
    <g g,>4)\!\p\fermata r r |
  % rehearsal 8, 82-102
    \time 4/4
    \pizz r4^\collaparte <f, c>\mp^\piz^\unis r2 |
    r4 <f c> r2 |
    r2 <f aes,>4\p r |
    R1 |
    <g c,>2 r |
    r4 <g c,>\pp r2 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } ees8.\pp ees16 ees8 ees4 ees ees8 f4-> |
    ees8 ees16 ees ees8 ees4 ees ees8 f4-> |
    ees8. ees16 ees8 ees4 ees ees8 f4-> |
    ees8 ees16 ees ees8 ees4 ees ees8 f4-> |
    ees8. ees16 ees8 ees4 ees ees8 f4-> |
    ees8 ees16 ees ees8 ees4 ees ees8 f4-> |
    ees8. ees16 ees8 ees4 ees ees8 f4-> |
    ees8 ees16 ees ees8 ees4 ees ees8 f4-> |
    ees8. ees16 ees8 ees4 ees ees8 f4-> |
    ees8 ees16 ees ees8 ees4 ees ees8 f4-> |
    ees8. ees16 ees8 ees4 ees ees8 f4-> |
    ees8 ees16 ees ees8 ees4 ees ees8 f4-> |
    ees8. ees16 ees8 ees4 ees ees8 ges4-> |
    ees4 \arco r r ees32(\mp\<^\arc f ges aes bes ces c d) <ees ees,>(^\div <f f,> <ges ges,> <aes aes,> <bes bes,> <ces ces,> <c c,> <d d,>) |
  % rehearsal 10, 117-122
    <ees ees,>2.->\!\f ~ <ees ees,>8 <bes bes,>16( <ees ees,>) <ges ges,>8->( <aes aes,>16 <ges ges,>) |
    <ees ees,>2.-> ~ <ees ees,>8 <des des,> <bes bes,>16( <des des,> <aes aes,> <des des,> |
    <bes bes,>8-.) r16 q-. q8-. q4-> <ees, ees,>8( <ges ges,> <ees ees,>) <des' des,>->( <ees ees,>16 <des des,> |
    <bes bes,>8-.) q16-. q-. q8-. q4-> <bes, bes,>8( <ees ees,> <bes' bes,>) <aes aes,>16( <bes bes,> <ges ges,> <aes aes,> |
    <bes bes,>8-.) r16 <ees, ees,>-. q2\> ~ q4 <bes bes,>16(\!\mf\< <ees ees,> <ges ges,> <aes aes,>) |
    <bes bes,>8-.\!\f r16 <ees, ees,>-. q2\> ~ q4 <bes bes,>32(\!\mf\< <des des,> <ees ees,> <f f,> <aes aes,> <bes bes,> <des des,> <ees ees,> |
  % rehearsal 11, 123-134
    <f f,>8-.->)\!\f r r4 r8 f,,4^\unis bes8-. <g' c,>-. <bes ees,>-. |
    <c f,>-.-> r r4 r8 f,,-. bes-. <g' c,>-. <bes ees,>-. <c f,>-. |
    <f bes,>-.-> r r4 r8 f,,4 <g' c,>8-. <bes ees,>-. <c f,>-. |
    <f bes,>-.-> r r4 r8 c,,-. ees-. <c' f,>-. <f bes,>-. <g c,>-. |
    <aes ces, ees,>-.-> r16 aes-. aes8-. aes4 aes ees8-. aes-. aes-. |
    <aes ces, ees,>-.-> aes16-. aes-. aes8-. aes4 aes ees8-. ees-. aes-. |
    <f' f,>8.->^\div q16-> q8-> q-> r8 <c c,>-> ~ \times 2/3 { <c c,>8 <bes bes,>-> <c c,>-> } \times 2/3 { <f, f,>-> <bes bes,>-> <c c,>-> } |
    <f f,>8.-> q16-> q8-> q-> r8 <c c,>-> ~ \times 2/3 { <c c,>8 <bes bes,>-> <bes bes,>-> } <c c,>16-> <f, f,>-> <bes bes,>-> <c c,>-> |
    <f f,>16-.-> <c c,>-> q-> <bes bes,>-> \times 4/5 { <c c,>-> <f, f,> <bes bes,> <c c,> <ees ees,> } <f f,>-.-> <c c,>-> q-> <bes bes,>-> \times 4/5 { <c c,>-> <f, f,> <bes bes,> <c c,> <ees ees,> } <f f,>-.-> <c c,>-> q-> <bes bes,>-> |
    \times 4/5 { <c c,>-> <f, f,> <bes bes,> <c c,> <ees ees,> } <f f,>8-.-> r <c c,>4--->\ff <bes bes,>---> <c c,>---> |
    <f, f,>---> <bes bes,>---> <c c,>---> <f f,>2---> |
    <g g,>8-.-> r r4 r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \key g \minor
    \pizz R1*5/4 | R1*5/4 |
    r2 r4 a,,8\p^\piz^\unis c e g |
    bes4 r r r2 | R1*5/4 |
    r2 r4 bes,8 c ees f |
    fis4 r r8 fis,\mp a b cis4 |
    r2 r8 a c d e4 |
  % rehearsal 13, 143-148
    \time 7/4
    r2 r r4 a,8\mf c d4-> |
    r2 r r4 a8 c d4-> |
    \time 6/4
    r r8 a c d r4 r8 a c d |
    \arco r2 r4 a8-.\cresc^\arc c-. d-. a-. c-. d-. |
    a-. c-. <c' d,>-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-.->\!\ff r r4 r \pizz d,,^\snappizzicato\sf^"Secco" r r \bar "||"
  % rehearsal 14, 149-161
    << { r8 <g bes,>\mp^\piz^\div r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> |
      r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> |
      r <g bes,> r <g c,>-> r <g c,> r <g bes,> r <g c,>-> r <g c,> |
      r <g bes,>\< r <g c,> r <g c,> <f a,>->\!\mf <f a,> <f a,>-> } \\
      { s8 d s d s d s d s d s d |
      s d s d s d s d s d s d |
      s d s ees-> s ees s d s ees-> s ees |
      s d s ees s ees d-> d d-> } >>
    \arco r \times 4/7 { d16(\<^\arc^\unis ees f g a bes c) } |
    d4->\!\f bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> r |
    \time 5/4
    << { <g, d>8\p^\div q-. q-. q-. q-. q-. q-. q-. q-. q-. |
      q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
      q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
      q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. } \\
      { <f bes,>-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
      q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
      q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
      q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. } >> |
    \time 6/4
    r2 c16(\mf^\unis bes g8-.) \tag #'score { g2->(\>\trill g8-.)\p r } \tag #'midi { \repeat tremolo 8 { g32->(\> a } g8-.)\!\p r } |
  % rehearsal 15, 162-176
    R1.*7 |
    r2 r4 r2 g32(\mp\< a b c d e f fis) |
    g2(\!\mf^\dolce e4 g2 c,4) |
    c2( d8 e) e2. |
    g2( ees8 f g2 c,4) |
    ees2( f8 bes g2.) |
    ges2( aes8 des bes2.) |
    aes2(\< bes8 ees c2.) |
    c4.( f,8 aes bes) c4.( g8 bes c) |
  % rehearsal 16, 177-180
    \tag #'score { <a' d,>1.:32\!\f | q: | }
      \tag #'midi { \trem <a d,>1.\!\f ~ | q | }
    \tutti r8 a,16 c d8-.-> r r4 r8 <a a,>16^\div <c c,> <d d,>8-.-> r r4 |
    r4 \pizz r d,^\snappizzicato\sf^\unis \arco r r \times 4/7 { d16(\f^\arc ees f g a bes c) } |
  % rehearsal 17, 181-188
    d4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> d,-. |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes-.->\mf\< g-. c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. bes-. c-. |
  % rehearsal 18, 189-202
    \time 5/4
    \tag #'score { <bes' d,>2.:32\!\f q2: |
      q2.: q2: | q2.: q2: | q2.: q2: | }
    \tag #'midi { \trem <bes d,>2.\!\f ~ q2 ~ |
      q2. ~ q2 ~ | q2. ~ q2 ~ | q2. ~ \tutti q2 | }
    <f a,>8-.->\mf\< c-. c-. <f a,>-.-> d-. <f a,>-.-> c-. c-. <f a,>-.-> d-. |
    <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> \tag #'score { d-.->\!\ff ~ } \tag #'midi { d\!\ff } |
    \tag #'score { \dimpap d2.:32\> d2: |
      d2.: d2: | d2.: d2: | d2.: d2: |
      d2.: d2: | d2.: d2: |
      d2.: d2: | d2:\!\p \offDim r4 r2 \bar "||" }
    \tag #'midi { \trem d2.\> ~ d2 ~ |
      d2. ~ d2 ~ | d2. ~ d2 ~ |
      d2. ~ d2 ~ | d2. ~ d2 ~ |
      d2. ~ d2 ~ | d2. ~ d2 ~ | d2\!\p \tutti r4 r2 \bar "||" }
  % d, rehearsal 19, 203-207
    \key g \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 R1 | R1 |
  % rehearsal 21, 222-228
    e,8\mp e4 e e e8 |
    e e4 e e e8 |
    e e4 e e cis8 |
    d d4 d r8 r4 |
    R1*3 |
  % rehearsal 22, 229-244
    r2 r8 <d' d,>(\f^\div <e e,>8. <b' b,>16 |
    \time 6/4 <g g,>2) r8 <d d,>( <e e,> <b' b,> <g g,>4) <d' d,>8.( <e e,>32 <d d,> |
    \time 4/4 <b b,>2) r8 <b b,>( <a a,> <g g,> |
    <a a,>2) r8 <e e,>( <g g,> <b b,> |
    <a a,>4.\> <g g,>8 <e e,>4) <a, a,>8.( <b b,>16 |
    <d d,>16\!\mf <e e,> <d d,>4.)\< r8 <d d,>8( <e e,>8.\!\f <b' b,>16 |
    \time 6/4 <g g,>2) r8 <d d,>( <e e,> <b' b,> <g g,>4) <d' d,>8.( <e e,>32 <d d,> |
    \time 4/4 <b b,>2) r8 <d d,>( <e e,> <g g,>) |
    <a a,>4.( <g g,>8 \times 2/3 { <e e,>4) <b b,>8( } \times 2/3 { <d d,> <e e,> <g g,>) } |
    <a a,>4.( <g g,>8 <e e,>\> <g, g,>16( <a a,> <b b,> <d d,> <e e,> <g g,>) |
    <b b,>1->\!\mp ~ |
    <b b,>8 a,(\>^\unis g e) \times 2/3 { e4( b8 ~ } \times 2/3 { b a g } |
    e4.)\!\p r8 r2 |
    \trem R1 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    \tag #'score { <e gis,>1:32->\f | q: | q: | q: | q: | }
    \tag #'midi { <e gis,>1->\f ~ | q ~ | q ~ | q ~ | \tutti q | }
  % rehearsal 24, 250-254
    R1 | R1 |
    r4 \times 4/6 { gis16\mp\< b cis b cis e } \times 4/6 { gis, e fis gis b cis } \times 4/6 { e, fis gis b cis e\! } |
    << { gis4->\f ~ gis16 } \\ { <cis,  e,>8 s s16 } >> fis-. fis-. e-. e-. cis-. cis-. gis-. gis-. fis-. fis-. e-. |
    gis-.\> fis-. fis-. e-. e-. cis-. cis-. gis-. gis'-. fis-. fis-. e-. e-. cis-. cis-. gis-.\!\mp |
  % rehearsal 25, 255-261
    \key d \minor
    R1 | R1 |
    r4 \times 4/6 { a'16\mp\< c d c d f } \times 4/6 { a, f g a c d } \times 4/6 { f, g a c d f\! } |
    \time 3/4
    << { a4->\f ~ a16 } \\ { <d, f,>8 s s16 } >> g-. g-. f-. f-. d-. d-. a-. |
    a-.\> g-. g-. f-. f-. d-. d-. a-. a4-.\!\mp |
    << { a''4->\f ~ a16 } \\ { <d, f,>8 s s16 } >> g-. g-. f-. f-. d-. d-. a-. |
    a-.\> g-. g-. f-. f-. d-. d-. a-. a4-.\!\mp |
  % rehearsal 26, 262-266
    R2. |
    g''16(\mp\cresc f) f( d) g( f) f( d) g( f) f( d) |
    <g b,>( f) f( d) <g b,>( f) f( d) <g b,>( f) f( d) |
    <g b,>( f) f( d) <g b,>( f) f( d) <g b,>( f) f( d) |
    <f b,>8-.->\!\ff <d gis,>-.-> r4 r |
  % rehearsal 27, 267-272
    R2.*6 |
  % rehearsal 28, 273-280
    \time 4/4
    r4 <a' a,>32->(\ff^\div <a' a,>8.. ~ <a a,>8-.) <g g,>-.-> \times 2/3 { <f f,>-.-> <d d,>-.-> <a a,>-.-> } |
    <f' f,>16->( <d d,>8. ~ <d d,>4 ~ <d d,>8-.) <c c,>-.-> <g g,>-.-> <c c,>-.-> |
    \times 4/5 { <a a,>16-> <g g,> <f f> r r } \times 4/5 { <g g,>-> <f f,> <d d,> r r } \times 4/5 { <f f,>-> <d d,> <a a,> r r } \times 4/5 { <d d,>-> <a a,> <g g,> r r } |
    <c c,>8-.-> r <d d,>32->( <c c,> <a a,>8. ~ <a a,>2)\> |
    <c c,>8-.->\!\f r <d d,>32->( <c c,> <a a,>8. ~ <a a,>2)\> |
    <c c,>8-.->\!\mf r \times 2/3 { <d d,>16( <c c,> <a a,> ~ } q8 ~ <a a,>2)\!\mp |
    R1 | \trem R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    \key g \major
    \tag #'score { d1:32\pp^\unis^\collaparte | d:\fermata | d: | d:\fermata | d: | d:\fermata | }
    \tag #'midi { d1\pp ~ | d ~ | d ~ | d ~ | d ~ | \tutti d | }
  % rehearsal 30, 287-299
    r2 \times 2/3 { <b' b,>4->\ff^\div <d d,>-> <e e,>-> } |
    <b' b,>2.-> \times 2/3 { <a a,>8( <b b,> <g g,> } |
    <a a,>2)\dim r8 <b b,>( <a a,>8. <e e,>16 |
    <g g,>2) r8 <a a,>( <g g,>8. <b, b,>16 |
    <d d,>2) r8 <e e,>( <d d,>8. <g, g,>16) |
    <g g,>1 ~ | <g g,>4\!\mp\fermata r r2 |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor \time 6/4
    g,,4->\f^\cl^\unis r r r2 r4 |
    R1.*9 |
    g'4->\mf^\arc ees8-. g-. f-. ees-. f16( ees c8-.) c4-_ g-_ |
    g'-> ees8-. g-. f-. ees-. f16( ees c8-.) c4-_ g-_ |
    ees'8( c-.) ees-. f4-> c8-. ees( c-.) ees-. f4-> c8-. |
    ees-.-> c-. f-. c-. ees-.-> c-. f-. c-. ees-.-> c-. ees-. f-. |
    g16->( f d8-.) d4-_ r8 g,-. f'-. d4-> c8-. d-. f-. |
    g16->( f d8-.) d4-_ r8 g,-. f'-. d4-> c8-. d-. f-. |
    g4-> r8 f-. d-. c-. g4-> r8 f'-. d-. c-. |
    g4-. r8 g'-. f4-. r8 f-. e4-. ees-. |
  % rehearsal 32, 318-322
    f4-.-> r r f16->( g a8-.) a-. a-. a-. a-. |
    a4-.-> r r aes16->( bes c8-.) c-. c-. c-. c-. |
    ees16->( des bes8-.) bes-. bes-. bes-. bes-. bes-. aes4-> ees8-. f-. aes-. |
    c4 r r r2 r4 |
    c16->( bes g8-.) g-. g-. g-. g-. c( ees16 c bes8-.) c4-> a8-. |
  % rehearsal 33, 323-328
    a4-.-> r r a4.->( g8-.) a-. c-. |
    a4-.-> r r a4.->( g8-.) a-. c-. |
    a4-.-> r r r2 r4 |
    a16->(\cresc c d8-.) d-. d-. d-. d-. a16->( c d8-.) d-. d-. d-. d-. |
    a16->( c d8-.) <a' d,>-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q4-.->\!\sf r r \times 4/7 { d,,16(\f ees f g a bes c) } \times 4/7 { d,( ees f g a bes c) } \times 4/7 { d,( ees f g a bes c) } |
  % rehearsal 34, 329-336
    d4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> \pizz r |
    << { r8 <g, bes,>\mp^\piz^\div r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> |
      r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> r <g bes,> |
      r <g bes,> r <g c,>-> r <g c,> r <g bes,> r <g c,>-> r <g c,> |
      r <g bes,>\< r <g c,> r <g c,> <f a,>->\!\mf <f a,> <f a,>4-> } \\
      { s8 d s d s d s d s d s d |
      s d s d s d s d s d s d |
      s d s ees-> s ees s d s ees-> s ees |
      s d s ees s ees d-> d d4-> } >> \arco r |
  % rehearsal 35, 337-344
    \time 5/4
    f'->(\f^\arc^\unis d8-.) f4-> bes,8-. c-. d-. d4-. |
    \pizz bes4.\mf^\piz bes g4 g |
    \arco f'8->(\f^\arc g16 f d8-.) f4-> bes,8-. c-. d-. d4-. |
    \pizz g,4.\mf^\piz g d4 d |
    \arco r2 r4 bes'8->\f g g4-.-> |
    r2 r4 c16->( bes g8-.) g4-.-> |
    r4 c16->( bes g8-.) r4 c16->( bes g8-.) \pizz r4 |
    g4->^\snappizzicato r g,8->\mf\>^\cl g g g g g\!\p |
  % rehearsal 36, 345-355
    \arco R1*5/4*6 |
    a'8-.->\p^\arc b-. cis-. cis-. cis-. cis-. r2 r4 |
    cis8-.-> e-. fis-. fis-. fis-. fis-. r2 r4 |
    f,8-.->\mp\< g-. a-. a-. a-. a-. f-.-> g-. a-. a-. a-. a-. |
    a-.->\mf c-. d-. d-. d-. d-. a-.-> c-. d-. d-. d-. d-. |
    a-.-> c-. d-.\< d-. d-. d-. d-. d-. d-. d-. d-. d-. |
  % rehearsal 37, 356-362
    <d' d,>4->\!\f^\div <bes bes,>8-. <d d,>-. <c c,>-. <bes bes,>-. <c c,>16( <bes bes,> <g g,>8-.) <g g,>4-_ <d d,>-_ |
    <d' d,>4-> <bes bes,>8-. <d d,>-. <c c,>-. <bes bes,>-. <c c,>16( <bes bes,> <g g,>8-.) <g g,>4-_ <d d,>-_ |
    <bes' bes,>8( <g g,>-.) <bes bes,>-. <c c,>4-> <g g,>8-. <bes bes,>( <g g,>-.) <bes bes,>-. <c c,>4-> <g g,>8-. |
    <bes bes,>( <g g,>-.) <c c,>-. <bes bes,>-. <bes bes,>-. <g g,>-. <g' g,>16->( <f f,> <d d,>8-.) <d d,>4-.-> <d, d,>-. |
    <d' d,>4-> <bes bes,>8-. <d d,>-. <c c,>-. <bes bes,>-. <c c,>16( <bes bes,> <g g,>8-.) <g g,>4-_ <d d,>-_ |
    <d' d,>4-> <bes bes,>8-. <d d,>-. <c c,>-. <bes bes,>-. <c c,>16( <bes bes,> <g g,>8-.) <g g,>4-_ <d d,>-_ |
    <bes' bes,>8( <g g,>-.) <bes bes,>-. <c c,>4-> <g g,>8-. <bes bes,>( <g g,>-.) <bes bes,>-. <c c,>4-> <g g,>8-. |
  % rehearsal 38, 363-372
    \time 5/4
    r2 r4 r <bes bes,>8-.->\mp\cresc <g g,>-. |
    <c c,>-. <g g,>-. <bes bes,>-.-> <g g,>-. <c c,>-. <g g,>-. <bes bes,>-.-> <g g,>-. <bes bes,>-. <c c,>-. |
    <d d,>8-.->\!\f <c c,>16( <d d,> <g, g,>8-.) <bes bes,>4-> <g g,>8-. <bes bes,>-. <c c,>-. <d d,>4-.-> |
    <d d,>8-.-> <c c,>16( <d d,> <g, g,>8-.) <bes bes,>4-> <g g,>8-. <f' f,>-. <d d,>-. <d d,>4-.-> |
    <d d,>8-.-> <c c,>16( <d d,> <g, g,>8-.) <bes bes,>4-> <g g,>8-. <bes bes,>16( <g g,> <bes bes,> <c c,>) <d d,>4-.-> |
    <d d,>8-.-> <c c,>16( <d d,> <g, g,>8-.) <bes bes,>4-> <g g,>8-. <g' g,>16->( <f f,> <d d,>8-.) <d d,>4-.-> |
    R1*5/4 |
    <f f,>8-.->\mf <c c,>-. <c c,>-. <f f,>-.-> <d d,>-. <f f,>-.-> <c c,>-. <c c,>-. <f f,>-.-> <d d,>-. |
    <f f,>-.->\cresc <d d,>-. <f f,>-.-> <d d,>-. <f f,>-.-> <d d,>-. <f f,>-.-> <d d,>-. <f f,>-.-> <d d,>-. |
    <f f,>-.-> <d d,>-. <f f,>-.-> <d d,>-. <f f,>-.-> <d d,>-. <f f,>-.-> <d d,>-. <f f,>-.-> <d d,>-. \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    \tag #'score { <ees bes>2.:32->\!\fff q:\> |
      q1.:\ff |
      <ees, bes>:\f |
      <ees, bes>:\mp\> |
      q:\!\p\< |
      q1:\!\f\> q2:\!\pp \bar "||" }
    \tag #'midi { \trem <ees'' bes>2.\!\fff ~ q\> ~ |
      q1.\ff |
      <ees, bes>\f |
      <ees, bes>\mp\> ~ |
      q\!\p\< ~ |
      q1\!\f\> ~ q2\!\pp | }
  }

  viola = \relative c' {
    \clef alto \key g \minor \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1. | R1. |
    \grace cis16( d8-.)\f d-. d-. d-. d-. d-. <d a>-. <d a>-. <d a>-. <d a>-. <d a>-. <d a>-. |
    <d a>-. r r4 r \pizz d,^\piz r r |
  % a, rehearsal 1, 5-12
    <g' bes,>4\mp r r r2 r4 |
    <g bes,> r r r2 r4 |
    r r8 <g c,>-> r4 r r8 <g c,>-> r4 |
    r2 r4 <f a,>->\mf <f a,>-> r |
    <g bes,>2\f r4 <g bes,>2 r4 |
    <g bes,>2 r4 <g bes,>2 r4 |
    r r8 <g c,>4-> r8 r4 r8 <g c,>4-> r8 |
    r2 r4 <f a,>-> <f a,>-> \arco r |
  % rehearsal 2, 13-17
    \time 5/4
    <f bes,>4-.->\p^\arc r8 q4-.-> r8 q4-. q-. |
    <g bes,>-.-> r8 q4-> r8 q4-. q-. |
    \pizz <f bes,>4.->^\piz q-> q4 q |
    <g bes,>4.-> q-> q4 q |
    \time 6/4
    r2 r4 g,4^\snappizzicato\sf r \arco r |
  % rehearsal 3, 18-28
    \time 5/4
    << { <e' a,>8-.\p^\arc^\div q4 q q q8-. q-. q-. |
      q-. q4 q q q8-. q4-. |
      <g c,>8-.\mp q4 q q q8-. q-. q-. |
      q-. q4 q q q8-. q4-. |
      <fis cis>8-.\mf q4 q q q8-. q-. q-. |
      <a e>-. q4 q q q8-. q-. q-. } \\
      { <c, g>8-.\p^\div q4 q q q8-. q-. q-. |
      q-. q4 q q q8-. q4-. |
      <ees bes>8-.\mp q4 q q q8-. q-. q-. |
      q-. q4 q q q8-. q4-. |
      <e a,>8-.\mf q4 q q q8-. q-. q-. |
      <fis cis>-. q4 q q q8-. q-. q-. } >> |
    \time 6/4
    <a cis,>8-.->\p^\unis q-. q-. q-. q-. q-. q-.-> q-. q-. q-. q-. q-. |
    q-.-> q-. q-. q-. q-. q-. q-.-> q-. q-. q-. q-. q-. |
    <f a,>-.->\mp\< q-. q-. q-. q-. q-. <g a,>-.-> q-. q-. q-. q-. q-. |
    <fis c>-.->\!\mf q-. q-. q-. q-. q-. q-.-> q-. q-. q-. q-. q-. |
    <fis c>-.-> q-. q-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 4, 29-40
    <g bes,>-.->\!\f q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    <d g,>-. q-. q-. <ees g,>4-> q8-. <d g,>-. q-. q-. <ees g,>4-> q8-. |
    <d g,>-. q-. <ees g,>-. q-. q-. q-. <d f,>-.-> <f a,>-. q-.-> d-. d-. d-. |
    <g bes,>-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    <d g,>-. q-. q-. <ees g,>4-> q8-. <d g,>-. q-. q-. <ees g,>4-> q8-. |
    <d g,>-.->\mf\< <g bes,>-. q-. q-. <d g,>-.-> <g bes,>-. q-. q-. <d g,>-.-> <g bes,>-. q-. q-. |
    <g bes,>4-.->\!\f c,16->( bes g8-.) r4 c16->( bes g8-.) r4 r |
    r8 d'-.\p\cresc d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    <d bes>16->(\!\ff bes'4..-> ~ bes4)\fermata c16-> bes-> g8-.-> r4 r \bar "||"
  % b,  rehearsal 5, 41-54
    \key c \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4
    c,2.\p ~ | c ~ | c | aes | bes4.\< des8( bes\!\mp\> des) |
    c2.\!\p ~ | c ~ | c ~ | c | aes | bes | c |
  % rehearsal 7, 67-81
    <g ees>^\div | <c f,>\< | <bes d,~>2(\!\mp <g d>4) |
    <g ees>2.\< | <c f,> | <bes d,> |
    g8(\!\mf\<^\unis c) c2 |
    c8( f) f4( ees8 f) |
    bes4..( c32 bes g4) |
    \clef treble g8(\!\f c) c2 |
    f8( ees c4.) c8( |
    g'-> f16 ees c2) |
    bes8(\> c g2) |
    bes8( ~ \times 2/3 { bes16 c bes } g2 ~ |
    g4)\!\p\fermata r r |
  % rehearsal 8, 82-102
    \clef alto \time 4/4
    \pizz r4^\collaparte <ees aes,>\mp^\piz r2 |
    r4 <ees aes,> r2 |
    r2 <c f,>4\p r |
    R1 |
    <d g,>2 r |
    r4 <d g,>\pp r2 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } c8.\pp c16 c8 c4 c c8 des4-> |
    c8 c16 c c8 c4 c c8 des4-> |
    c8. c16 c8 c4 c c8 des4-> |
    c8 c16 c c8 c4 c c8 des4-> |
    c8. c16 c8 c4 c c8 des4-> |
    c8 c16 c c8 c4 c c8 des4-> |
    c8. c16 c8 c4 c c8 des4-> |
    c8 c16 c c8 c4 c c8 des4-> |
    c8. c16 c8 c4 c c8 des4-> |
    c8 c16 c c8 c4 c c8 des4-> |
    c8. c16 c8 c4 c c8 des4-> |
    c8 c16 c c8 c4 c c8 des4-> |
    c8. c16 c8 c4 c c8 ees4-> |
    c4 \arco r r2 \clef treble ees32(\mf\<^\arc f ges aes bes ces c d) |
  % rehearsal 10, 117-122
    ees2.->\!\f ~ ees8 bes16( ees) ges8->( aes16 ges) |
    ees2.-> ~ ees8 des bes16( des aes des |
    bes8-.) r16 bes-. bes8-. bes4-> ees,8( ges ees) des'->( ees16 des |
    bes8-.) bes16-. bes-. bes8-. bes4-> bes,8( ees bes') aes16( bes ges aes |
    bes8-.->) r16 ees,-. ees2\> ~ ees4 bes16(\!\mf\< ees ges aes) |
    bes8-.->\!\f r16 ees,-. ees2\> ~ ees4 bes32(\!\mf\< des ees f aes bes des ees |
  % rehearsal 11, 123-134
    f8-.->)\!\f r r4 r8 f,4 <f bes,>8-. <g c,>-. <bes ees,>-. |
    <c f,>-.-> r r4 r8 f,-. <f bes,>-. <g c,>-. <bes ees,>-. <c f,>-. |
    <f bes,>-.-> r r4 r8 f,4 <g c,>8-. <bes ees,>-. <c f,>-. |
    <f bes,>-.-> r r4 r8 c,-. c-. c-. <f bes,>-. <g c,>-. |
    <ees' aes, ces,>-.-> r16 ees-. ees8-. ees4 ees bes8-. ees-. f-. |
    <ees aes, ces,>-.-> ees16-. ees-. ees8-. ees4 ees aes,8-. bes-. ees-. |
    f8.-> f16-> f8-> f-> r8 c-> ~ \times 2/3 { c8 bes-> c-> } \times 2/3 { f,-> bes-> c-> } |
    f8.-> f16-> f8-> f-> r8 c-> ~ \times 2/3 { c8 bes-> bes-> } c16-> f,-> bes-> c-> |
    f16-.-> c-> c-> bes-> \times 4/5 { c-> f, bes c ees } f-.-> c-> c-> bes-> \times 4/5 { c-> f, bes c ees } f-.-> c-> c-> bes-> |
    \times 4/5 { c-> f, bes c ees } f8-.-> r c4--->\ff bes---> c---> |
    f,---> bes---> c---> <f c>2---> |
    <g d>4-.-> r r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \clef alto \key g \minor
    \pizz R1*5/4 | R1*5/4 |
    e,,8\p^\piz g a c e g a4 r |
    R1*5/4 | R1*5/4 |
    ees,8 g bes c ees g bes4 r |
    r2 r8 fis,\mp a b cis4 |
    r2 r8 a c d e4 \trem |
  % rehearsal 13, 143-148
    \time 7/4
    \tag #'score { << { <fis c>1:32\mf^\div^\arc q2.: |
      q1: q2.: |
      \time 6/4 q1.: } \\
      { <d a>1:32 q2.: | q1: q2.: | q1. } >> | }
    \tag #'midi { <fis d c a>1*7/4\mf ~ | q ~ | \tutti q1. | }
    a,8-.\cresc^\unis c-. d-. a-. c-. d-. a-. c-.  d-. a-. c-. d-. |
    a-. c-. <a' d,>-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-.->\!\ff r r4 r \pizz d,,^\snappizzicato\sf^"Secco" r r \bar "||"
  % rehearsal 14, 149-161
    <g' bes,>4\mp^\piz r r r2 r4 |
    <g bes,> r r r2 r4 |
    r r8 <g c,>-> r4 r r8 <g c,>-> r4 |
    r2 r4 <f a,>->\mf <f a,>-> r |
    <g bes,>2\f r4 <g bes,>2 r4 |
    <g bes,>2 r4 <g bes,>2 r4 |
    r r8 <g c,>4-> r8 r4 r8 <g c,>4-> r8 |
    r2 r4 <f a,>-> <f a,>-> \arco r |
    \time 5/4
    <f bes,>4-.->\p^\arc r8 q4-.-> r8 q4-. q-. |
    <g bes,>-.-> r8 q4-> r8 q4-. q-. |
    \pizz <f bes,>4.->^\piz q-> q4 q |
    <g bes,>4.-> q-> q4 q |
    \time 6/4
    r2 r4 g,->\mf \arco r r |
  % Rehearsal 15, 162-176
    g'2(\mp^\dolce^\arc e4 g2 c,4) |
    c2( d8 e) e2. |
    g4( a8 g e4 g2 c,4) |
    c4( g8 a c d e2.) |
    bes'2( g4 bes2 ees,4) |
    ees2( f8 g) g2 f8( ees |
    c4 ees4. f8 c2) ees8( f |
    g2. ~ g4) \times 4/7 { g,16( a b c d e f } g8-.) r |
    r8 e,8(\mf g a c d e4.) g8( a g |
    e4 d8 c g a) c( a g e c) r |
    r ees( g bes c4) r8 g( bes c ees f) |
    g4( f8 ees bes c) ees( c bes g ees) r |
    r bes''( aes ges des ees) ges( ees des bes ges) r |
    r c'(\< bes aes ees f) aes( f ees c aes) r |
    r aes( c ees f4) r8 c( ees f g4)\! |
  % rehearsal 16, 177-180
    \tag #'score { << { <a e>1.:32\f^\div | q2.: q2: q8-. } \\
      { <g d>1.:32 | q2.: q2: q8-. } >> }
      \tag #'midi { \trem <a g e d>1.\f ~ | q1 ~ q4 ~ \tutti q8-. }
      a,16 c |
    d8-.-> r r a16 c d8-.-> r r a16 c d8-. r r4 |
    \pizz r2 d,4^\snappizzicato\sf \arco r \times 4/7 { d'16(^\arc ees f g a bes c } d8-.) r |
  % rehearsal 17, 181-188
    <g, bes,>-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    <d g,>-. q-. q-. <ees g,>4-> q8-. <d g,>-. q-. q-. <ees g,>4-> q8-. |
    <d g,>-. q-. <ees g,>-. q-. q-. q-. <d f,>-.-> <f a,>-. q-.-> d-. d-. d-. |
    <g bes,>-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    <d g,>-. q-. q-. <ees g,>4-> q8-. <d g,>-. q-. q-. <ees g,>4-> q8-. |
    <d g,>-.->\mf\< <g bes,>-. q-. q-. <d g,>-.-> <g bes,>-. q-. q-. <d g,>-.-> <g bes,>-. q-. q-. |
  % rehearsal 18, 189-202
    \time 5/4
    d4->\!\f bes8-. d4-> g,8-. bes-. c-. d4-.-> |
    \tag #'score { <g bes,>2.:32 q2: | }
      \tag #'midi { \trem <g bes,>2. ~ \tutti q2 | }
    d4-> bes8-. d4-> g,8-. bes-. c-. d4-.-> |
    \tag #'score { <g bes,>2.:32 q2: | }
      \tag #'midi { \trem <g bes,>2. ~ \tutti q2 | }
    <d a>8-.->\mf\< r r <d a>-.-> r <d a>-.-> r4 <d a>8-.-> r |
    <d a>-.-> r <d a>-.-> r <d a>-.-> r <d a>-.-> r <d a>-.-> <f a,>-.->\!\ff |
    R1*5/4 | R1*5/4 | \pizz r4 d\f^\piz r r2 |
    R1*5/4 | r4 d\mf r r2 |
    R1*5/4 | r2 d4\mp r2 |
    R1*5/4 \bar "||"
  % d, rehearsal 19, 203-207
    \key g \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    R1 | R1 |
    \time 6/4 R1. |
    \time 4/4 R1*4 |
    \time 6/4 R1. |
    \time 4/4 R1*3 |
    \time 6/4 R1. |
    \time 4/4 \arco R1 | R1 |
  % rehearsal 21, 222-228
    b8\mp^\arc b4 b b b8 |
    b b4 b b b8 |
    b b4 b b a8 |
    c c4 c d,8\mf d d |
    d'( c16 bes g4) r8 d( \times 2/3 { f g bes) } |
    f'16->( d c bes g4) r8 d16( f g bes c d) |
    g8.->(\< f16) \times 2/3 { f8( d) d } g8.->( f16) \times 2/3 { f8( d) d } |
  % rehearsal 22, 229-244
    a'8-> \times 2/3 { r16 g( f } d4)\! \clef treble r8 d( e8. b'16 |
    \time 6/4 g2) r8 d( e b' g4) d'8.( e32 d |
    \time 4/4 b2) r8 b( a g |
    a2) r8 e( g b |
    a4.\> g8 e4) a,8.( b16 |
    d16\!\mf e d4.)\< r8 d8( e8.\!\f b'16 |
    \time 6/4 g2) r8 d( e b' g4) d'8.( e32 d |
    \time 4/4 b2) r8 d( e g) |
    a4.( g8 \times 2/3 { e4) b8( } \times 2/3 { d e g) } |
    a4.( g8 e\> g,16( a b d e g) |
    b1->\!\mp ~ |
    b8 r r4 r2 |
    \clef alto R1*3 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    << { <gis, cis,>8-.->\sf^\div } \\ { <e gis,>-.-> } >> r r4 r2 | R1 |
    r2 r4 << { <cis' e, gis,>8-.->\sf } \\ { <gis cis, e,>-.-> } >> r | R1 | R1 |
  % rehearsal 24, 250-254
    R1 |
    \times 4/6 { b,16\p\<^\unis cis e gis fis e } \times 4/6 { cis\!\mp\> b gis b fis gis } \times 4/6 { b\!\p\< cis e gis fis e } \times 4/6 { cis\!\mp\> b gis b fis gis } |
    \times 4/6 { gis\mp\< b cis b cis e } \times 4/6 { gis, b cis b cis e } \times 4/6 { gis, e fis gis b cis } \times 4/6 { \repeat tremolo 6 <e gis,> } |
    \tag #'score { q1:32\!\f |
      q2:\> <cis gis>4: q8-.\!\mp r | }
    \tag #'midi { \trem <e gis,>1\!\f ~ |
      q2\> ~ <cis gis>4 ~ \tutti q8-.\!\mp r | }
  % rehearsal 25, 255-261
    \key d \minor
    R1 |
    \times 4/6 { c16\p\< d f a g f } \times 4/6 { d\!\mp\> c a c g a } \times 4/6 { c\!\p\< d f a g f } \times 4/6 { d\!\mp\> c a c g a } |
    \times 4/6 { a\mp\< c d c d f } \times 4/6 { a, c d c d f } \times 4/6 { a, f g a c d } \times 4/6 { \repeat tremolo 6 <f a,>\! } |
    \time 3/4
    \tag #'score { q2.:32\f | << { q: } \\ { s2\> s4\!\p } >> |
      q2.:32\f | << { q: } \\ { s2\> s4\!\p } >> | }
    \tag #'midi { \trem << { q2.\f ~ | q } \\ { s2. | s2\> s4\!\p } >> |
      << { q2.\f ~ | q: } \\ { s2. | s2\> s4\!\p } >> | }
  % rehearsal 26, 262-266
    g16(\cresc f) f( d) g( f) f( d) g( f) f( d) |
    g( f) f( d) g( f) f( d) g( f) f( d) |
    <g gis,>( f) f( d) <g gis,>( f) f( d) <g gis,>( f) f( d) |
    <g gis,>( f) f( d) <g gis,>( f) f( d) <g gis,>( f) f( d) |
    <f gis,>8-.->\!\ff <d gis,>-.-> r4 r |
  % rehearsal 27, 267-272
    \pizz R2.*3 |
    r4 d\p^\piz r |
    R2. | r4 d \arco r |
  % rehearsal 28, 273-280
    \clef treble \time 4/4
    r4 a'32->(\ff^\arc a'8.. ~ a8-.) g-.-> \times 2/3 { f-.-> d-.-> a-.-> } |
    f'16->( d8. ~ d4 ~ d8-.) c-.-> g-.-> c-.-> |
    \clef alto
    \times 4/5 { a16-> g f d a } \times 4/5 { g'-> f d a g } \times 4/5 { f'-> d a g f } \times 4/5 { d'-> a g f d } |
    c'8-.-> r d32->( c a8. ~ a2)\> |
    c8-.->\!\f r d32->( c a8. ~ a2)\> |
    c8-.->\!\mf r \times 2/3 { d16( c a ~ } a8 ~ a4. ~ \times 2/3 { a16)\!\mp g'(\> f } |
    d1)\!\pp | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    \key g \major
     R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    \clef treble
    r2 \times 2/3 { b'4->\ff d-> e-> } |
    b'2.-> \times 2/3 { a8( b g } |
    a2)\dim r8 b( a8. e16 |
    g2) r8 a( g8. b,16 |
    d2) r8 e( d8. g,16) |
    g1 ~ | g4\!\mp\fermata r r2 |
    \clef alto
    \trem R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor \time 6/4
    \tag #'score { <g g,>1.:32->\fpp^"Div., pont." | q: | q: | q: | q2.: q2: r4 | }
    \tag #'midi { <g g,>1.\pp ~ | q ~ | q ~ | q ~ | q1 ~ \tutti q4 r | }
    d4->\mp^"Unis., norm." bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes-.-> g-. c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. bes-. c-. |
    d-. g,4-_ g'-_ f8-. ees-. g16(\< f ees8-.) ees16( c) bes( c g bes) |
    c16->(\!\mf bes g8-.) g4-_ r8 c,-. bes'-. g4-> f8-. g-. bes-. |
    c16->( bes g8-.) g4-_ r8 c,-. bes'-. g4-> f8-. g-. bes-. |
    c4-> r8 bes-. g-. f-. c4-> r8 bes'-. g-. f-. |
    c4-. r8 c'-. bes4-. r8 bes-. a4-. aes-. |
    bes8-. g4-> f8-. d4-. bes'8( c16 bes g8-.) bes4-> d,8-. |
    g4-> r8 f-. d4-. bes'8( c16 bes g8-.) bes4-> d,8-. |
    g8-. f-. d4-. f8-. d-. g-. f-. d4-. f8-. d-. |
    g4-. d'-> ~ d c-> ~ c-. a-. |
  % rehearsal 32, 318-322
    a16->( c d8-.) d-. d-. d-. d-. d4-.-> r r |
    c16->( ees f8-.) f-. f-. f-. f-. f4-.-> r r |
    bes4-> r8 aes-. f-. ees-. des( ees16 des bes8-.) des4-> ees8-. |
    f16->( ees c8-.) c-. c-. c-. c-. c-. aes4-> c8-. ees-. f-. |
    g4 r r r2 r4 |
  % rehearsal 33, 323-328
    d4-.-> r8 a-. c-. d-. f( g16 f d8-.) f4-> c8-. |
    d4-.-> r8 a-. c-. d-. f( g16 f d8-.) f4-> c8-. |
    d4-.-> r r a16->(\cresc c d8-.) d-. d-. d-. d-. |
    a16->( c d8-.) d-. d-. d-. d-. a16->( c d8-.) d-. d-. d-. d-. |
    a16->( c d8-.) <a' d,>-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q4-.->\!\sf r \times 4/7 { d,,16(\f ees f g a bes c) } \times 4/7 { d,( ees f g a bes c } d8-.) r r4 |
  % rehearsal 34, 329-336
    <g bes,>8-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    q-.-> q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. q-. |
    <d g,>-. q-. q-. <ees g,>4-> q8-. <d g,>-. q-. q-. <ees g,>4-> q8-. |
    <d g,>-. q-. <ees g,>-. q-. q-. q-. <d f,>-.-> <f a,>-. q4-.-> \pizz r |
    <g bes,>4\mp^\piz r r r2 r4 |
    <g bes,> r r r2 r4 |
    r r8 <g c,>-> r4 r r8 <g c,>-> r4 |
    r2 r4 <f a,>->\mf <f a,>-> r |
  % rehearsal 35, 337-344
    \time 5/4
    <bes d,>4.->\f q-> q4-> q-> |
    g4.\mf f ees4 d |
    <bes' d,>4.->\f q-> q4-> q-> |
    d,4.\mf c b4 bes \arco |
    bes8->(\f^"Arco, sul C" c16 bes g8-.) bes4-> g8-. <d' g,>-.-> q q4-.-> |
    c8->(^\simile bes16 c g8-.) bes4-> g8-. <d' g,>16-.-> q-. q8-. q4-.-> |
    c16->(^\sim bes g8-.) <d' g,>16-.-> q-. q8-. c16->(^\sim bes g8-.) <d' g,>16-.-> q-. q8-. c16->(^\sim bes g8-.) |
    g'-.->\> g-. g-. g-. g-.\!\mf r r4 r |
  % rehearsal 36, 345-355
    << { <e a,>8-.\p^\div q4 q q q8-. q-. q-. |
      q-. q4 q q q8-. q4-. |
      <g c,>8-.\mp q4 q q q8-. q-. q-. |
      q-. q4 q q q8-. q4-. |
      <fis cis>8-.\mf q4 q q q8-. q-. q-. |
      <a e>-. q4 q q q8-. q-. q-. } \\
      { <c, g>8-.\p^\div q4 q q q8-. q-. q-. |
      q-. q4 q q q8-. q4-. |
      <ees bes>8-.\mp q4 q q q8-. q-. q-. |
      q-. q4 q q q8-. q4-. |
      <e a,>8-.\mf q4 q q q8-. q-. q-. |
      <fis cis>-. q4 q q q8-. q-. q-. } >> |
    \time 6/4
    <a cis,>8-.->\p^\unis q-. q-. q-. q-. q-. q-.-> q-. q-. q-. q-. q-. |
    q-.-> q-. q-. q-. q-. q-. q-.-> q-. q-. q-. q-. q-. |
    <f a,>-.->\mp\< q-. q-. q-. q-. q-. <g a,>-.-> q-. q-. q-. q-. q-. |
    <fis c>-.->\!\mf q-. q-. q-. q-. q-. q-.-> q-. q-. q-. q-. q-. |
    <fis c>-.-> q-. q-.\< q-. q-. q-. q-. q-. q-. q-. q-. q-. |
  % rehearsal 37, 356-362
    \clef treble
    \stemBoth d'4->\!\f { <g, bes,>8 s } bes-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
    bes( g-.) c-. bes-. bes-. g-. g'16->( f d8-.) d4-.-> d,-. |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    d'4-> bes8-. d-. c-. bes-. c16( bes g8-.) g4-_ d-_ |
    bes'8( g-.) bes-. c4-> g8-. bes( g-.) bes-. c4-> g8-. |
  % rehearsal 38, 363-372
    \time 5/4
    bes-.->\mp\cresc g-. c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. |
    c-. g-. bes-.-> g-. c-. g-. bes-.-> g-. bes-. c-. |
    d8-.->\!\f c16( d g,8-.) bes4-> g8-. bes-. c-. d4-.-> |
    d8-.-> c16( d g,8-.) bes4-> g8-. f'-. d-. d4-.-> |
    d8-.-> c16( d g,8-.) bes4-> g8-. bes16( g bes c) d4-.-> |
    d8-.-> c16( d g,8-.) bes4-> g8-. g'16->( f d8-.) d4-.-> |
    f8-.->\mf c-. c-. f-.-> d-. f-.-> c-. c-. f-.-> d-. |
    f-.-> c-. c-. f-.-> d-. f-.-> c-. c-. f-.-> d-. |
    <f a,>-.->\cresc d-. <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> d-. |
    <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> d-. <f a,>-.-> d-. \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    \tag #'score { g2.:32->\!\fff g:\> |
      g1.:\ff | \clef alto g,:\f |
      g,:\mp\> | g:\!\p\< |
      g1:\!\f\> g2:\!\pp \bar "||" }
    \tag #'midi { \trem g''2.\!\fff ~ g\> ~ |
      g1.\ff | g,\f |
      g,\mp\> ~ | g\!\p\< ~ |
      g1\!\f\> ~ g2\!\pp | }
  }

  cello = \relative c {
    \clef bass \key g \minor \numericTimeSignature \time 6/4
  % intro, 1-4
    \grace { s16 } R1.*3 |
    d8-.\mf d-. d-. d-. d-. d-. d-. r r4 \pizz r |
  % a, rehearsal 1, 5-12
    g2\mp^\piz d4 g2 d4 |
    g2 d4 g2 d4 |
    g4 g8 c,4-> c8 g'4 g8 c,4-> c8 |
    g'4\< c,8 c4 c8 d4->\!\mf d-> \arco d8-.\<^\arc d-. |
    g4-.\!\f r d-. g-. r d-. |
    g-. r d-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> r |
  % rehearsal 2, 13-17
    \time 5/4
    \pizz bes2\p^\piz f4 bes f |
    g2 d4 g g |
    bes2 f4 bes f | g2 d4 g g |
    \time 6/4
    \arco r2 c16(\mf^\arc bes g8-.) \pizz r2 r4 |
  % rehearsal 3, 18-28
    \time 5/4
    c2\p^\piz g4 c g | c2 g4 c c |
    ees2\mp bes4 ees bes | ees2 bes4 ees ees |
    fis2\mf cis4 fis cis | a2 e'4 a a, |
    \arco a'-.->\p^\arc r r gis-.-> r r |
    fis-.-> r r e-.-> r r |
    f-.->\mp\< r r ees-.-> r r |
    d-.->\!\mf r r d-.-> r r |
    d-.-> d8-.\< d-. d-. d-. d-. d-. d-. d-. d-. d-. |
  % rehearsal 4, 29-40
    g,4-.\!\f r d'-. g-. r d-. |
    g,-. r d'-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> d-. |
    g,-. r d'-. g-. r d-. |
    g,-. r d'-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'-.->\mf\< g-. g-. g-. f-.-> f-. f-. f-. e-.-> e-. e-. e-. |
    ees4-.->\!\f r r c16->( bes g8-.) r4 r |
    r8 d'-.\p\cresc d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d-.->\!\ff r r4 r\fermata g,16-> g-> g8-.-> r4 r\bar "||"
  % b, rehearsal 5, 41-54
    \key c \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4
    \pizz r4^\piz c\p c | r bes bes |
    r a a | r aes aes | r g\< g\!\mp\> |
    r c\!\p c | r b b | r bes bes | r a a |
    r aes aes | r g g | r c c |
  % rehearsal 7, 67-81
    \arco bes2.^\arc | aes\< | g2\!\mp r4 |
    g'8(\mp\< c) c2 |
    c8( f) f4( ees8 f) |
    bes8( g ~ g2) |
    ees,2(\mf\< bes'4) | aes2. | g4 g,2 |
    c2.\!\f | bes | a2( aes4) |
    g2.\> | c ~ | c4\!\p\fermata r r |
  % rehearsal 8, 82-102
    \time 4/4
    \pizz r4^\collaparte aes\mp^\piz r2 |
    r4 aes r2 |
    r2 des,4\p r |
    R1 |
    g2 r |
    r4 g\pp r2 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \grace { s16 } c2\p^\piz g4 c g-> | c2 g4 c g-> |
    c2 g4 c g-> | c2 g4 c g-> |
    c2 g4 c g-> | c2 g4 c g-> |
    c8 \arco r16 c-.\mp^\markup { \bold \italic "Arco, pont." } c8-. c4-> c-> g8-. bes->( g-.) |
    c8-. c16-. c-. c8-. c4-> c-> g8-. bes16->( c g bes) |
    c4-. \pizz r g\p^\piz c g-> | c2 g4 c g-> |
    c2 g4 c g-> | c2 g4 c g-> |
    c2 ges4 c ges-> | c2\< ges4 c \arco bes^\arc |
  % rehearsal 10, 117-122
    ees-.->\!\f r bes-. ees-. bes-> |
    ees-. r bes-. ees-. bes-> |
    ees-. r bes-. ees-. bes-> |
    ees-. r bes-. ees-. bes-> |
    ees-.-> r bes-. ees-. bes |
    ees-.-> r bes-. ees-. bes8-. bes-. |
  % rehearsal 11, 123-134
    f-.-> r r4 r8 f'4 ees8-. c-. bes-. |
    f-.-> r r4 r8 bes'-. aes-. f-. ees-. c-. |
    bes-.-> r r4 r8 aes'4 f8-. ees-. c-. |
    bes-.-> r r4 r8 bes'-. aes-. f-. ees-. c-. |
    ces-.-> r r4 r r8 ees-. ees-. ees-. |
    ces-.-> r r4 r r8 ees-. ees-. ees-. |
    des8.-> des16-> des8-> des-> r4 r2 |
    des8.-> des16-> des8-> des-> r4 r2 |
    des4-.-> r des-.-> r des-.-> |
    r2 des4--->\ff des---> aes---> |
    des---> des---> aes---> des2---> |
    g,4-.-> r r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \key g \minor
    \pizz R1*5/4 |
    r2 r4 r8 g\p^\piz a c |
    e4 r r r2 |
    R1*5/4 |
    r2 r4 r8 g, bes c |
    ees4 r r r2 |
    R1*5/4 | \arco R1*5/4 |
  % rehearsal 13, 143-148
    \time 7/4
    d4->\mf^\arc c8-. d4-> a8-. c-. d-. d-. r r2 |
    d4-> c8-. d4-> a8-. c-. d-. d-. r r2 |
    \time 6/4
    a8-. c-. d-. r r4 a8-. c-. d-. r r4 |
    a8-.\cresc c-. d-. a-. c-. d-. a-. c-.  d-. a-. c-. d-. |
    d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d-.->\!\ff r r4 r \pizz d^\snappizzicato\sf^"Secco" r r \bar "||"
  % rehearsal 14, 149-161
    g2\mp^\piz d4 g2 d4 |
    g2 d4 g2 d4 |
    g4 g8 c,4-> c8 g'4 g8 c,4-> c8 |
    g'4\< c,8 c4 c8 d4->\!\mf d-> \arco d8-.\<^\arc d-. |
    g4-.\!\f r d-. g-. r d-. |
    g-. r d-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> r |
    \time 5/4
    \pizz bes2\p^\piz f4 bes f |
    g2 d4 g g |
    bes2 f4 bes f | g2 d4 g g |
    \time 6/4
    \arco r2 c16(\mf^\arc bes g8-.) \pizz r2 r4 |
  % rehearsal 15, 162-176
    c2\mp^\piz g4 c a g |
    c2 g4 c g e' |
    c2 g4 c a g |
    c2 g4 c g c |
    ees2 bes4 ees g, bes |
    c2 g4 c g bes |
    aes2 ees4 f c' f,  |
    g a' g d\< a g |
    c2\!\mf g4 c e, g |
    c2 g4 c g a |
    c2 g4 c g bes |
    c2 bes4 ees bes c |
    ees2 des4 ges des ees |
    f2\< ees4 aes ees aes, |
    \arco f'8-.^\arc f-. f-. f-. f-. f-. ees-. ees-. ees-. ees-. ees-. ees-. |
  % rehearsal 16, 177-180
    d4->\!\f c8-. d4-> a8-. c-. d-. d4-.-> r |
    d-> c8-. d4-> a8-. c-. d-. d4-.-> r8 a16 c |
    d8-.-> r r a16 c d8-.-> r r2 r8 a16 c |
    d8-.-> r r4 r \times 4/7 { d16->( ees f g a bes c) } \times 4/7 { d,16( ees f g a bes c } d8-.) r |
  % rehearsal 17, 181-188
    g,,4-. r d'-. g-. r d-. |
    g,-. r d'-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> d-. |
    g,-. r d'-. g-. r d-. |
    g,-. r d'-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'-.->\mf\< g-. g-. g-. f-.-> f-. f-. f-. e-.-> e-. ees-. ees-. |
  % rehearsal 18, 189-202
    \time 5/4
    d4->\!\f bes8-. d4-> g,8-. bes-. c-. d4-.-> |
    \tag #'score { d2.:32\mf d2: | }
      \tag #'midi { \trem d2. ~ \tutti d2 | }
    d4->\f bes8-. d4-> g,8-. bes-. c-. d4-.-> |
    \tag #'score { d2.:32\mf d2: | }
      \tag #'midi { \trem d2. ~ \tutti d2 | }
    d8-.->\< r r d-.-> r d-.-> r4 d8-.-> r |
    d-.-> r d-.-> r d-.-> r d-.-> r d-.-> d-.->\!\ff |
    R1*5/4 | R1*5/4 | \pizz r4 d\f^\piz r r2 |
    R1*5/4 | r4 d\mf r r2 |
    R1*5/4 | r2 d4\mp r2 |
    R1*5/4 \bar "||"
  % d, rehearsal 19, 203-207
    \key g \major \time 4/4
    \pizz R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    d1\mp^\piz | d1 |
    \time 6/4 d1 r4 fis4 |
    \time 4/4 e2 d | c2. b4 | a2. a4 | d2. d4 |
    \time 6/4 d1 r4 fis |
    \time 4/4 e2\< d | c1\!\mf | b |
    \time 6/4 e4 d c2 b4 bes |
    \time 4/4 a2\> d |
    \arco g,8(\!\mp\<^\arc d4 e8) \times 2/3 { g( a b } \times 2/3 { d e g) } |
  % rehearsal 21, 222-228
    b8(\!\mf a16 g e4) r8 b( \times 2/3 { d e g) } |
    b8( a16 g e4) r8 b16( d e d e g) |
    d'8.( b16) \times 2/3 { b8( a g } \times 2/3 { e4) b8( } \times 2/3 { d e g } |
    a2) r |
    g8 g4 g g g8 |
    f f4 f f f8 |
    e\< e4 e8 ees ees4 ees8 |
  % rehearsal 22, 229-244
    d d4 d d\!\f d8 |
    \time 6/4 g,1 g'4 fis |
    \time 4/4 e2 d | c2. b4 | a2.\> a4 | d2.\!\mf\< d4\!\f |
    \time 6/4 g,1 g'4 fis |
    \time 4/4 e2 d | c1 | b2.\> b4 |
    a1->\!\mp ~ | a8 r r4 r2 |
    R1*3 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    r2 r8 gis-.->\f cis-.-> e-.-> |
    fis16-.-> cis-.-> e-.-> fis-.-> gis8-.-> r16 e'-.-> cis8-.-> r16 r32 cis,-> cis4-.-> |
    r2 r4 r8 gis-.-> |
    \times 2/3 { b-.-> cis-.-> e-.-> } \times 4/5 { fis16-.-> cis-.-> e-.-> fis-.-> b-.-> } gis8-.-> r16 gis'-.-> gis4-> ~ |
    gis8. fis32 e cis8-.-> r16 r32 e,-> e8-.-> cis-.-> r4 |
  % rehearsal 24, 250-254
    \times 4/6 { b16\p\< cis e fis gis b } \times 4/6 { cis->\!\mp b gis b gis fis } \times 4/6 { e\> fis e cis b cis } \times 4/6 { e fis e cis b cis } |
    \times 2/3 { e4->\!\p\< gis8-. } \times 2/3 { e-.\!\mp b-. cis-. } \times 2/3 { e-. gis-. fis-. } \times 2/3 {  e4-> b8-. } |
    \times 2/3 { cis-.\< b-. gis-. } \times 2/3 { cis-. b-. gis-. } \times 2/3 { cis-. b-. gis-. } \times 2/3 { cis-. b-. gis-. } |
    \tag #'score { ais1:32\!\f | ais:\> | }
    \tag #'midi { \trem ais1\!\f ~ | ais\> \tutti | }
  % rehearsal 25, 255-261
    \key d \minor
    \times 4/6 { c16\p\< d f g a c } \times 4/6 { d->\!\mp c a c a g } \times 4/6 { f\> g f d c d } \times 4/6 { f g f d c d } |
    \times 2/3 { f4->\!\p\< a8-. } \times 2/3 { f-.\!\mp c-. d-. } \times 2/3 { f-. a-. g-. } \times 2/3 { f4-> c8-. } |
    \times 2/3 { d-.\< c-. a-. } \times 2/3 { d-. c-. a-. } \times 2/3 { d-. c-. a-. } \times 2/3 { d-. c-. a-.\! } |
    \time 3/4
    \tag #'score { b2.:32\f | << { b: } \\ { s2\> s4\!\mp } >> |
      bes2.:32\f | << { a: } \\ { s2\> s4\!\mp } >> |
  % rehearsal 26, 262-266
      gis2.:\p\cresc | gis: | gis: | gis: | }
    \tag #'midi { \trem << { b2.\f ~ | b } \\ { s2. | s2\> s4\!\mp } >> |
      << { bes2.\f | a } \\ { s2. | s2\> s4\!\mp } >> |
      gis2.\p\< ~ | gis ~ | gis ~ | \tutti gis | }
    gis8-.->\!\ff gis-.-> r4 r |
  % rehearsal 27, 267-272
    \pizz R2.*3 |
    r4 d'\p^\piz r |
    R2. | r4 d \arco r |
  % rehearsal 28, 273-280
    \time 4/4
    r2 a32->\ff^\arc a16.-.-> r8 r4 |
    r4 a32-> a16.-.-> r8 a32-> a16.-.-> r8 r4 |
    a'8-.-> r a-.-> r f-.-> r d-.-> r |
    r2 \times 2/3 { a8-.-> a-.-> a-.-> } a4-.-> |
    r2 \times 2/3 { a8-.->\f a-.-> a-.-> } a4-.-> |
    r2 \times 2/3 { a8-_\mf\> a-_ a ~ } a8 ~ \times 2/3 { a16\!\mp g'(\> f } |
    d1)\pp | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    \key g \major
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1 |
    c1->\ff ~ | c\dim |
    e | b2 bes |
    a1 ~ | a4\!\mp\fermata r r2 |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor \time 6/4
    R1. |
    g'4->\mp ees8-. g-. f-. ees-. f16( ees c8-.) c4-_ g-_ |
    g'-> ees8-. g-. f-. ees-. f16( ees c8-.) c4-_ g-_ |
    ees'8( c-.) ees-. f4-> c8-. ees( c-.) ees-. f4-> c8-. |
    ees-.-> c-. f-. c-. ees-.-> c-. f-. c-. ees-.-> c-. ees-. f-. |
    g16->( f d8-.) d4-_ r8 g,-. f'-. d4-> c8-. d-. f-. |
    g16->( f d8-.) d4-_ r8 g,-. f'-. d4-> c8-. d-. f-. |
    g4-> r8 f-. d-. c-. g4-> r8 f'-. d-. c-. |
    g4-. r8 g'-. f4-. r8 f-. e4-. ees-. |
    d8-. bes16( c d8-.) d16( f g8-.) bes,-. c4-.\< f,-. g-. |
    c4->\!\mf r8 bes-. g4-. ees'8( f16 ees c8-.) ees4-> g,8-. |
    c4-> r8 bes-. g4-. ees'8( f16 ees c8-.) ees4-> g,8-. |
    c-. bes-. g4-. bes8-. g-. c-. bes-. g4-. bes8-. g-. |
    c4-. g-> ~ g f-> ~ f-. d-. |
    g-. g-. r r d'-. c-. |
    bes-. g-. r r d'-. c-. |
    bes-. g-. d'8( c) bes4-. g-. d'8( c) |
    bes2 a g4-. ees'-. |
  % rehearsal 32, 318-322
    d4-.-> r r r2 r4 | R1.*4 |
  % rehearsal 33, 323-328
    a16->(\mf c d8-.) d-. d-. d-. d-. d4-.-> r r |
    a16->( c d8-.) d-. d-. d-. d-. d4-.-> r r |
    a16->(\cresc c d8-.) d-. d-. d-. d-. a16->( c d8-.) d-. d-. d-. d-. |
    a16->( c d8-.) d-. d-. d-. d-. a16->( c d8-.) d-. d-. d-. d-. |
    a16->( c d8-.) d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d4-.->\!\sf \times 4/7 { d,16->(\f ees f g a bes c) } \times 4/7 { d,( ees f g a bes c } d8-.) r r4 r |
  % rehearsal 34, 329-336
    g,4-.-> r d'-. g-. r d-. |
    g,-. r d'-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> \pizz r |
    g2\mp^\piz d4 g2 d4 |
    g2 d4 g2 d4 |
    g4 g8 c,4-> c8 g'4 g8 c,4-> c8 |
    g'4\< c,8 c4 c8 d4->\!\mf d-> \arco r |
  % rehearsal 35, 337-344
    \time 5/4
    bes4-.->\f^\arc r f-. bes-. bes-. |
    R1*5/4 |
    bes4-.-> r f-. bes-. bes-. |
    R1*5/4 |
    bes'8->( c16 bes g8-.) bes4-> g8-. g,-.-> g g4-.-> |
    c'8->( bes16 c g8-.) bes4-> g8-. g,16-.-> g-. g8-. g4-.-> |
    c'16->( bes g8-.) g,16-.-> g-. g8-. c'16->( bes g8-.) g,16-.-> g-. g8-. c'16->( bes g8-.) |
    \pizz r2 g'4->\mf^\piz r r |
  % rehearsal 36, 345-355
    c,,2\p g4 c g | c2 g4 c c |
    ees2\mp bes4 ees bes | ees2 bes4 ees ees |
    fis2\mf cis4 fis cis | a2 e'4 a a, |
    \arco a'-.->\p^\arc r r gis-.-> r r |
    fis-.-> r r e-.-> r r |
    f-.->\mp\< r r ees-.-> r r |
    d-.->\!\mf r r d-.-> r r |
    d-.-> d8-.\< d-. d-. d-. d-. d-. d-. d-. d-. d-. |
  % rehearsal 37, 356-362
    g,4-.\!\f r d'-. g-. r d-. |
    g,-. r d'-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> d-. |
    g,-. r d'-. g-. r d-. |
    g,-. r d'-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
  % rehearsal 38, 363-372
    \time 5/4
    g'-.->\mp\cresc g-. g-. g-. g-.-> g-. g-. g-. fis-.-> fis-. |
    fis-. fis-. f-.-> f-. f-. f-. e-.-> e-. ees-. ees-. |
    d4-.->\!\f r r d8-. d-. d4-.-> |
    d-.-> r r d8-. d-. d4-.-> |
    d-.-> r r d8-. d-. d4-.-> |
    d-.-> r r d8-. d-. d4-.-> |
    d8-.\mf r r d-. r d-. r4 d8-. r |
    d-. r r d-. r d-. r4 d8-. r |
    d-.\cresc r d-. r d-. r d-. r d-. r |
    d-. r d-. r d-. r d-. r d-. r \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    \tag #'score { g,2.:32->\!\fff g:\> |
      g1.:\ff\> | g:\!\f\> |
      g:\!\mp\> | g:\!\p\< |
      g1:\!\f\> g2:\!\pp \bar "||" }
    \tag #'midi { \trem g2.\!\fff ~ g\> ~ |
      g1.\ff\> ~ | g\!\f\> ~ |
      g\!\mp\> ~ | g\!\p\< ~ |
      g1\!\f\> ~ g2\!\pp | }
  }

  contrabass = \relative c {
    \clef bass \key g \minor \numericTimeSignature \time 6/4
    \transposition c
  % intro, 1-4
    \grace { s16 } R1.*3 |
    r2 \pizz r4 r8 d\mp^\piz d d d d |
  % a, rehearsal 1, 5-12
    g2 d4 g2 d4 |
    g2 d4 g2 d4 |
    g g8 c,4-> c8 g'4 g8 c,4-> c8 |
    g'4\< c,8 c4 c8 d4->\!\mf d-> \arco d8-.\<^\arc d-. |
    g4-.\!\f r d-. g-. r d-. |
    g-. r d-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> r |
  % rehearsal 2, 13-17
    \time 5/4
    R1*5/4 | R1*5/4 |
    \pizz bes2\p^\piz r4 bes f |
    g2 r4 g g |
    \time 6/4 R1. |
  % rehearsal 3, 18-28
    \time 5/4
    R1*5/4 | R1*5/4 |
    ees'2\mp bes4 ees bes | ees2 bes4 ees ees |
    fis2\mf cis4 fis cis | a2 e'4 a a, |
    \arco a'-.->\p^\arc r r gis-.-> r r |
    fis-.-> r r e-.-> r r |
    f-.->\mp\< r r ees-.-> r r |
    d-.->\!\mf r r d-.-> r r |
    d-.-> d8-.\< d-. d-. d-. d-. d-. d-. d-. d-. d-. |
  % rehearsal 4, 29-40
    g,4-.\!\f r d'-. g-. r d-. |
    g,-. r d'-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> d-. |
    g,-. r d'-. g-. r d-. |
    g,-. r d'-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'-.->\mf\< g-. g-. g-. f-.-> f-. f-. f-. e-.-> e-. e-. e-. |
    ees4-.->\!\f r r c16->( bes g8-.) r4 r |
    r8 d'-.\p\cresc d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d-.->\!\ff r r4 r\fermata g,16-> g-> g8-.-> r4 r\bar "||"
  % b, rehearsal 5, 41-54
    \key c \minor \time 3/4
    R2.*3 |
    \time 4/4 R1*9 | R1 | R1^\fermataMarkup \bar "||"
  % rehearsal 6, 55-66
    \time 3/4 R2.*12 |
  % rehearsal 7, 67-81
    R2. | R2. | r4 g'8(\mp f g bes) |
    c2(\< bes4) | aes2. | g2( f4) |
    ees2(\!\mf\< bes'4) | aes2. | g4 g,2 |
    c2.\!\f | bes | a2( aes4) |
    g2.\> | c ~ | c4\!\p\fermata r r |
  % rehearsal 8, 82-102
    \time 4/4 R1*3 | R1*3 |
    \time 3/4 R2.*6 | R2.*4 | R2.*4 | R2.^\fermataMarkup \bar "||"
  % rehearsal 9, 103-116
    \time 5/4
    \pizz \grace { s16 } c2\p^\piz g4 c g-> | c2 g4 c g-> |
    c2 g4 c g-> | c2 g4 c g-> |
    c2 g4 c g-> | c2 g4 c g-> |
    c2 g4 c g-> | c2 g4 c g-> |
    c2 g4 c g-> | c2 g4 c g-> |
    c2 g4 c g-> | c2 g4 c g-> |
    c2 ges4 c ges-> | c2\< ges4 c \arco bes^\arc |
  % rehearsal 10, 117-122
    ees-.->\!\f r bes-. ees-. bes-> |
    ees-. r bes-. ees-. bes-> |
    ees-. r bes-. ees-. bes-> |
    ees-. r bes-. ees-. bes-> |
    ees-.-> r bes-. ees-. bes |
    ees-.-> r bes-. ees-. bes8-. bes-. |
  % rehearsal 11, 123-134
    f-.-> r r4 r8 f'4 ees8-. c-. bes-. |
    f-.-> r r4 r8 bes'-. aes-. f-. ees-. c-. |
    bes-.-> r r4 r8 aes'4 f8-. ees-. c-. |
    bes-.-> r r4 r8 bes'-. aes-. f-. ees-. c-. |
    ces-.-> r r4 r r8 ees-. ees-. ees-. |
    ces-.-> r r4 r r8 ees-. ees-. ees-. |
    des8.-> des16-> des8-> des-> r4 r2 |
    des8.-> des16-> des8-> des-> r4 r2 |
    des4-.-> r des-.-> r des-.-> |
    r2 des4--->\ff des---> aes---> |
    des---> des---> aes---> des2---> |
    g,4-.-> r r r2 \bar "||"
  % c, rehearsal 12, 135-142
    \key g \minor
    R1*5/4*8 |
  % rehearsal 13, 143-148
    \time 7/4
    d'4->\mf c8-. d4-> a8-. c-. d-. d-. r r2 |
    d4-> c8-. d4-> a8-. c-. d-. d-. r r2 |
    \time 6/4
    a8-. c-. d-. r r4 a8-. c-. d-. r r4 |
    a8-.\cresc c-. d-. a-. c-. d-. a-. c-.  d-. a-. c-. d-. |
    d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d-.->\!\ff r r4 r \pizz d^\snappizzicato\sf^"Secco" r r \bar "||"
  % rehearsal 14, 149-161
    g2\mp^\piz d4 g2 d4 |
    g2 d4 g2 d4 |
    g g8 c,4-> c8 g'4 g8 c,4-> c8 |
    g'4\< c,8 c4 c8 d4->\!\mf d-> \arco d8-.\<^\arc d-. |
    g4-.\!\f r d-. g-. r d-. |
    g-. r d-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> r |
    \time 5/4
    R1*5/4 | R1*5/4 |
    \pizz bes2\p^\piz r4 bes f |
    g2 r4 g g |
    \time 6/4 R1. |
  % rehearsal 15, 162-176
    R1.*8 |
    c2\mf^\piz g4 c e g, |
    c2 g4 c g a |
    c2 g4 c g bes |
    c2 bes4 ees bes c |
    ees2 des4 ges des ees |
    f2\< ees4 aes ees aes, |
    \arco f'8-.^\arc f-. f-. f-. f-. f-. ees-. ees-. ees-. ees-. ees-. ees-. |
  % rehearsal 16, 177-180
    d4->\!\f c8-. d4-> a8-. c-. d-. d4-.-> r |
    d-> c8-. d4-> a8-. c-. d-. d4-.-> r8 a16 c |
    d8-.-> r r a16 c d8-.-> r r2 r8 a16 c |
    d8-.-> r r4 r \times 4/7 { d16->( ees f g a bes c } d8-.) r r4 |
  % rehearsal 17, 181-188
    g,,-. r d'-. g-. r d-. |
    g,-. r d'-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> d-. |
    g,-. r d'-. g-. r d-. |
    g,-. r d'-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'-.->\mf\< g-. g-. g-. f-.-> f-. f-. f-. e-.-> e-. ees-. ees-. |
  % rehearsal 18, 189-202
    \time 5/4
    d4->\!\f bes8-. d4-> g,8-. bes-. c-. d4-.-> |
    \tag #'score { d2.:32\mf d2: | }
      \tag #'midi { \trem d2. ~ \tutti d2 | }
    d4->\f bes8-. d4-> g,8-. bes-. c-. d4-.-> |
    \tag #'score { d2.:32\mf d2: | }
      \tag #'midi { \trem d2. ~ \tutti d2 | }
    d8-.->\mf\< r r d-.-> r d-.-> r4 d8-.-> r |
    d-.-> r d-.-> r d-.-> r d-.-> r d-.-> d-.->\!\ff |
    R1*5/4 | R1*5/4 | \pizz r4 d\f^\piz r r2 |
    R1*5/4 | r4 d\mf r r2 |
    R1*5/4 | r2 d4\mp r2 |
    R1*5/4 \bar "||"
  % d, rehearsal 19, 203-207
    \key g \major \time 4/4
    R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 \bar ":" R1 |
  % rehearsal 20, 208-221
    \pizz g1\mp^\piz | g1 |
    \time 6/4 g1 r4 fis4 |
    \time 4/4 e2 d | c2. b4 | a2. a4 | d2. d4 |
    \time 6/4 g1 r4 fis |
    \time 4/4 e2\< d | c1\!\mf | b |
    \time 6/4 e4 d c2 b4 bes |
    \time 4/4 a2\> d |
    g,2\!\mp\< g'4 fis |
  % rehearsal 21, 222-228
    e1\!\mf | d | c2 b4 a |
    d2 \arco d8 d4 d8 |
    g g4 g g g8 |
    f f4 f f f8 |
    e\< e4 e8 ees ees4 ees8 |
  % rehearsal 22, 229-244
    d d4 d d\!\f d8 |
    \time 6/4 g,1 g'4 fis |
    \time 4/4 e2 d | c2. b4 | a2.\> a4 | d2.\!\mf\< d4\!\f |
    \time 6/4 g,1 g'4 fis |
    \time 4/4 e2 d | c1 | b2.\> b4 |
    a1->\!\mp ~ | a8 r r4 r2 |
    R1*3 | R1^\fermataMarkup \bar "||"
  % rehearsal 23, 245-249
    \key cis \minor
    r2 r8 gis-.->\f cis-.-> e-.-> |
    fis16-.-> cis-.-> e-.-> fis-.-> gis8-.-> r16 e'-.-> cis8-.-> r16 r32 cis,-> cis4-.-> |
    r2 r4 r8 gis-.-> |
    \times 2/3 { b-.-> cis-.-> e-.-> } \times 4/5 { fis16-.-> cis-.-> e-.-> fis-.-> b-.-> } gis8-.-> r16 gis'-.-> gis4-> ~ |
    gis8. fis32 e cis8-.-> r16 r32 e,-> e8-.-> cis-.-> r4 |
  % rehearsal 24, 250-254
    \times 2/3 { b8-.\p\< cis-. e-. } \times 2/3 { gis8.->(\!\mp fis16) e8-. } \times 2/3 { cis-.\> b-. gis-. } \times 2/3 { b-. fis-. gis-. } |
    \times 2/3 { b-.\!\p\< cis-. e-. } \times 2/3 { gis8.->(\!\mp fis16) e8-. } \times 2/3 { cis-. b-. gis-. } \times 2/3 { b-. fis-. gis-. } |
    \times 2/3 { cis-.\< b-. gis-. } \times 2/3 { cis-. b-. gis-. } \times 2/3 { cis-. b-. gis-. } \times 2/3 { cis-. b-. gis-. } |
    \tag #'score { ais1:32\!\f | ais:\> | }
    \tag #'midi { \trem ais1\!\f ~ | ais\> \tutti | }
  % rehearsal 25, 255-261
    \key d \minor
    \times 2/3 { a8-.\p\< d-. f-. } \times 2/3 { a8.->(\!\mp g16) f8-. } \times 2/3 { d-.\> c-. a-. } \times 2/3 { c-. g-. a-. } |
    \times 2/3 { c-.\!\p\< d-. f-. } \times 2/3 { a8.->(\!\mp g16) f8-. } \times 2/3 { d-. c-. a-. } \times 2/3 { c-. g-. a-. } |
    \times 2/3 { d-.\< c-. a-. } \times 2/3 { d-. c-. a-. } \times 2/3 { d-. c-. a-. } \times 2/3 { d-. c-. a-.\! } |
    \time 3/4
    \tag #'score { b2.:32\f | << { b: } \\ { s2\> s4\!\mp } >> |
      bes2.:\f | << { a: } \\ { s2\> s4\!\mp } >> |
  % rehearsal 26, 262-266
      gis2.:\p\cresc | gis: | gis: | gis: | }
    \tag #'midi { \trem << { b2.\f ~ | b } \\ { s2. | s2\> s4\!\mp } >> |
      << { bes2.\f | a } \\ { s2. | s2\> s4\!\mp } >> |
      gis2.\p\< ~ | gis ~ | gis ~ |  \tutti gis | }
    gis8-.->\!\ff gis-.-> r4 r |
  % rehearsal 27, 267-272
    \pizz R2.*3 |
    r4 d'\p^\piz r |
    R2. | r4 d \arco r |
  % rehearsal 28, 273-280
    \time 4/4
    r2 a32->\ff^\arc a16.-.-> r8 r4 |
    r4 a32-> a16.-.-> r8 a32-> a16.-.-> r8 r4 |
    a'8-.-> r a-.-> r f-.-> r d-.-> r |
    r2 \times 2/3 { a8-.-> a-.-> a-.-> } a4-.-> |
    r2 \times 2/3 { a8-.->\f a-.-> a-.-> } a4-.-> |
    r2 \times 2/3 { a8-_\mf\> a-_ a ~ } a8 ~ \times 2/3 { a16\!\mp g'(\> f } |
    d1)\pp | R1^\fermataMarkup \bar "||"
  % rehearsal 29, 281-286
    \key g \major
    R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup | R1 | R1^\fermataMarkup |
  % rehearsal 30, 287-299
    R1 |
    c1->\ff ~ | c\dim |
    e | b2 bes |
    a1 ~ | a4\!\mp\fermata r r2 |
    R1*4 | R1 | R1^\fermataMarkup \bar "||"
  % e, rehearsal 31, 300-317
    \key g \minor \time 6/4
    R1.*18 |
  % rehearsal 32, 318-322
    R1.*5 |
  % rehearsal 33, 323-328
    a16->(\mf c d8-.) d-. d-. d-. d-. d4-.-> r r |
    a16->( c d8-.) d-. d-. d-. d-. d4-.-> r r |
    a16->(\cresc c d8-.) d-. d-. d-. d-. a16->( c d8-.) d-. d-. d-. d-. |
    a16->( c d8-.) d-. d-. d-. d-. a16->( c d8-.) d-. d-. d-. d-. |
    a16->( c d8-.) d-. d-. d-. d-. d-. d-. d-. d-. d-. d-. |
    d4-.->\!\sf \times 4/7 { d16->(\f ees f g a bes c } d8-.) r r2 r4 |
  % rehearsal 34, 329-336
    g,,4-.-> r d'-. g-. r d-. |
    g,-. r d'-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> \pizz r |
    g2\mp^\piz d4 g2 d4 |
    g2 d4 g2 d4 |
    g4 g8 c,4-> c8 g'4 g8 c,4-> c8 |
    g'4\< c,8 c4 c8 d4->\!\mf d-> r |
  % rehearsal 35, 337-344
    \time 5/4
    bes4-.->\f^\arc r f-. bes-. bes-. |
    R1*5/4 |
    bes4-.-> r f-. bes-. bes-. |
    R1*5/4 |
    r2 r4 g8-.-> g-. g4-.-> |
    r2 r4 g8-.-> g-. g4-.-> |
    r4 g16-.-> g-. g8-. r4 g16-.-> g-. g8-. r4 |
    R1*5/4 |
  % rehearsal 36, 345-355
    \pizz R1*5/4 | R1*5/4 |
    ees'2\mp^\piz bes4 ees bes | ees2 bes4 ees ees |
    fis2\mf cis4 fis cis | a2 e'4 a a, |
    \arco a'-.->\p^\arc r r gis-.-> r r |
    fis-.-> r r e-.-> r r |
    f-.->\mp\< r r ees-.-> r r |
    d-.->\!\mf r r d-.-> r r |
    d-.-> d8-.\< d-. d-. d-. d-. d-. d-. d-. d-. d-. |
  % rehearsal 37, 356-362
    g,4-.\!\f r d'-. g-. r d-. |
    g,-. r d'-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
    g'4-. c,8-. c4-. c8-. d4-.-> d-.-> d-. |
    g,-. r d'-. g-. r d-. |
    g,-. r d'-. g-. r d-. |
    g-. g8-. c,4-> c8-. g'4-. g8-. c,4-> c8-. |
  % rehearsal 38, 363-372
    \time 5/4
    g'-.->\mp\cresc g-. g-. g-. g-.-> g-. g-. g-. fis-.-> fis-. |
    fis-. fis-. f-.-> f-. f-. f-. e-.-> e-. ees-. ees-. |
    d4-.->\!\f r r d8-. d-. d4-.-> |
    d-.-> r r d8-. d-. d4-.-> |
    d-.-> r r d8-. d-. d4-.-> |
    d-.-> r r d8-. d-. d4-.-> |
    d8-.\mf r r d-. r d-. r4 d8-. r |
    d-. r r d-. r d-. r4 d8-. r |
    d-.\cresc r d-. r d-. r d-. r d-. r |
    d-. r d-. r d-. r d-. r d-. r \bar "||"
  % f, rehearsal 39, 373-378
    \time 6/4
    \tag #'score { g,2.:32->\!\fff g:\> |
      g1.:\ff\> | g:\!\f\> |
      g:\!\mp\> | g:\!\p\< |
      g1:\!\f\> g2:\!\pp \bar "||" }
    \tag #'midi { \trem g2.\!\fff ~ g\> ~ |
      g1.\ff\> ~ | g\!\f\> ~ |
      g\!\mp\> ~ | g\!\p\< ~ |
      g1\!\f\> ~ g2\!\pp | }
  }

  #(set-global-staff-size 9)

%{  \score {
    \new Orchestra = "orchestra" <<
    \set Score.skipBars = ##f
    \new MarkLine {
    \removeWithTag #'midi \removeWithTag #'hide \marks }
      \new StaffGroup = "woodwind" <<
      \new SquareStaff = "picc fl" <<
        \new Staff = "piccolo" {
          \set Staff.instrumentName = "Piccolo"
          \set Staff.shortInstrumentName = "Picc."
        \keepWithTag #'score \piccolo
        }
        \new Staff = "flutes" {
          \set Staff.instrumentName = "Flutes I & II"
          \set Staff.shortInstrumentName = "Fl."
        \keepWithTag #'score \flutes
        }
      >>
      \new Staff = "oboes" {
        \set Staff.instrumentName = \markup { \column { "Oboes I & II" "(2nd doubling english horn)" } }
        \set Staff.shortInstrumentName = "Ob."
      \keepWithTag #'score \oboes
      }
      \new Staff = "oboes" {
        \set Staff.instrumentName = "English horn"
        \set Staff.shortInstrumentName = "E.h."
      \enghorn
      }
      \new Staff = "clarinets" {
        \set Staff.instrumentName = \markup {
          \column { \line { "Clarinets I & II" }
            \line { "in B" \smaller \flat } } }
        \set Staff.shortInstrumentName = "Cl."
      \keepWithTag #'score \clarinets
      }
      \new GrandStaff = "bassoons" <<
        \new Staff = "bassoons" {
          \set Staff.instrumentName = \markup { \column { "Bassoons I & II" "(2nd doubling contrabassoon)" } }
          \set Staff.shortInstrumentName = "Bn."
        \bassoons
        }
        \new Staff = "bassoons" {
          \set Staff.instrumentName = "Contrabassoon"
          \set Staff.shortInstrumentName = "Cbn."
        \contrabassoon
        }
      >>
    >>
    \new StaffGroup = "brass" <<
      \new SquareStaff = "horns" <<
        \new Staff = "hornsI" {
          \set Staff.instrumentName = \markup {
            \column { \line { "Horns I & II" }
              \line { "in F" } } }
          \set Staff.shortInstrumentName = "Hn. I & II"
        \hornI
        }
        \new Staff = "hornsII" {
          \set Staff.instrumentName = \markup {
            \column { \line { "Horns III & IV" }
              \line { "in F" } } }
          \set Staff.shortInstrumentName = "Hn. III & IV"
        \hornII
        }
      >>
      \new Staff = "trumpets" {
        \set Staff.instrumentName = \markup {
          \column { \line { "Trumpets I & II" }
          \line { "in B" \smaller \flat } } }
        \set Staff.shortInstrumentName = "Tp. I & II"
      \trumpets
      }
      \new Staff = "trombones 1 & 2" {
        \set Staff.instrumentName = "Trombones I & II"
        \set Staff.shortInstrumentName = "Tb. I & II"
      \trombones
      }
      \new Staff = "tuba" {
        \set Staff.instrumentName = "Bass trombone & Tuba"
        \set Staff.shortInstrumentName = "Btb. & Tu."
      \tuba
      }
    >>
    \new Staff = "timpani" {
      \set Staff.instrumentName = "Timpani"
      \set Staff.shortInstrumentName = "Tim."
    \keepWithTag #'score \timpani
    }
    \new SquareStaff = "drums" <<
      \new GrandStaff = "1" <<
        \set GrandStaff.instrumentName = "Percussion I"
        \set GrandStaff.shortInstrumentName = "Perc. I"
        \new RhythmicStaff = "tambourine" {
          \set RhythmicStaff.instrumentName = "Whip"
          \set RhythmicStaff.shortInstrumentName = "Whi."
        \whip
        }
        \new RhythmicStaff = "triangle" {
          \set RhythmicStaff.instrumentName = "Triangle"
          \set RhythmicStaff.shortInstrumentName = "Tri."
        \keepWithTag #'i \trian
        }
        \new RhythmicStaff = "cymbal" {
          \set RhythmicStaff.instrumentName = \markup { \column { "Cymbals" "Suspended cymbal" } }
          \set RhythmicStaff.shortInstrumentName = \markup { \column { "Cym." "Susp. cym." } }
        \keepWithTag #'i \cym
        }
        \new RhythmicStaff = "tams" {
          \set RhythmicStaff.instrumentName = "Tam-tam"
          \set RhythmicStaff.shortInstrumentName = "Tam-t"
        \keepWithTag #'i \tamtam
        }
        \new RhythmicStaff = "snare" \with {
        \override VerticalAxisGroup #'remove-first = ##t } {
          \set RhythmicStaff.instrumentName = "Snare drum"
          \set RhythmicStaff.shortInstrumentName = "Sn."
        \snareI
        }
      >>
      \new GrandStaff = "2" <<
        \set GrandStaff.instrumentName = "Percussion II"
        \set GrandStaff.shortInstrumentName = "Perc. II"
        \new RhythmicStaff = "tambourine" {
          \set RhythmicStaff.instrumentName = "Tambourine"
          \set RhythmicStaff.shortInstrumentName = "Tamb."
        \tamb
        }
        \new RhythmicStaff = "triangle" \with {
        \override VerticalAxisGroup #'remove-first = ##t } {
          \set RhythmicStaff.instrumentName = "Triangle"
          \set RhythmicStaff.shortInstrumentName = "Tri."
        \keepWithTag #'ii \trian
        }
        \new RhythmicStaff = "tams" \with {
        \override VerticalAxisGroup #'remove-first = ##t } {
          \set RhythmicStaff.instrumentName = "Tam-tam"
          \set RhythmicStaff.shortInstrumentName = "Tam-t"
        \keepWithTag #'ii \tamtam
        }
      >>
      \new GrandStaff = "3" <<
        \set GrandStaff.instrumentName = "Percussion III"
        \set GrandStaff.shortInstrumentName = "Perc. III"
        \new RhythmicStaff = "snare" {
          \set RhythmicStaff.instrumentName = "Snare drum"
          \set RhythmicStaff.shortInstrumentName = "Sn."
        \snareIII
        }
        \new RhythmicStaff = "cymbal" \with {
        \override VerticalAxisGroup #'remove-first = ##t } {
          \set RhythmicStaff.instrumentName = "Cymbals"
          \set RhythmicStaff.shortInstrumentName = "Cym."
        \keepWithTag #'iii \cym
        }
      >>
      \new RhythmicStaff = "bass drum" {
        \set RhythmicStaff.instrumentName = \markup { \column { "Percussion IV" "Bass drum" } }
        \set RhythmicStaff.shortInstrumentName = \markup { \column { "Perc. Iv" "Bd." } }
      \bsdrum
      }
    >>
    \new PianoStaff = "harp" <<
      \set PianoStaff.instrumentName = "Harp"
      \set PianoStaff.shortInstrumentName = "Hrp."
      \set PianoStaff.connectArpeggios = ##t
      \new Staff = "rh" { \keepWithTag #'score \harprh }
      \new Dynamics { \dynamics }
      \new Staff = "lh" { \keepWithTag #'score \harplh }
    >>
    \new SmallMarkLine {
    \removeWithTag #'midi \marks }
    \new StaffGroup = "strings" <<
      \new SquareStaff = "violins" <<
        \new Staff = "violin I" {
          \set Staff.instrumentName = "Violin I"
          \set Staff.shortInstrumentName = "Vn. I"
        \keepWithTag #'score \violinI
        }
        \new Staff = "violin II" {
          \set Staff.instrumentName = "Violin II"
          \set Staff.shortInstrumentName = "Vn. II"
        \keepWithTag #'score \violinII
        }
      >>
      \new Staff = "viola" {
        \set Staff.instrumentName = "Viola"
        \set Staff.shortInstrumentName = "Vl."
      \keepWithTag #'score \viola
      }
      \new SquareStaff = "Cello and Bass" <<
        \new Staff = "violoncello" {
          \set Staff.instrumentName = "Violoncello"
          \set Staff.shortInstrumentName = "Vc."
        \keepWithTag #'score { \cello }
        }
        \new Staff = "contrabass" {
          \set Staff.instrumentName = "Contrabass"
          \set Staff.shortInstrumentName = "Cb."
        \keepWithTag #'score { \contrabass }
        }
        >>
      >>
    >>
    \layout {
      \context {
        \Score
        \remove "Mark_engraver"
        \remove "Metronome_mark_engraver"
      }
    }
  }

%}\score {
  \unfoldRepeats \articulate {
  \new StaffGroup = "orchestra" <<
    \new Staff = "piccolo" {
      \set Staff.midiInstrument = "piccolo"
    \removeWithTag #'score \removeWithTag #'hide << \marks \piccolo >>
    }
    \new Staff = "flutes" {
      \set Staff.midiInstrument = "flute"
    \keepWithTag #'midi \flutes
    }
    \new Staff = "oboes" {
      \set Staff.midiInstrument = "oboe"
    \keepWithTag #'midi << { \transpose c' g' \oboes } \\ { \enghorn } >>
    }
    \new Staff = "clarinets" {
      \set Staff.midiInstrument = "clarinet"
    \keepWithTag #'midi \clarinets
    }
    \new Staff = "bassoons" {
      \set Staff.midiInstrument = "bassoon"
    << { \transpose c c' \bassoons } \\ { \contrabassoon } >>
    }
    \new Staff = "horns" {
      \set Staff.midiInstrument = "french horn"
    << \hornI \\ \hornII >>
    }
    \new Staff = "trumpets" {
      \set Staff.midiInstrument = "trumpet"
    \trumpets
    }
    \new Staff = "trombones" {
      \set Staff.midiInstrument = "trombone"
    << \trombones \\ \tuba >>
    }
    \new Staff = "timpani" {
      \set Staff.midiInstrument = "timpani"
    \keepWithTag #'midi \timpani
    }
    \new DrumStaff { \midiperc }
    \new Staff = "harp" {
      \set Staff.midiInstrument = "orchestral harp"
    \keepWithTag #'midi << \harprh \\ \dynamics \\ \harplh >>
    }
    \new StaffGroup = "strings" <<
      \set StaffGroup.midiInstrument = "string ensemble 1"
      \new Staff = "violini" { \keepWithTag #'midi \violinI }
      \new Staff = "violinii" { \keepWithTag #'midi \violinII }
      \new Staff = "viola" { \keepWithTag #'midi \viola }
      \new Staff = "bass" { \keepWithTag #'midi \cello }
      \new Staff = "bass" { \keepWithTag #'midi \contrabass }
    >>
  >>
  }
  \midi { }
}

